/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.ByteData;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.WorkbookMethods;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.SheetDrawingWriter;
import jxl.biff.formula.ExternalSheet;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.Blank;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WriteException;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BottomMarginRecord;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CalcCountRecord;
import jxl.write.biff.CalcModeRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.CellXFRecord;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DBCellRecord;
import jxl.write.biff.DefaultColumnWidth;
import jxl.write.biff.DefaultRowHeightRecord;
import jxl.write.biff.DeltaRecord;
import jxl.write.biff.DimensionRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.GridSetRecord;
import jxl.write.biff.GuttersRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HorizontalCentreRecord;
import jxl.write.biff.HorizontalPageBreaksRecord;
import jxl.write.biff.IndexRecord;
import jxl.write.biff.IterationRecord;
import jxl.write.biff.LeftMarginRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.ObjectProtectRecord;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.PaneRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrintGridLinesRecord;
import jxl.write.biff.PrintHeadersRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefModeRecord;
import jxl.write.biff.RightMarginRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.SCLRecord;
import jxl.write.biff.SaveRecalcRecord;
import jxl.write.biff.ScenarioProtectRecord;
import jxl.write.biff.SelectionRecord;
import jxl.write.biff.SetupRecord;
import jxl.write.biff.TopMarginRecord;
import jxl.write.biff.VerticalCentreRecord;
import jxl.write.biff.VerticalPageBreaksRecord;
import jxl.write.biff.Weird1Record;
import jxl.write.biff.Window2Record;
import jxl.write.biff.WritableSheetImpl;

final class SheetWriter {
    private static Logger logger = Logger.getLogger(SheetWriter.class);
    private File outputFile;
    private RowRecord[] rows;
    private int numRows;
    private int numCols;
    private HeaderRecord header;
    private FooterRecord footer;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private ArrayList hyperlinks;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private ArrayList validatedCells;
    private DataValidation dataValidation;
    private MergedCells mergedCells;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private WorkspaceInformationRecord workspaceOptions;
    private TreeSet columnFormats;
    private SheetDrawingWriter drawingWriter;
    private boolean chartOnly;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private WritableSheetImpl sheet;
    private int indexPos = 0;
    private IndexRecord indexRecord = null;

    public SheetWriter(File file, WritableSheetImpl writableSheetImpl, WorkbookSettings workbookSettings) {
        this.outputFile = file;
        this.sheet = writableSheetImpl;
        this.workspaceOptions = new WorkspaceInformationRecord();
        this.workbookSettings = workbookSettings;
        this.chartOnly = false;
        this.drawingWriter = new SheetDrawingWriter(workbookSettings);
    }

    public void write(int n) throws IOException {
        WritableRecordData writableRecordData8;
        WritableRecordData writableRecordData2;
        WritableRecordData writableRecordData3;
        WritableRecordData writableRecordData4;
        WritableRecordData writableRecordData5;
        WritableRecordData writableRecordData6;
        Object object;
        WritableRecordData writableRecordData7;
        Assert.verify(this.rows != null);
        if (this.chartOnly) {
            this.drawingWriter.write(this.outputFile);
            return;
        }
        BOFRecord bOFRecord = new BOFRecord(BOFRecord.sheet);
        this.outputFile.write(bOFRecord);
        int n2 = n / 32;
        if (n - n2 * 32 != 0) {
            ++n2;
        }
        this.indexPos = this.outputFile.getPos();
        this.indexRecord = new IndexRecord(0, n, n2);
        this.outputFile.write(this.indexRecord);
        if (this.settings.getAutomaticFormulaCalculation()) {
            writableRecordData7 = new CalcModeRecord(CalcModeRecord.automatic);
            this.outputFile.write(writableRecordData7);
        } else {
            writableRecordData7 = new CalcModeRecord(CalcModeRecord.manual);
            this.outputFile.write(writableRecordData7);
        }
        writableRecordData7 = new CalcCountRecord(100);
        this.outputFile.write(writableRecordData7);
        RefModeRecord refModeRecord = new RefModeRecord();
        this.outputFile.write(refModeRecord);
        IterationRecord iterationRecord = new IterationRecord(false);
        this.outputFile.write(iterationRecord);
        DeltaRecord deltaRecord = new DeltaRecord(0.001);
        this.outputFile.write(deltaRecord);
        SaveRecalcRecord saveRecalcRecord = new SaveRecalcRecord(this.settings.getRecalculateFormulasBeforeSave());
        this.outputFile.write(saveRecalcRecord);
        PrintHeadersRecord printHeadersRecord = new PrintHeadersRecord(this.settings.getPrintHeaders());
        this.outputFile.write(printHeadersRecord);
        PrintGridLinesRecord printGridLinesRecord = new PrintGridLinesRecord(this.settings.getPrintGridLines());
        this.outputFile.write(printGridLinesRecord);
        GridSetRecord gridSetRecord = new GridSetRecord(true);
        this.outputFile.write(gridSetRecord);
        GuttersRecord guttersRecord = new GuttersRecord();
        guttersRecord.setMaxColumnOutline(this.maxColumnOutlineLevel + 1);
        guttersRecord.setMaxRowOutline(this.maxRowOutlineLevel + 1);
        this.outputFile.write(guttersRecord);
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord(this.settings.getDefaultRowHeight(), this.settings.getDefaultRowHeight() != 255);
        this.outputFile.write(defaultRowHeightRecord);
        if (this.maxRowOutlineLevel > 0) {
            this.workspaceOptions.setRowOutlines(true);
        }
        if (this.maxColumnOutlineLevel > 0) {
            this.workspaceOptions.setColumnOutlines(true);
        }
        this.workspaceOptions.setFitToPages(this.settings.getFitToPages());
        this.outputFile.write(this.workspaceOptions);
        if (this.rowBreaks.size() > 0) {
            object = new int[this.rowBreaks.size()];
            for (int i = 0; i < ((int[])object).length; ++i) {
                object[i] = (Integer)this.rowBreaks.get(i);
            }
            writableRecordData6 = new HorizontalPageBreaksRecord((int[])object);
            this.outputFile.write(writableRecordData6);
        }
        if (this.columnBreaks.size() > 0) {
            object = new int[this.columnBreaks.size()];
            for (int i = 0; i < ((int[])object).length; ++i) {
                object[i] = (Integer)this.columnBreaks.get(i);
            }
            writableRecordData6 = new VerticalPageBreaksRecord((int[])object);
            this.outputFile.write(writableRecordData6);
        }
        object = new HeaderRecord(this.settings.getHeader().toString());
        this.outputFile.write((ByteData)object);
        writableRecordData6 = new FooterRecord(this.settings.getFooter().toString());
        this.outputFile.write(writableRecordData6);
        HorizontalCentreRecord horizontalCentreRecord = new HorizontalCentreRecord(this.settings.isHorizontalCentre());
        this.outputFile.write(horizontalCentreRecord);
        VerticalCentreRecord verticalCentreRecord = new VerticalCentreRecord(this.settings.isVerticalCentre());
        this.outputFile.write(verticalCentreRecord);
        if (this.settings.getLeftMargin() != this.settings.getDefaultWidthMargin()) {
            writableRecordData5 = new LeftMarginRecord(this.settings.getLeftMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getRightMargin() != this.settings.getDefaultWidthMargin()) {
            writableRecordData5 = new RightMarginRecord(this.settings.getRightMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getTopMargin() != this.settings.getDefaultHeightMargin()) {
            writableRecordData5 = new TopMarginRecord(this.settings.getTopMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getBottomMargin() != this.settings.getDefaultHeightMargin()) {
            writableRecordData5 = new BottomMarginRecord(this.settings.getBottomMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.plsRecord != null) {
            this.outputFile.write(this.plsRecord);
        }
        writableRecordData5 = new SetupRecord(this.settings);
        this.outputFile.write(writableRecordData5);
        if (this.settings.isProtected()) {
            writableRecordData4 = new ProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData4);
            writableRecordData3 = new ScenarioProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData3);
            writableRecordData2 = new ObjectProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData2);
            if (this.settings.getPassword() != null) {
                writableRecordData8 = new PasswordRecord(this.settings.getPassword());
                this.outputFile.write(writableRecordData8);
            } else if (this.settings.getPasswordHash() != 0) {
                writableRecordData8 = new PasswordRecord(this.settings.getPasswordHash());
                this.outputFile.write(writableRecordData8);
            }
        }
        this.indexRecord.setDataStartPosition(this.outputFile.getPos());
        writableRecordData4 = new DefaultColumnWidth(this.settings.getDefaultColumnWidth());
        this.outputFile.write(writableRecordData4);
        writableRecordData3 = this.sheet.getWorkbook().getStyles().getNormalStyle();
        writableRecordData2 = this.sheet.getWorkbook().getStyles().getDefaultDateFormat();
        writableRecordData8 = null;
        for (WritableRecordData writableRecordData8 : this.columnFormats) {
            XFRecord xFRecord;
            if (((ColumnInfoRecord)writableRecordData8).getColumn() < 256) {
                this.outputFile.write(writableRecordData8);
            }
            if ((xFRecord = ((ColumnInfoRecord)writableRecordData8).getCellFormat()) == writableRecordData3 || ((ColumnInfoRecord)writableRecordData8).getColumn() >= 256) continue;
            Cell[] cellArray = this.getColumn(((ColumnInfoRecord)writableRecordData8).getColumn());
            for (int i = 0; i < cellArray.length; ++i) {
                if (cellArray[i] == null || cellArray[i].getCellFormat() != writableRecordData3 && cellArray[i].getCellFormat() != writableRecordData2) continue;
                ((WritableCell)cellArray[i]).setCellFormat(xFRecord);
            }
        }
        if (this.autoFilter != null) {
            this.autoFilter.write(this.outputFile);
        }
        DimensionRecord dimensionRecord = new DimensionRecord(n, this.numCols);
        this.outputFile.write(dimensionRecord);
    }

    public void writeRecords(int n) throws IOException {
        if (this.chartOnly) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            DBCellRecord dBCellRecord = new DBCellRecord(this.outputFile.getPos());
            int n3 = Math.min(32, this.numRows - i * 32);
            boolean bl = true;
            for (n2 = i * 32; n2 < i * 32 + n3; ++n2) {
                if (this.rows[n2] == null) continue;
                this.rows[n2].write(this.outputFile);
                if (!bl) continue;
                dBCellRecord.setCellOffset(this.outputFile.getPos());
                bl = false;
            }
            for (n2 = i * 32; n2 < i * 32 + n3; ++n2) {
                if (this.rows[n2] == null) continue;
                dBCellRecord.addCellRowPosition(this.outputFile.getPos());
                this.rows[n2].writeCells(this.outputFile);
            }
            this.indexRecord.addBlockPosition(this.outputFile.getPos());
            dBCellRecord.setPosition(this.outputFile.getPos());
            this.outputFile.write(dBCellRecord);
        }
    }

    public void writeTail() throws IOException {
        Object object;
        WritableRecordData writableRecordData;
        Object object2;
        if (this.chartOnly) {
            return;
        }
        if (!this.workbookSettings.getDrawingsDisabled()) {
            this.drawingWriter.write(this.outputFile);
        }
        Window2Record window2Record = new Window2Record(this.settings);
        this.outputFile.write(window2Record);
        if (this.settings.getHorizontalFreeze() != 0 || this.settings.getVerticalFreeze() != 0) {
            object2 = new PaneRecord(this.settings.getHorizontalFreeze(), this.settings.getVerticalFreeze());
            this.outputFile.write((ByteData)object2);
            writableRecordData = new SelectionRecord(SelectionRecord.upperLeft, 0, 0);
            this.outputFile.write(writableRecordData);
            if (this.settings.getHorizontalFreeze() != 0) {
                writableRecordData = new SelectionRecord(SelectionRecord.upperRight, this.settings.getHorizontalFreeze(), 0);
                this.outputFile.write(writableRecordData);
            }
            if (this.settings.getVerticalFreeze() != 0) {
                writableRecordData = new SelectionRecord(SelectionRecord.lowerLeft, 0, this.settings.getVerticalFreeze());
                this.outputFile.write(writableRecordData);
            }
            if (this.settings.getHorizontalFreeze() != 0 && this.settings.getVerticalFreeze() != 0) {
                writableRecordData = new SelectionRecord(SelectionRecord.lowerRight, this.settings.getHorizontalFreeze(), this.settings.getVerticalFreeze());
                this.outputFile.write(writableRecordData);
            }
            object = new Weird1Record();
            this.outputFile.write((ByteData)object);
        } else {
            object2 = new SelectionRecord(SelectionRecord.upperLeft, 0, 0);
            this.outputFile.write((ByteData)object2);
        }
        if (this.settings.getZoomFactor() != 100) {
            object2 = new SCLRecord(this.settings.getZoomFactor());
            this.outputFile.write((ByteData)object2);
        }
        this.mergedCells.write(this.outputFile);
        object2 = this.hyperlinks.iterator();
        writableRecordData = null;
        while (object2.hasNext()) {
            writableRecordData = (WritableHyperlink)object2.next();
            this.outputFile.write(writableRecordData);
        }
        if (this.buttonPropertySet != null) {
            this.outputFile.write(this.buttonPropertySet);
        }
        if (this.dataValidation != null || this.validatedCells.size() > 0) {
            this.writeDataValidation();
        }
        if (this.conditionalFormats != null && this.conditionalFormats.size() > 0) {
            for (ConditionalFormat conditionalFormat : this.conditionalFormats) {
                conditionalFormat.write(this.outputFile);
            }
        }
        object = new EOFRecord();
        this.outputFile.write((ByteData)object);
        this.outputFile.setData(this.indexRecord.getData(), this.indexPos + 4);
    }

    final HeaderRecord getHeader() {
        return this.header;
    }

    final FooterRecord getFooter() {
        return this.footer;
    }

    void setWriteData(RowRecord[] rowRecordArray, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, MergedCells mergedCells, TreeSet treeSet, int n, int n2) {
        this.rows = rowRecordArray;
        this.rowBreaks = arrayList;
        this.columnBreaks = arrayList2;
        this.hyperlinks = arrayList3;
        this.mergedCells = mergedCells;
        this.columnFormats = treeSet;
        this.maxRowOutlineLevel = n;
        this.maxColumnOutlineLevel = n2;
    }

    void setDimensions(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
    }

    void setSettings(SheetSettings sheetSettings) {
        this.settings = sheetSettings;
    }

    WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    void setWorkspaceOptions(WorkspaceInformationRecord workspaceInformationRecord) {
        if (workspaceInformationRecord != null) {
            this.workspaceOptions = workspaceInformationRecord;
        }
    }

    void setCharts(Chart[] chartArray) {
        this.drawingWriter.setCharts(chartArray);
    }

    void setDrawings(ArrayList arrayList, boolean bl) {
        this.drawingWriter.setDrawings(arrayList, bl);
    }

    Chart[] getCharts() {
        return this.drawingWriter.getCharts();
    }

    void checkMergedBorders() {
        Range[] rangeArray = this.mergedCells.getMergedCells();
        ArrayList<CellXFRecord> arrayList = new ArrayList<CellXFRecord>();
        for (int i = 0; i < rangeArray.length; ++i) {
            Range range = rangeArray[i];
            Cell cell = range.getTopLeft();
            XFRecord xFRecord = (XFRecord)cell.getCellFormat();
            if (xFRecord == null || !xFRecord.hasBorders() || xFRecord.isRead()) continue;
            try {
                CellXFRecord cellXFRecord;
                int n;
                CellXFRecord cellXFRecord2 = new CellXFRecord(xFRecord);
                Cell cell2 = range.getBottomRight();
                cellXFRecord2.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                cellXFRecord2.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                cellXFRecord2.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                if (cell.getRow() == cell2.getRow()) {
                    cellXFRecord2.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                }
                if (cell.getColumn() == cell2.getColumn()) {
                    cellXFRecord2.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                }
                if ((n = arrayList.indexOf(cellXFRecord2)) != -1) {
                    cellXFRecord2 = (CellXFRecord)arrayList.get(n);
                } else {
                    arrayList.add(cellXFRecord2);
                }
                ((WritableCell)cell).setCellFormat(cellXFRecord2);
                if (cell2.getRow() > cell.getRow()) {
                    if (cell2.getColumn() != cell.getColumn()) {
                        CellXFRecord cellXFRecord3 = new CellXFRecord(xFRecord);
                        cellXFRecord3.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord3.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                        cellXFRecord3.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                        n = arrayList.indexOf(cellXFRecord3);
                        if (n != -1) {
                            cellXFRecord3 = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord3);
                        }
                        this.sheet.addCell(new Blank(cell.getColumn(), cell2.getRow(), cellXFRecord3));
                    }
                    for (int j = cell.getRow() + 1; j < cell2.getRow(); ++j) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                        if (cell.getColumn() == cell2.getColumn()) {
                            cellXFRecord.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        }
                        if ((n = arrayList.indexOf(cellXFRecord)) != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(cell.getColumn(), j, cellXFRecord));
                    }
                }
                if (cell2.getColumn() > cell.getColumn()) {
                    int n2;
                    if (cell2.getRow() != cell.getRow()) {
                        CellXFRecord cellXFRecord4 = new CellXFRecord(xFRecord);
                        cellXFRecord4.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord4.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        cellXFRecord4.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                        n = arrayList.indexOf(cellXFRecord4);
                        if (n != -1) {
                            cellXFRecord4 = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord4);
                        }
                        this.sheet.addCell(new Blank(cell2.getColumn(), cell.getRow(), cellXFRecord4));
                    }
                    for (n2 = cell.getRow() + 1; n2 < cell2.getRow(); ++n2) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        n = arrayList.indexOf(cellXFRecord);
                        if (n != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(cell2.getColumn(), n2, cellXFRecord));
                    }
                    for (n2 = cell.getColumn() + 1; n2 < cell2.getColumn(); ++n2) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                        if (cell.getRow() == cell2.getRow()) {
                            cellXFRecord.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                        }
                        if ((n = arrayList.indexOf(cellXFRecord)) != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(n2, cell.getRow(), cellXFRecord));
                    }
                }
                if (cell2.getColumn() <= cell.getColumn() && cell2.getRow() <= cell.getRow()) continue;
                CellXFRecord cellXFRecord5 = new CellXFRecord(xFRecord);
                cellXFRecord5.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                cellXFRecord5.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                cellXFRecord5.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                if (cell2.getRow() == cell.getRow()) {
                    cellXFRecord5.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                }
                if (cell2.getColumn() == cell.getColumn()) {
                    cellXFRecord5.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                }
                if ((n = arrayList.indexOf(cellXFRecord5)) != -1) {
                    cellXFRecord5 = (CellXFRecord)arrayList.get(n);
                } else {
                    arrayList.add(cellXFRecord5);
                }
                this.sheet.addCell(new Blank(cell2.getColumn(), cell2.getRow(), cellXFRecord5));
                for (int j = cell.getColumn() + 1; j < cell2.getColumn(); ++j) {
                    CellXFRecord cellXFRecord6 = new CellXFRecord(xFRecord);
                    cellXFRecord6.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                    cellXFRecord6.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                    if (cell.getRow() == cell2.getRow()) {
                        cellXFRecord6.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                    }
                    if ((n = arrayList.indexOf(cellXFRecord6)) != -1) {
                        cellXFRecord6 = (CellXFRecord)arrayList.get(n);
                    } else {
                        arrayList.add(cellXFRecord6);
                    }
                    this.sheet.addCell(new Blank(j, cell2.getRow(), cellXFRecord6));
                }
                continue;
            }
            catch (WriteException writeException) {
                logger.warn(writeException.toString());
            }
        }
    }

    private Cell[] getColumn(int n) {
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.rows[n2] != null && this.rows[n2].getCell(n) != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            cellArray[i] = this.rows[i] != null ? this.rows[i].getCell(n) : null;
        }
        return cellArray;
    }

    void setChartOnly() {
        this.chartOnly = true;
    }

    void setPLS(PLSRecord pLSRecord) {
        this.plsRecord = pLSRecord;
    }

    void setButtonPropertySet(ButtonPropertySetRecord buttonPropertySetRecord) {
        this.buttonPropertySet = buttonPropertySetRecord;
    }

    void setDataValidation(DataValidation dataValidation, ArrayList arrayList) {
        this.dataValidation = dataValidation;
        this.validatedCells = arrayList;
    }

    void setConditionalFormats(ArrayList arrayList) {
        this.conditionalFormats = arrayList;
    }

    void setAutoFilter(AutoFilter autoFilter) {
        this.autoFilter = autoFilter;
    }

    private void writeDataValidation() throws IOException {
        if (this.dataValidation != null && this.validatedCells.size() == 0) {
            this.dataValidation.write(this.outputFile);
            return;
        }
        if (this.dataValidation == null && this.validatedCells.size() > 0) {
            int n = this.sheet.getComboBox() != null ? this.sheet.getComboBox().getObjectId() : -1;
            this.dataValidation = new DataValidation(n, (ExternalSheet)this.sheet.getWorkbook(), (WorkbookMethods)this.sheet.getWorkbook(), this.workbookSettings);
            for (CellValue cellValue : this.validatedCells) {
                CellFeatures cellFeatures = cellValue.getCellFeatures();
                DataValiditySettingsRecord dataValiditySettingsRecord = new DataValiditySettingsRecord(cellFeatures.getDVParser());
                this.dataValidation.add(dataValiditySettingsRecord);
            }
            this.dataValidation.write(this.outputFile);
            return;
        }
        for (CellValue cellValue : this.validatedCells) {
            CellFeatures cellFeatures = cellValue.getCellFeatures();
            DataValiditySettingsRecord dataValiditySettingsRecord = new DataValiditySettingsRecord(cellFeatures.getDVParser());
            this.dataValidation.add(dataValiditySettingsRecord);
        }
        this.dataValidation.write(this.outputFile);
    }

    void resetRows() {
        this.rows = null;
        this.numRows = 0;
    }
}

