/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.mdi;

import com.swimap.iview.util.log.IviewLogger;
import com.swimap.mdi.ExtendedWindow;
import com.swimap.mdi.WindowInterface;
import com.swimap.mdi.WindowState;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public abstract class ExternalContainer
extends JFrame
implements WindowInterface {
    private static IviewLogger logger = IviewLogger.getLogger(ExternalContainer.class, "IVIEW");
    ExtendedWindow framePanel = null;
    protected JMenuBar jMenuBar1 = new JMenuBar();
    private WindowAdapter listener = new WindowAdapter(){

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            ExternalContainer.this.windowOpened(windowEvent);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            ExternalContainer.this.windowActivated(windowEvent);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            ExternalContainer.this.windowDeactivated(windowEvent);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ExternalContainer.this.windowClosing(windowEvent);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            ExternalContainer.this.windowClosed(windowEvent);
        }
    };

    ExternalContainer(ExtendedWindow extendedWindow) {
        super(extendedWindow.getTitle());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.listener);
        this.setBounds(extendedWindow.getWindowBounds());
        this.setTitle(extendedWindow.getTitle());
        this.setIconImage(extendedWindow.getIconImage());
        extendedWindow.setContainer(this);
        this.framePanel = extendedWindow;
        this.setResizable(extendedWindow.isResizable());
        this.getContentPane().add(this.framePanel);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    protected void updateMenu() {
        JToolBar jToolBar;
        JMenu[] jMenuArray = this.framePanel.getJMenus();
        if (jMenuArray != null && jMenuArray.length > 0) {
            for (int i = 0; i < jMenuArray.length; ++i) {
                this.jMenuBar1.add((Component)jMenuArray[i], this.getMenuInsertPos());
            }
            this.jMenuBar1.validate();
            this.jMenuBar1.repaint();
        }
        if ((jToolBar = this.framePanel.getToolbar()) != null) {
            jToolBar.setBorderPainted(true);
            jToolBar.setBorder(BorderFactory.createEtchedBorder());
            this.getContentPane().add((Component)jToolBar, "North");
            this.getContentPane().validate();
            this.getContentPane().repaint();
            jToolBar.setVisible(true);
        }
    }

    ExternalContainer() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.jMenuBar1);
    }

    protected abstract int getMenuInsertPos();

    public void windowOpened(WindowEvent windowEvent) {
        this.framePanel.windowOpened();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.framePanel.windowActivated();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.framePanel.windowDeactivated();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.getContentPane().remove(this.framePanel);
        this.framePanel.windowClosed();
        this.framePanel.setContainer(null);
        this.framePanel = null;
        this.removeWindowListener(this.listener);
        this.listener = null;
    }

    @Override
    public void dispose() {
        if (this.framePanel.windowPreClose()) {
            super.dispose();
        }
    }

    @Override
    public JFrame getJFrame() {
        return this;
    }

    @Override
    public void setWindowState(WindowState windowState) {
        switch (windowState.getValue()) {
            case 0: {
                super.setState(0);
                break;
            }
            case 1: {
                super.setState(1);
                break;
            }
            case 2: {
                super.setState(0);
                break;
            }
        }
    }

    @Override
    public WindowState getWindowState() {
        int n = super.getState();
        if (n == 1) {
            return WindowState.ICON_STATE;
        }
        return WindowState.NORMAL_STATE;
    }

    @Override
    public void setWindowBounds(Rectangle rectangle) {
        if (rectangle != null) {
            this.setBounds(rectangle);
        }
    }

    @Override
    public Rectangle getWindowBounds() {
        return this.getBounds();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.toFront();
        } else {
            this.toBack();
        }
    }

    @Override
    public void addMenu(JMenu jMenu) {
        this.jMenuBar1.add(jMenu);
        this.jMenuBar1.revalidate();
        this.jMenuBar1.repaint();
    }
}

