/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.log;

import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.helpmanagement.HelpBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;

public class IviewRollingFileAppender
extends RollingFileAppender {
    private String suffix = null;
    private boolean isRollOverCalled = false;
    private static boolean onlinehelpStarted = false;
    private static final long MAX_FILE_CAPABILITY = 0x500000L;
    private int fileNumber = 1;
    private static final int MAX_FILE_NUMBER = 20;
    private static String firstOutputFileName = null;

    public IviewRollingFileAppender() {
        this.maxFileSize = 0x500000L;
        this.maxBackupIndex = 20;
    }

    public void setFile(String string) {
        if (null != string) {
            String string2;
            firstOutputFileName = string2 = this.getFileName(string);
            super.setFile(string2);
        }
    }

    public synchronized void setFile(String string, boolean bl, boolean bl2, int n) throws IOException {
        try {
            super.setFile(string, bl, bl2, n);
            if (!this.isRollOverCalled) {
                if ("true".equals(System.getProperty("iview.osgi"))) {
                    System.out.println("Tracing will be written into: file " + string.substring(System.getProperty("user.dir").length() + 1));
                } else {
                    System.out.println("Tracing will be written into: file " + string);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (DebugTracer.isEnableDebug()) {
                PrintStream printStream = null;
                OutputStreamWriter outputStreamWriter = null;
                printStream = new PrintStream(System.out);
                outputStreamWriter = this.createWriter(printStream);
                this.setQWForFiles(outputStreamWriter);
            }
            throw fileNotFoundException;
        }
    }

    private String getFileName(String string) {
        String string2;
        String string3 = DebugTracer.addFolderToFile(string);
        if (onlinehelpStarted && null != string3) {
            string2 = null;
            if (string3.indexOf(File.separator) > -1) {
                string2 = string3.substring(0, string3.lastIndexOf(File.separator));
            } else if (string3.indexOf(47) > -1) {
                string2 = string3.substring(0, string3.lastIndexOf(47));
            }
            string3 = string2 + File.separator + "helptrace.txt";
        }
        string3 = this.trimFileExtension(string3);
        string3 = string3 + '_' + DebugTracer.createTimeString(new GregorianCalendar());
        if (null != this.suffix) {
            string3 = string3 + '.';
            string3 = string3.concat(this.suffix);
        }
        if ("true".equals(System.getProperty("iview.osgi"))) {
            string2 = System.getProperty("user.dir");
            string3 = string2 + "/" + string3;
        }
        return string3;
    }

    private String trimFileExtension(String string) {
        int n = string.lastIndexOf(46);
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separator));
        if (n > -1 && n2 < n) {
            this.suffix = string.substring(n + 1);
            string = string.substring(0, n);
        }
        return string;
    }

    public void rollOver() {
        this.isRollOverCalled = true;
        if (this.qw != null) {
            LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        if (this.maxBackupIndex > 0) {
            try {
                String string = DebugTracer.createFileName(this.fileName, this.fileNumber);
                DebugTracer.checkFileNumber(firstOutputFileName, this.maxBackupIndex);
                this.setFile(string, false, this.bufferedIO, this.bufferSize);
                ++this.fileNumber;
                DebugTracer.makeLogFileZip();
            }
            catch (IOException iOException) {
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)iOException);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream, true);
        System.setErr(printStream);
        return super.createWriter(outputStream);
    }

    public void setMaxBackupIndex(int n) {
        if (n <= 0) {
            super.setMaxBackupIndex(20);
            return;
        }
        super.setMaxBackupIndex(n);
    }

    public void setMaxFileSize(String string) {
        if (null != string) {
            String string2 = string.trim().toUpperCase();
            long l = 0L;
            if (string2.indexOf("KB") > -1) {
                string2 = string2.substring(0, string2.indexOf("KB"));
                try {
                    l = Long.valueOf(string2) * 1024L;
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
            } else if (string2.indexOf("MB") > -1) {
                string2 = string2.substring(0, string2.indexOf("MB"));
                try {
                    l = Long.valueOf(string2) * 1024L * 1024L;
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
            } else if (string2.indexOf("GB") > -1) {
                string2 = string2.substring(0, string2.indexOf("GB"));
                try {
                    l = Long.valueOf(string2) * 1024L * 1024L * 1024L;
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
            }
            if (null != string2) {
                try {
                    Long.parseLong(string2, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    super.setMaxFileSize("5MB");
                    return;
                }
                if (Long.parseLong(string2, 10) <= 0L || l <= 0L) {
                    super.setMaxFileSize("5MB");
                    return;
                }
            }
        }
        super.setMaxFileSize(string);
    }

    static {
        String string = System.getProperty("helptrace");
        if (HelpBundle.isStarted()) {
            onlinehelpStarted = HelpBundle.isStarted();
        } else if (null != string) {
            onlinehelpStarted = Boolean.parseBoolean(string);
        }
    }
}

