/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.jni;

import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;

public class Windows
extends Os {
    private static IviewLogger logger = IviewLogger.getLogger(Windows.class, "IVIEW");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDllForOSGI() {
        String string = System.getProperty("iview.dll");
        if (null == string || string.length() == 0) {
            logger.debug("Load library through System.loadLibrary");
            System.loadLibrary("iviewLibrary");
            logger.debug("Library loaded through System.loadLibrary");
            return;
        }
        try {
            Class<ClassLoader> clazz = ClassLoader.class;
            Field field = clazz.getDeclaredField("sys_paths");
            boolean bl = field.isAccessible();
            if (!bl) {
                field.setAccessible(true);
            }
            Object object = field.get(clazz);
            field.set(clazz, null);
            try {
                String string2 = System.getProperty("iview.dll");
                if (string2 != null) {
                    if (!(string2 = new File(string2).getCanonicalPath()).endsWith("/") && !string2.endsWith("\\")) {
                        string2 = string2 + System.getProperty("file.separator");
                    }
                    logger.debug("load library using System.load from path " + string2);
                    System.load(string2 + "iviewLibrary.dll");
                    logger.debug("Library loaded using System.load from path " + string2);
                }
            }
            catch (Exception exception) {
                logger.debug("load library failed when loading System.load");
            }
            finally {
                field.set(clazz, object);
                field.setAccessible(bl);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    @Override
    public long getFreeDiskSpace(String string) throws IOException {
        long l = 0L;
        try {
            l = this.getFreeDiskSpaceWindowsImp(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return l;
    }

    @Override
    public int getTimeZoneRawOffset() {
        int n = 0;
        try {
            n = this.getTimeZoneRawOffsetWindowsImp();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return n;
    }

    @Override
    public String getTimeZoneID() {
        String string = "";
        try {
            string = this.getTimeZoneIDWindowsImp();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return string;
    }

    @Override
    public int[] getTimeZoneInfo() {
        int[] nArray = null;
        try {
            nArray = this.getTimeZoneInfoWindowsImp();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return nArray;
    }

    @Override
    public int getOnlineWindowNumber(String string, String string2) {
        if (null == string2) {
            string2 = "";
        }
        int n = 0;
        try {
            n = this.statWindowOnlineWindowsImp(string, Windows.stringtoByte(string2));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return n;
    }

    @Override
    public String[] getSystemEncoding() {
        String[] stringArray = null;
        try {
            String string = this.getSystemEncodingWindowsImp();
            if (null != string) {
                String[] stringArray2 = string.split("\\(");
                String string2 = stringArray2[0].trim();
                string2 = "CP" + string2;
                String string3 = stringArray2[1].substring(0, stringArray2[1].length() - 1);
                stringArray = new String[]{string3, string2};
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
        return stringArray;
    }

    public char[] getSystemClipBoardChars() {
        char[] cArray = this.getClipBoardChars();
        return cArray;
    }

    private native long getFreeDiskSpaceWindowsImp(String var1);

    private native String getTimeZoneIDWindowsImp();

    private native int getTimeZoneRawOffsetWindowsImp();

    private native int[] getTimeZoneInfoWindowsImp();

    private native int statWindowOnlineWindowsImp(String var1, byte[] var2);

    @Override
    public native void flashTaskBar(Window var1, int var2, int var3);

    private native String getSystemEncodingWindowsImp();

    private native char[] getClipBoardChars();

    static {
        try {
            if ("true".equals(System.getProperty("iview.osgi"))) {
                Windows.loadDllForOSGI();
            } else {
                System.loadLibrary("iviewLibrary");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.warn("load library iview error!");
            logger.warn(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }
}

