/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.jni;

import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.IOException;
import java.util.Calendar;

public class Solaris
extends Os {
    private static final int MINUTES = 60;
    private static final int SECONDS = 60;
    private static final int MILLIS = 1000;
    private static final int HOURS = 24;
    private static final int DAY_IN_MINUTES = 1440;
    private static IviewLogger logger = IviewLogger.getLogger(Solaris.class, "IVIEW");

    @Override
    public long getFreeDiskSpace(String string) throws IOException {
        long l = 0L;
        try {
            l = this.getFreeDiskSpaceSolarisImp(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
            throw this.runException;
        }
        return l;
    }

    @Override
    public int getTimeZoneRawOffset() {
        int n = 0;
        try {
            n = this.getTimeZoneRawOffsetSolarisImp();
        }
        catch (Exception exception) {
            logger.trace("Exception : " + exception.getMessage(), exception);
        }
        logger.trace("TimeZone raw offset received from OS :" + n + " minutes");
        return n;
    }

    @Override
    public String getTimeZoneID() {
        String string = null;
        try {
            string = this.getTimeZoneIDSolarisImp();
        }
        catch (Exception exception) {
            logger.trace("Exception : " + exception.getMessage(), exception);
        }
        logger.trace("TimeZone ID received from OS :" + string);
        return string;
    }

    @Override
    public int[] getTimeZoneInfo() {
        int[] nArray = null;
        try {
            nArray = this.getTimeZoneInformation();
            if (null != nArray) {
                if (0 == nArray[0]) {
                    return nArray;
                }
                int n = this.getTimeZoneRawOffset();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DST Information from OS is, ");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" " + nArray[i]);
                }
                stringBuffer.append("\nDST Offset from OS: " + n);
                logger.trace(stringBuffer.toString());
                Calendar calendar = Calendar.getInstance();
                Calendar calendar2 = Calendar.getInstance();
                calendar.set(calendar.get(1), nArray[1] - 1, nArray[2], 0, 0, 0);
                calendar2.set(calendar.get(1), nArray[6] - 1, nArray[7], 0, 0, 0);
                nArray[4] = nArray[4] * 60 + n;
                nArray[9] = nArray[9] * 60 + n;
                if (nArray[4] >= 1440) {
                    nArray[4] = nArray[4] % 1440;
                    calendar.add(5, 1);
                } else if (nArray[4] < 0) {
                    calendar.add(5, -1);
                    nArray[4] = nArray[4] + 1440;
                }
                nArray[9] = nArray[9] + nArray[0];
                if (nArray[9] >= 1440) {
                    nArray[9] = nArray[9] % 1440;
                    calendar2.add(5, 1);
                } else if (nArray[9] < 0) {
                    calendar2.add(5, -1);
                    nArray[9] = nArray[9] + 1440;
                }
                nArray[1] = calendar.get(2) + 1;
                nArray[2] = calendar.get(8);
                nArray[3] = calendar.get(7);
                nArray[6] = calendar2.get(2) + 1;
                nArray[7] = calendar2.get(8);
                nArray[8] = calendar2.get(7);
                nArray[3] = nArray[3] - 1;
                nArray[8] = nArray[8] - 1;
                nArray[4] = nArray[4] * 60 * 1000;
                nArray[9] = nArray[9] * 60 * 1000;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError);
            throw this.runException;
        }
        catch (Exception exception) {
            logger.trace(exception);
            throw this.runException;
        }
        return nArray;
    }

    @Override
    public int getOnlineWindowNumber(String string, String string2) {
        return -1;
    }

    private native long getFreeDiskSpaceSolarisImp(String var1);

    private native int[] getTimeZoneInformation();

    private native String getTimeZoneIDSolarisImp();

    private native int getTimeZoneRawOffsetSolarisImp();

    @Override
    public void flashTaskBar(Window window, int n, int n2) {
    }

    @Override
    public String[] getSystemEncoding() {
        String[] stringArray = null;
        try {
            String string = null;
            String string2 = this.getSystemEncodingSolarisImp();
            if (null == string2) {
                return stringArray;
            }
            int n = string2.indexOf(46);
            if (n >= 0) {
                int n2 = string2.indexOf(64);
                string = n2 >= 0 ? string2.substring(n + 1, n2) : string2.substring(n + 1);
            } else if ("C".equalsIgnoreCase(string2)) {
                string = "ISO-8859-1";
            }
            if (null != string && !"UTF-8".equalsIgnoreCase(string)) {
                stringArray = new String[]{string, string};
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
        return stringArray;
    }

    private native String getSystemEncodingSolarisImp();

    static {
        try {
            System.loadLibrary("iviewLibrary");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.warn("load library iview error!");
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }
}

