/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.jni;

import com.swimap.iview.util.jni.Linux;
import com.swimap.iview.util.jni.Solaris;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.IOException;

public abstract class Os {
    private static IviewLogger logger = IviewLogger.getLogger(Os.class, "IVIEW");
    private static Os os;
    protected RuntimeException runException = new RuntimeException("invoke native method error.");

    public static Os getOs() {
        if (os != null) {
            return os;
        }
        String string = System.getProperty("os.name");
        logger.debug("Operating System " + string);
        if (string.indexOf("Windows") != -1) {
            os = new Windows();
        } else if (string.indexOf("SunOS") != -1) {
            os = new Solaris();
        } else if (string.indexOf("Linux") != -1) {
            os = new Linux();
        } else {
            logger.warn("Operating System " + string + " is not supported.");
        }
        return os;
    }

    public abstract long getFreeDiskSpace(String var1) throws IOException;

    public abstract int getTimeZoneRawOffset();

    public abstract String getTimeZoneID();

    public abstract int[] getTimeZoneInfo();

    public abstract int getOnlineWindowNumber(String var1, String var2);

    public static byte[] stringtoByte(String string) {
        try {
            byte[] byArray = string.getBytes(System.getProperty("file.encoding"));
            byte[] byArray2 = new byte[byArray.length + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 0;
            byArray2[byArray.length + 1] = 0;
            return byArray2;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
    }

    public abstract void flashTaskBar(Window var1, int var2, int var3);

    public abstract String[] getSystemEncoding();
}

