/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.jni;

import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Linux
extends Os {
    private static IviewLogger logger = IviewLogger.getLogger(Linux.class, "IVIEW");

    @Override
    public long getFreeDiskSpace(String string) throws IOException {
        long l = 0L;
        try {
            l = this.getFreeDiskSpaceLinuxImp(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw this.runException;
        }
        return l;
    }

    @Override
    public String getTimeZoneID() {
        return null;
    }

    @Override
    public int[] getTimeZoneInfo() {
        return null;
    }

    @Override
    public int getTimeZoneRawOffset() {
        return 0;
    }

    private native long getFreeDiskSpaceLinuxImp(String var1);

    @Override
    public int getOnlineWindowNumber(String string, String string2) {
        return -1;
    }

    @Override
    public void flashTaskBar(Window window, int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemEncoding() {
        String[] stringArray = null;
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec("locale charmap");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            if (null != string && !"UTF-8".equals(string)) {
                stringArray = new String[]{string, string};
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        return stringArray;
    }

    static {
        try {
            Process process = Runtime.getRuntime().exec("uname -m");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            logger.warn("Supported Lunux architectures are x86_64, ppc64, ppc32, ia64");
            logger.warn("linuxArch:" + string);
            if ("x86_64".equalsIgnoreCase(string)) {
                System.loadLibrary("iviewLibraryLinux_x86_64");
            } else if ("ppc64".equalsIgnoreCase(string)) {
                System.loadLibrary("iviewLibraryLinux_ppc_64");
            } else if ("ppc32".equalsIgnoreCase(string) || "ppc".equalsIgnoreCase(string)) {
                System.loadLibrary("iviewLibraryLinux_ppc_32");
            } else if ("ia64".equalsIgnoreCase(string)) {
                System.loadLibrary("iviewLibraryLinux_ia_64");
            } else {
                logger.warn("Linux Architecture is not Supported");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.warn("load library iview error!");
            logger.trace(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
        catch (Exception exception) {
            logger.warn("load library iview error!");
            logger.trace(exception.getMessage(), exception);
        }
    }
}

