/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement.decryptor;

import com.swimap.iview.util.helpmanagement.decryptor.DecrpytStream;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecrypterFactory {
    private static IviewLogger logger = IviewLogger.getLogger(DecrypterFactory.class, "IVIEW");
    private static final String ENCRYPTED_HEAD = "ENCRYPTED_HEAD";

    public static void decrypt(DecrpytStream decrpytStream, OutputStream outputStream) {
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = decrpytStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            decrpytStream.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            logger.trace("Exception while writing to stream : " + iOException);
        }
    }

    public static class DefaultDecryptStream
    extends DecrpytStream {
        private String headStr = "";
        private int index = 0;
        private boolean initialized = false;
        private boolean isEncryptedFlag = false;

        public DefaultDecryptStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() throws IOException {
            if (!this.initialized && !this.isEncryptedFlag) {
                StringBuffer stringBuffer = new StringBuffer(1);
                int n = 0;
                int n2 = DecrypterFactory.ENCRYPTED_HEAD.length();
                for (int i = 0; i < n2 && (n = this.in.read()) >= 0; ++i) {
                    stringBuffer.append((char)n);
                }
                this.headStr = stringBuffer.toString();
                this.initialized = true;
                this.isEncryptedFlag = DecrypterFactory.ENCRYPTED_HEAD.equals(this.headStr);
            }
            int n = 0;
            if (!this.isEncryptedFlag) {
                n = this.index < this.headStr.length() ? (int)this.headStr.charAt(this.index++) : this.in.read();
                return n;
            }
            n = this.in.read();
            if (n < 0) {
                return n;
            }
            return (n & 0xF0) >>> 4 | (n & 0xF) << 4;
        }

        @Override
        public boolean isEncrypted(InputStream inputStream) throws IOException {
            return true;
        }
    }
}

