/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.util.log.IviewLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.net.ConnectException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLDocumentUtil {
    private static IviewLogger logger = IviewLogger.getLogger(XMLDocumentUtil.class, "IVIEW");
    private static final XMLDocumentUtil INSTANCE = new XMLDocumentUtil();
    private static final String DTDSTRING = "<?xml version='1.0' encoding='UTF-8'?><!ELEMENT helpset (title, maps, view+, subhelpset*, presentation*, impl?)><!ATTLIST helpset version ( 1.0 | 2.0) #IMPLIED><!ATTLIST helpset xml:lang CDATA #IMPLIED><!ELEMENT title (#PCDATA)><!ELEMENT maps (homeID, mapref+)><!ELEMENT homeID (#PCDATA)><!ELEMENT mapref EMPTY><!ATTLIST mapref location CDATA #REQUIRED><!ELEMENT view (name | label | image? | type | data?)*><!ATTLIST view xml:lang CDATA #IMPLIED><!ATTLIST view mergetype CDATA #IMPLIED><!ELEMENT name (#PCDATA)><!ELEMENT label (#PCDATA)><!ELEMENT image (#PCDATA)><!ELEMENT type (#PCDATA)><!ELEMENT data (#PCDATA)><!ATTLIST data engine CDATA #IMPLIED><!ELEMENT subhelpset EMPTY><!ATTLIST subhelpset location CDATA #IMPLIED><!ELEMENT presentation (name, size?, location?, title?, image?, toolbar?)*><!ATTLIST presentation xml:lang CDATA #IMPLIED><!ATTLIST presentation default (true | false) #IMPLIED><!ATTLIST presentation displayviews (true | false) #IMPLIED><!ATTLIST presentation displayviewimages (true | false) #IMPLIED><!ELEMENT size EMPTY><!ATTLIST size width CDATA #REQUIRED><!ATTLIST size height CDATA #REQUIRED><!ELEMENT location EMPTY><!ATTLIST location x CDATA #REQUIRED><!ATTLIST location y CDATA #REQUIRED><!ELEMENT toolbar (helpaction*)><!ELEMENT helpaction (#PCDATA)><!ATTLIST helpaction image CDATA #IMPLIED><!ELEMENT impl (helpsetregistry?, viewerregistry*)><!ELEMENT helpsetregistry EMPTY><!ATTLIST helpsetregistry helpbrokerclass CDATA #REQUIRED><!ELEMENT viewerregistry EMPTY><!ATTLIST viewerregistry viewertype CDATA #REQUIRED><!ATTLIST viewerregistry viewerclass CDATA #REQUIRED>";
    private static final ByteArrayInputStream IS = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><!ELEMENT helpset (title, maps, view+, subhelpset*, presentation*, impl?)><!ATTLIST helpset version ( 1.0 | 2.0) #IMPLIED><!ATTLIST helpset xml:lang CDATA #IMPLIED><!ELEMENT title (#PCDATA)><!ELEMENT maps (homeID, mapref+)><!ELEMENT homeID (#PCDATA)><!ELEMENT mapref EMPTY><!ATTLIST mapref location CDATA #REQUIRED><!ELEMENT view (name | label | image? | type | data?)*><!ATTLIST view xml:lang CDATA #IMPLIED><!ATTLIST view mergetype CDATA #IMPLIED><!ELEMENT name (#PCDATA)><!ELEMENT label (#PCDATA)><!ELEMENT image (#PCDATA)><!ELEMENT type (#PCDATA)><!ELEMENT data (#PCDATA)><!ATTLIST data engine CDATA #IMPLIED><!ELEMENT subhelpset EMPTY><!ATTLIST subhelpset location CDATA #IMPLIED><!ELEMENT presentation (name, size?, location?, title?, image?, toolbar?)*><!ATTLIST presentation xml:lang CDATA #IMPLIED><!ATTLIST presentation default (true | false) #IMPLIED><!ATTLIST presentation displayviews (true | false) #IMPLIED><!ATTLIST presentation displayviewimages (true | false) #IMPLIED><!ELEMENT size EMPTY><!ATTLIST size width CDATA #REQUIRED><!ATTLIST size height CDATA #REQUIRED><!ELEMENT location EMPTY><!ATTLIST location x CDATA #REQUIRED><!ATTLIST location y CDATA #REQUIRED><!ELEMENT toolbar (helpaction*)><!ELEMENT helpaction (#PCDATA)><!ATTLIST helpaction image CDATA #IMPLIED><!ELEMENT impl (helpsetregistry?, viewerregistry*)><!ELEMENT helpsetregistry EMPTY><!ATTLIST helpsetregistry helpbrokerclass CDATA #REQUIRED><!ELEMENT viewerregistry EMPTY><!ATTLIST viewerregistry viewertype CDATA #REQUIRED><!ATTLIST viewerregistry viewerclass CDATA #REQUIRED>".getBytes());
    private static final InputSource SOURCE = new InputSource(IS);

    public static XMLDocumentUtil getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToXMLDoc(Document document, String string, String string2) {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        outputFormat.setEncoding(string);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string2);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            logger.trace("writeToDoc : " + iOException.toString());
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                logger.trace("writeToDoc : " + iOException.toString());
            }
        }
    }

    Document createXMLDocument(File file, final String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            try {
                documentBuilder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String string3, String string2) throws SAXException {
                        Pattern pattern = Pattern.compile(string);
                        Matcher matcher = pattern.matcher(string2);
                        if (matcher.find()) {
                            try {
                                IS.close();
                            }
                            catch (IOException iOException) {
                                logger.trace("XMLDocumentUtil | createXMLDocument | " + iOException.toString());
                            }
                            return SOURCE;
                        }
                        return null;
                    }
                });
                document = documentBuilder.parse(file);
                return document;
            }
            catch (ConnectException connectException) {
                logger.trace("XMLDocumentUtil | createXMLDocument |" + connectException.toString());
            }
            catch (SAXException sAXException) {
                logger.trace("XMLDocumentUtil | createXMLDocument |" + sAXException.toString());
            }
            catch (IOException iOException) {
                logger.trace("XMLDocumentUtil | createXMLDocument |" + iOException.toString());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.trace("XMLDocumentUtil | createXMLDocument |" + parserConfigurationException.toString());
        }
        return null;
    }

    String[] getFileLocations(String string, final String string2) {
        logger.trace("Getting " + string2 + " file locations from " + string);
        File file = new File(string);
        if (file.exists()) {
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(string2);
                }
            };
            File[] fileArray = file.listFiles(filenameFilter);
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getPath();
            }
            logger.trace("Got all the " + string2 + " files from " + string);
            return stringArray;
        }
        return new String[0];
    }
}

