/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.FlatMap;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.HelpSetFactory;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.TryMap;

public class IViewHelpSet
extends HelpSet {
    private static IviewLogger logger = IviewLogger.getLogger(IViewHelpSet.class, "IVIEW");
    private URL helpsetUrl;
    private Vector subHelpSets = new Vector();
    private Locale locale = Locale.getDefault();

    public IViewHelpSet(ClassLoader classLoader, URL uRL) throws HelpSetException {
        super(classLoader);
        this.helpsetUrl = uRL;
        IViewHelpSetFactory iViewHelpSetFactory = new IViewHelpSetFactory();
        this.parseInto(uRL, iViewHelpSetFactory);
        HelpSet helpSet = iViewHelpSetFactory.parsingEnded(this);
        if (helpSet == null) {
            throw new HelpSetException("Could not parse. Please check log for errors");
        }
    }

    public URL getHelpSetURL() {
        return this.helpsetUrl;
    }

    protected void addSubHelpSet(HelpSet helpSet) {
        this.subHelpSets.addElement(helpSet);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static HelpSet parse(URL uRL, ClassLoader classLoader, HelpSet.DefaultHelpSetFactory defaultHelpSetFactory) {
        try {
            IViewHelpSet iViewHelpSet = new IViewHelpSet(classLoader, uRL);
            iViewHelpSet.parseInto(uRL, (HelpSetFactory)defaultHelpSetFactory);
            return defaultHelpSetFactory.parsingEnded((HelpSet)iViewHelpSet);
        }
        catch (HelpSetException helpSetException) {
            logger.trace(helpSetException.getMessage(), helpSetException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseInto(URL uRL, HelpSet.DefaultHelpSetFactory defaultHelpSetFactory) {
        Reader reader = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            reader = XmlReader.createReader((URLConnection)uRLConnection);
            defaultHelpSetFactory.parsingStarted(uRL);
            new IViewHelpSetParser(defaultHelpSetFactory).parseInto(reader, this);
        }
        catch (Exception exception) {
            defaultHelpSetFactory.reportMessage("Got an IOException (" + exception.getMessage() + ")", false);
            logger.trace("Got an IOException (" + exception.getMessage() + ")", exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                reader = null;
            }
        }
        for (Object e : this.subHelpSets) {
            this.add((HelpSet)e);
        }
    }

    private static String convertPath(String string) {
        String string2 = System.getProperty("iview.osgi");
        if (null != string2 && null != string && string.startsWith("jar:file:")) {
            String string3 = string.substring("jar:file:".length(), string.length());
            try {
                String string4 = System.getProperty("user.dir");
                string3 = "jar:file:" + URLEncoder.encode(string4, "UTF-8") + File.separator + string3;
                return string3;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    private static class IViewHelpSetParser
    implements ParserListener {
        private Stack tagStack;
        private Locale defLocale;
        private Locale prevLocale;
        private HelpSet myHelpSet;
        private Locale myHSLocale;
        private HelpSet.DefaultHelpSetFactory helpSetFactory;
        private String tagName;
        private String presentationLabel;
        private String presentationType;
        private String helpAction;
        private Point location;
        private Dimension dimension;
        private Vector helpActionVector;
        private boolean showToolbar;
        private String presentationTitle;
        private String viewMergeType;
        private String presentationData;
        private boolean defPresentation = false;
        private Hashtable dataHashTable;
        private boolean displayViewImages = true;
        private boolean isDisplayViews = true;
        private String tagImage;
        private String helpActionImage;

        private int getIntPropValue(TagProperties tagProperties, String string) {
            String string2 = tagProperties.getProperty(string);
            return string2 == null ? 0 : Integer.parseInt(string2);
        }

        IViewHelpSetParser(HelpSet.DefaultHelpSetFactory defaultHelpSetFactory) {
            this.helpSetFactory = defaultHelpSetFactory;
        }

        synchronized void parseInto(Reader reader, HelpSet helpSet) throws IOException {
            this.tagStack = new Stack();
            this.myHelpSet = helpSet;
            this.prevLocale = this.defLocale = helpSet.getLocale();
            this.myHSLocale = helpSet.getLocale();
            Parser parser = new Parser(reader);
            parser.addParserListener((ParserListener)this);
            parser.parse();
        }

        public void doctypeFound(ParserEvent parserEvent) {
            this.helpSetFactory.processDOCTYPE(parserEvent.getRoot(), parserEvent.getPublicId(), parserEvent.getSystemId());
        }

        public void tagFound(ParserEvent parserEvent) {
            String string;
            String string2;
            Hashtable hashtable;
            logger.debug("tagFound " + parserEvent.getTag().name);
            Locale locale = null;
            Tag tag = parserEvent.getTag();
            String string3 = tag.name;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            TagProperties tagProperties = tag.atts;
            Hashtable hashtable2 = hashtable = tagProperties == null ? null : tagProperties.getHashtable();
            if (tagProperties != null) {
                this.viewMergeType = tagProperties.getProperty("mergetype");
                this.helpActionImage = tagProperties.getProperty("image");
                string2 = tagProperties.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang((String)string2);
                n = this.getIntPropValue(tagProperties, "x");
                n2 = this.getIntPropValue(tagProperties, "y");
                n3 = this.getIntPropValue(tagProperties, "width");
                n4 = this.getIntPropValue(tagProperties, "height");
                string = tagProperties.getProperty("default");
                if (string != null && string.equals("true")) {
                    this.defPresentation = true;
                }
                if ((string = tagProperties.getProperty("displayviewimages")) != null && string.equals("false")) {
                    this.displayViewImages = false;
                }
                if ((string = tagProperties.getProperty("displayviews")) != null && string.equals("false")) {
                    this.isDisplayViews = false;
                }
            }
            if (locale == null) {
                locale = this.prevLocale;
            }
            if ("helpset".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!locale.equals(this.defLocale) && !locale.equals(this.myHSLocale) && this.myHelpSet instanceof IViewHelpSet) {
                        ((IViewHelpSet)this.myHelpSet).setLocale(locale);
                        this.defLocale = locale;
                    }
                    if (tagProperties != null && (string2 = tagProperties.getProperty("version")) != null && string2.compareTo("1.0") != 0 && string2.compareTo("2.0") != 0) {
                        this.debugError("helpset.unknownVersion", string2);
                    }
                    this.addTag(tag, locale);
                }
                return;
            }
            if (this.tagStack.empty()) {
                this.debugError("helpset.wrongTopLevel", string3);
            }
            string2 = (LangElement)this.tagStack.peek();
            string = string2.getTag().name;
            if ("title".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("helpset") && !string.equals("presentation")) {
                        this.debugError2(string3, string);
                    }
                    if (!locale.equals(this.defLocale) && !locale.equals(this.myHSLocale)) {
                        this.debugError3(locale, this.defLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if ("homeID".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("maps")) {
                        this.debugError2(string3, string);
                    }
                    this.addTag(tag, locale);
                }
            } else if ("mapref".equals(string3)) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("maps")) {
                        this.debugError2(string3, string);
                    }
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.helpSetFactory.processMapRef(this.myHelpSet, hashtable);
                }
            } else if ("data".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("view")) {
                        this.debugError2(string3, string);
                    } else {
                        this.addTag(tag, locale);
                    }
                    this.dataHashTable = hashtable;
                }
            } else if (string3.equals("name") || string3.equals("type") || string3.equals("image")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!string.equals("view") && !string.equals("presentation")) {
                    this.debugError2(string3, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if ("label".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!string.equals("view")) {
                    this.debugError2(string3, string);
                } else {
                    if (!locale.equals(this.defLocale) && !locale.equals(this.myHSLocale)) {
                        this.debugError3(locale, this.defLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if ("view".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    if (null != this.tagImage) {
                        if (null == this.dataHashTable) {
                            this.dataHashTable = new Hashtable();
                        }
                        this.dataHashTable.put("imageID", this.tagImage);
                    }
                    if (this.viewMergeType != null) {
                        if (this.dataHashTable == null) {
                            this.dataHashTable = new Hashtable();
                        }
                        this.dataHashTable.put("mergetype", this.viewMergeType);
                    }
                    this.helpSetFactory.processView(this.myHelpSet, this.tagName, this.presentationLabel, this.presentationType, hashtable, this.presentationData, this.dataHashTable, locale);
                    this.presentationLabel = null;
                    this.tagName = null;
                    this.tagImage = null;
                    this.presentationType = null;
                    this.dataHashTable = null;
                    this.presentationData = null;
                    this.viewMergeType = null;
                } else if (!string.equals("helpset")) {
                    this.debugError2(string3, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if ("presentation".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    this.helpSetFactory.processPresentation(this.myHelpSet, this.tagName, this.defPresentation, this.isDisplayViews, this.displayViewImages, this.dimension, this.location, this.presentationTitle, this.tagImage, this.showToolbar, this.helpActionVector);
                    this.tagName = null;
                    this.defPresentation = false;
                    this.isDisplayViews = true;
                    this.displayViewImages = true;
                    this.dimension = null;
                    this.location = null;
                    this.presentationTitle = null;
                    this.tagImage = null;
                    this.showToolbar = false;
                    this.helpActionVector = null;
                } else if (!string.equals("helpset")) {
                    this.debugError2(string3, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if ("size".equals(string3)) {
                if (tag.isEnd) {
                    if (this.dimension == null) {
                        this.dimension = new Dimension(n3, n4);
                    } else {
                        this.dimension.setSize(n3, n4);
                    }
                    n3 = 0;
                    n4 = 0;
                    if (!tag.isEmpty) {
                        this.removeTag(tag);
                    }
                } else if ("presentation".equals(string)) {
                    this.addTag(tag, locale);
                    this.dimension = new Dimension();
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("location".equals(string3)) {
                if (tag.isEnd) {
                    if (null == this.location) {
                        this.location = new Point(n, n2);
                    } else {
                        this.location.setLocation(n, n2);
                    }
                    n = 0;
                    n2 = 0;
                    if (!tag.isEmpty) {
                        this.removeTag(tag);
                    }
                } else if ("presentation".equals(string)) {
                    this.addTag(tag, locale);
                    this.location = new Point();
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("toolbar".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if ("presentation".equals(string)) {
                    this.addTag(tag, locale);
                    this.helpActionVector = new Vector();
                    this.showToolbar = true;
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("helpaction".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    if (null != this.helpAction) {
                        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                        this.helpActionVector.add(new HelpSetFactory.HelpAction(this.helpAction, hashtable3));
                        if (null != this.helpActionImage) {
                            hashtable3.put("image", this.helpActionImage);
                            this.helpActionImage = null;
                        }
                        this.helpAction = null;
                    }
                } else if ("toolbar".equals(string)) {
                    this.addTag(tag, locale);
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("maps".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if ("helpset".equals(string)) {
                    this.addTag(tag, locale);
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("subhelpset".equals(string3)) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.helpSetFactory.processSubHelpSet(this.myHelpSet, hashtable);
                }
            } else if ("impl".equals(string3)) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if ("helpset".equals(string)) {
                    this.addTag(tag, locale);
                } else {
                    this.debugError2(string3, string);
                }
            } else if ("helpsetregistry".equals(string3)) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else if (!"impl".equals(string)) {
                    this.debugError2(string3, string);
                } else {
                    String string4;
                    if (!tag.isEnd) {
                        this.addTag(tag, locale);
                    }
                    if (null != tagProperties && null != (string4 = tagProperties.getProperty("helpbrokerclass"))) {
                        this.myHelpSet.setKeyData(HelpSet.implRegistry, "helpBroker/class", (Object)string4);
                    }
                }
            } else if ("viewerregistry".equals(string3)) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else if (!string.equals("impl")) {
                    this.debugError2(string3, string);
                } else {
                    if (!tag.isEnd) {
                        this.addTag(tag, locale);
                    }
                    if (null != tagProperties) {
                        String string5 = tagProperties.getProperty("viewertype");
                        String string6 = tagProperties.getProperty("viewerclass");
                        if (string5 != null && string6 != null) {
                            ClassLoader classLoader = HelpSet.class.getClassLoader();
                            this.myHelpSet.setKeyData(HelpSet.kitTypeRegistry, string5, (Object)string6);
                            this.myHelpSet.setKeyData(HelpSet.kitLoaderRegistry, string5, (Object)classLoader);
                        }
                    }
                }
            }
        }

        public void piFound(ParserEvent parserEvent) {
            this.helpSetFactory.processPI(this.myHelpSet, parserEvent.getTarget(), parserEvent.getData());
        }

        public void textFound(ParserEvent parserEvent) {
            logger.debug("textFound: text: " + parserEvent.getText());
            if (this.tagStack.empty()) {
                return;
            }
            LangElement langElement = (LangElement)this.tagStack.peek();
            Tag tag = langElement.getTag();
            String string = parserEvent.getText().trim();
            String string2 = tag.name;
            if (string2.equals("helpset")) {
                this.debugNull("helpset", string);
                return;
            }
            int n = this.tagStack.size();
            String string3 = "";
            if (n >= 2) {
                langElement = (LangElement)this.tagStack.elementAt(n - 2);
                string3 = langElement.getTag().name;
            }
            if ("title".equals(string2)) {
                if (string3.equals("helpset")) {
                    this.helpSetFactory.processTitle(this.myHelpSet, string);
                } else {
                    this.presentationTitle = string.trim();
                }
            } else if (string2.equals("homeID")) {
                this.helpSetFactory.processHomeID(this.myHelpSet, string);
            } else if (string2.equals("data")) {
                this.presentationData = IViewHelpSet.convertPath(string.trim());
            } else if (string2.equals("label")) {
                this.presentationLabel = string.trim();
            } else if (string2.equals("name")) {
                this.tagName = string.trim();
            } else if (string2.equals("helpaction")) {
                this.helpAction = string.trim();
            } else if (string2.equals("type")) {
                this.presentationType = string.trim();
            } else if (string2.equals("image")) {
                this.tagImage = string.trim();
            } else if (string2.equals("view")) {
                this.debugNull("view", string);
            } else if (string2.equals("maps")) {
                this.debugNull("maps", string);
            } else if (string2.equals("mergetype")) {
                this.debugNull("mergetype", string);
            } else if (string2.equals("mapref")) {
                this.debugNull("mapref", string);
            } else if (string2.equals("subhelpset")) {
                this.debugNull("subhelpset", string);
            }
        }

        public void errorFound(ParserEvent parserEvent) {
        }

        public void commentFound(ParserEvent parserEvent) {
        }

        protected void addTag(Tag tag, Locale locale) {
            this.tagStack.push(new LangElement(tag, locale));
            if (locale == null || this.prevLocale == null) {
                this.prevLocale = locale;
                return;
            }
            if (!this.prevLocale.equals(locale)) {
                this.prevLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            LangElement langElement;
            String string = tag.name;
            Locale locale = null;
            do {
                if (this.tagStack.empty()) {
                    this.debugError("helpset.unbalanced", string);
                }
                langElement = (LangElement)this.tagStack.pop();
            } while (!langElement.getTag().name.equals(string));
            if (this.tagStack.empty()) {
                locale = this.defLocale;
            } else {
                langElement = (LangElement)this.tagStack.peek();
                locale = langElement.getLocale();
            }
            if (locale == null || this.prevLocale == null) {
                this.prevLocale = locale;
                return;
            }
            if (!this.prevLocale.equals(locale)) {
                this.prevLocale = locale;
            }
        }

        private void debugError(String string, String string2) {
            logger.debug(HelpUtilities.getText((String)string, (String)string2));
        }

        private void debugError2(String string, String string2) {
            logger.debug(HelpUtilities.getText((String)"helpset.wrongParent", (String)string, (String)string2));
        }

        private void debugError3(Locale locale, Locale locale2, Locale locale3) {
            String string = HelpUtilities.getText((String)"helpset.wrongLocale", (String)locale.toString(), (String)locale2.toString(), (String)locale3.toString());
            logger.trace(string);
        }

        private void debugNull(String string, String string2) {
            if (null != string2 && string2.length() > 0) {
                logger.debug(HelpUtilities.getText((String)"helpset.wrongText", (String)string, (String)string2));
            }
        }
    }

    public static class IViewHelpSetFactory
    extends HelpSet.DefaultHelpSetFactory {
        public void processMapRef(HelpSet helpSet, Hashtable hashtable) {
            String string = (String)hashtable.get("location");
            string = IViewHelpSet.convertPath(string);
            URL uRL = helpSet.getHelpSetURL();
            try {
                FlatMap flatMap = new FlatMap(new URL(uRL, string), helpSet);
                Map map = helpSet.getLocalMap();
                if (map == null) {
                    logger.debug("map is null");
                    helpSet.setLocalMap((Map)flatMap);
                } else if (map instanceof TryMap) {
                    logger.debug("map is TryMap");
                    ((TryMap)map).add((Map)flatMap);
                    helpSet.setLocalMap(map);
                } else {
                    logger.debug("map is not TryMap");
                    TryMap tryMap = new TryMap();
                    tryMap.add(map);
                    tryMap.add((Map)flatMap);
                    helpSet.setLocalMap((Map)tryMap);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }

        public void processSubHelpSet(HelpSet helpSet, Hashtable hashtable) {
            logger.debug("create SubHelpSet");
            String string = (String)hashtable.get("location");
            string = IViewHelpSet.convertPath(string);
            URL uRL = helpSet.getHelpSetURL();
            logger.debug("location: " + string);
            logger.debug("base helpset: " + uRL);
            URL uRL2 = null;
            IViewHelpSet iViewHelpSet = null;
            try {
                uRL2 = new URL(uRL, string);
                InputStream inputStream = uRL2.openStream();
                if (inputStream != null && (iViewHelpSet = new IViewHelpSet(helpSet.getLoader(), uRL2)) != null && helpSet instanceof IViewHelpSet) {
                    ((IViewHelpSet)helpSet).addSubHelpSet(iViewHelpSet);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            catch (HelpSetException helpSetException) {
                logger.trace(helpSetException.getMessage(), helpSetException);
            }
        }
    }
}

