/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.helpmanagement.CSH;
import com.swimap.iview.util.helpmanagement.HelpAdapter;
import com.swimap.iview.util.helpmanagement.HelpFrame;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TextHelpModel;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class IViewHelpBroker
implements HelpBroker,
KeyListener {
    private static IviewLogger logger = IviewLogger.getLogger(IViewHelpBroker.class, "IVIEW");
    protected HelpSet helpset = null;
    protected HelpFrame frame = null;
    protected JHelp jhelp = null;
    protected Locale locale = null;
    protected Font font = null;
    protected JDialog dialog = null;
    protected Window ownerWindow = null;
    protected boolean modallyActivated = false;
    private final int DEFAULT_HELP_WIDTH = 645;
    private final int DEFAULT_HELP_HEIGHT = 495;
    private int hELP_WIDTH = 645;
    private int hELP_HEIGHT = 495;
    WindowListener dl = null;
    boolean modalDeactivated = true;
    static boolean on1dot1 = true;
    private boolean isNotified = false;
    protected ActionListener displayHelpFromFocus = null;
    protected ActionListener displayHelpFromSource = null;
    private static final boolean debug = false;
    private HelpLock helpLock = new HelpLock();

    public IViewHelpBroker(HelpSet helpSet) {
        this.setHelpSet(helpSet);
        this.initializeHelpClassLoader();
    }

    public IViewHelpBroker() {
        this.initializeHelpClassLoader();
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public void setHelpSet(HelpSet helpSet) {
        if (helpSet != null && this.helpset != helpSet) {
            if (this.jhelp != null) {
                DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
                this.jhelp.setModel((TextHelpModel)defaultHelpModel);
            }
            this.helpset = helpSet;
        }
    }

    public void setHelpSetPresentation(HelpSet.Presentation presentation) {
    }

    public void showID(Map.ID iD, String string, String string2) throws InvalidHelpSetContextException {
    }

    public void showID(String string, String string2, String string3) throws BadIDException {
    }

    public void enableHelpKey(Component component, String string, HelpSet helpSet, String string2, String string3) {
    }

    public void enableHelpOnButton(Object object, String string, HelpSet helpSet, String string2, String string3) {
    }

    public void setLocale(Locale locale) {
        if (null != this.locale) {
            this.jhelp.setLocale(this.locale);
        }
        this.locale = locale;
    }

    public void setFont(Font font) {
        if (null != this.jhelp) {
            this.jhelp.setFont(font);
        }
        this.font = font;
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public Font getFont() {
        this.createHelpWindow();
        if (null != this.font) {
            return this.font;
        }
        return this.jhelp.getFont();
    }

    public void setCurrentView(String string) {
        this.createHelpWindow();
        JHelpNavigator jHelpNavigator = null;
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements() && !ResourceUtil.areEquals((jHelpNavigator = (JHelpNavigator)enumeration.nextElement()).getNavigatorName(), string)) {
            jHelpNavigator = null;
        }
        if (jHelpNavigator == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.jhelp.setCurrentNavigator(jHelpNavigator);
    }

    public void initPresentation() {
        this.createHelpWindow();
    }

    public String getCurrentView() {
        this.createHelpWindow();
        return this.jhelp.getCurrentNavigator().getNavigatorName();
    }

    Window getHelpWindow() {
        if (this.modallyActivated) {
            return this.dialog;
        }
        return this.frame;
    }

    public void dispose() {
        if (null != this.dialog) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if (null != this.frame) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayed(boolean bl) {
        Object object;
        logger.debug("setDisplayed");
        if (bl) {
            try {
                object = this.helpLock;
                synchronized (object) {
                    logger.trace("Going to notify....." + System.currentTimeMillis());
                    this.isNotified = true;
                    this.helpLock.notifyAll();
                    logger.trace("Notified....." + System.currentTimeMillis());
                }
                this.createHelpWindow();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        if (this.modallyActivated) {
            if (bl) {
                this.dialog.show();
            } else if (this.dialog != null) {
                this.dialog.hide();
            }
        } else {
            if (this.frame != null) {
                try {
                    object = System.getProperty("os.name");
                    if (object != null && ((String)object).startsWith("Sun")) {
                        this.frame.hide();
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    logger.error("An error occured at setDisplayed()");
                    logger.trace(arrayIndexOutOfBoundsException.getMessage(), arrayIndexOutOfBoundsException);
                    HelpManager.stopHelpServer();
                }
                this.setState();
            }
            this.frame.setVisible(bl);
        }
    }

    public boolean isDisplayed() {
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.isShowing();
            }
            return false;
        }
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                return false;
            }
            return this.getState();
        }
        return false;
    }

    public void setLocation(Point point) throws UnsupportedOperationException {
        this.createHelpWindow();
        if (this.modallyActivated) {
            this.dialog.setLocation(point);
        } else {
            this.frame.setLocation(point);
        }
    }

    public Point getLocation() throws UnsupportedOperationException {
        if (null == this.jhelp) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.getLocation();
            }
        } else if (this.frame != null) {
            return this.frame.getLocation();
        }
        return null;
    }

    public Dimension getSize() throws UnsupportedOperationException {
        if (null == this.jhelp) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (null != this.dialog) {
                return this.dialog.getSize();
            }
        } else if (null != this.frame) {
            return this.frame.getSize();
        }
        return null;
    }

    public void setSize(Dimension dimension) throws UnsupportedOperationException {
        this.hELP_WIDTH = dimension.width;
        this.hELP_HEIGHT = dimension.height;
        this.createHelpWindow();
        if (this.modallyActivated) {
            this.dialog.setSize(dimension);
            this.dialog.validate();
        } else {
            this.frame.setSize(dimension);
            this.frame.validate();
        }
    }

    public void setViewDisplayed(boolean bl) {
        this.createHelpWindow();
        this.jhelp.setNavigatorDisplayed(bl);
    }

    public boolean isViewDisplayed() {
        this.createHelpWindow();
        return this.jhelp.isNavigatorDisplayed();
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        block2: {
            IViewHelpBroker.debug("setCurrentID");
            this.createJHelp();
            String string = this.getHistoryname(iD);
            try {
                this.jhelp.getModel().setCurrentID(iD, string, this.jhelp.getCurrentNavigator());
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                if (this.jhelp == null) break block2;
                DefaultHelpModel defaultHelpModel = new DefaultHelpModel(this.helpset);
                this.jhelp.setModel((TextHelpModel)defaultHelpModel);
            }
        }
    }

    public void setCurrentID(String string) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create((String)string, (HelpSet)this.helpset));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            logger.trace(invalidHelpSetContextException.getMessage(), invalidHelpSetContextException);
        }
    }

    public String getHistoryname(Map.ID iD) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeByID(this.helpset, iD);
        if (defaultMutableTreeNode == null) {
            return "";
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null) {
            return tOCItem.getName();
        }
        return "";
    }

    private DefaultMutableTreeNode findNodeByID(HelpSet helpSet, Map.ID iD) {
        TOCView tOCView = (TOCView)helpSet.getNavigatorView("TOC");
        DefaultMutableTreeNode defaultMutableTreeNode = tOCView.getDataAsTree();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNode(defaultMutableTreeNode, iD);
        if (defaultMutableTreeNode2 != null) {
            return defaultMutableTreeNode2;
        }
        Enumeration enumeration = helpSet.getHelpSets();
        if (enumeration == null) {
            return null;
        }
        HelpSet helpSet2 = null;
        while (enumeration.hasMoreElements()) {
            helpSet2 = (HelpSet)enumeration.nextElement();
            defaultMutableTreeNode2 = this.findNodeByID(helpSet2, iD);
            if (defaultMutableTreeNode2 == null) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD) {
        Map.ID iD2;
        if (iD == null) {
            return null;
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null && (iD2 = tOCItem.getID()) != null && ResourceUtil.areEquals(iD2.id, iD.id)) {
            return defaultMutableTreeNode;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNode(defaultMutableTreeNode2, iD);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public Map.ID getCurrentID() {
        return this.jhelp != null ? this.jhelp.getModel().getCurrentID() : null;
    }

    public void setCurrentURL(URL uRL) {
        this.createHelpWindow();
        this.jhelp.getModel().setCurrentURL(uRL);
        if (this.modallyActivated) {
            this.dialog.setVisible(true);
            this.dialog.show();
        } else {
            this.frame.setVisible(true);
            this.frame.show();
        }
    }

    public URL getCurrentURL() {
        return this.jhelp.getModel().getCurrentURL();
    }

    public void enableHelpKey(Component component, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 1);
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            component.addKeyListener(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 112 || n == 156) {
            ActionListener actionListener = this.getDisplayHelpFromFocus();
            actionListener.actionPerformed(new ActionEvent(keyEvent.getComponent(), 1001, null));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    public void enableHelp(Component component, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
    }

    public void enableHelp(MenuItem menuItem, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
    }

    private boolean isDisplayListenerExist(ActionListener[] actionListenerArray) {
        if (null != actionListenerArray) {
            for (int i = 0; i < actionListenerArray.length; ++i) {
                if (!(actionListenerArray[i] instanceof CSH.DisplayHelpFromSource)) continue;
                return true;
            }
        }
        return false;
    }

    public void enableHelpOnButton(Component component, String string, HelpSet helpSet) {
        if (!(component instanceof AbstractButton) && !(component instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            ActionListener[] actionListenerArray = abstractButton.getActionListeners();
            if (this.isDisplayListenerExist(actionListenerArray)) {
                return;
            }
            abstractButton.addActionListener(this.getDisplayHelpFromSource());
        } else if (component instanceof Button) {
            Button button = (Button)component;
            ActionListener[] actionListenerArray = button.getActionListeners();
            if (this.isDisplayListenerExist(actionListenerArray)) {
                return;
            }
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem menuItem, String string, HelpSet helpSet) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
        menuItem.addActionListener(this.getDisplayHelpFromSource());
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (null == this.displayHelpFromSource) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (null == this.displayHelpFromFocus) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    public void setActivationWindow(Window window) {
        if (window != null && window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (dialog.isModal()) {
                this.modallyActivated = true;
                this.ownerWindow = window;
            } else {
                this.modallyActivated = false;
                this.ownerWindow = null;
            }
        } else {
            this.modallyActivated = false;
            this.ownerWindow = null;
        }
    }

    private synchronized void createJHelp() {
        IViewHelpBroker.debug("createJHelp");
        if (this.jhelp == null) {
            this.jhelp = new JHelp(this.helpset);
            if (null != this.font) {
                this.jhelp.setFont(this.font);
            }
            if (null != this.locale) {
                this.jhelp.setLocale(this.locale);
            }
        }
    }

    private synchronized void createHelpWindow() {
        IViewHelpBroker.debug("createHelpWindow");
        Point point = null;
        Dimension dimension = null;
        JDialog jDialog = null;
        this.createJHelp();
        String string = this.helpset.getTitle();
        if (this.modallyActivated) {
            Window window = null;
            try {
                Method method = Window.class.getMethod("getOwner", null);
                if (method != null && this.dialog != null) {
                    window = (Window)method.invoke((Object)this.dialog, null);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                logger.trace("IViewHelpBroker:createHelpWindow: NoSuchMethodError is thrown.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.trace("IViewHelpBroker:createHelpWindow: NoSuchMethodException is thrown.");
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.trace("IViewHelpBroker:createHelpWindow: java.lang.reflect.InvocationTargetException is thrown.");
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace("IViewHelpBroker:createHelpWindow: java.lang.IllegalAccessException is thrown.");
            }
            if (this.dialog == null || window != this.ownerWindow || this.modalDeactivated) {
                if (null != this.dialog) {
                    jDialog = this.dialog;
                    dimension = this.dialog.getSize();
                    point = this.dialog.getLocation();
                }
                if (null != this.frame) {
                    dimension = this.frame.getSize();
                    point = this.frame.getLocation();
                    this.frame.dispose();
                }
                if (on1dot1) {
                    this.dialog = new JDialog();
                    this.dialog.setTitle(string);
                } else {
                    this.dialog = new JDialog((Dialog)this.ownerWindow, string);
                    this.dl = new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            IViewHelpBroker.debug("modal window closing");
                            if (null != IViewHelpBroker.this.dialog && IViewHelpBroker.this.dialog.isShowing()) {
                                IViewHelpBroker.this.dialog.hide();
                            }
                            if (null != IViewHelpBroker.this.ownerWindow) {
                                IViewHelpBroker.this.ownerWindow.removeWindowListener(IViewHelpBroker.this.dl);
                            }
                            IViewHelpBroker.this.ownerWindow = null;
                            IViewHelpBroker.this.modalDeactivated = true;
                        }
                    };
                    this.modalDeactivated = false;
                    IViewHelpBroker.debug("adding windowlistener");
                    this.ownerWindow.addWindowListener(this.dl);
                }
                if (dimension == null) {
                    this.dialog.setSize(this.hELP_WIDTH, this.hELP_HEIGHT);
                } else {
                    this.dialog.setSize(dimension);
                }
                if (null != point) {
                    this.dialog.setLocation(point);
                }
                this.dialog.getContentPane().add((Component)this.jhelp);
                if (null != jDialog) {
                    jDialog.dispose();
                }
            }
        } else {
            if (this.frame == null) {
                this.frame = new HelpFrame(string, this.helpset, this.jhelp);
            }
            if (this.dialog != null) {
                dimension = this.dialog.getSize();
                point = this.dialog.getLocation();
                this.dialog.dispose();
                this.ownerWindow = null;
                this.dialog = null;
            }
            if (dimension != null) {
                this.frame.setSize(dimension);
            } else {
                this.frame.setSize(this.hELP_WIDTH, this.hELP_HEIGHT);
            }
            if (this.frame instanceof HelpFrame) {
                this.frame.addJHelp(this.jhelp);
            } else {
                this.frame.getContentPane().add((Component)this.jhelp);
            }
            this.frame.setTitle(this.helpset.getTitle());
        }
    }

    private static void debug(Object object) {
    }

    public void closeHelpWithDelay() {
        if (HelpManager.isStopHelp()) {
            logger.trace("Stoping help.....");
            final int n = HelpManager.getHelpStopDelay();
            logger.trace("delay = " + n);
            if (n <= 0) {
                HelpManager.stopHelpServer();
            } else {
                logger.trace("Closing help.....");
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HelpLock helpLock = IViewHelpBroker.this.helpLock;
                        synchronized (helpLock) {
                            logger.trace("Going to wait....." + System.currentTimeMillis());
                            try {
                                IViewHelpBroker.this.isNotified = false;
                                IViewHelpBroker.this.helpLock.wait(n);
                                logger.trace("Cam out wait....." + System.currentTimeMillis() + IViewHelpBroker.this.isNotified);
                                if (!IViewHelpBroker.this.isNotified) {
                                    logger.trace("Going to Stop....." + System.currentTimeMillis());
                                    HelpManager.stopHelpServer();
                                    logger.trace("Going to Stoped....." + System.currentTimeMillis());
                                }
                                IViewHelpBroker.this.isNotified = false;
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                    }
                }).start();
            }
        }
    }

    private void initializeHelpClassLoader() {
        String string = System.getProperty("os.name");
        if (string.indexOf("SunOS") != -1) {
            UIManager.getDefaults().put("ClassLoader", HelpAdapter.class.getClassLoader());
        }
    }

    private void setState() {
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = Frame.class.getMethod("setState", classArray);
            if (method != null) {
                Object[] objectArray = new Object[]{0};
                method.invoke((Object)this.frame, objectArray);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            logger.trace(noSuchMethodError.getMessage(), noSuchMethodError);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean getState() {
        try {
            Method method = Frame.class.getMethod("getState", null);
            if (method != null) {
                int n = (Integer)method.invoke((Object)this.frame, null);
                return n == 0;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            logger.trace("IViewHelpBroker:isDisplayed: NoSuchMethodError is thrown.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.trace("IViewHelpBroker:isDisplayed: NoSuchMethodException is thrown.");
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.trace("IViewHelpBroker:isDisplayed: InvocationTargetException is thrown.");
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.trace("IViewHelpBroker:isDisplayed: IllegalAccessException is thrown.");
        }
        return true;
    }

    static {
        try {
            Class[] classArray = new Class[]{Dialog.class, Boolean.TYPE};
            Constructor constructor = JDialog.class.getConstructor(classArray);
            on1dot1 = constructor == null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            on1dot1 = true;
        }
    }

    private class HelpLock {
        private HelpLock() {
        }
    }
}

