/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.HelpBundle;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.helpmanagement.IViewHelpBroker;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.SwingUtilities;

public class HelpServer
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(HelpServer.class, "IVIEW");
    private static final int BUFFER_LENGTH = 1024;
    private DatagramSocket server = null;
    private DatagramPacket buf = new DatagramPacket(new byte[1024], 1024);
    private boolean isFirstShowHelp = true;
    private final Object lock = new Object();
    private int count = 0;
    private IviewUtilTimer timer = null;
    private static final long INTERVAL = 3000L;
    private static final int MAX_CHECKCOUNT = 60;
    private int port = 0;
    private boolean isHelpPreLoading = true;

    public HelpServer(int n) throws Exception {
        this(n, null);
    }

    public HelpServer(int n, String string) throws Exception {
        this.port = n;
        this.server = new DatagramSocket(n);
        this.start();
        HelpManager.getInstance().setStartFlg(true);
        if (string != null) {
            this.displayHelp(string);
        }
    }

    final void close() {
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    @Override
    public void run() {
        if ("true".equals(System.getProperty("mainrun"))) {
            this.startCountThread();
        }
        this.waitForClient();
    }

    private void startCountThread() {
        this.timer = new IviewUtilTimer();
        this.timer.schedule(new IviewTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (FrameworkHelper.isOSGIHelpClient() && !HelpBundle.isActive()) {
                    this.cancel();
                }
                Object object = HelpServer.this.lock;
                synchronized (object) {
                    HelpServer.this.count++;
                }
                if (HelpServer.this.count > 60) {
                    logger.debug("Shake hand error,HelpManager exit!");
                    HelpManager.stopHelpServer();
                }
            }
        }, 3000L, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClient() {
        try {
            while (true) {
                Object object;
                this.server.receive(this.buf);
                byte[] byArray = this.buf.getData();
                if (!this.buf.getAddress().equals(InetAddress.getLocalHost())) {
                    logger.warn("Request rejected from host" + this.buf.getAddress());
                    continue;
                }
                String string = null;
                if (!HelpManagerUtil.getInstance().isValidId(byArray, this.buf.getLength())) {
                    string = new String(byArray, 0, this.buf.getLength());
                    logger.warn("Invalid ID: " + string);
                    continue;
                }
                string = HelpManagerUtil.getInstance().filtSalt(byArray, this.buf.getLength());
                if (string.indexOf("\n") != -1) {
                    logger.warn("breaked ID: " + string);
                    continue;
                }
                if ("mainprogramexit".equals(string)) {
                    HelpManager.stopHelpServer();
                    break;
                }
                if (string.startsWith("mainprogramexitwithconfirm")) {
                    object = string.substring("mainprogramexitwithconfirm".length());
                    HelpManager.stopServerWithConfirm((String)object);
                } else {
                    if (string.startsWith("changehelpsetcommand")) {
                        object = string.substring("changehelpsetcommand".length());
                        logger.debug("Receive change helpSet command. HelpSetName=[" + (String)object + ']');
                        HelpManager.getInstance().reloadHelpIdRes((String)object);
                        HelpManager.getInstance().loadHelpSet((String)object);
                        HelpManager.getInstance().setDisplayed(false);
                        logger.debug("helpFrame set visible is false!");
                        continue;
                    }
                    if (string.startsWith("addsubhelpsetcommand")) {
                        logger.debug("Help id =" + string);
                        object = string.substring("addsubhelpsetcommand".length());
                        HelpManager.getInstance().addSubHelpSet((String)object, true);
                        continue;
                    }
                    if (string.startsWith("removesubhelpsetcommand")) {
                        logger.debug("Help id =" + string);
                        object = string.substring("removesubhelpsetcommand".length());
                        HelpManager.getInstance().removeSubHelpSet((String)object, true);
                        continue;
                    }
                    if (string.startsWith("shakehandcommand")) {
                        object = this.lock;
                        synchronized (object) {
                            this.count = 0;
                        }
                    }
                }
                logger.trace("displayHelp begin help id =" + string);
                object = this.lock;
                synchronized (object) {
                    this.displayHelp(string);
                }
                logger.trace("displayHelp end");
            }
        }
        catch (Exception exception) {
            logger.trace("HelpServer is closed");
            logger.trace(exception.getMessage(), exception);
            this.close();
        }
    }

    private void displayHelp(String string) {
        final IViewHelpBroker iViewHelpBroker = HelpManager.getInstance().getHelpBroker();
        HelpSet helpSet = iViewHelpBroker.getHelpSet();
        try {
            Map.ID iD = null;
            String string2 = null;
            int n = string.indexOf("ANCHOR200703130318");
            if (n > 0) {
                string2 = string.substring(n + "ANCHOR200703130318".length());
                string = string.substring(0, n);
            }
            if (n < 0) {
                block11: {
                    try {
                        iD = Map.ID.create((String)string, (HelpSet)helpSet);
                    }
                    catch (BadIDException badIDException) {
                        iD = helpSet.getHomeID();
                        if (iD != null) break block11;
                        throw badIDException;
                    }
                }
                iViewHelpBroker.setCurrentID(iD);
            } else {
                try {
                    iD = Map.ID.create((String)string, (HelpSet)helpSet);
                    URL uRL = iD.getURL();
                    StringBuffer stringBuffer = new StringBuffer(40);
                    stringBuffer.append(uRL.getProtocol());
                    stringBuffer.append(':');
                    stringBuffer.append(uRL.getPath());
                    stringBuffer.append('#');
                    stringBuffer.append(string2);
                    logger.trace("displayHelp: url = " + stringBuffer.toString());
                    URL uRL2 = new URL(stringBuffer.toString());
                    iViewHelpBroker.setCurrentURL(uRL2);
                }
                catch (BadIDException badIDException) {
                    iD = helpSet.getHomeID();
                    if (iD == null) {
                        throw badIDException;
                    }
                    iViewHelpBroker.setCurrentID(iD);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = System.getProperty("isfasthelpmode");
                        boolean bl = Boolean.valueOf(string);
                        logger.trace("isHelpPreLoading Value : " + HelpServer.this.isHelpPreLoading);
                        if (bl && HelpServer.this.isHelpPreLoading) {
                            logger.trace("Pre Loading Online Help is done...");
                            HelpServer.this.isHelpPreLoading = false;
                            return;
                        }
                        logger.trace("Help Frame is show.");
                        iViewHelpBroker.setDisplayed(true);
                        ((IViewHelpBroker)iViewHelpBroker).getHelpWindow().setVisible(true);
                    }
                    catch (Throwable throwable) {
                        logger.trace("An error occured at setDisplayed()");
                        logger.trace(throwable.getMessage(), throwable);
                    }
                    if (HelpServer.this.isFirstShowHelp) {
                        ((IViewHelpBroker)iViewHelpBroker).getHelpWindow().addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent windowEvent) {
                                ((IViewHelpBroker)iViewHelpBroker).getHelpWindow().hide();
                                logger.trace("Help Frame is hide.");
                                if (System.getProperty("mainrun") == null || "false".equals(System.getProperty("mainrun"))) {
                                    logger.trace("mainrun=null will stop server");
                                    HelpManager.stopHelpServer();
                                } else {
                                    ((IViewHelpBroker)iViewHelpBroker).closeHelpWithDelay();
                                }
                            }

                            @Override
                            public void windowClosed(WindowEvent windowEvent) {
                                ((IViewHelpBroker)iViewHelpBroker).getHelpWindow().hide();
                                if (System.getProperty("mainrun") == null || "false".equals(System.getProperty("mainrun"))) {
                                    HelpManager.stopHelpServer();
                                } else {
                                    ((IViewHelpBroker)iViewHelpBroker).closeHelpWithDelay();
                                }
                            }
                        });
                        HelpServer.this.isFirstShowHelp = false;
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            logger.trace("An error occured at displayHelp()");
            logger.trace(throwable.getMessage(), throwable);
        }
    }

    public int getPort() {
        return this.port;
    }
}

