/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public final class HelpManagerUtil {
    private static IviewLogger logger = IviewLogger.getLogger(HelpManagerUtil.class, "IVIEW");
    private static final HelpManagerUtil instance = new HelpManagerUtil();
    private static final String SALT = "#(SWPD33742A29D09487)";
    private static final String LIB = HelpManagerUtil.getLibPath();
    static final String DEFAULT_DIR = LIB + "/filelock/onlinehelp/";
    private static final String START_LOCK_FILE = DEFAULT_DIR + "start.lock";
    private RandomAccessFile startFile = null;
    private static FileChannel startFileChannel = null;
    private static final String lockFileName = LIB + "/filelock/onlinehelp.lock";
    private static RandomAccessFile read = null;
    private static FileChannel fileChannel = null;
    private static final File HELP_DIR = CommonUtil.getAbsoluteFile("./help");

    private HelpManagerUtil() {
    }

    private static String getLibPath() {
        File file = new File("./lib/filelock/onlinehelp/start.lock");
        File file2 = new File("./lib/filelock/onlinehelp.lock");
        if (file.exists() && file2.exists()) {
            return "./lib";
        }
        return "../lib";
    }

    public static HelpManagerUtil getInstance() {
        return instance;
    }

    byte[] putSalt(String string) {
        return (string + SALT).getBytes();
    }

    String filtSalt(byte[] byArray, int n) {
        String string = new String(byArray, 0, n - SALT.length());
        return string;
    }

    boolean isValidId(byte[] byArray, int n) {
        if (byArray == null || n < SALT.length()) {
            return false;
        }
        return SALT.equals(this.getSalt(byArray, n));
    }

    private String getSalt(byte[] byArray, int n) {
        return new String(byArray, n - SALT.length(), SALT.length());
    }

    void writeTimeStrToFile(int n, String string) {
        File file = CommonUtil.getAbsoluteFile(DEFAULT_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        CommonUtil.writeStrToFile(DEFAULT_DIR + n + ".dat", string);
    }

    void deleteFile(int n) {
        String string = DEFAULT_DIR + n + ".dat";
        File file = CommonUtil.getAbsoluteFile(string);
        if (file.exists() && !file.delete()) {
            logger.error("Failed to delete the file " + string);
        }
    }

    String getTimeStrFromFile(int n) {
        return CommonUtil.getStrFromFile(DEFAULT_DIR + n + ".dat");
    }

    boolean checkTimeEqual(String string, int n) {
        String string2 = this.getTimeStrFromFile(n);
        if (null == string2) {
            return false;
        }
        return string2.equals(string);
    }

    boolean preCheckConf() {
        return HELP_DIR.exists() && this.addStartWriteLock();
    }

    boolean addStartWriteLock() {
        File file = CommonUtil.getAbsoluteFile(START_LOCK_FILE);
        if (!file.exists()) {
            return true;
        }
        try {
            this.startFile = new RandomAccessFile(file, "rw");
            startFileChannel = this.startFile.getChannel();
            FileLock fileLock = startFileChannel.lock();
            if (null != fileLock && fileLock.isValid()) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.removeStartWriteLock();
        logger.error("Failed to add file lock at file:lib/filelock/onlinehelp/start.lock");
        return false;
    }

    void removeStartWriteLock() {
        try {
            if (null != startFileChannel) {
                startFileChannel.close();
                startFileChannel = null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        try {
            if (null != this.startFile) {
                this.startFile.close();
                this.startFile = null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    boolean addReadLock() {
        File file = CommonUtil.getAbsoluteFile(lockFileName);
        if (!file.exists()) {
            return true;
        }
        try {
            read = new RandomAccessFile(file, "r");
            fileChannel = read.getChannel();
            FileLock fileLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
            if (null != fileLock && fileLock.isValid()) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.removeReadLock();
        logger.error("Failed to add file lock at file:lib/filelock/onlinehelp.lock");
        return false;
    }

    void removeReadLock() {
        try {
            if (null != fileChannel) {
                fileChannel.close();
                fileChannel = null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        try {
            if (null != read) {
                read.close();
                read = null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(String string, int n) {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            this.sendMsg(datagramSocket, string, n);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            datagramSocket.close();
        }
    }

    void sendMsg(DatagramSocket datagramSocket, String string, int n) {
        try {
            byte[] byArray = HelpManagerUtil.getInstance().putSalt(string);
            byte[] byArray2 = new byte[1024];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            datagramSocket.send(new DatagramPacket(byArray2, byArray.length, InetAddress.getLocalHost(), n));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void sendExitCmdToPort(String string, int n) {
        String string2 = "mainprogramexitwithconfirm" + string;
        this.sendMsg(string2, n);
    }
}

