/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.subsystemmanagement.SubsystemInfo;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.RegistryUtilities;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.CSH;
import com.swimap.iview.util.helpmanagement.HelpAdapter;
import com.swimap.iview.util.helpmanagement.HelpClient;
import com.swimap.iview.util.helpmanagement.HelpIntegrator;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.helpmanagement.HelpServer;
import com.swimap.iview.util.helpmanagement.IHedexHelpInterface;
import com.swimap.iview.util.helpmanagement.IHelpIntegrator;
import com.swimap.iview.util.helpmanagement.IHelpManager;
import com.swimap.iview.util.helpmanagement.IViewHelpBroker;
import com.swimap.iview.util.helpmanagement.IViewHelpSet;
import com.swimap.iview.util.helpmanagement.XMLDocumentUtil;
import com.swimap.iview.util.helpmanagement.xml.Index;
import com.swimap.iview.util.helpmanagement.xml.Indexitem;
import com.swimap.iview.util.helpmanagement.xml.Map;
import com.swimap.iview.util.helpmanagement.xml.MapID;
import com.swimap.iview.util.helpmanagement.xml.Toc;
import com.swimap.iview.util.helpmanagement.xml.Tocitem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Button;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public final class HelpManager
implements IHelpManager {
    private static final String DTDPATTERN = "helpset_(\\d)_(\\d).dtd";
    private static final String HS_MERGE_COMMENT_BEGIN = "For_Subhelp_merge_Begin";
    private static final String HS_MERGE_COMMENT_END = "For_Subhelp_merge_End";
    private static IviewLogger logger = IviewLogger.getLogger(HelpManager.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/helpmanagement/Res");
    public static final String ANCHOR_SEPARATOR = "ANCHOR200703130318";
    public static final String HELP_ID_PROPERTY = "HELP_ID_PROPERTY";
    private static String destinationFileNameHeader = "help";
    public static final String CONFIRMEXITCMD = "mainprogramexitwithconfirm";
    public static final String ENDFLG = "mainprogramexit";
    public static final String CHANGEHELPSET = "changehelpsetcommand";
    public static final String SHAKEHANDCOMMAND = "shakehandcommand";
    public static final String SHOWHELPMENUFLG = "showhelpmenuflg";
    public static final String HELPSETPATHANDNAME = "helpsetpathandname";
    public static final String SUBHELPSETFILENAME = "subhelpsetfilename";
    public static final String REMOVESUBHELPSETFILENAME = "removesubhelpsetfilename";
    public static final String ADDSUBHELPSET = "addsubhelpsetcommand";
    public static final String REMOVESUBHELPSET = "removesubhelpsetcommand";
    private static final String HELP_FAST_LOAD = "fasthelpmode";
    static final int BUFFER_LENGTH = 1024;
    private static final int DEFAULT_PORT = 5000;
    private static JFrame defaultMainFrame = null;
    private static String baseFileNameHeader = "base";
    private IViewHelpBroker helpBroker = null;
    private HelpSet helpSet = null;
    private static HelpClient helpClient = null;
    private static HelpServer helpServer = null;
    private static boolean showHelpMenuFlg = true;
    private static String mainClassName = "com.swimap.iview.util.helpmanagement.HelpAdapter";
    private static ImageIcon helpFrameIcon = null;
    private static String aboutDlgClassName = "javax.swing.JDialog";
    private static String helpSetName = "";
    private volatile boolean started = false;
    private volatile boolean starting = false;
    private static String startTime = null;
    private static ResourceBundle helpIDRes = null;
    private static final long INTERVAL = 30000L;
    private Hashtable subHelpTable = new Hashtable(15);
    private Hashtable subHelpSetInHelpConfigureFile = new Hashtable(12);
    private static File tmpFileDir = CommonUtil.getAbsoluteFile("./help");
    public static final String Index_suffix = "_index.xml";
    public static final String Toc_suffix = "_toc.xml";
    public static final String Map_suffix = "_map.jhm";
    public static final String HS_FILE = "help.hs";
    public static final String Index_Dir = "plugin/index/";
    public static final String Toc_Dir = "plugin/toc/";
    public static final String Map_Dir = "plugin/map/";
    public static final String HELPSET_DIR = "plugin/hs/";
    public static final String SUBSYSTEM_HELP_DIR = "subsystemhelp";
    private static final String HELP_CLASSNAME_PARAM_NAME = "-DProductHelpClass";
    private static boolean isPreLaunch = false;
    private static IHelpIntegrator productHelpImp = null;
    private static HashMap<String, String> hedexParamMap = new HashMap(5);
    private static List<IHedexHelpInterface> hedexHelpListeners = null;
    static final String[] browsers = new String[]{"firefox", "netscape", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    private static HelpManager instance;
    private static final String SUBHELPSET = "subhelpset";
    private static String browserPath;

    private HelpManager() {
        if (null == productHelpImp) {
            if (this.isNeedMerge()) {
                HelpManager.merge(baseFileNameHeader);
            }
            this.loadHelpSet();
        }
        if (!HelpManager.isWebBrowserEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HelpManagerUtil.getInstance().removeReadLock();
                    HelpManager.getInstance().launchHelper(HelpManager.ENDFLG);
                    DebugTracer.cleanup();
                }
            });
        }
    }

    public static HelpManager getInstance() {
        if (instance == null) {
            instance = new HelpManager();
        }
        return instance;
    }

    public static void setDefaultLocale(Locale locale) {
        try {
            Locale.setDefault(locale);
        }
        catch (Exception exception) {
            Locale.setDefault(Locale.US);
        }
    }

    public static void setDestinationFileNameHeader(String string) {
        if (string != null) {
            destinationFileNameHeader = string;
        }
    }

    public static void setMainFrame(JFrame jFrame) {
        defaultMainFrame = jFrame;
    }

    public static JFrame getMainFrame() {
        return defaultMainFrame;
    }

    public static void setHelpFrameIcon(ImageIcon imageIcon) {
        helpFrameIcon = imageIcon;
    }

    public static ImageIcon getHelpFrameIcon() {
        return helpFrameIcon;
    }

    public static void setAboutDlgClassName(String string) {
        aboutDlgClassName = string;
    }

    public static String getAboutDlgClassName() {
        return aboutDlgClassName;
    }

    public static void setMainClassName(String string) {
        mainClassName = string;
    }

    public static String getMainClassName() {
        return mainClassName;
    }

    public static void updateHelpSet() {
        logger.debug("invoke the updateHelpSet() method!");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("help");
        stringBuffer.append(File.separator);
        stringBuffer.append(Locale.getDefault().toString());
        stringBuffer.append(File.separator);
        try {
            stringBuffer.append(destinationFileNameHeader);
            if (!stringBuffer.toString().endsWith(".hs")) {
                stringBuffer.append(".hs");
            }
            HelpManager.setHelpSetName(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static void setHelpSetName(String string) {
        HelpManager.getInstance().launchHelper(ENDFLG);
        helpSetName = string;
        logger.debug("invoke setHelpSetName()");
        HelpManager.getInstance().reloadHelpIdRes(helpSetName);
        HelpManager.getInstance().loadHelpSet(helpSetName);
        HelpManager.sendRemoteHelp(CHANGEHELPSET + string);
    }

    public static String getHelpSetName() {
        return helpSetName;
    }

    public static void setShowHelpMenuFlg(boolean bl) {
        showHelpMenuFlg = bl;
    }

    public static boolean getShowHelpMenuFlg() {
        return showHelpMenuFlg;
    }

    public static final String encodeHedexStr(String string) {
        if (null == string || "".equals(string)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length() * 6);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                if (c < '\u007f') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c < '\u0100') {
                    stringBuffer.append("%");
                    if (c < '\u0010') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toString(c, 16));
                    continue;
                }
                stringBuffer.append("%u");
                if (c < '\u1000') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            if (c < '\u0100') {
                stringBuffer.append("%");
                if (c < '\u0010') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append("%u");
            if (c < '\u1000') {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(c, 16));
        }
        return stringBuffer.toString();
    }

    public String getHelpID(String string) {
        if (null != helpIDRes) {
            return helpIDRes.getString(string);
        }
        return null;
    }

    public void launchHelper(JDialog jDialog, String string) {
        if (null == productHelpImp) {
            try {
                HelpManager.sendRemoteHelp(string);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            productHelpImp.launchHelper(jDialog, string);
        }
    }

    public synchronized void launchHelper(String string) {
        if (null == productHelpImp) {
            try {
                HelpManager.sendRemoteHelp(string);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            productHelpImp.launchHelper(string);
        }
    }

    public synchronized void launchHelper(String string, String string2) {
        if (productHelpImp instanceof HelpIntegrator) {
            ((HelpIntegrator)productHelpImp).launchHelper(string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append(string);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(ANCHOR_SEPARATOR);
                stringBuffer.append(string2);
            }
            this.launchHelper(stringBuffer.toString());
        }
    }

    @Override
    public void launchHelper() {
        if (null == productHelpImp) {
            String string = "";
            string = HelpManager.isWebBrowserEnabled() ? System.getProperty("homepage") : this.getHomeID();
            this.launchHelper(string);
        } else {
            productHelpImp.launchHelper();
        }
    }

    public void preLaunchHelp() {
        boolean bl = this.getStartFlg();
        if (!bl) {
            HelpManager.setIsHelpPreLaunch(true);
            this.launchHelper();
            HelpManager.setIsHelpPreLaunch(false);
        }
    }

    public static boolean isHelpPreLaunch() {
        return isPreLaunch;
    }

    private static void setIsHelpPreLaunch(boolean bl) {
        isPreLaunch = bl;
    }

    public static boolean isFastLoadingMode() {
        String string = System.getProperty(HELP_FAST_LOAD);
        if (null == string) {
            string = "true";
        }
        return Boolean.valueOf(string) != false && productHelpImp == null;
    }

    public void enableHelpOnButton(Component component, String string) {
        if (null == productHelpImp) {
            if (!(component instanceof AbstractButton) && !(component instanceof Button)) {
                throw new IllegalArgumentException("Invalid Component");
            }
            try {
                if (helpIDRes != null) {
                    string = helpIDRes.getString(string);
                }
            }
            catch (Exception exception) {
                logger.warn("Can not find the resource for help ID " + string + " in file ./help/helpid.properties");
            }
            final String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("id");
            }
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ActionListener[] actionListenerArray = abstractButton.getActionListeners();
                this.removeHelpListener(abstractButton, actionListenerArray);
                abstractButton.addActionListener(new LaunchHelpListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HelpManager.this.launchHelper(string2);
                    }
                });
            } else if (component instanceof Button) {
                Button button = (Button)component;
                ActionListener[] actionListenerArray = button.getActionListeners();
                this.removeHelpListener(button, actionListenerArray);
                button.addActionListener(new LaunchHelpListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HelpManager.this.launchHelper(string2);
                    }
                });
            }
        } else {
            productHelpImp.enableHelpOnButton(component, string);
        }
    }

    private void removeHelpListener(Component component, ActionListener[] actionListenerArray) {
        if (null != actionListenerArray && null != component) {
            for (int i = 0; i < actionListenerArray.length; ++i) {
                if (!(actionListenerArray[i] instanceof LaunchHelpListener)) continue;
                logger.trace("Removing the old action listener " + actionListenerArray[i]);
                if (component instanceof AbstractButton) {
                    ((AbstractButton)component).removeActionListener(actionListenerArray[i]);
                    continue;
                }
                if (!(component instanceof Button)) continue;
                ((Button)component).removeActionListener(actionListenerArray[i]);
            }
        }
    }

    public void enableHelpOnButton(MenuItem menuItem, String string) {
        if (null == productHelpImp) {
            if (menuItem == null) {
                throw new IllegalArgumentException("Invalid Component");
            }
            try {
                if (helpIDRes != null) {
                    string = helpIDRes.getString(string);
                }
            }
            catch (Exception exception) {
                logger.warn("Can not find the resource for help ID " + string + " in file ./help/helpid.properties");
            }
            final String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("id");
            }
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpManager.this.launchHelper(string2);
                }
            });
        } else {
            productHelpImp.enableHelpOnButton(menuItem, string);
        }
    }

    public void enableHelpKey(Component component, String string) {
        if (null == productHelpImp) {
            if (component instanceof InternalFrame) {
                this.enableHelpKey(((InternalFrame)component).getContentPane(), string);
            } else if (component instanceof JRootPane && ((JRootPane)component).getParent() instanceof InternalFrame) {
                this.enableHelpKey(((JRootPane)component).getContentPane(), string);
            }
            if (helpIDRes != null) {
                try {
                    this.helpBroker.enableHelpKey(component, helpIDRes.getString(string), this.helpSet);
                    return;
                }
                catch (Exception exception) {
                    logger.warn("Can not find the resource for help ID " + string + " in file ./help/helpid.properties");
                }
            }
            try {
                this.helpBroker.enableHelpKey(component, string, this.helpSet);
            }
            catch (Exception exception) {
                logger.warn("Can not find the help ID " + string);
            }
        } else {
            productHelpImp.enableHelpKey(component, string);
        }
    }

    public void enableHelpKey(Component component, String string, String string2) {
        if (productHelpImp instanceof HelpIntegrator) {
            ((HelpIntegrator)productHelpImp).enableHelpKey(component, string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append(string);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(ANCHOR_SEPARATOR);
                stringBuffer.append(string2);
            }
            this.enableHelpKey(component, stringBuffer.toString());
        }
    }

    public IViewHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    public void loadHelpSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("help");
        stringBuffer.append(File.separator);
        stringBuffer.append(Locale.getDefault().toString());
        stringBuffer.append(File.separator);
        String string = stringBuffer.toString();
        try {
            stringBuffer.append(destinationFileNameHeader);
            if (!stringBuffer.toString().endsWith(".hs")) {
                stringBuffer.append(".hs");
            }
            this.loadHelpSet(stringBuffer.toString());
            this.addSubsystemSubHelpSet(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void addSubsystemSubHelpSet(String string) {
        string = string + SUBSYSTEM_HELP_DIR + File.separator;
        List<SubsystemInfo> list = SubsystemManager.getInstance().getAllSubsystem();
        if (null == this.helpSet) {
            logger.debug("helpSet is null. " + destinationFileNameHeader + ".hs is missing in help/en_US(or zh_CN) folder.");
            return;
        }
        for (SubsystemInfo subsystemInfo : list) {
            String string2 = string + subsystemInfo.getId() + File.separator + destinationFileNameHeader + ".hs";
            this.addSubHelpSet(string2);
        }
    }

    public void loadHelpSet(String string) {
        block4: {
            try {
                this.helpSet = this.getHelpSet(string);
                if (this.helpBroker == null) {
                    this.helpBroker = new IViewHelpBroker(this.helpSet);
                } else {
                    this.helpBroker.setHelpSet(this.helpSet);
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                if (!HelpManager.isWebBrowserEnabled()) break block4;
                this.helpBroker = new IViewHelpBroker();
            }
        }
    }

    private HelpSet getHelpSet(String string) throws HelpSetException {
        IViewHelpSet iViewHelpSet = null;
        if (null == string || string.trim().length() == 0) {
            logger.debug("helpSetName is null or length equals zero.");
            return iViewHelpSet;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer("");
        URL uRL = null;
        if (string.toLowerCase().startsWith("jar:file:")) {
            string2 = string;
        } else {
            stringBuffer.append("file:");
            stringBuffer.append(System.getProperty("user.dir"));
            stringBuffer.append(File.separator);
            stringBuffer.append(string);
            if (!stringBuffer.toString().endsWith(".hs")) {
                stringBuffer.append(".hs");
            }
            string2 = stringBuffer.toString();
        }
        logger.debug("fullHelpSetName=" + string2);
        uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string2);
        if (null == uRL) {
            try {
                uRL = new URL(string2.replace("#", "%23"));
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
        }
        iViewHelpSet = new IViewHelpSet(classLoader, uRL);
        return iViewHelpSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadHelpIdRes(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(System.getProperty("user.dir"));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        File file = CommonUtil.getAbsoluteFile(stringBuffer.toString());
        String string2 = file.getParentFile().getParent();
        BufferedInputStream bufferedInputStream = null;
        logger.debug("Invoke ReloadHelpIDRes method.");
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(CommonUtil.getAbsolutePath(string2 + "/helpid.properties")));
            helpIDRes = new PropertyResourceBundle(bufferedInputStream);
        }
        catch (Exception exception) {
            logger.warn("Read resource file helpid.properties error: ");
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            try {
                if (null != bufferedInputStream) {
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    public void enableHelp(Component component, String string) {
        if (null == productHelpImp) {
            if (helpIDRes != null) {
                try {
                    this.helpBroker.enableHelp(component, helpIDRes.getString(string), this.helpSet);
                    return;
                }
                catch (Exception exception) {
                    logger.warn("Can not find the resource for help ID " + string + " in file ./help/helpid.properties");
                }
            }
            try {
                this.helpBroker.enableHelp(component, string, this.helpSet);
            }
            catch (Exception exception) {
                logger.warn("Can not find the help ID " + string);
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            productHelpImp.enableHelp(component, string);
        }
    }

    public void enableHelp(MenuItem menuItem, String string) {
        if (helpIDRes != null) {
            try {
                this.helpBroker.enableHelp(menuItem, helpIDRes.getString(string), this.helpSet);
                return;
            }
            catch (Exception exception) {
                logger.warn("Can not find the resource for help ID " + string + " in file ./help/helpid.properties");
            }
        }
        try {
            this.helpBroker.enableHelp(menuItem, string, this.helpSet);
        }
        catch (Exception exception) {
            logger.warn("Can not find the help ID " + string);
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void setCurrentID(Component component) {
        this.helpBroker.setCurrentID(CSH.getHelpIDString(component));
    }

    public void setCurrentID(String string) {
        this.helpBroker.setCurrentID(string);
    }

    public String getHomeID() {
        String string = null;
        try {
            Map.ID iD = this.helpSet.getHomeID();
            if (null != iD) {
                string = iD.id;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return string;
    }

    public void setHomeID(String string) {
        this.helpSet.setHomeID(string);
    }

    public void setDisplayed(boolean bl) {
        this.helpBroker.setDisplayed(bl);
    }

    public boolean isDisplayed() {
        return this.helpBroker.isDisplayed();
    }

    public Font getFont() {
        return this.helpBroker.getFont();
    }

    public void setFont(Font font) {
        this.helpBroker.setFont(font);
    }

    public Dimension getSize() {
        return this.helpBroker.getSize();
    }

    public void setSize(Dimension dimension) {
        this.helpBroker.setSize(dimension);
    }

    public Map.ID getCurrentID() {
        return this.helpBroker.getCurrentID();
    }

    public void setViewDisplayed(boolean bl) {
        this.helpBroker.setViewDisplayed(bl);
    }

    static void sendRemoteHelp(String string) {
        if (null != FrameworkUtilities.getTerminalManager() && FrameworkUtilities.getTerminalManager().isLockOrUnLockDialogshown()) {
            logger.trace("Client is locked. Help window will not be shown.");
            return;
        }
        if (HelpManager.isWebBrowserEnabled()) {
            if (ENDFLG.equals(string)) {
                return;
            }
            if (string != null && (string.startsWith(CHANGEHELPSET) || string.startsWith(ADDSUBHELPSET) || string.startsWith(REMOVESUBHELPSET))) {
                return;
            }
            if (!HelpManager.isHelpPreLaunch()) {
                HelpManager.launchHelpBrowser(string);
                return;
            }
            return;
        }
        if (helpClient == null) {
            logger.trace("HelpManger sendRemoteHelp");
            if (ENDFLG.equals(string)) {
                return;
            }
            if (string != null && (string.startsWith(CHANGEHELPSET) || string.startsWith(ADDSUBHELPSET) || string.startsWith(REMOVESUBHELPSET))) {
                return;
            }
            try {
                helpClient = new HelpClient();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                return;
            }
        }
        helpClient.sendMessage(string);
    }

    private static boolean isWebBrowserEnabled() {
        String string = System.getProperty("webhost");
        String string2 = System.getProperty("homepage");
        return null != string && string.length() != 0 && null != string2 && string2.length() != 0;
    }

    public static String getHedexServerURL(String string, boolean bl) {
        String string2 = HelpManager.getURL(string);
        if (null != string2 && !bl) {
            string2 = string2 + "&ui=1";
        }
        return string2;
    }

    private static String getURL(String string) {
        Object object;
        String string2;
        String string3 = null;
        string3 = string == null || string.equals(System.getProperty("homepage")) ? System.getProperty("homepage") : System.getProperty("webhost") + string;
        string3 = HelpManager.changeURL(string3);
        String string4 = System.getProperty("hedexWebIP");
        String string5 = System.getProperty("hedexWebPort");
        if (null != string4 && null != string5) {
            string2 = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
            object = "\\b([0-9]*)";
            string3 = string3.replaceFirst(string2, string4);
            string3 = string3.replaceFirst(':' + (String)object, ':' + string5);
        }
        if (null != (string2 = System.getProperty("hedexWebProtocol")) && (string2.equalsIgnoreCase("https") || string2.equalsIgnoreCase("http"))) {
            object = "http(s)?";
            string3 = string3.replaceFirst((String)object, string2);
            logger.trace("Replaced HTTP url = " + string3);
        }
        for (Map.Entry entry : hedexParamMap.entrySet()) {
            string3 = HelpManager.setHedexParamProperty((String)entry.getKey(), (String)entry.getValue(), string3);
        }
        logger.trace("URL is :" + string3);
        return string3;
    }

    public void setHedexParam(String string, String string2) {
        if ("id".equals(string)) {
            throw new IllegalArgumentException("id key can not be set dynamically. Its used internally.");
        }
        hedexParamMap.put(string, string2);
    }

    private static String setHedexParamProperty(String string, String string2, String string3) {
        String string4 = string3;
        Matcher matcher = Pattern.compile("([\\?&]" + string + "=([^&$]*))").matcher(string4);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "";
        while (matcher.find()) {
            bl = true;
            string5 = matcher.group(1);
            string5 = string5.replaceAll(matcher.group(2), string2);
            matcher.appendReplacement(stringBuffer, string5);
        }
        if (bl) {
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        int n = string4.indexOf(63);
        if (n != -1) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string6 = string4.substring(0, n + 1);
            stringBuffer2.append(string6);
            stringBuffer2.append(string + '=' + string2);
            String string7 = string4.substring(n + 1, string4.length());
            stringBuffer2.append('&' + string7);
            return stringBuffer2.toString();
        }
        string4 = string4 + string + '=' + string2;
        return string4;
    }

    public String getHedexParam(String string) {
        String string2 = hedexParamMap.get(string);
        if (null != string2) {
            return string2;
        }
        return this.getHedexParamProperty(string, System.getProperty("homepage"));
    }

    private String getHedexParamProperty(String string, String string2) {
        if (null == string2) {
            return null;
        }
        Matcher matcher = Pattern.compile("[\\?&]" + string + "=([^&$]*)").matcher(string2);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean launchUrlWithDesktop(String string) {
        boolean bl = false;
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uRI = new URI(string);
                desktop.browse(uRI);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private static boolean launchHelpBrowser(String string) {
        block18: {
            HelpManager.fireHedexWillLaunch();
            if (null != string) {
                string = string.replaceAll("\\s", "%20");
            }
            String string2 = HelpManager.getURL(string);
            try {
                String string3 = System.getProperty("os.name");
                if (null != string3 && string3.contains("Windows")) {
                    Object object;
                    if (HelpManager.launchUrlWithDesktop(string2)) {
                        logger.trace("Help is displayed in browser (using Java Desktop)");
                        HelpManager.fireHedexHelpLaunched();
                        return true;
                    }
                    boolean bl = false;
                    if (null == browserPath) {
                        HelpManager.setBrowserPath();
                        bl = true;
                    }
                    boolean bl2 = true;
                    if (null != browserPath) {
                        object = new File(browserPath);
                        if (((File)object).exists()) {
                            logger.trace("file path exists");
                            bl2 = false;
                            Runtime.getRuntime().exec(browserPath + "  " + string2);
                            HelpManager.fireHedexHelpLaunched();
                        } else if (!bl) {
                            logger.trace("file path doesn't exists read again from registry");
                            browserPath = null;
                            HelpManager.setBrowserPath();
                            if (null != browserPath) {
                                object = new File(browserPath);
                                if (((File)object).exists()) {
                                    logger.trace("file path exists");
                                    bl2 = false;
                                    Runtime.getRuntime().exec(browserPath + "  " + string2);
                                    HelpManager.fireHedexHelpLaunched();
                                } else {
                                    logger.trace("file path doesn't exists");
                                }
                            }
                        }
                    }
                    if (bl2) {
                        logger.trace("showing message dialog");
                        object = res.getString("HelpClient_Browser_NotAvailable");
                        OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), object, 0);
                        return false;
                    }
                    break block18;
                }
                try {
                    boolean bl = false;
                    for (String string4 : browsers) {
                        boolean bl3 = bl = Runtime.getRuntime().exec(new String[]{"which", string4}).waitFor() == 0;
                        if (!bl) continue;
                        Runtime.getRuntime().exec(new String[]{string4, string2});
                        break;
                    }
                    if (!bl) {
                        logger.trace("There is no supported browsers found");
                        break block18;
                    }
                    HelpManager.fireHedexHelpLaunched();
                }
                catch (InterruptedException interruptedException) {
                    logger.trace("Exception while opening browser : " + interruptedException);
                }
            }
            catch (IOException iOException) {
                logger.trace("Exception while opening browser : " + iOException);
                return false;
            }
        }
        logger.trace("Help is displayed in browser.");
        return true;
    }

    private static void setBrowserPath() {
        Object object;
        Object object2;
        Object object3 = RegistryUtilities.getCurrentUserBrowserPath();
        if (object3 != null) {
            object2 = null;
            object2 = object3.startsWith("\"") ? object3.substring(1, object3.length() - 1) : object3;
            object = new File((String)object2);
            if (((File)object).exists()) {
                browserPath = object2;
                logger.trace("Browser path : " + browserPath);
            } else {
                logger.trace("Browser path in CURRENT_USER Registry doesn't exist");
            }
        } else {
            logger.trace("Registry for Browser Path not found in CURRENT_USER");
        }
        if (null == browserPath) {
            object3 = RegistryUtilities.getLocalMachineBrowserPath();
            if (object3 != null) {
                object2 = null;
                object2 = object3.startsWith("\"") ? object3.substring(1, object3.length() - 1) : object3;
                object = new File((String)object2);
                if (((File)object).exists()) {
                    browserPath = object2;
                    logger.trace("Browser path : " + browserPath);
                } else {
                    logger.trace("Browser path in LOCAL_MACHINE Registry doesn't exist");
                }
            } else {
                logger.trace("Registry for Browser Path not found in LOCAL_MACHINE ");
            }
        }
        if (null == browserPath) {
            object2 = File.listRoots();
            if (null != object2) {
                for (File file : object2) {
                    String string = file.getAbsolutePath() + "Program Files\\Internet Explorer\\iexplore.exe";
                    if (!new File(string).exists()) continue;
                    object3 = string;
                }
            }
            if (object3 != null) {
                object = null;
                object = object3.startsWith("\"") ? object3.substring(1, object3.length() - 1) : object3;
                File file = new File((String)object);
                if (file.exists()) {
                    browserPath = object;
                    logger.trace("Browser path : " + browserPath);
                } else {
                    logger.trace("Browser path is not found");
                }
            } else {
                logger.trace("Internet Explorer is not installed ");
            }
        }
    }

    static String changeURL(String string) {
        int n;
        if (null == string) {
            return string;
        }
        String string2 = System.getProperty("subsystem");
        StringBuffer stringBuffer = new StringBuffer(string);
        SubsystemManager.LoadMode loadMode = SubsystemManager.getInstance().getClientLoadMode();
        String string3 = "lib=";
        int n2 = string.indexOf(string3);
        if (n2 > -1 && (n = string.indexOf(38, n2)) > -1) {
            if (loadMode == SubsystemManager.LoadMode.single) {
                stringBuffer.replace(n2 + string3.length(), n, string2);
                string = stringBuffer.toString();
            } else if (loadMode == SubsystemManager.LoadMode.complex && null != string2 && string2.contains(";")) {
                stringBuffer.replace(n2 + string3.length(), n, string2);
                string = stringBuffer.toString();
            }
            logger.trace("URL is :" + string);
        }
        return string;
    }

    public static boolean startHelpServer() {
        int n = 5000;
        try {
            try {
                n = Integer.parseInt(System.getProperty("helpport"));
            }
            catch (Exception exception) {
                n = 5000;
            }
            logger.trace("port=" + n);
            helpServer = new HelpServer(n);
            long l = System.currentTimeMillis();
            startTime = String.valueOf(l);
            logger.debug("startTime = " + startTime);
            HelpManagerUtil.getInstance().writeTimeStrToFile(n, startTime);
            return true;
        }
        catch (Exception exception) {
            HelpManagerUtil.getInstance().sendMsg(HelpManager.getInstance().getHomeID(), n);
            return false;
        }
    }

    public void setStartFlg(boolean bl) {
        this.started = bl;
    }

    public boolean getStartFlg() {
        return this.started;
    }

    public void setStartingFlg(boolean bl) {
        this.starting = bl;
    }

    public boolean getStartingFlg() {
        return this.starting;
    }

    public static void stopHelpServer() {
        if (!FrameworkHelper.isOSGIHelpClient()) {
            HelpManager.cleanUpHelp();
        }
        HelpAdapter.exitTerminal();
    }

    public static void cleanUpHelp() {
        if (helpServer != null) {
            HelpManagerUtil.getInstance().deleteFile(helpServer.getPort());
            helpServer.close();
            helpServer = null;
        }
        if (helpClient != null) {
            helpClient.close();
            helpClient = null;
        }
        logger.debug("HelpManager exit.");
        DebugTracer.cleanup();
    }

    public static void stopServerWithConfirm(final String string) {
        final IViewHelpBroker iViewHelpBroker = HelpManager.getInstance().getHelpBroker();
        if (!iViewHelpBroker.isDisplayed()) {
            logger.trace("HelpFrame is not show,so stop the server directly.");
            HelpManager.stopHelpServer();
            return;
        }
        IviewUtilTimer iviewUtilTimer = new IviewUtilTimer();
        iviewUtilTimer.schedule(new IviewTimerTask(){

            @Override
            public void run() {
                logger.trace("Timer is run , to stop server.");
                HelpManager.stopHelpServer();
            }
        }, 30000L, 30000L);
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPane.showMessageDialog(iViewHelpBroker.getHelpWindow(), string);
            logger.trace("Close confrim dialog to stop server.");
            HelpManager.stopHelpServer();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(((IViewHelpBroker)iViewHelpBroker).getHelpWindow(), string);
                    logger.trace("Close confrim dialog to stop server.");
                    HelpManager.stopHelpServer();
                }
            });
        }
    }

    public static void setStartTime(String string) {
        logger.debug("startTime is " + string);
        startTime = string;
    }

    public static String getStartTime() {
        return startTime;
    }

    public static void setBaseFileNameHeader(String string) {
        baseFileNameHeader = string;
    }

    public static void merge() {
        String string = "help/" + Locale.getDefault().toString() + '/';
        HelpManager.mergeIndex(string);
        HelpManager.mergeToc(string);
        HelpManager.mergeMap(string);
        HelpManager.mergeHelpSet(string);
    }

    public static void merge(String string) {
        HelpManager.setBaseFileNameHeader(string);
        HelpManager.merge();
    }

    private boolean isNeedMerge() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "help/" + Locale.getDefault().toString() + '/';
        string = string4 + destinationFileNameHeader + Index_suffix;
        string2 = string4 + destinationFileNameHeader + Toc_suffix;
        string3 = string4 + destinationFileNameHeader + Map_suffix;
        return !this.isFileExit(string) || !this.isFileExit(string2) || !this.isFileExit(string3);
    }

    private boolean isFileExit(String string) {
        File file = new File(string);
        return file.exists();
    }

    private static void mergeHelpSet(String string) {
        String string2 = string + HELPSET_DIR;
        String string3 = string + HS_FILE;
        logger.trace("Base file name = " + string3);
        logger.trace("SubHelpSet Directory Path : " + string2);
        String[] stringArray = XMLDocumentUtil.getInstance().getFileLocations(string2, ".hs");
        File file = new File(string3);
        if (!file.exists() || null == stringArray || stringArray.length == 0) {
            logger.trace("The base file or the plugin files are not existing. Merge is ignored.");
            Document document = XMLDocumentUtil.getInstance().createXMLDocument(file, DTDPATTERN);
            if (null != document) {
                document.getDocumentElement().normalize();
                Node[] nodeArray = HelpManager.isMergeCommentPresent(document);
                if (nodeArray.length != 2) {
                    return;
                }
                HelpManager.removeMergedSubHelpSetLocation(nodeArray);
                String string4 = "UTF-8";
                if (string.indexOf("zh_CN") > -1) {
                    string4 = "GBK";
                }
                String string5 = string + File.separator + HS_FILE;
                XMLDocumentUtil.getInstance().writeToXMLDoc(document, string4, string5);
            } else {
                logger.trace("The HS file was not properly parsed");
            }
            return;
        }
        HelpManager.mergeHSFiles(file, stringArray);
    }

    private static void mergeHSFiles(File file, String[] stringArray) {
        Object object;
        String string = file.getAbsolutePath();
        String string2 = file.getParent();
        String string3 = "location";
        logger.trace("mergeHSFiles : Parsing Xml : " + string);
        Document document = XMLDocumentUtil.getInstance().createXMLDocument(file, DTDPATTERN);
        if (null == document) {
            logger.trace("mergeHSFiles : The hs document was not created");
            return;
        }
        document.getDocumentElement().normalize();
        Node[] nodeArray = HelpManager.isMergeCommentPresent(document);
        if (null == nodeArray || nodeArray.length != 2) {
            logger.trace("Proper Merge comments could not be found, subhelpset merging is aborted");
            return;
        }
        Element element = document.getDocumentElement();
        HelpManager.removeMergedSubHelpSetLocation(nodeArray);
        Document document2 = null;
        int n = 0;
        Node node = null;
        NamedNodeMap namedNodeMap = null;
        String string4 = null;
        int n2 = 0;
        Element element2 = null;
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = new File(stringArray[i]);
            document2 = XMLDocumentUtil.getInstance().createXMLDocument(file2, DTDPATTERN);
            document2.getDocumentElement().normalize();
            object = document2.getElementsByTagName(SUBHELPSET);
            n = object.getLength();
            for (int j = 0; j < n; ++j) {
                node = object.item(j);
                namedNodeMap = node.getAttributes();
                n2 = namedNodeMap.getLength();
                for (int k = 0; k < n2; ++k) {
                    if (!ResourceUtil.areEqualsIgnoreCase(((Attr)namedNodeMap.item(k)).getNodeName(), string3)) continue;
                    string4 = ((Attr)namedNodeMap.item(k)).getNodeValue();
                }
                element2 = document.createElement(SUBHELPSET);
                element2.setAttribute("location", string4);
                element.insertBefore(element2, nodeArray[1]);
            }
        }
        String string5 = "UTF-8";
        if (string2.indexOf("zh_CN") > -1) {
            string5 = "GBK";
        }
        object = string2 + File.separator + HS_FILE;
        XMLDocumentUtil.getInstance().writeToXMLDoc(document, string5, (String)object);
    }

    private static Node[] isMergeCommentPresent(Document document) {
        logger.trace("isMergeCommentPresent : Checking if the proper merge comments are present");
        int n = 0;
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(document, 128, null, true);
        Node node = nodeIterator.nextNode();
        Node[] nodeArray = new Node[2];
        String string = null;
        String string2 = null;
        String string3 = null;
        while (node != null) {
            string = node.getNodeValue().toLowerCase();
            string2 = HS_MERGE_COMMENT_BEGIN.toLowerCase();
            string3 = HS_MERGE_COMMENT_END.toLowerCase();
            if (string.indexOf(string2) >= 0) {
                logger.trace("For_Subhelp_merge_Beginis present");
                if (n > 1) break;
                nodeArray[n] = node;
                ++n;
                node = nodeIterator.nextNode();
                string = node.getNodeValue().toLowerCase();
                if (null != node && string.indexOf(string3) >= 0) {
                    logger.trace("For_Subhelp_merge_End is present");
                    nodeArray[n] = node;
                    ++n;
                    break;
                }
                nodeIterator.previousNode();
                nodeArray = new Node[2];
                n = 0;
            }
            node = nodeIterator.nextNode();
        }
        if (n != 2) {
            logger.trace("No proper merge comments");
            return new Node[0];
        }
        return nodeArray;
    }

    private static void removeMergedSubHelpSetLocation(Node[] nodeArray) {
        String string = "#comment";
        logger.trace("removeMergedSubHelpSetLocation : Removing already existing subhelpsets...");
        Node node = null;
        Node node2 = nodeArray[0].getNextSibling();
        Node node3 = null;
        String string2 = node2.getNodeName();
        String string3 = SUBHELPSET;
        boolean bl = ResourceUtil.areEquals(string2, string);
        while (!bl) {
            if (ResourceUtil.areEquals((node2 = node2.getNextSibling()).getNodeName(), string3)) {
                node3 = node2.getNextSibling();
                node = node2.getParentNode();
                node.removeChild(node2);
                node2 = node3;
            }
            string2 = node2.getNodeName();
            bl = ResourceUtil.areEquals(string2, string);
        }
        logger.trace("removeMergedSubHelpSetLocation : Removed the existing subhelpsets");
    }

    private static void mergeIndex(String string) {
        String string2 = string + Index_Dir;
        try {
            File file = CommonUtil.getAbsoluteFile(string2);
            File[] fileArray = file.listFiles();
            String string3 = string + baseFileNameHeader + Index_suffix;
            logger.debug("Base file name = " + string3);
            File file2 = CommonUtil.getAbsoluteFile(string3);
            if (!(file2.exists() || fileArray != null && fileArray.length != 0)) {
                logger.debug("The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Index index = Index.unmarshal(file2);
            if (index == null) {
                index = new Index();
            }
            if (fileArray != null && fileArray.length > 0) {
                Index index2 = null;
                for (int i = 0; i < fileArray.length; ++i) {
                    index2 = Index.unmarshal(fileArray[i]);
                    if (index2 == null) continue;
                    HelpManager.mergeHelpIndex(index, index2);
                }
            }
            try {
                index.marshal(string + destinationFileNameHeader + Index_suffix);
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private static void mergeToc(String string) {
        String string2 = string + Toc_Dir;
        try {
            File file = CommonUtil.getAbsoluteFile(string2);
            File[] fileArray = file.listFiles();
            String string3 = string + baseFileNameHeader + Toc_suffix;
            logger.debug("Base file name = " + string3);
            File file2 = CommonUtil.getAbsoluteFile(string3);
            if (!(file2.exists() || fileArray != null && fileArray.length != 0)) {
                logger.debug("The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Toc toc = Toc.unmarshal(string3);
            if (toc == null) {
                toc = new Toc();
            }
            if (fileArray != null && fileArray.length > 0) {
                Toc toc2 = null;
                for (int i = 0; i < fileArray.length; ++i) {
                    toc2 = Toc.unmarshal(fileArray[i].getAbsolutePath());
                    if (toc2 == null) continue;
                    HelpManager.mergeHelpToc(toc, toc2);
                }
            }
            try {
                toc.marshal(string + destinationFileNameHeader + Toc_suffix);
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private static void mergeMap(String string) {
        String string2 = string + Map_Dir;
        try {
            File file = CommonUtil.getAbsoluteFile(string2);
            File[] fileArray = file.listFiles();
            String string3 = string + baseFileNameHeader + Map_suffix;
            logger.debug("Base file name = " + string3);
            File file2 = CommonUtil.getAbsoluteFile(string3);
            if (!(file2.exists() || fileArray != null && fileArray.length != 0)) {
                logger.debug("The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Map map = Map.unmarshal(file2);
            if (map == null) {
                map = new Map();
            }
            if (fileArray != null && fileArray.length > 0) {
                Map map2 = null;
                for (int i = 0; i < fileArray.length; ++i) {
                    map2 = Map.unmarshal(fileArray[i].getAbsolutePath());
                    if (map2 == null) continue;
                    HelpManager.mergeHelpMap(map, map2);
                }
            }
            try {
                map.marshal(string + destinationFileNameHeader + Map_suffix);
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private static void mergeHelpIndex(Index index, Index index2) {
        Indexitem[] indexitemArray = index2.getIndexitem();
        Indexitem indexitem = null;
        String string = null;
        for (int i = 0; i < indexitemArray.length; ++i) {
            indexitem = indexitemArray[i];
            if (indexitem == null) continue;
            string = indexitem.getText();
            if (index.contains(indexitem)) {
                HelpManager.mergeHelpIndex(index.getChild(string), indexitem);
                continue;
            }
            if (index.getChild(string) != null) {
                throw new RuntimeException("There has wrong with the index files: duplicate text = \"" + string + "\" with different values");
            }
            index.addIndexitem(indexitem);
        }
    }

    private static void mergeHelpToc(Toc toc, Toc toc2) {
        Tocitem[] tocitemArray = toc2.getTocitem();
        Tocitem tocitem = null;
        String string = null;
        for (int i = 0; i < tocitemArray.length; ++i) {
            tocitem = tocitemArray[i];
            if (tocitem == null) continue;
            string = tocitem.getText();
            if (toc.contains(tocitem)) {
                HelpManager.mergeHelpToc(toc.getChild(string), tocitem);
                continue;
            }
            if (toc.getChild(string) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + string + "\" with different values");
            }
            toc.addTocitem(tocitem);
        }
    }

    private static void mergeHelpIndex(Indexitem indexitem, Indexitem indexitem2) {
        Indexitem[] indexitemArray = indexitem2.getIndexitem();
        Indexitem indexitem3 = null;
        String string = null;
        for (int i = 0; i < indexitemArray.length; ++i) {
            indexitem3 = indexitemArray[i];
            if (indexitem3 == null) continue;
            string = indexitem3.getText();
            if (indexitem.contains(indexitem3)) {
                HelpManager.mergeHelpIndex(indexitem.getChild(indexitem3.getText()), indexitem3);
                continue;
            }
            if (indexitem.getChild(string) != null) {
                throw new RuntimeException("There has wrong with the index files: duplicate text = \"" + string + "\" with different values");
            }
            indexitem.addIndexitem(indexitem3);
        }
    }

    private static void mergeHelpToc(Tocitem tocitem, Tocitem tocitem2) {
        Tocitem[] tocitemArray = tocitem2.getTocitem();
        Tocitem tocitem3 = null;
        String string = null;
        for (int i = 0; i < tocitemArray.length; ++i) {
            tocitem3 = tocitemArray[i];
            if (tocitem3 == null) continue;
            string = tocitem3.getText();
            if (tocitem.contains(tocitem3)) {
                HelpManager.mergeHelpToc(tocitem.getChild(tocitem3.getText()), tocitem3);
                continue;
            }
            if (tocitem.getChild(string) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + string + "\" with different values");
            }
            tocitem.addTocitem(tocitem3);
        }
    }

    private static void mergeHelpMap(Map map, Map map2) {
        MapID[] mapIDArray = map2.getMapID();
        MapID mapID = null;
        String string = null;
        for (int i = 0; i < mapIDArray.length; ++i) {
            mapID = mapIDArray[i];
            if (mapID == null) continue;
            string = mapID.getTarget();
            if (map.contains(mapID)) continue;
            if (map.getChild(string) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + string + "\" with different values");
            }
            map.addMapID(mapID);
        }
    }

    public void addSubHelpSet(String string) {
        this.addSubHelpSet(string, false);
    }

    void addSubHelpSet(String string, boolean bl) {
        if (null == string || string.trim().length() == 0) {
            throw new IllegalArgumentException("fileName argument shouldn't be null and fileName's length shouldn't be zero. ");
        }
        if (this.subHelpTable.containsKey(string)) {
            logger.debug("SubHelpTable has contain the key:" + string);
            return;
        }
        if (bl) {
            try {
                HelpSet helpSet = this.getHelpSet(string);
                this.subHelpTable.put(string, helpSet);
                this.getHelpSet().add(helpSet);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            this.subHelpTable.put(string, string);
            HelpManager.sendRemoteHelp(ADDSUBHELPSET + string);
        }
    }

    public void removeSubHelpSet(String string) {
        this.removeSubHelpSet(string, false);
    }

    public void removeSubHelpSetFromHelpConfFile(String string) {
        if (null == string || string.trim().length() == 0) {
            throw new IllegalArgumentException("The fileName can not be null or empty");
        }
        if (this.subHelpSetInHelpConfigureFile.containsKey(string)) {
            logger.debug("This file name has been added previous: " + string);
            return;
        }
        this.subHelpSetInHelpConfigureFile.put(string, string);
    }

    void removeSubHelpSet(String string, boolean bl) {
        if (null == string || string.trim().length() == 0) {
            throw new IllegalArgumentException("fileName argument shouldn't be null and fileName's length shouldn't be zero. ");
        }
        if (!this.subHelpTable.containsKey(string)) {
            logger.debug("SubHelpTable don't contain the key:" + string);
        }
        if (bl) {
            HelpSet helpSet = (HelpSet)this.subHelpTable.get(string);
            boolean bl2 = this.getHelpSet().remove(helpSet);
            if (bl2) {
                this.subHelpTable.remove(string);
            } else {
                logger.error("Failed to Remove helpset" + string);
            }
        } else {
            this.subHelpTable.remove(string);
            HelpManager.sendRemoteHelp(REMOVESUBHELPSET + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createTmpFile() {
        if (this.subHelpTable.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        Enumeration enumeration = this.subHelpTable.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        File file = null;
        BufferedWriter bufferedWriter = null;
        try {
            file = File.createTempFile("helpset", "tmp", tmpFileDir);
            file.deleteOnExit();
            bufferedWriter = new BufferedWriter(new BufferedWriter(new FileWriter(file)));
            bufferedWriter.write(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            String string = null;
            return string;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        return file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String saveSupHelpSet2TempFile() {
        if (this.subHelpSetInHelpConfigureFile.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        Enumeration enumeration = this.subHelpSetInHelpConfigureFile.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        File file = null;
        BufferedWriter bufferedWriter = null;
        try {
            file = File.createTempFile(SUBHELPSET, "tmp", tmpFileDir);
            file.deleteOnExit();
            bufferedWriter = new BufferedWriter(new BufferedWriter(new FileWriter(file)));
            bufferedWriter.write(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            String string = null;
            return string;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        return file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readTmpFile(String string) {
        File file = new File(tmpFileDir, string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (null != string2) {
                logger.debug("Reading subHelpSet path is " + string2);
                this.addSubHelpSet(string2, true);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                    bufferedReader = null;
                    boolean bl = file.delete();
                    if (!bl) {
                        logger.debug("Failed to delete temp file.");
                    }
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRemoveSubHelpsetFile(String string) {
        File file = new File(tmpFileDir, string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (null != string2) {
                logger.debug("Reading subHelpSet path is " + string2);
                this.removeSubHelpsetFromConfigFile(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                    bufferedReader = null;
                    boolean bl = file.delete();
                    if (!bl) {
                        logger.debug("Failed to delete temp file.");
                    }
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    private void removeSubHelpsetFromConfigFile(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(32);
        if (string.toLowerCase().startsWith("jar:file:")) {
            string2 = string;
        } else {
            stringBuffer.append("file:");
            stringBuffer.append(System.getProperty("user.dir"));
            stringBuffer.append(File.separator);
            stringBuffer.append(string);
            if (!stringBuffer.toString().endsWith(".hs")) {
                stringBuffer.append(".hs");
            }
            string2 = stringBuffer.toString();
            string2 = string2.replace('\\', '/');
        }
        logger.trace("Remove helpset name: " + string2);
        Enumeration enumeration = this.helpSet.getHelpSets();
        HelpSet helpSet = null;
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            helpSet = (HelpSet)enumeration.nextElement();
            string3 = helpSet.getHelpSetURL().toString();
            logger.trace("URLString: " + string3);
            if (!ResourceUtil.areEquals(string2, string3)) continue;
            this.helpSet.remove(helpSet);
            return;
        }
    }

    public void removeHelpKey(Object object) {
        if (object instanceof Component) {
            CSH.setHelpIDString((Component)object, null);
            CSH.setHelpSet((Component)object, null);
        } else if (object instanceof MenuItem) {
            CSH.setHelpIDString((MenuItem)object, null);
            CSH.setHelpSet((MenuItem)object, null);
        }
    }

    private static IHelpIntegrator getPruductHelpImp() {
        Main main = Main.instance();
        if (null == main) {
            return null;
        }
        String[] stringArray = main.getRuntimeArgs();
        if (null == stringArray) {
            return null;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!HELP_CLASSNAME_PARAM_NAME.equals(stringArray[i].trim())) continue;
                if (null != stringArray[++i]) {
                    String string = stringArray[i].trim();
                    Class<?> clazz = Class.forName(string);
                    return (IHelpIntegrator)clazz.newInstance();
                }
                break;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return null;
    }

    public void cleanSubHelptable() {
        if (FrameworkHelper.isOSGIHelpClient() && null != this.subHelpTable) {
            this.subHelpTable.clear();
        }
    }

    public static boolean isStopHelp() {
        String string = System.getProperty("iview.help.stop");
        return Boolean.valueOf(string);
    }

    public static int getHelpStopDelay() {
        String string = System.getProperty("iview.help.delaytime");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            DebugTracer.trace("Exception while reading delaytime :" + numberFormatException);
        }
        return n;
    }

    public static void addHedexHelpListeners(IHedexHelpInterface iHedexHelpInterface) {
        if (null == iHedexHelpInterface) {
            return;
        }
        if (null == hedexHelpListeners) {
            hedexHelpListeners = new ArrayList<IHedexHelpInterface>(1);
        }
        hedexHelpListeners.add(iHedexHelpInterface);
    }

    public void removeSelectionListener(IHedexHelpInterface iHedexHelpInterface) {
        if (null == iHedexHelpInterface || null == hedexHelpListeners) {
            return;
        }
        hedexHelpListeners.remove(iHedexHelpInterface);
    }

    private static void fireHedexWillLaunch() {
        if (null == hedexHelpListeners) {
            return;
        }
        IHedexHelpInterface iHedexHelpInterface = null;
        int n = hedexHelpListeners.size();
        for (int i = 0; i < n; ++i) {
            iHedexHelpInterface = hedexHelpListeners.get(i);
            iHedexHelpInterface.hedexHelpWillLaunch();
        }
    }

    private static void fireHedexHelpLaunched() {
        if (null == hedexHelpListeners) {
            return;
        }
        IHedexHelpInterface iHedexHelpInterface = null;
        int n = hedexHelpListeners.size();
        for (int i = 0; i < n; ++i) {
            iHedexHelpInterface = hedexHelpListeners.get(i);
            iHedexHelpInterface.hedexHelpLaunched();
        }
    }

    public static void main(String[] stringArray) {
        DebugTracer.identifyDebugParam(stringArray);
        HelpManager.setBaseFileNameHeader("help");
        HelpManager.setDefaultLocale(Locale.getDefault());
        HelpManager.setMainFrame(new JFrame());
        HelpManager.setHelpFrameIcon(new ImageIcon("./help/helpicon.gif"));
        HelpManager.setAboutDlgClassName("javax.swing.JDialog");
        String string = System.getProperty("helpid");
        String string2 = System.getProperty(SHOWHELPMENUFLG);
        String string3 = System.getProperty(HELPSETPATHANDNAME);
        if (!HelpManager.startHelpServer()) {
            logger.warn("The process of HelpManager has been running");
            System.exit(0);
        }
        if (string2 != null && "false".equalsIgnoreCase(string2)) {
            HelpManager.setShowHelpMenuFlg(false);
        }
        if (string3 != null && !"".equals(string3)) {
            HelpManager.getInstance().loadHelpSet(string3);
        } else {
            HelpManager.getInstance().loadHelpSet();
        }
        if (null != string && string.length() > 0) {
            HelpManager.getInstance().launchHelper(string);
        } else {
            HelpManager.getInstance().launchHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        productHelpImp = HelpManager.getPruductHelpImp();
        if (null == productHelpImp) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(CommonUtil.getAbsolutePath("./help/helpid.properties")));
                helpIDRes = new PropertyResourceBundle(bufferedInputStream);
            }
            catch (Exception exception) {
                logger.warn("Read resource file helpid.properties error: ");
                logger.trace(exception.getMessage(), exception);
            }
            finally {
                try {
                    if (null != bufferedInputStream) {
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                    }
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
        instance = new HelpManager();
        browserPath = null;
    }

    private static abstract class LaunchHelpListener
    implements ActionListener {
        private LaunchHelpListener() {
        }
    }
}

