/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.sun.java.help.impl.JHelpPrintHandler;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class HelpFrame
extends JFrame {
    private static IviewLogger logger = IviewLogger.getLogger(HelpFrame.class, "IVIEW");
    private static final String TOCSTRING = "TOC";
    private static final String INDEXSTRING = "Index";
    private static final String SEARCHSTRING = "Search";
    protected static ImageIcon frameIcon = HelpManager.getHelpFrameIcon();
    protected static String aboutDlgClassName = HelpManager.getAboutDlgClassName();
    private JHelp help = null;
    private HelpSet helpSet = null;
    JMenu menu_HelpFrame_View = null;
    JRadioButtonMenuItem directoryMenuItem = null;
    JRadioButtonMenuItem indexMenuItem = null;
    JRadioButtonMenuItem searchMenuItem = null;
    private JDialog dlg = null;
    private static boolean noPageSetup;
    private static boolean on1dot1;

    public HelpFrame(String string, HelpSet helpSet, JHelp jHelp) {
        super(string);
        this.setName("HelpFrame");
        try {
            if (frameIcon != null) {
                this.setIconImage(frameIcon.getImage());
            } else {
                logger.warn("FrameIcon is null.");
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.helpSet = helpSet;
            this.addJHelp(jHelp);
            this.getContentPane().add((Component)this.createMenuBar(), "North");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Window[] windowArray = HelpFrame.this.getOwnedWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    String string = windowArray[i].getClass().toString();
                    if (!"class javax.swing.Popup$HeavyWeightWindow".equalsIgnoreCase(string)) continue;
                    windowArray[i].dispose();
                }
            }
        });
    }

    public void addJHelp(JHelp jHelp) {
        try {
            this.help = jHelp;
            this.getContentPane().add((Component)this.help, "Center");
            this.validate();
        }
        catch (Exception exception) {
            logger.debug("ravlid error!");
            logger.trace(exception.getMessage(), exception);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar(){

            @Override
            public JMenu getMenu(int n) {
                JMenu jMenu = super.getMenu(n);
                if (jMenu.equals(HelpFrame.this.menu_HelpFrame_View)) {
                    String string = HelpFrame.this.help.getCurrentNavigator().getNavigatorName();
                    try {
                        if (null != HelpFrame.this.directoryMenuItem) {
                            HelpFrame.this.directoryMenuItem.setSelected(HelpFrame.TOCSTRING.equals(string));
                        }
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                    try {
                        if (null != HelpFrame.this.indexMenuItem) {
                            HelpFrame.this.indexMenuItem.setSelected(HelpFrame.INDEXSTRING.equals(string));
                        }
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                    try {
                        if (null != HelpFrame.this.searchMenuItem) {
                            HelpFrame.this.searchMenuItem.setSelected(HelpFrame.SEARCHSTRING.equals(string));
                        }
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                }
                return jMenu;
            }
        };
        HelpMenuListener helpMenuListener = new HelpMenuListener();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        jMenu = new JMenu(HelpManager.res.getString("HelpFrame_File"));
        jMenu.setName("HelpFrame_File");
        jMenu.setMnemonic('F');
        jMenuItem = new JMenuItem(HelpManager.res.getString("HelpFrame_Print"));
        jMenuItem.setName("HelpFrame_Print");
        jMenuItem.setMnemonic('P');
        jMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_Print"));
        JHelpPrintHandler jHelpPrintHandler = null;
        try {
            if (on1dot1) {
                Class<?> clazz = Class.forName("com.sun.java.help.impl.JHelpPrintHandler");
                Constructor<?> constructor = clazz.getConstructor(JHelp.class);
                jHelpPrintHandler = (JHelpPrintHandler)constructor.newInstance(this.help);
            } else {
                Class<?> clazz = Class.forName("com.sun.java.help.impl.JHelpPrintHandler1_2");
                Constructor<?> constructor = clazz.getConstructor(JHelp.class);
                jHelpPrintHandler = (JHelpPrintHandler)constructor.newInstance(this.help);
            }
        }
        catch (Throwable throwable) {
            logger.trace(throwable.getMessage(), throwable);
        }
        jMenuItem.addActionListener((ActionListener)jHelpPrintHandler);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(HelpManager.res.getString("HelpFrame_Exit"));
        jMenuItem.setName("HelpFrame_Exit");
        jMenuItem.setMnemonic('E');
        jMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_Exit"));
        jMenuItem.addActionListener(helpMenuListener);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.menu_HelpFrame_View = new JMenu(HelpManager.res.getString("HelpFrame_View"));
        this.menu_HelpFrame_View.setName("HelpFrame_menu_HelpFrame_View");
        this.menu_HelpFrame_View.setMnemonic('V');
        if (this.helpSet.getNavigatorView(TOCSTRING) != null) {
            this.directoryMenuItem = new JRadioButtonMenuItem(HelpManager.res.getString("HelpFrame_Directory"));
            this.directoryMenuItem.setName("HelpFrame_directoryMenuItem");
            this.directoryMenuItem.setMnemonic('T');
            this.directoryMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_Directory"));
            this.directoryMenuItem.addActionListener(helpMenuListener);
            this.menu_HelpFrame_View.add(this.directoryMenuItem);
        }
        if (this.helpSet.getNavigatorView(INDEXSTRING) != null) {
            this.indexMenuItem = new JRadioButtonMenuItem(HelpManager.res.getString("HelpFrame_Index"));
            this.indexMenuItem.setName("HelpFrame_indexMenuItem");
            this.indexMenuItem.setMnemonic('I');
            this.indexMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_Index"));
            this.indexMenuItem.addActionListener(helpMenuListener);
            this.menu_HelpFrame_View.add(this.indexMenuItem);
        }
        if (this.helpSet.getNavigatorView(SEARCHSTRING) != null) {
            this.searchMenuItem = new JRadioButtonMenuItem(HelpManager.res.getString("HelpFrame_Search"));
            this.searchMenuItem.setName("HelpFrame_searchMenuItem");
            this.searchMenuItem.setMnemonic('S');
            this.searchMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_Search"));
            this.searchMenuItem.addActionListener(helpMenuListener);
            this.menu_HelpFrame_View.add(this.searchMenuItem);
        }
        jMenuBar.add(this.menu_HelpFrame_View);
        if (HelpManager.getShowHelpMenuFlg()) {
            jMenu = new JMenu(HelpManager.res.getString("HelpFrame_Help"));
            jMenu.setName("HelpFrame_Help");
            jMenu.setMnemonic('H');
            jMenuItem = new JMenuItem(HelpManager.res.getString("HelpFrame_About"));
            jMenuItem.setName("HelpFrame_About");
            jMenuItem.setMnemonic('A');
            jMenuItem.setActionCommand(HelpManager.res.getString("HelpFrame_About"));
            jMenuItem.addActionListener(helpMenuListener);
            jMenu.add(jMenuItem);
            jMenuBar.add(jMenu);
        }
        return jMenuBar;
    }

    private void exit_actionPerformed() {
        this.dispose();
    }

    private void directory_actionPerformed() {
        Enumeration enumeration = this.help.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (!TOCSTRING.equals(jHelpNavigator.getNavigatorName())) continue;
            this.help.setCurrentNavigator(jHelpNavigator);
            break;
        }
    }

    private void index_actionPerformed() {
        Enumeration enumeration = this.help.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (!INDEXSTRING.equals(jHelpNavigator.getNavigatorName())) continue;
            this.help.setCurrentNavigator(jHelpNavigator);
            break;
        }
    }

    private void search_actionPerformed() {
        Enumeration enumeration = this.help.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (!SEARCHSTRING.equals(jHelpNavigator.getNavigatorName())) continue;
            this.help.setCurrentNavigator(jHelpNavigator);
            break;
        }
    }

    private void about_actionPerformed() {
        if (this.dlg == null && aboutDlgClassName != null) {
            try {
                Class<?> clazz = Class.forName(aboutDlgClassName);
                Class[] classArray = new Class[]{JFrame.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this};
                this.dlg = (JDialog)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                logger.warn("reflect Class error: " + aboutDlgClassName);
                logger.trace(exception.getMessage(), exception);
                return;
            }
        }
        if (this.dlg != null) {
            this.dlg.setVisible(true);
        } else {
            logger.warn("not defined aboutDialog.");
        }
    }

    static {
        on1dot1 = false;
        noPageSetup = false;
        try {
            Method method = Toolkit.class.getMethod("getMaximumCursorColors", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noPageSetup = true;
            on1dot1 = true;
        }
        if (!noPageSetup) {
            String[] stringArray;
            boolean bl = false;
            try {
                stringArray = DataFlavor.class.getMethod("getTextPlainUnicodeFlavor", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = true;
            }
            stringArray = new String[]{""};
            stringArray[0] = System.getProperty("os.name");
            if (stringArray[0] != null && (stringArray[0].indexOf("Solaris") != -1 || stringArray[0].indexOf("SunOS") != -1 || stringArray[0].indexOf("Linux") != -1 || stringArray[0].indexOf("HP-UX") != -1) && bl) {
                noPageSetup = true;
            }
        }
    }

    private class HelpMenuListener
    implements ActionListener {
        private HelpMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ResourceUtil.areEquals(string, HelpManager.res.getString("HelpFrame_Exit"))) {
                HelpFrame.this.exit_actionPerformed();
            } else if (ResourceUtil.areEquals(string, HelpManager.res.getString("HelpFrame_Directory"))) {
                HelpFrame.this.directory_actionPerformed();
            } else if (ResourceUtil.areEquals(string, HelpManager.res.getString("HelpFrame_Index"))) {
                HelpFrame.this.index_actionPerformed();
            } else if (ResourceUtil.areEquals(string, HelpManager.res.getString("HelpFrame_Search"))) {
                HelpFrame.this.search_actionPerformed();
            } else if (ResourceUtil.areEquals(string, HelpManager.res.getString("HelpFrame_About"))) {
                HelpFrame.this.about_actionPerformed();
            }
        }
    }
}

