/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.oem.iview.startup.Bootstrap;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.lookandfeel.UIStyleManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.HelpBundle;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.startup.StartupClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.DatagramSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;

class HelpClient {
    private static IviewLogger logger = IviewLogger.getLogger(HelpClient.class, "IVIEW");
    private DatagramSocket client = new DatagramSocket();
    private static final int PAUSE_TIME = 3000;
    private static final int DEFAULT_PORT = 5000;
    private static final int MAX_PORT = 5100;
    private static final int MAX_CHECKFILE_COUNT = 60;
    private int port = 5000;
    private Thread shakeHandThread = null;
    private static final String DEFAULT_HELPCLASSPATH = "lib/iview.jar;lib/helpSupportLib/jhall.jar;lib/iviewlib.jar";

    public HelpClient() throws Exception {
        try {
            if (System.getProperty("helpport") != null) {
                this.port = Integer.parseInt(System.getProperty("helpport"));
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.port = 5000;
        }
    }

    int getPort() {
        return this.port;
    }

    void close() {
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    void sendMessage(String string) {
        if (this.client == null) {
            logger.error("The client socket is closed .");
            return;
        }
        String string2 = System.getProperty("mainrun");
        if (HelpManager.getInstance().getStartingFlg()) {
            return;
        }
        if (!HelpManager.getInstance().getStartFlg() && (string2 == null || "false".equals(string2))) {
            this.synInvokeStartTenor(string, 0);
        } else if (HelpManager.getInstance().getStartFlg()) {
            if (!this.checkPortUsable(this.getPort()) && !HelpManagerUtil.getInstance().checkTimeEqual(HelpManager.getStartTime(), this.getPort())) {
                this.synInvokeStartTenor(string, 0);
            } else if (this.checkPortUsable(this.getPort())) {
                this.synInvokeStartTenor(string, this.getPort());
            } else {
                if ("mainprogramexit".equals(string)) {
                    HelpManager.getInstance().setStartFlg(false);
                }
                HelpManagerUtil.getInstance().sendMsg(this.client, string, this.port);
            }
        }
    }

    private void synInvokeStartTenor(final String string, final int n) {
        if ("mainprogramexit".equals(string) || string != null && string.startsWith("changehelpsetcommand")) {
            return;
        }
        SyncCommand syncCommand = new SyncCommand(){

            @Override
            public Object call() {
                boolean bl = HelpClient.this.preCheckAndStartTenor(string, n);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        syncCommand.startCall(FrameworkUtilities.getMainFrame(), true);
        Boolean bl = (Boolean)syncCommand.getResult();
        if (null != bl && !bl.booleanValue()) {
            logger.debug("Failed to start help, return value is false.");
            if (!HelpManager.isHelpPreLaunch()) {
                OptionPane.showLineWrapOptionDialog(FrameworkUtilities.getMainFrame(), HelpManager.res.getString("HelpClient_start_Failed"), 0);
            }
        }
    }

    private boolean preCheckAndStartTenor(String string, int n) {
        boolean bl = false;
        HelpManager.getInstance().setStartingFlg(true);
        boolean bl2 = HelpManagerUtil.getInstance().preCheckConf();
        if (!bl2) {
            logger.debug("Failed to add file lock, preCheckAndStartTenor return.");
            HelpManager.getInstance().setStartingFlg(false);
            return bl2;
        }
        if (n == 0) {
            for (n = 5000; n <= 5100; ++n) {
                if (!this.checkPortUsable(n)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                logger.error("Port within range 5000-5100 are busy");
                HelpManager.getInstance().setStartingFlg(false);
                HelpManagerUtil.getInstance().removeStartWriteLock();
                return bl;
            }
        }
        bl = true;
        this.port = n;
        HelpManagerUtil.getInstance().deleteFile(this.port);
        if (this.startTenor(string)) {
            boolean bl3 = true;
            File file = null;
            int n2 = 0;
            while (bl3 && n2 <= 60) {
                try {
                    if (FrameworkHelper.isOSGIHelpClient() && !HelpBundle.isActive()) break;
                    Thread.sleep(1000L);
                    ++n2;
                    file = CommonUtil.getAbsoluteFile(HelpManagerUtil.DEFAULT_DIR + this.getPort() + ".dat");
                    if (!file.exists()) continue;
                    bl3 = false;
                    HelpManager.setStartTime(HelpManagerUtil.getInstance().getTimeStrFromFile(this.getPort()));
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
            if (n2 > 60) {
                logger.debug("Failed to start help,Current check file count is " + n2);
                bl = false;
                HelpManager.getInstance().setStartFlg(false);
            } else {
                HelpManager.getInstance().setStartFlg(true);
            }
        } else {
            logger.debug("startTenor method return false");
            bl = false;
        }
        HelpManagerUtil.getInstance().removeStartWriteLock();
        HelpManager.getInstance().setStartingFlg(false);
        logger.debug("preCheckAndStartTenor method retValue is " + bl);
        return bl;
    }

    private boolean startTenor(String string) {
        Object object;
        String string2;
        if (string != null && ("mainprogramexit".equals(string) || string.startsWith("changehelpsetcommand"))) {
            logger.debug("It's not need to start a new process. when the flag is " + string);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "java";
        arrayList.add(string3);
        arrayList.add("-Dhelpport=" + this.getPort());
        arrayList.add("-Dhelpid=" + string);
        arrayList.add("-Dmainrun=true");
        arrayList.add("-Dfile.encoding=" + System.getProperty("file.encoding"));
        arrayList.add("-DStyleName=" + UIStyleManager.getCurrentUIStyle());
        arrayList.add("-Duser.region=" + Locale.getDefault().getCountry());
        arrayList.add("-Duser.language=" + Locale.getDefault().getLanguage());
        arrayList.add("-Diview.help.stop=" + HelpManager.isStopHelp());
        arrayList.add("-Diview.help.delaytime=" + HelpManager.getHelpStopDelay());
        arrayList.add("-DisValid=" + System.getProperty("isValid"));
        arrayList.add("-Diview.osgi=" + System.getProperty("iview.osgi"));
        if ("true".equals(System.getProperty("iview.help.process"))) {
            arrayList.add("-Duser.dir=" + System.getProperty("user.dir"));
        }
        arrayList.add("-Diview.help.process=" + System.getProperty("iview.help.process"));
        arrayList.add("-Xverify:none");
        boolean bl = HelpManager.isFastLoadingMode();
        if (!HelpManager.isHelpPreLaunch() && null != Main.instance()) {
            bl = false;
        }
        arrayList.add("-Disfasthelpmode=" + bl);
        arrayList.add("-Dshowhelpmenuflg=" + HelpManager.getShowHelpMenuFlg());
        arrayList.add("-Dsubsystem=" + System.getProperty("subsystem"));
        arrayList.add("-Dhelpsetpathandname=" + HelpManager.getHelpSetName());
        String string4 = HelpManager.getInstance().createTmpFile();
        if (null != string4) {
            arrayList.add("-Dsubhelpsetfilename=" + string4);
        }
        if (null != (string2 = HelpManager.getInstance().saveSupHelpSet2TempFile())) {
            arrayList.add("-Dremovesubhelpsetfilename=" + string2);
        }
        arrayList.add("-classpath");
        arrayList.add(this.getClassPath());
        arrayList.add(HelpManager.getMainClassName());
        arrayList.add("-showtrace");
        arrayList.add("false");
        arrayList.add("-enabledebug");
        arrayList.add("true");
        arrayList.add("-tracefile");
        String string5 = DebugTracer.getTraceLogFolderName();
        if (string5 != null && string5.length() > 0) {
            object = System.getProperty("user.dir");
            arrayList.add('.' + string5.substring(((String)object).length()) + System.getProperty("file.separator") + "helptrace.txt");
        } else {
            arrayList.add("helptrace.txt");
        }
        logger.trace("New 2005.08.31 Launch Help Command: ");
        logger.trace(arrayList);
        try {
            object = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
            if (!FrameworkHelper.isOSGIHelpClient()) {
                new Thread((Process)object){
                    final /* synthetic */ Process val$process;
                    {
                        this.val$process = process;
                    }

                    @Override
                    public void run() {
                        try {
                            this.setName("Help Msg reader");
                            HelpClient.readAndPrintErrMsg(this.val$process.getInputStream());
                            HelpClient.readAndPrintErrMsg(this.val$process.getErrorStream());
                            logger.trace("Read error stream finished.");
                        }
                        catch (Exception exception) {
                            logger.trace(exception.getMessage(), exception);
                        }
                    }
                }.start();
            } else if (null != HelpBundle.getHelpBundle()) {
                String string6;
                String string7;
                System.setProperty("mainrun", "true");
                String string8 = HelpManager.getHelpSetName();
                if (null != string8) {
                    System.setProperty("helpsetpathandname", "\"" + string8 + "\"");
                }
                if (null != (string7 = HelpManager.getInstance().createTmpFile())) {
                    System.setProperty("subhelpsetfilename", "\"" + string7 + "\"");
                }
                if (null != (string6 = HelpManager.getInstance().saveSupHelpSet2TempFile())) {
                    System.setProperty("removesubhelpsetfilename", "\"" + string6 + "\"");
                }
                HelpBundle.startHelpBundle();
            } else {
                System.out.println("HelpClient Failed : Bundle not available");
                logger.trace("Help bundle is not available");
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        logger.trace("Begin to start shake hand.");
        this.startShakeHand();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndPrintErrMsg(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                logger.error(string);
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
        finally {
            try {
                inputStream.close();
                lineNumberReader.close();
                lineNumberReader = null;
                inputStreamReader.close();
                inputStreamReader = null;
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    private String getClassPath() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.class.path");
        if (Bootstrap.getInstance().getClientClassLoader() != null) {
            string2 = Bootstrap.getInstance().getHelpClassPath();
            if (null == string2 || string2.trim().length() == 0) {
                string2 = DEFAULT_HELPCLASSPATH;
            }
        } else if (CommonUtil.isStartupClassLoaded() && StartupClassLoader.getInstance() != null) {
            URL[] uRLArray = StartupClassLoader.getInstance().getURLs();
            string2 = "";
            int n = uRLArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + uRLArray[i].getPath() + ";";
            }
            string2 = string2.replace("%20", " ").replace("%23", "#") + ";";
        }
        if (string.indexOf("Windows") < 0) {
            if (!(string2 = string2.replaceAll(";", ":")).startsWith(":")) {
                string2 = ':' + string2;
            }
            if (!string2.endsWith(":")) {
                string2 = string2 + ':';
            }
        }
        return string2;
    }

    private boolean checkPortUsable(int n) {
        try {
            DatagramSocket datagramSocket = new DatagramSocket(n);
            datagramSocket.close();
            return true;
        }
        catch (Exception exception) {
            logger.trace("HelpClient:checkPortUsable Port is  busy port no :" + n);
            return false;
        }
    }

    private void startShakeHand() {
        if (this.shakeHandThread != null && this.shakeHandThread.isAlive()) {
            return;
        }
        this.shakeHandThread = new Thread("HandShaking"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (!FrameworkHelper.isOSGIHelpClient() || HelpBundle.isActive()) {
                            HelpManagerUtil.getInstance().sendMsg(HelpClient.this.client, "shakehandcommand", HelpClient.this.port);
                            Thread.sleep(3000L);
                        }
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                        continue;
                    }
                    break;
                }
            }
        };
        this.shakeHandThread.start();
    }
}

