/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.UIStyleManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.HelpBundle;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.helpmanagement.decryptor.Factory;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class HelpAdapter {
    private static IviewLogger logger;
    private static HelpAdapter instance;
    private static String destinationFileNameHeader;
    private static ImageIcon frameIcon;

    public static HelpAdapter getInstance() {
        if (instance == null) {
            instance = new HelpAdapter();
        }
        return instance;
    }

    public static void stopHelpBundle(boolean bl) {
        try {
            if (null != HelpBundle.getHelpBundle()) {
                HelpManager.getInstance().getHelpBroker().dispose();
                HelpManager.getInstance().cleanSubHelptable();
                if (bl) {
                    HelpManager.stopHelpServer();
                } else {
                    HelpManager.cleanUpHelp();
                }
            }
        }
        catch (Exception exception) {
            logger.trace(exception);
        }
    }

    public static void setHelpBundle(Object object) {
        HelpBundle.setHelpBundle(object);
    }

    public static Object getHelpBundle() {
        return HelpBundle.getHelpBundle();
    }

    public static void initHelpManager() {
        HelpManager.setDestinationFileNameHeader(destinationFileNameHeader);
        HelpManager.setDefaultLocale(Locale.getDefault());
        HelpManager.setMainFrame(FrameworkUtilities.getMainFrame());
        HelpManager.setHelpFrameIcon(frameIcon);
        HelpManager.setAboutDlgClassName("com.swimap.iview.framework.AboutDialog");
        HelpManager.setMainClassName("com.swimap.iview.util.helpmanagement.HelpAdapter");
    }

    public static void exitTerminal() {
        if (FrameworkHelper.isOSGIHelpClient()) {
            try {
                HelpBundle.stopHelpBundle();
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
        } else {
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        String string3;
        if (!FrameworkHelper.isOSGIClient()) {
            UIManager.getDefaults().put("ClassLoader", HelpAdapter.class.getClassLoader());
        }
        DebugTracer.identifyDebugParam(stringArray);
        logger.trace("Ready add file lock.");
        if (!HelpManagerUtil.getInstance().addReadLock()) {
            logger.error("Failed to add file lock, the help process exit.");
            DebugTracer.cleanup();
            HelpAdapter.exitTerminal();
        }
        if ((string3 = System.getProperty("helpid")) != null && string3.indexOf(34) == 0 && string3.lastIndexOf(34) == string3.length() - 1) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        logger.trace("helpId given by the user after modification: " + string3);
        String string4 = System.getProperty("showhelpmenuflg");
        String string5 = System.getProperty("helpsetpathandname");
        if (string5 != null && string5.indexOf(34) == 0 && string5.lastIndexOf(34) == string5.length() - 1) {
            string5 = string5.substring(1, string5.length() - 1);
        }
        if (null != (string2 = System.getProperty("subhelpsetfilename"))) {
            string2 = string2.replace("\"", "");
        }
        String string6 = System.getProperty("removesubhelpsetfilename");
        UIStyleManager.loadUIStyleName();
        logger.warn("ready for start server");
        if (!HelpManager.startHelpServer()) {
            logger.warn("The process of HelpManager has been running");
            HelpAdapter.exitTerminal();
        }
        HelpAdapter.initHelpManager();
        if (string4 != null && "false".equalsIgnoreCase(string4)) {
            HelpManager.setShowHelpMenuFlg(false);
        }
        if ("true".equalsIgnoreCase(string = System.getProperty("isValid"))) {
            DebugTracer.trace("Iview perform the decryption.");
            URL.setURLStreamHandlerFactory(new Factory());
        }
        if (string5 != null && string5.length() > 0) {
            HelpManager.getInstance().reloadHelpIdRes(string5);
            HelpManager.getInstance().loadHelpSet(string5);
        } else {
            HelpManager.getInstance().loadHelpSet();
        }
        if (null != string2) {
            HelpManager.getInstance().readTmpFile(string2);
        }
        if (null != string6) {
            HelpManager.getInstance().readRemoveSubHelpsetFile(string6);
        }
        if (string3 != null && string3.length() > 0) {
            HelpManager.getInstance().launchHelper(string3);
        } else {
            HelpManager.getInstance().launchHelper();
        }
    }

    static {
        Serializable serializable;
        if (!FrameworkHelper.isOSGIHelpClient()) {
            System.setProperty("helptrace", "true");
            Logger.getRootLogger().removeAllAppenders();
        }
        logger = IviewLogger.getLogger(HelpAdapter.class, "IVIEW");
        instance = null;
        destinationFileNameHeader = "help";
        frameIcon = null;
        try {
            serializable = ResourceMng.getInstance().getLocale();
            Locale.setDefault((Locale)serializable);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        serializable = CommStyleManager.getInstance().getCommonStyleFile("conf/help/help");
        try {
            AreaDescContainer areaDescContainer = ((CommStyleInfo)serializable).getAreaDescContainer("help");
            DescContainer descContainer = areaDescContainer.getDescContainer("helpset");
            destinationFileNameHeader = descContainer.getParasItemValue("helpSetFileName");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        try {
            frameIcon = (ImageIcon)ResourceMng.getInstance().getIcon("HelpIcon", false);
            if (frameIcon == null || frameIcon.getIconWidth() == -1 || frameIcon.getIconHeight() == -1) {
                frameIcon = (ImageIcon)ResourceMng.getInstance().getIcon("FrameIcon");
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }
}

