/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.util.helpmanagement.HelpBundle;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.helpmanagement.IViewHelpBroker;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CSH {
    private static IviewLogger logger = IviewLogger.getLogger(CSH.class, "IVIEW");

    public static void setHelpIDString(Component component, String string) {
        try {
            javax.help.CSH.setHelpIDString((Component)component, (String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
    }

    public static String getHelpIDString(Component component) {
        String string = null;
        try {
            string = javax.help.CSH.getHelpIDString((Component)component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
        return string;
    }

    public static void setHelpSet(Component component, HelpSet helpSet) {
        try {
            javax.help.CSH.setHelpSet((Component)component, (HelpSet)helpSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
    }

    public static HelpSet getHelpSet(Component component) {
        HelpSet helpSet = null;
        try {
            helpSet = javax.help.CSH.getHelpSet((Component)component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
        return helpSet;
    }

    public static void setHelpIDString(MenuItem menuItem, String string) {
        try {
            javax.help.CSH.setHelpIDString((MenuItem)menuItem, (String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
    }

    public static String getHelpIDString(MenuItem menuItem) {
        String string = null;
        try {
            string = javax.help.CSH.getHelpIDString((MenuItem)menuItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
        return string;
    }

    public static void setHelpSet(MenuItem menuItem, HelpSet helpSet) {
        try {
            javax.help.CSH.setHelpSet((MenuItem)menuItem, (HelpSet)helpSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
    }

    public static HelpSet getHelpSet(MenuItem menuItem) {
        HelpSet helpSet = null;
        try {
            helpSet = javax.help.CSH.getHelpSet((MenuItem)menuItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Invalid Component. comp is neither Component nor MenuItem.");
        }
        return helpSet;
    }

    public static Object trackCSEvents() {
        return javax.help.CSH.trackCSEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findFocusOwner(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component instanceof JPopupMenu) {
                return CSH.findArmedPopupmenu((JPopupMenu)component);
            }
            if (component instanceof JComponent && ((JComponent)component).hasFocus()) {
                if (component instanceof JMenu) {
                    component = CSH.findArmedMenuItem((JMenu)component);
                }
                return component;
            }
            if (component instanceof Container) {
                int n = ((Container)component).getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = CSH.findFocusOwner(((Container)component).getComponent(i));
                    if (component2 == null) continue;
                    return component2;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findArmedPopupmenu(JPopupMenu jPopupMenu) {
        if (null == jPopupMenu) {
            return null;
        }
        Object object = jPopupMenu.getTreeLock();
        synchronized (object) {
            if (!jPopupMenu.isVisible()) {
                return null;
            }
            int n = jPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jPopupMenu.getComponent(i);
                if (!(component instanceof JMenuItem) || !((JMenuItem)component).isArmed()) continue;
                if (component instanceof JMenu) {
                    component = CSH.findArmedMenuItem((JMenu)component);
                }
                return component;
            }
            return jPopupMenu.getInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JMenuItem findArmedMenuItem(JMenu jMenu) {
        if (null == jMenu) {
            return null;
        }
        Object object = jMenu.getTreeLock();
        synchronized (object) {
            if (!jMenu.isArmed()) {
                return null;
            }
            int n = jMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jMenu.getMenuComponent(i);
                if (!(component instanceof JMenuItem) || !((JMenuItem)component).isArmed()) continue;
                if (component instanceof JMenu) {
                    component = CSH.findArmedMenuItem((JMenu)component);
                }
                return (JMenuItem)component;
            }
            return jMenu;
        }
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker helpBroker = null;

        public DisplayHelpFromFocus(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("help broker is null");
            }
            this.helpBroker = helpBroker;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            Component component2 = (Component)actionEvent.getSource();
            if (this.helpBroker instanceof IViewHelpBroker) {
                component = SwingUtilities.windowForComponent(component2);
                ((IViewHelpBroker)this.helpBroker).setActivationWindow((Window)component);
            }
            if ((component = CSH.findFocusOwner(component2)) == null) {
                component = component2;
            }
            String string = CSH.getHelpIDString(component);
            if (!HelpBundle.showLaunchedHelp()) {
                HelpManager.getInstance().launchHelper(string);
            }
        }
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker helpBroker = null;

        public DisplayHelpFromSource(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("help broker is null");
            }
            this.helpBroker = helpBroker;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Container container;
            Object object2;
            Object object3 = actionEvent.getSource();
            if (object3 instanceof Component) {
                object2 = (Component)actionEvent.getSource();
                if (object2 instanceof JMenuItem) {
                    while (object2 instanceof JMenuItem && (container = ((Component)object2).getParent()) instanceof JPopupMenu) {
                        object2 = ((JPopupMenu)container).getInvoker();
                    }
                }
                try {
                    container = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object2);
                    if (this.helpBroker instanceof IViewHelpBroker) {
                        ((IViewHelpBroker)this.helpBroker).setActivationWindow((Window)container);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.trace("CSH:DisplayHelpFromSource:actionPerformed:ClassNotFoundException thrown.");
                }
            } else if (object3 instanceof MenuItem) {
                block26: {
                    object2 = (MenuItem)actionEvent.getSource();
                    container = null;
                    while (true) {
                        if ((object = ((MenuComponent)object2).getParent()) instanceof Menu) {
                            object2 = (MenuItem)object;
                            continue;
                        }
                        if (object instanceof MenuBar) {
                            try {
                                container = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)((MenuBar)object).getParent());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                logger.trace("CSH:DisplayHelpFromSource:actionPerformed:ClassNotFoundException");
                            }
                            break block26;
                        }
                        if (object instanceof Frame) {
                            container = (Window)object;
                            break block26;
                        }
                        if (object instanceof Component) break;
                    }
                    try {
                        container = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.trace("CSH:DisplayHelpFromSource:actionPerformed:ClassNotFoundException");
                    }
                }
                if (this.helpBroker instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.helpBroker).setActivationWindow((Window)container);
                }
            }
            object2 = null;
            container = null;
            if (object3 instanceof Component) {
                object = (Component)object3;
                object2 = CSH.getHelpIDString((Component)object);
                container = CSH.getHelpSet((Component)object);
            } else if (object3 instanceof MenuItem) {
                object = (MenuItem)object3;
                object2 = CSH.getHelpIDString((MenuItem)object);
                container = CSH.getHelpSet((MenuItem)object);
            } else {
                return;
            }
            if (null == container) {
                container = this.helpBroker.getHelpSet();
            }
            try {
                object = Map.ID.create((String)object2, (HelpSet)container);
                if (object == null) {
                    object = container.getHomeID();
                }
                this.helpBroker.setCurrentID((Map.ID)object);
                this.helpBroker.setDisplayed(true);
            }
            catch (Exception exception) {
                logger.trace("trouble in HelpActionListener");
            }
        }
    }
}

