/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.format;

import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.ZoneDSTUtil;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeFormatService {
    private static final String ZONE_GMT = "GMT";
    private static final String TIME_HMS = " HH:mm:ss";
    private static final String TIME_AP = " hh:mm:ss a";

    public static String getUTCString(Calendar calendar) {
        return TimeDateFormatUtil.convertFromUTC(calendar.getTimeInMillis(), TimeFormatService.getUTCTimeZone());
    }

    public static String getLocaleString(Calendar calendar) {
        return TimeDateFormatUtil.convertFromUTC(calendar.getTimeInMillis(), TimeFormatService.getClientTimeZone());
    }

    public static String getString(Calendar calendar) {
        return TimeDateFormatUtil.convertFromUTC(calendar.getTimeInMillis(), calendar.getTimeZone());
    }

    private static TimeZone getUTCTimeZone() {
        return TimeZone.getTimeZone(ZONE_GMT);
    }

    private static TimeZone getClientTimeZone() {
        return TimeZone.getDefault();
    }

    public static String getSimpleFormatPatternWithYMDT() {
        String string = TimeFormatService.getDateFormat();
        string = string + TIME_HMS;
        return string;
    }

    private static String getDateFormat() {
        String string = "";
        String string2 = TimeDateFormatUtil.getCurDateSeparatorSymbol();
        int n = TimeDateFormatUtil.getCurDateFormat();
        string = n == 0 ? "dd" + string2 + "MM" + string2 + "yyyy" : (n == 1 ? "MM" + string2 + "dd" + string2 + "yyyy" : "yyyy" + string2 + "MM" + string2 + "dd");
        return string;
    }

    public static String getSimpleFormatPattern() {
        String string = TimeFormatService.getDateFormat();
        int n = TimeDateFormatUtil.getCurTimeFormat();
        string = n == 1 ? string + TIME_AP : string + TIME_HMS;
        if (ZoneDSTUtil.isShowZone()) {
            string = string + " Z";
        }
        return string;
    }

    public static String getFormatPattern() {
        String string = TimeFormatService.getDateFormat();
        int n = TimeDateFormatUtil.getCurTimeFormat();
        string = n == 1 ? string + " hh:mm:ss " + TimeDateFormatUtil.getCurAmFormatSymbol() : string + TIME_HMS;
        if (ZoneDSTUtil.isShowZone()) {
            string = string + " Z";
        }
        if (ZoneDSTUtil.isShowDST()) {
            string = string + " DST";
        }
        return string;
    }
}

