/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.format;

import com.swimap.imap12.util.dateChooser.InmCommonUtil;
import com.swimap.iview.util.format.FormatException;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.format.ZoneDSTUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeDateFormatUtil {
    private static IviewLogger logger = IviewLogger.getLogger(TimeDateFormatUtil.class, "IVIEW");
    public static final int TIMEFORMATWITHOUTAM_PM = 0;
    public static final int TIMEFORMATWITHAM_PM = 1;
    public static final int DATESHOWFORMAT_DMY = 0;
    public static final int DATESHOWFORMAT_MDY = 1;
    public static final int DATESHOWFORMAT_YMD = 2;
    public static final ValueNamePair DEFAULT_DATE_SEPARATOR_SYMBOL = new ValueNamePair(0, "DateSeparateSymbol0");
    public static final ValueNamePair DEFAULT_TIME_SEPARATOR_SYMBOL = new ValueNamePair(0, "TimeSeparateSymbol0");
    public static final ValueNamePair DEFAULT_DATE_FORMAT = new ValueNamePair(1, "DateShowFormat1");
    public static final ValueNamePair DEFAULT_TIME_FORMAT = new ValueNamePair(0, "TimeFormat0");
    public static final ValueNamePair DEFAULT_AM_FORMAT_SYMBOL = new ValueNamePair(0, "AmFormat0");
    public static final ValueNamePair DEFAULT_PM_FORMAT_SYMBOL = new ValueNamePair(0, "PmFormat0");
    public static final int DATE_SEPARATOR_SYMBOL_VALUE = 11;
    public static final int DATE_FORMAT_VALUE = 12;
    public static final int TIME_SEPARATOR_SYMBOL_VALUE = 6;
    public static final int TIME_FORMAT_VALUE = 7;
    public static final int AM_FORMAT_SYMBOL_VALUE = 8;
    public static final int PM_FORMAT_SYMBOL_VALUE = 9;
    private static ValueNamePair curDateSeparatorSymbol = DEFAULT_DATE_SEPARATOR_SYMBOL;
    private static ValueNamePair curTimeSeparatorSymbol = DEFAULT_TIME_SEPARATOR_SYMBOL;
    private static ValueNamePair curDateFormat = DEFAULT_DATE_FORMAT;
    private static ValueNamePair curTimeFormat = DEFAULT_TIME_FORMAT;
    private static ValueNamePair curAmFormatSymbol = DEFAULT_AM_FORMAT_SYMBOL;
    private static ValueNamePair curPmFormatSymbol = DEFAULT_PM_FORMAT_SYMBOL;
    private static final int MAX_YEAR = 9999;
    private static final int MID_OF_DAY = 12;
    private static final int WHOLE_OF_DAY = 24;
    private static TimeZone timeZone = TimeZone.getDefault();
    private static final int ONE_SEC = 1000;
    private static final int MILLI_SECOND = 1000;
    private static final int SECONDS = 60;
    private static final int ROUND_CONST = 10;

    public static String getFormatDateTime(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer(30);
        TimeDateFormatUtil.getFormatDate(calendar, TimeDateFormatUtil.getCurDateSeparatorSymbol(), TimeDateFormatUtil.getCurDateFormat(), stringBuffer);
        stringBuffer.append(" ");
        TimeDateFormatUtil.getFormatTime(calendar, TimeDateFormatUtil.getCurTimeSeparatorSymbol(), TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol(), TimeDateFormatUtil.getCurTimeFormat(), stringBuffer);
        return stringBuffer.toString();
    }

    public static String getFormatDateTime(int n, int n2, int n3, int n4, int n5, int n6) throws FormatException {
        boolean bl;
        boolean bl2 = bl = InmCommonUtil.validateDate(n, n2, n3, 9999) && InmCommonUtil.validateTime(n4, n5, n6, true);
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("getFormatDateTime ( int _year , int _month , int _day ,int _hour , int _minute , int _second ) Error!  ").append("  year =  ").append(n).append("  month =  ").append(n2).append("  day =  ").append(n3).append("  hour =  ").append(n4).append("  minute =  ").append(n5).append("  second =  ").append(n6);
            throw new FormatException(stringBuffer.toString());
        }
        String string = InmCommonUtil.toYearString(n);
        String string2 = InmCommonUtil.toMDHMSString(n2);
        String string3 = InmCommonUtil.toMDHMSString(n3);
        String string4 = InmCommonUtil.toMDHMSString(n4);
        String string5 = InmCommonUtil.toMDHMSString(n5);
        String string6 = InmCommonUtil.toMDHMSString(n6);
        StringBuffer stringBuffer = new StringBuffer(30);
        TimeDateFormatUtil.appendDate(string, string2, string3, TimeDateFormatUtil.getCurDateSeparatorSymbol(), TimeDateFormatUtil.getCurDateFormat(), stringBuffer);
        stringBuffer.append(" ");
        TimeDateFormatUtil.appendTime(string4, string5, string6, TimeDateFormatUtil.getCurTimeSeparatorSymbol(), TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol(), TimeDateFormatUtil.getCurTimeFormat(), stringBuffer);
        return stringBuffer.toString();
    }

    public static String getFormatDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws FormatException {
        if (n8 > 86400 || n8 < -86400) {
            StringBuffer stringBuffer = new StringBuffer(35);
            stringBuffer.append(" _timeZone =  ").append(n8).append(" is invalid");
            throw new FormatException(stringBuffer.toString());
        }
        String string = TimeDateFormatUtil.getFormatDateTime(n, n2, n3, n4, n5, n6);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string);
        if (ZoneDSTUtil.isShowZone()) {
            if (n8 >= 0) {
                stringBuffer.append(" +");
            } else {
                stringBuffer.append(" -");
                n8 = Math.abs(n8);
            }
            int n9 = n8 / 3600;
            int n10 = (n8 - n9 * 3600) / 60;
            if (1 == String.valueOf(n9).trim().length()) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n9);
            stringBuffer.append(":");
            if (1 == String.valueOf(n10).trim().length()) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n10);
        }
        if (n7 != 0 && ZoneDSTUtil.isShowDST()) {
            stringBuffer.append(" DST");
        }
        return stringBuffer.toString();
    }

    public static String getFormatDate(Calendar calendar) {
        return TimeDateFormatUtil.appendDate(InmCommonUtil.toYearString(calendar), InmCommonUtil.toMonthString(calendar), InmCommonUtil.toDateString(calendar), TimeDateFormatUtil.getCurDateSeparatorSymbol(), TimeDateFormatUtil.getCurDateFormat());
    }

    public static String getFormatDate(int n, int n2, int n3) throws FormatException {
        StringBuffer stringBuffer = new StringBuffer(16);
        TimeDateFormatUtil.getFormatDate(n, n2, n3, stringBuffer);
        return stringBuffer.toString();
    }

    private static void getFormatDate(int n, int n2, int n3, StringBuffer stringBuffer) throws FormatException {
        boolean bl = InmCommonUtil.validateDate(n, n2, n3, 9999);
        if (!bl) {
            StringBuffer stringBuffer2 = new StringBuffer(95);
            stringBuffer2.append("getFormatDate( int _year , int _month , int _day ) Error!  ").append("  year =  ").append(n).append("  month =  ").append(n2).append("  day =  ").append(n3);
            throw new FormatException(stringBuffer2.toString());
        }
        String string = InmCommonUtil.toYearString(n);
        String string2 = InmCommonUtil.toMDHMSString(n2);
        String string3 = InmCommonUtil.toMDHMSString(n3);
        TimeDateFormatUtil.appendDate(string, string2, string3, TimeDateFormatUtil.getCurDateSeparatorSymbol(), TimeDateFormatUtil.getCurDateFormat(), stringBuffer);
    }

    public static String getFormatDate(Calendar calendar, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        TimeDateFormatUtil.getFormatDate(calendar, string, n, stringBuffer);
        return stringBuffer.toString();
    }

    private static void getFormatDate(Calendar calendar, String string, int n, StringBuffer stringBuffer) {
        TimeDateFormatUtil.appendDate(InmCommonUtil.toYearString(calendar), InmCommonUtil.toMonthString(calendar), InmCommonUtil.toDateString(calendar), string, n, stringBuffer);
    }

    public static String getFormatTime(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer(14);
        TimeDateFormatUtil.getFormatTime(calendar, stringBuffer);
        return stringBuffer.toString();
    }

    private static void getFormatTime(Calendar calendar, StringBuffer stringBuffer) {
        TimeDateFormatUtil.appendTime(InmCommonUtil.toHourString(calendar), InmCommonUtil.toMinuteString(calendar), InmCommonUtil.toSecondString(calendar), TimeDateFormatUtil.getCurTimeSeparatorSymbol(), TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol(), TimeDateFormatUtil.getCurTimeFormat(), stringBuffer);
    }

    public static String getFormatTime(int n, int n2, int n3) throws FormatException {
        boolean bl = InmCommonUtil.validateTime(n, n2, n3, true);
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("getFormatTime (int _hour , int _minute , int _second ) Error! ").append("  hour =  ").append(n).append("  minute =  ").append(n2).append("  second =  ").append(n3);
            throw new FormatException(stringBuffer.toString());
        }
        String string = InmCommonUtil.toMDHMSString(n);
        String string2 = InmCommonUtil.toMDHMSString(n2);
        String string3 = InmCommonUtil.toMDHMSString(n3);
        StringBuffer stringBuffer = new StringBuffer(14);
        stringBuffer.append(TimeDateFormatUtil.appendTime(string, string2, string3, TimeDateFormatUtil.getCurTimeSeparatorSymbol(), TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol(), TimeDateFormatUtil.getCurTimeFormat()));
        return stringBuffer.toString();
    }

    public static String getFormatTime(int n, int n2, int n3, boolean bl) throws FormatException {
        if (bl) {
            boolean bl2 = InmCommonUtil.validateTime(n, n2, n3, true);
            if (!bl2) {
                StringBuffer stringBuffer = new StringBuffer(110);
                stringBuffer.append("getFormatTime (int _hour , int _minute , int _second ) Error! ").append("  hour =  ").append(n).append("  minute =  ").append(n2).append("  second =  ").append(n3);
                throw new FormatException(stringBuffer.toString());
            }
            String string = InmCommonUtil.toMDHMSString(n);
            String string2 = InmCommonUtil.toMDHMSString(n2);
            String string3 = InmCommonUtil.toMDHMSString(n3);
            StringBuffer stringBuffer = new StringBuffer(14);
            TimeDateFormatUtil.appendTime(string, string2, string3, TimeDateFormatUtil.getCurTimeSeparatorSymbol(), TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol(), TimeDateFormatUtil.getCurTimeFormat(), stringBuffer, true);
            return stringBuffer.toString();
        }
        return TimeDateFormatUtil.getFormatTime(n, n2, n3);
    }

    public static String getFormatTime(Calendar calendar, String string, String string2, String string3, int n) {
        StringBuffer stringBuffer = new StringBuffer(14);
        TimeDateFormatUtil.getFormatTime(calendar, string, string2, string3, n, stringBuffer);
        return stringBuffer.toString();
    }

    private static void getFormatTime(Calendar calendar, String string, String string2, String string3, int n, StringBuffer stringBuffer) {
        TimeDateFormatUtil.appendTime(InmCommonUtil.toHourString(calendar), InmCommonUtil.toMinuteString(calendar), InmCommonUtil.toSecondString(calendar), string, string2, string3, n, stringBuffer);
    }

    private static String appendDate(String string, String string2, String string3, String string4, int n) {
        StringBuffer stringBuffer = new StringBuffer(14);
        TimeDateFormatUtil.appendDate(string, string2, string3, string4, n, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendDate(String string, String string2, String string3, String string4, int n, StringBuffer stringBuffer) {
        if (n == 0) {
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            stringBuffer.append(string);
        } else if (n == 1) {
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(string4);
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
        }
    }

    private static String appendTime(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        StringBuffer stringBuffer = new StringBuffer(14);
        TimeDateFormatUtil.appendTime(string, string2, string3, string4, string5, string6, n, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendTime(String string, String string2, String string3, String string4, String string5, String string6, int n, StringBuffer stringBuffer) {
        String string7 = null;
        if (n == 1) {
            int n2 = Integer.valueOf(string);
            if (n2 > 12) {
                string = n2 - 12 < 10 ? '0' + String.valueOf(n2 - 12) : String.valueOf(n2 - 12);
                string7 = string6;
                if (n2 == 24) {
                    string7 = string5;
                }
            } else if (n2 == 0) {
                string = String.valueOf(n2 + 12);
                string7 = string5;
            } else {
                string7 = n2 == 12 ? string6 : string5;
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(string4);
        stringBuffer.append(string2);
        stringBuffer.append(string4);
        stringBuffer.append(string3);
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string7);
        }
    }

    private static void appendTime(String string, String string2, String string3, String string4, String string5, String string6, int n, StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            String string7 = "";
            if (n == 1) {
                int n2 = Integer.valueOf(string);
                if (n2 > 12) {
                    string = n2 - 12 < 10 ? '0' + String.valueOf(n2 - 12) : String.valueOf(n2 - 12);
                    string7 = string6;
                } else {
                    string7 = string5;
                }
            }
            stringBuffer.append(string);
            stringBuffer.append(string4);
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
            if (string7.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
            }
        } else {
            TimeDateFormatUtil.appendTime(string, string2, string3, string4, string5, string6, n, stringBuffer);
        }
    }

    public static String[] getTime_AM_PM_Symbols() {
        String[] stringArray = new String[]{TimeDateFormatUtil.getCurAmFormatSymbol(), TimeDateFormatUtil.getCurPmFormatSymbol()};
        return stringArray;
    }

    public static byte getFormatTimeDateType() {
        int n = 0;
        switch (TimeDateFormatUtil.getCurTimeFormat()) {
            case 0: {
                if (TimeDateFormatUtil.getCurDateFormat() == 2) {
                    n = 3;
                }
                if (TimeDateFormatUtil.getCurDateFormat() == 0) {
                    n = 8;
                }
                if (TimeDateFormatUtil.getCurDateFormat() != 1) break;
                n = 10;
                break;
            }
            case 1: {
                if (TimeDateFormatUtil.getCurDateFormat() == 2) {
                    n = 7;
                }
                if (TimeDateFormatUtil.getCurDateFormat() == 0) {
                    n = 9;
                }
                if (TimeDateFormatUtil.getCurDateFormat() != 1) break;
                n = 11;
                break;
            }
            default: {
                n = 3;
            }
        }
        return (byte)n;
    }

    public static boolean isAM_PMEnable() {
        return TimeDateFormatUtil.getCurTimeFormat() == 1;
    }

    public static String getCurAmFormatSymbol() {
        return TimeDateFormatUtil.getCurAmFormatSymbolPair().toString();
    }

    public static int getCurDateFormat() {
        return TimeDateFormatUtil.getCurDateFormatPair().getValue();
    }

    public static String getCurDateSeparatorSymbol() {
        return TimeDateFormatUtil.getCurDateSeparatorSymbolPair().toString();
    }

    public static String getCurPmFormatSymbol() {
        return TimeDateFormatUtil.getCurPmFormatSymbolPair().toString();
    }

    public static int getCurTimeFormat() {
        return TimeDateFormatUtil.getCurTimeFormatPair().getValue();
    }

    public static String getCurTimeSeparatorSymbol() {
        return TimeDateFormatUtil.getCurTimeSeparatorSymbolPair().toString();
    }

    public static ValueNamePair getCurAmFormatSymbolPair() {
        return curAmFormatSymbol;
    }

    public static ValueNamePair getCurDateFormatPair() {
        return curDateFormat;
    }

    public static ValueNamePair getCurDateSeparatorSymbolPair() {
        return curDateSeparatorSymbol;
    }

    public static ValueNamePair getCurPmFormatSymbolPair() {
        return curPmFormatSymbol;
    }

    public static ValueNamePair getCurTimeFormatPair() {
        return curTimeFormat;
    }

    public static ValueNamePair getCurTimeSeparatorSymbolPair() {
        return curTimeSeparatorSymbol;
    }

    public static void setCurAmFormatSymbol(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curAmFormatSymbol value is null.");
            return;
        }
        curAmFormatSymbol = valueNamePair;
    }

    public static void setCurDateFormat(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curDateFormat value is null.");
            return;
        }
        curDateFormat = valueNamePair;
    }

    public static void setCurDateSeparatorSymbol(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curDateSeparatorSymbol value is null.");
            return;
        }
        curDateSeparatorSymbol = valueNamePair;
    }

    public static void setCurPmFormatSymbol(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curPmFormatSymbol value is null.");
            return;
        }
        curPmFormatSymbol = valueNamePair;
    }

    public static void setCurTimeFormat(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curTimeFormat value is null.");
            return;
        }
        curTimeFormat = valueNamePair;
    }

    public static void setCurTimeSeparatorSymbol(ValueNamePair valueNamePair) {
        if (null == valueNamePair) {
            logger.trace("_curTimeSeparatorSymbol value is null.");
            return;
        }
        curTimeSeparatorSymbol = valueNamePair;
    }

    public static void switchLocalCalendar(Calendar calendar) {
        TimeZone timeZone = TimeZone.getDefault();
        TimeDateFormatUtil.switchCalendar(calendar, timeZone);
    }

    public static void switchGMTCalendar(Calendar calendar) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        TimeDateFormatUtil.switchCalendar(calendar, timeZone);
    }

    public static void switchCalendar(Calendar calendar, TimeZone timeZone) {
        if (calendar == null || calendar.getTimeZone() == null || timeZone == null) {
            throw new IllegalArgumentException("The 'srcCalendar' and 'srcCalendar.getTimeZone()' and 'toZone' can not be null.");
        }
        calendar.get(11);
        calendar.setTimeZone(timeZone);
        calendar.get(11);
    }

    public static void setTimeZone(TimeZone timeZone) {
        TimeDateFormatUtil.timeZone = timeZone;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static long convertToUTC(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        return TimeDateFormatUtil.convertToUTC(n, n2, n3, n4, n5, n6, n7, timeZone, bl);
    }

    public static long convertToUTC(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = InmCommonUtil.validateDate(n, n2 + 1, n3, 9999) && InmCommonUtil.validateTime(n4, n5, n6, true) && 0 <= n7 && n7 < 1000;
        if (!bl3) {
            StringBuffer stringBuffer = new StringBuffer(260);
            stringBuffer.append("convertToUTC(int _year, int _month, int _day, int _hour, int _minute, int _second, int _milliseconds, TimeZone _timeZone, boolean flag) Error!  ").append("  year =  ").append(n).append("  month =  ").append(n2).append("  day =  ").append(n3).append("  hour =  ").append(n4).append("  minute =  ").append(n5).append("  second =  ").append(n6).append("  milliseconds = ").append(n7);
            logger.trace(stringBuffer.toString());
            return 0L;
        }
        long l = 0L;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(n, n2, n3, n4, n5, n6);
        boolean bl5 = timeZone.inDaylightTime(calendar.getTime());
        boolean bl6 = bl2 = !timeZone.inDaylightTime(calendar.getTime()) && timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() - (long)timeZone.getDSTSavings()));
        if (timeZone.useDaylightTime()) {
            if (bl5) {
                calendar.set(16, timeZone.getDSTSavings());
            } else if (bl2 && bl) {
                calendar.set(16, timeZone.getDSTSavings());
            }
        }
        TimeDateFormatUtil.switchGMTCalendar(calendar);
        l = calendar.getTimeInMillis();
        l /= 1000L;
        l *= 1000L;
        return l += (long)n7;
    }

    public static String convertFromUTC(long l) {
        return TimeDateFormatUtil.convertFromUTC(l, timeZone);
    }

    public static String convertFromUTC(long l, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(15) / 1000;
        int n8 = calendar.get(16) / 1000;
        String string = null;
        try {
            string = TimeDateFormatUtil.getFormatDateTime(n, n2, n3, n4, n5, n6, n8, n7);
        }
        catch (FormatException formatException) {
            logger.trace("convertFromUTC formatException: " + formatException);
            string = null;
        }
        catch (Exception exception) {
            logger.trace("convertFromUTC exception: " + exception);
            string = null;
        }
        return string;
    }

    public static String getFormatDateTimeZoneDST(Calendar calendar) {
        String string = TimeDateFormatUtil.getFormatDateTime(calendar);
        if (ZoneDSTUtil.isShowZone()) {
            string = string + TimeDateFormatUtil.getZoneOffset();
        }
        if (ZoneDSTUtil.isShowDST()) {
            return string + " DST";
        }
        return string;
    }

    public static String getZoneOffset() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        Calendar calendar = Calendar.getInstance();
        long l = calendar.get(15);
        if (l >= 0L) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            l = -l;
        }
        long l2 = l / 1000L / 60L;
        if (l2 / 60L >= 10L) {
            stringBuffer.append(l2 / 60L);
        } else {
            stringBuffer.append('0').append(l2 / 60L);
        }
        if (l2 % 60L >= 10L) {
            stringBuffer.append(':').append(l2 % 60L);
        } else {
            stringBuffer.append(":0").append(l2 % 60L);
        }
        return stringBuffer.toString();
    }
}

