/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.format;

import com.swimap.iview.util.format.FormatException;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.log.IviewLogger;
import java.text.NumberFormat;

public class NumberFormatUtil {
    private static IviewLogger logger = IviewLogger.getLogger(NumberFormatUtil.class, "IVIEW");
    private static final String ZERO = ".";
    public static final ValueNamePair DEFAULT_GROUP_FORMAT = new ValueNamePair(0, " ");
    public static final ValueNamePair DEFAULT_IS_SHOW_WITH_ZERO = new ValueNamePair(1, "ShowFormatfromZero1");
    public static final ValueNamePair DEFAULT_DIGIT_AFTER_ZERO = new ValueNamePair(2, "DigitafterZero2");
    public static final int GROUP_FORMAT_VALUE = 1;
    public static final int IS_SHOW_WITH_ZERO_VALUE = 2;
    public static final int DIGIT_AFTER_ZERO_VALUE = 3;
    private static ValueNamePair curGroupFormat = DEFAULT_GROUP_FORMAT;
    private static ValueNamePair curIsShowWithZero = DEFAULT_IS_SHOW_WITH_ZERO;
    private static ValueNamePair curDigitafterZero = DEFAULT_DIGIT_AFTER_ZERO;
    private static final int SHOW_WITH_ZERO_VALUE = 1;

    public static String getFormatNumber(String string) throws FormatException {
        try {
            return NumberFormatUtil.getFormatNumber(string, NumberFormatUtil.getCurGroupFormat(), NumberFormatUtil.getCurDigitafterZero(), NumberFormatUtil.getCurIsShowWithZero());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            StringBuffer stringBuffer = new StringBuffer(60);
            stringBuffer.append("getFormatNumber (String _num) Error!  ").append("  _num =  ").append(string);
            throw new FormatException(stringBuffer.toString());
        }
    }

    public static String getFormatNumber(int n) {
        try {
            String string = "";
            string = Integer.toString(n);
            return NumberFormatUtil.getFormatNumber(string, NumberFormatUtil.getCurGroupFormat(), NumberFormatUtil.getCurDigitafterZero(), NumberFormatUtil.getCurIsShowWithZero());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            logger.trace("getFormatNumber (int _num) Error!  _num =  " + n);
            return "";
        }
    }

    public static String getFormatNumber(String string, String string2, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (string == null || string.length() == 0) {
            return "";
        }
        if ("0".equals(string)) {
            return string;
        }
        if (" ".equals(string2)) {
            string2 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        String string3 = "";
        String string4 = "";
        int n5 = string.indexOf(ZERO);
        if (n5 < 0) {
            string3 = string.trim();
        } else {
            string4 = string.substring(n5 + 1).trim();
            if (string4.length() > n) {
                string = string.substring(0, n5 + n + 2);
                string = NumberFormatUtil.formatDecimal(string, n);
                n5 = string.indexOf(ZERO);
                string4 = string.substring(n5 + 1).trim();
            }
            string3 = string.substring(0, n5).trim();
        }
        if (string3.length() <= 3) {
            if (string3.length() == 0 && bl) {
                stringBuffer.append("0");
            } else if (!"0".equals(string3) || bl) {
                stringBuffer.append(string3);
            }
        } else if (string2 != null && string2.length() > 0) {
            n4 = string3.length() % 3;
            if (n4 > 0) {
                String string5 = string3.substring(0, n4);
                stringBuffer.append(string5);
                if (!"-".equals(string5)) {
                    stringBuffer.append(string2);
                }
            }
            n3 = string3.length();
            for (n2 = n4; n2 < n3; n2 += 3) {
                stringBuffer.append(string3.substring(n2, n2 + 3));
                if (n2 + 3 >= n3) continue;
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(string3);
        }
        if (string4.length() > 0 && n > 0) {
            stringBuffer.append(ZERO);
            if (string4.length() > n) {
                stringBuffer.append(string4.substring(0, n));
            } else {
                stringBuffer.append(string4);
                for (n4 = n - string4.length(); n4 > 0; --n4) {
                    stringBuffer.append('0');
                }
            }
        }
        if ('-' == stringBuffer.charAt(0)) {
            n4 = 1;
            for (n2 = 1; n2 < stringBuffer.length(); ++n2) {
                n3 = stringBuffer.charAt(n2);
                if (48 == n3 || 46 == n3) continue;
                n4 = 0;
                break;
            }
            if (n4 != 0) {
                stringBuffer = stringBuffer.deleteCharAt(0);
            }
        }
        return stringBuffer.toString();
    }

    private static String formatDecimal(String string, int n) {
        if (n >= 0) {
            try {
                double d = Double.parseDouble(string);
                double d2 = 0.5;
                for (int i = 0; i < n; ++i) {
                    d2 *= 0.1;
                }
                if (d < 0.0) {
                    d2 = -d2;
                }
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(n + 1);
                numberFormat.setMinimumFractionDigits(n + 1);
                return numberFormat.format(d += d2);
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
        return string;
    }

    public static ValueNamePair getCurDigitafterZeroPair() {
        return curDigitafterZero;
    }

    public static ValueNamePair getCurGroupFormatPair() {
        return curGroupFormat;
    }

    public static ValueNamePair getCurIsShowWithZeroPair() {
        return curIsShowWithZero;
    }

    public static int getCurDigitafterZero() {
        return NumberFormatUtil.getCurDigitafterZeroPair().getValue();
    }

    public static String getCurGroupFormat() {
        return NumberFormatUtil.getCurGroupFormatPair().toString();
    }

    public static boolean getCurIsShowWithZero() {
        return NumberFormatUtil.getCurIsShowWithZeroPair().getValue() == 1;
    }

    public static void setCurDigitafterZero(ValueNamePair valueNamePair) {
        curDigitafterZero = valueNamePair;
    }

    public static void setCurGroupFormat(ValueNamePair valueNamePair) {
        curGroupFormat = valueNamePair;
    }

    public static void setCurIsShowWithZero(ValueNamePair valueNamePair) {
        curIsShowWithZero = valueNamePair;
    }
}

