/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;

public class TextControl
extends JComponent
implements Serializable {
    protected boolean isDrawEdge = false;
    protected boolean isTransparent = true;
    private static final int DEFAULT_POSITION = 33;
    private static final int WIDTH = 150;
    private static final int HEIGHT = 20;
    protected int pos = 33;
    protected Insets margins = null;
    protected String data = null;
    protected Color edgColor = Color.black;

    public TextControl() {
        this.setSize(150, 20);
    }

    public TextControl(String string) {
        this();
        this.data = string;
    }

    public void setText(String string) {
        this.data = string;
        this.repaint();
    }

    public String getText() {
        return this.data;
    }

    public void setAlignment(int n) {
        this.pos = n;
    }

    public int getAlignment() {
        return this.pos;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setTransparent(boolean bl) {
        this.isTransparent = bl;
        this.repaint();
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void setEdgeColor(Color color) {
        this.edgColor = color;
        this.repaint();
    }

    public Color getEdgeColor() {
        return this.edgColor;
    }

    public void setDrawEdge(boolean bl) {
        this.isDrawEdge = bl;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.isDrawEdge;
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics graphics = this.getGraphics();
        if (null == graphics || null == this.data || this.data.length() == 0) {
            return new Dimension(150, 20);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Insets insets = new Insets(0, 0, 0, 0);
        return new Dimension(insets.left + insets.right + fontMetrics.stringWidth(this.data), insets.top + insets.bottom + fontMetrics.getHeight());
    }

    @Override
    public void update(Graphics graphics) {
        boolean bl = this.isTransparent;
        this.isTransparent = false;
        super.paint(graphics);
        this.isTransparent = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        Insets insets = new Insets(0, 0, 0, 0);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        if (!this.isTransparent) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (null != this.data && this.data.length() > 0) {
            int n = 0;
            int n2 = 0;
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            switch (this.pos & 0xF) {
                case 1: {
                    n = insets.left;
                    break;
                }
                case 2: {
                    n = (dimension.width - fontMetrics.stringWidth(this.data)) / 2;
                    break;
                }
                case 3: {
                    n = dimension.width - fontMetrics.stringWidth(this.data) - insets.right;
                    break;
                }
                default: {
                    n = insets.left;
                }
            }
            switch (this.pos & 0xF0) {
                case 16: {
                    n2 = insets.top;
                    break;
                }
                case 32: {
                    n2 = (dimension.height - fontMetrics.getHeight()) / 2;
                    break;
                }
                case 48: {
                    n2 = dimension.height - insets.bottom - fontMetrics.getHeight();
                    break;
                }
                default: {
                    n2 = insets.top;
                }
            }
            n2 = n2 + fontMetrics.getLeading() + fontMetrics.getAscent();
            graphics.setColor(this.getForeground());
            graphics.drawString(this.data, n, n2);
        }
        if (this.isDrawEdge) {
            graphics.setColor(this.edgColor);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }
}

