/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.adapter;

import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.resource.i18n.UnicodeInputStream;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceMngHelper {
    private static final String DEFAULT_STYLE_LOCALE_DIR = "style/defaultstyle/locale/";
    private static IviewLogger logger = IviewLogger.getLogger(ResourceMngHelper.class, "IVIEW");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResourceBundleFromPropertyFile(String string) {
        Object object;
        Properties properties = new Properties();
        String string2 = ResourceMngHelper.getLocaleFullFileName(string) + ".properties";
        File file = CommonUtil.getAbsoluteFile(string2);
        URL uRL = ResourceMngHelper.getURLFromJar(string2);
        if (file.exists() || null != uRL) {
            object = null;
            InputStreamReader inputStreamReader = null;
            try {
                UnicodeInputStream unicodeInputStream;
                String string3;
                try {
                    object = new FileInputStream(CommonUtil.getAbsolutePath(string2));
                }
                catch (IOException iOException) {
                    logger.error("Exception While loading the file : " + iOException);
                }
                if (null == object && null != uRL) {
                    object = uRL.openStream();
                }
                inputStreamReader = null == (string3 = (unicodeInputStream = new UnicodeInputStream((InputStream)object, null)).getEncoding()) ? new InputStreamReader((InputStream)unicodeInputStream, ResourceUtil.CLIENT_ENCODING) : new InputStreamReader((InputStream)unicodeInputStream, string3);
                properties.load(inputStreamReader);
            }
            catch (IOException iOException) {
                logger.error("Exception While loading the file : " + iOException);
                properties = null;
            }
            finally {
                if (null != inputStreamReader) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.error("Exception While Claosing stream : " + iOException);
                    }
                }
                if (null != object) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        logger.error("Exception While Claosing stream : " + iOException);
                    }
                }
            }
        } else {
            logger.error("Resource file not found:" + string2);
        }
        object = new PropertyResourceBundleEx(properties);
        return object;
    }

    public static URL getURLFromJar(String string) {
        String string2 = string;
        if (string.indexOf(92) != -1) {
            string2 = string.replace('\\', '/');
        }
        URL uRL = null;
        ClassLoader classLoader = ResourceMngHelper.class.getClassLoader();
        if (null != classLoader) {
            uRL = classLoader.getResource(string2);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string) {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            URL uRL;
            try {
                inputStream = new FileInputStream(CommonUtil.getAbsolutePath(string));
            }
            catch (IOException iOException) {
                logger.error("Get property failed :" + iOException);
                properties = null;
            }
            if (inputStream == null && null != (uRL = ResourceMngHelper.getURLFromJar(string))) {
                if (null == properties) {
                    properties = new Properties();
                }
                inputStream = uRL.openStream();
            }
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            logger.trace("Get property failed :" + iOException);
            properties = null;
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException iOException) {
                logger.trace("Stream can not be closed :" + iOException);
            }
        }
        return properties;
    }

    public static String getLocaleFullFileName(String string) {
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = DEFAULT_STYLE_LOCALE_DIR + string2 + '_' + string3 + System.getProperty("file.separator");
        return string4 + string;
    }

    public static String[] getProperty(String string, String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        int n3 = Math.min(n2, stringArray2.length);
        String[] stringArray3 = new String[n2];
        Properties properties = ResourceMngHelper.getProperties(string);
        if (properties == null) {
            return stringArray3;
        }
        for (n = 0; n < n3; ++n) {
            stringArray3[n] = properties.getProperty(stringArray[n], stringArray2[n]);
        }
        for (n = n3; n < n2; ++n) {
            stringArray3[n] = properties.getProperty(stringArray[n]);
        }
        return stringArray3;
    }
}

