/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.adapter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;

public class LineWrapper {
    public static final int SAVE_FRONT = 0;
    public static final int SAVE_BACK = 1;
    private static final int TEN = 10;
    private static char[] punctuations = new char[]{'\uff0c', '\u3002', '\uff1b', '\uff1f', '\uff01', '\uff1a', '\u201d', '\uff09', '\u300b', '\u2019', ',', '.', ';', '?', '!', ':', '\"', ')', '>'};

    public static String getLineWrapString(String string, int n, Font font, boolean bl) {
        if (string == null || font == null) {
            throw new IllegalArgumentException("original or font can not be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxLengthPerLine must be more then 0.");
        }
        Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ("\r".equals(string3) || "\n".equals(string3)) {
                stringBuffer.append(string3);
                continue;
            }
            int n2 = fontMetrics.stringWidth(string3);
            if (n2 <= n) {
                stringBuffer.append(string3);
                continue;
            }
            while (n2 > n) {
                String string4;
                int n3;
                if (fontMetrics.stringWidth(string3.substring(0, 1)) > n) {
                    throw new IllegalArgumentException("maxLengthPerLine must be more then " + n + '.');
                }
                int n4 = string3.length();
                for (n3 = 0; n3 < n4 && fontMetrics.stringWidth(string3.substring(0, n3)) <= n; ++n3) {
                }
                boolean bl2 = false;
                if (bl && (string4 = string3.substring(0, n3)).substring(string4.length() - 2).getBytes().length > 2) {
                    if (LineWrapper.isSeparator(string4.charAt(string4.length() - 1))) {
                        --n3;
                    }
                    bl2 = true;
                }
                int n5 = string3.substring(0, n3 - 1).lastIndexOf(" ");
                if (bl) {
                    n5 = LineWrapper.getLastDouByteChar(string3.substring(0, n3 - 1));
                }
                if (!bl2) {
                    if (bl) {
                        if (LineWrapper.getLastDouByteChar(string3.charAt(n3 - 1) + "") == -1 && n5 != -1) {
                            n3 = n5 + 2;
                        }
                    } else if (string3.charAt(n3 - 1) != ' ' && n5 != -1) {
                        n3 = n5 + 2;
                    }
                }
                stringBuffer.append(string3.substring(0, n3 - 1));
                stringBuffer.append(string2);
                string3 = string3.substring(n3 - 1);
                n2 = fontMetrics.stringWidth(string3);
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static boolean isSeparator(char c) {
        for (int i = 0; i < punctuations.length; ++i) {
            if (punctuations[i] != c) continue;
            return true;
        }
        return false;
    }

    public static String getAbbreviatoryString(String string, int n, Font font) {
        return LineWrapper.getAbbreviatoryString(string, n, font, 0);
    }

    public static String getAbbreviatoryString(String string, int n, Font font, int n2) {
        if (string == null || font == null) {
            throw new IllegalArgumentException("original and font can not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("length can not less then 0.");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("mode must be one of the 'MODE_FRONT' or 'MODE_BACK'.");
        }
        Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(string);
        if (n3 <= n) {
            return string;
        }
        int n4 = string.length();
        if (n2 == 1) {
            while (fontMetrics.stringWidth(string.substring(n4)) <= n && --n4 >= 0) {
            }
            return "..." + string.substring(n4 + 1);
        }
        int n5 = 0;
        while (fontMetrics.stringWidth(string.substring(0, n5)) <= n && ++n5 <= n4) {
        }
        return string.substring(0, n5 - 1) + "...";
    }

    private static int getLastDouByteChar(String string) {
        for (int i = string.length() - 1; i > 0; --i) {
            if (string.substring(i).getBytes().length == string.substring(i).length() && string.charAt(i) != ' ') continue;
            return i;
        }
        return -1;
    }
}

