/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.adapter;

public class JCStringTokenizer {
    private int index;
    private String string;
    private int length;
    private boolean count = false;
    public boolean strip_esc = true;
    protected char escape_char = (char)92;
    private char[] token;

    public JCStringTokenizer(String string) {
        if (string != null) {
            this.string = string.trim();
            this.length = this.string.length();
        }
    }

    public int countTokens(char c) {
        int n = this.index;
        this.count = true;
        int n2 = 0;
        while (this.index < this.length) {
            this.nextToken(c);
            ++n2;
        }
        this.index = n;
        this.count = false;
        return n2;
    }

    public char getEscapeChar() {
        return this.escape_char;
    }

    public int getPosition() {
        return this.index;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    public String nextToken() {
        int n;
        if (this.string == null || this.index >= this.length) {
            return null;
        }
        for (n = this.index; n < this.length && Character.isWhitespace(this.string.charAt(n)); ++n) {
        }
        this.index = n;
        if (n >= this.length) {
            return null;
        }
        if (!this.count) {
            this.token = new char[this.length + 1];
        }
        int n2 = 0;
        for (n = this.index; n < this.length && !Character.isWhitespace(this.string.charAt(n)); ++n) {
            if (this.count) continue;
            this.token[n2++] = this.string.charAt(n);
        }
        this.index = n + 1;
        return this.count ? null : new String(this.token).trim();
    }

    public String nextToken(char c) {
        if (this.string == null || this.index >= this.length) {
            return null;
        }
        if (!this.count) {
            this.token = new char[this.length + 1];
        }
        int n = this.index;
        int n2 = 0;
        while (n < this.length) {
            if (this.escape_char != '\u0000' && n + 1 < this.length && this.string.charAt(n) == this.escape_char) {
                if (!this.strip_esc) {
                    if (this.token != null) {
                        this.token[n2++] = this.string.charAt(n);
                        this.token[n2] = this.string.charAt(++n);
                    }
                } else {
                    ++n;
                    if (!this.count) {
                        this.token[n2] = this.string.charAt(n) == 'n' ? 10 : this.string.charAt(n);
                    }
                }
            } else {
                if (this.string.charAt(n) == c) break;
                if (!this.count) {
                    this.token[n2] = this.string.charAt(n);
                }
            }
            ++n;
            ++n2;
        }
        this.index = n + 1;
        return this.count || n2 <= 0 ? null : new String(this.token, 0, n2);
    }

    public static String[] parse(String string, char c) {
        return JCStringTokenizer.parse(string, c, '\\');
    }

    public static String[] parse(String string, char c, char c2) {
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        jCStringTokenizer.escape_char = c2;
        String[] stringArray = new String[jCStringTokenizer.countTokens(c)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = jCStringTokenizer.nextToken(c);
            if (stringArray[i] != null) continue;
            stringArray[i] = "";
        }
        return stringArray;
    }

    public void setEscapeChar(char c) {
        this.escape_char = c;
    }
}

