/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.util.ISyncCommand;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.TrayIcon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public abstract class SyncCommandExt
implements ISyncCommand {
    private static IviewLogger logger = IviewLogger.getLogger(SyncCommandExt.class, "IVIEW");
    static int callcount = 0;
    private boolean isSuspend = false;
    private boolean syncLockGUI = true;
    private InternalFrame syncLockFrame = null;
    private Component oldGlassPane = null;
    private Component newGlassPane = null;
    private boolean lockFrameFocusable = false;
    private Image oldFrameImage = null;
    private boolean fullScreenable = false;
    private Object result = null;
    private Exception excep = null;
    private Thread thread = null;
    private boolean showOptionDialog = true;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static MouseListener glassPaneMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }
    };
    private static KeyListener glassPaneKeyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }
    };
    private InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            if (SyncCommandExt.this.syncLockFrame.isLockScreen()) {
                SyncCommandExt.this.setInternalFrameBusy(true);
                FrameworkUtilities.getMainFrame().requestFocus();
            }
        }
    };
    private boolean frameCloseable;
    private KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (keyEvent.getKeyCode() == 9 && keyEvent.isControlDown() && keyEvent.getID() == 401 && keyEvent.isShiftDown()) {
                FrameworkUtilities.getWindowTabbedManager().getTabbedBar().selectNextTab(false);
                return true;
            }
            if (keyEvent.getKeyCode() == 9 && keyEvent.isControlDown() && keyEvent.getID() == 401) {
                FrameworkUtilities.getWindowTabbedManager().getTabbedBar().selectNextTab(true);
                return true;
            }
            return SwingUtilities.isDescendingFrom(component, SyncCommandExt.this.syncLockFrame);
        }
    };

    @Override
    public Exception getException() {
        return this.excep;
    }

    @Override
    public boolean startCall() {
        return this.startCall(null, true);
    }

    @Override
    public boolean startCall(Component component, boolean bl) {
        if (component == null || !(component instanceof InternalFrame)) {
            SyncCommand syncCommand = new SyncCommand(){

                @Override
                public Object call() throws Exception {
                    SyncCommandExt.this.result = SyncCommandExt.this.call();
                    SyncCommandExt.this.excep = SyncCommandExt.this.getException();
                    return SyncCommandExt.this.result;
                }

                @Override
                protected boolean stop() {
                    return SyncCommandExt.this.stop();
                }
            };
            return syncCommand.startCall(component, bl);
        }
        if (ScreenToolKit.getFullScreenFlg()) {
            logger.debug("Client is in Full Screen, cannot start SyncCommandExt");
            return false;
        }
        logger.debug("SyncID:" + this.hashCode() + "--startCall called....lockGUI is " + bl);
        this.syncLockFrame = (InternalFrame)component;
        this.syncLockGUI = bl;
        this.isSuspend = true;
        this.result = null;
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.thread) {
                logger.trace("SyncCommandExt cannot be called twice over the same SyncCommandExt object");
                throw new IllegalStateException("SyncCommandExt cannot be called twice");
            }
            this.thread = new Thread((Runnable)new ProcessRunable(), "SysnCommandExt thread " + ++callcount);
            this.thread.start();
            logger.debug("SyncID:" + this.hashCode() + "--SyncCommand(ProcessRunnable) thread started...." + "Thread:" + this.thread.getName());
            this.suspendEvent();
            this.invokeMouseMoveEvent();
            if (this.excep != null) {
                return false;
            }
        } else {
            try {
                this.excep = null;
                this.result = this.call();
            }
            catch (Exception exception) {
                this.excep = exception;
                return false;
            }
        }
        return true;
    }

    private void invokeMouseMoveEvent() {
        Object object;
        AbstractButton abstractButton = SwimapButtonListener.getCurrentButton();
        AWTEvent aWTEvent = SwimapButtonListener.getLastMoveEvent();
        if (abstractButton != null && aWTEvent != null && (object = aWTEvent.getSource()) != null) {
            this.dispatchCompEvent(object, aWTEvent);
        }
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    private void resumeEvent() {
        logger.debug("SyncID:" + this.hashCode() + "--resumeEvent called.");
        this.isSuspend = false;
        Frame frame = OptionPane.getRootFrame();
        EventQueue eventQueue = frame.getToolkit().getSystemEventQueue();
        eventQueue.postEvent(new MouseEvent(frame, 0, 0L, 0, 0, 0, 1, false, 0));
    }

    private void suspendEvent() {
        logger.debug("SyncID:" + this.hashCode() + "--suspendEvent called.");
        if (this.isSuspend && this.syncLockGUI) {
            this.lockInternalFrame();
        }
        Frame frame = OptionPane.getRootFrame();
        EventQueue eventQueue = frame.getToolkit().getSystemEventQueue();
        while (this.isSuspend) {
            try {
                InternalFrame internalFrame;
                WindowManager windowManager;
                KeyEvent keyEvent;
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (aWTEvent.getID() == 401 && aWTEvent instanceof KeyEvent && (keyEvent = (KeyEvent)aWTEvent).getKeyCode() == 3 && keyEvent.isControlDown() && ((windowManager = FrameworkUtilities.getWindowManager()) == null ? this.cancel() : this.syncLockFrame == (internalFrame = (InternalFrame)windowManager.getActiveWindow()) && this.cancel())) break;
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (aWTEvent.getSource() instanceof Component) {
                    if ((Component)aWTEvent.getSource() == this.syncLockFrame) continue;
                    ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(aWTEvent.getSource() instanceof MenuComponent)) continue;
                ((MenuComponent)aWTEvent.getSource()).dispatchEvent(aWTEvent);
            }
            catch (Throwable throwable) {
                logger.trace("Exception : " + throwable.getMessage() + " while suspendEvent SyncID:" + this.hashCode(), throwable);
            }
        }
        if (!this.isSuspend && this.syncLockGUI) {
            this.unlockInternalFrame();
        }
    }

    private void lockInternalFrame() {
        this.syncLockFrame.setLockScreen(true);
        this.oldFrameImage = this.syncLockFrame.getIconImage();
        ImageIcon imageIcon = (ImageIcon)ResourceMng.getInstance().getIcon("BusyFrameIcon");
        if (imageIcon != null) {
            this.syncLockFrame.setIconImage(imageIcon.getImage());
        }
        this.oldGlassPane = this.syncLockFrame.getGlassPane();
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isManagingFocus() {
                return true;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        jPanel.setOpaque(false);
        jPanel.requestFocus();
        this.newGlassPane = jPanel;
        this.syncLockFrame.setGlassPane(this.newGlassPane);
        this.lockFrameFocusable = this.syncLockFrame.isFocusable();
        this.frameCloseable = this.syncLockFrame.isClosable();
        this.syncLockFrame.setFocusable(false);
        this.syncLockFrame.setBusy(true);
        this.fullScreenable = this.syncLockFrame.isFullScreenable();
        this.syncLockFrame.setFullScreenable(false);
        FrameworkUtilities.getWindowManager().enableFullScreenToolBarButton(false, this.syncLockFrame);
        FrameworkUtilities.getMainFrame().requestFocus();
        this.setInternalFrameBusy(true);
        this.syncLockFrame.addInternalFrameListener(this.internalFrameAdapter);
    }

    private void unlockInternalFrame() {
        if (null == this.oldGlassPane) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        if (this.syncLockFrame.isLockScreen()) {
            this.syncLockFrame.setLockScreen(false);
        }
        if (this.lockFrameFocusable) {
            this.syncLockFrame.setFocusable(this.lockFrameFocusable);
        }
        if (this.syncLockFrame.getFrameIcon() != this.oldFrameImage) {
            this.syncLockFrame.setIconImage(this.oldFrameImage);
        }
        if (this.fullScreenable) {
            this.syncLockFrame.setFullScreenable(this.fullScreenable);
            FrameworkUtilities.getWindowManager().enableFullScreenToolBarButton(this.fullScreenable, this.syncLockFrame);
        }
        if (this.syncLockFrame.isBusy()) {
            this.syncLockFrame.setBusy(false);
        }
        this.setInternalFrameBusy(false);
        if (this.frameCloseable) {
            this.syncLockFrame.setClosable(this.frameCloseable);
        }
        this.syncLockFrame.removeInternalFrameListener(this.internalFrameAdapter);
        this.syncLockFrame.setGlassPane(this.oldGlassPane);
    }

    public void setInternalFrameBusy(boolean bl) {
        logger.debug("SyncID:" + this.hashCode() + "--setBusy called with busy=" + bl);
        InternalFrame internalFrame = this.syncLockFrame;
        if (bl) {
            internalFrame.getGlassPane().setVisible(true);
            internalFrame.getGlassPane().addMouseListener(glassPaneMouseListener);
            internalFrame.getGlassPane().addKeyListener(glassPaneKeyListener);
            internalFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            internalFrame.getGlassPane().setVisible(false);
            internalFrame.getGlassPane().removeMouseListener(glassPaneMouseListener);
            internalFrame.getGlassPane().removeKeyListener(glassPaneKeyListener);
            internalFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean cancel() {
        boolean bl = this.stop();
        if (bl) {
            this.isSuspend = false;
        }
        if (bl && this.showOptionDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Frame frame = OptionPane.getRootFrame();
                    OptionPane.showMessageDialog(frame, res.getString("Synccommand.break"));
                }
            });
        }
        return bl;
    }

    protected boolean stop() {
        return false;
    }

    public void enableStopDialog(boolean bl) {
        this.showOptionDialog = bl;
    }

    private void dispatchCompEvent(Object object, AWTEvent aWTEvent) {
        if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else if (object instanceof TrayIcon) {
            try {
                Method method = TrayIcon.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                method.invoke(object, aWTEvent);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            logger.error("SyncID:" + this.hashCode() + "--unable to dispatch event: " + aWTEvent);
        }
    }

    private class ProcessRunable
    implements Runnable {
        private ProcessRunable() {
        }

        @Override
        public void run() {
            SyncCommandExt.this.excep = null;
            try {
                SyncCommandExt.this.result = SyncCommandExt.this.call();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                SyncCommandExt.this.excep = exception;
            }
            SyncCommandExt.this.resumeEvent();
        }
    }
}

