/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ISyncCommand;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.SequencedEventCheck;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.dnd.SunDropTargetEvent;

public abstract class SyncCommand
implements ISyncCommand {
    private static IviewLogger logger = IviewLogger.getLogger(SyncCommand.class, "IVIEW");
    private boolean isSuspend = false;
    private boolean lockGUI = true;
    private Component component = null;
    private Object result = null;
    private Exception excep = null;
    private Thread thread = null;
    private static ArrayList eventList = new ArrayList(5);
    private static boolean suspendInvocationEvent = false;
    private static Object lock = new Object();
    private Window[] windows = null;
    private boolean showOptionDialog = true;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private boolean isBusyResetted = false;
    private JFrame mainFrame = null;
    static int callcount = 0;

    @Override
    public Exception getException() {
        return this.excep;
    }

    @Override
    public boolean startCall() {
        return this.startCall(null, true);
    }

    public static synchronized void beginSuspendInvocationEvent() {
        logger.debug("begin Suspend Invocation Event");
        suspendInvocationEvent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addEvent(Object object) {
        Object object2 = lock;
        synchronized (object2) {
            eventList.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void endSuspendInvocationEvent() {
        logger.debug("end Suspend Invocation Event");
        suspendInvocationEvent = false;
        ArrayList arrayList = null;
        Object object = lock;
        synchronized (object) {
            arrayList = eventList;
            eventList = new ArrayList(5);
        }
        object = new Thread(new PostInvocationEventRunable(arrayList));
        ((Thread)object).start();
    }

    @Override
    public boolean startCall(Component component, boolean bl) {
        this.component = component;
        this.lockGUI = bl;
        this.isSuspend = true;
        this.result = null;
        if (SwingUtilities.isEventDispatchThread()) {
            if (Thread.currentThread().isInterrupted()) {
                logger.error("Could not execute SyncComand:" + this.hashCode() + " since Event dispatch thread is interrupted");
                this.excep = new IllegalThreadStateException("Thread is interrupted");
                return false;
            }
            logger.debug("SyncID:" + this.hashCode() + "--startCall called....lockGUI is " + bl);
            if (null == this.thread) {
                this.thread = new Thread((Runnable)new ProcessRunable(callcount++), "sysnCommand thread " + callcount);
            }
            this.mainFrame = FrameworkUtilities.getMainFrame();
            if (null != this.mainFrame) {
                ArrayList<Window> arrayList = new ArrayList<Window>();
                this.getAllWindows(arrayList, this.mainFrame);
                this.windows = arrayList.toArray(new Window[arrayList.size()]);
            }
            this.thread.start();
            logger.debug("SyncID:" + this.hashCode() + "--SyncCommand(ProcessRunnable) thread started...." + "Thread:" + this.thread.getName());
            this.suspendEvent();
            this.invokeMouseMoveEvent();
            if (this.excep != null) {
                return false;
            }
        } else {
            try {
                this.excep = null;
                this.result = this.call();
            }
            catch (Exception exception) {
                logger.trace(exception);
                this.excep = exception;
                return false;
            }
        }
        return true;
    }

    private void getAllWindows(List<Window> list, Window window) {
        for (Window window2 : window.getOwnedWindows()) {
            list.add(window2);
            this.getAllWindows(list, window2);
        }
    }

    private void invokeMouseMoveEvent() {
        Object object;
        AbstractButton abstractButton = SwimapButtonListener.getCurrentButton();
        AWTEvent aWTEvent = SwimapButtonListener.getLastMoveEvent();
        if (abstractButton != null && aWTEvent != null && (object = aWTEvent.getSource()) != null) {
            this.dispatchCompEvent(object, aWTEvent);
        }
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    private void resumeEvent() {
        logger.debug("SyncID:" + this.hashCode() + "--resumeEvent called.");
        this.isSuspend = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SyncCommand.this.lockGUI) {
                    SyncCommand.this.setBusy(false);
                }
                FrameworkUtilities.removeActiveSyncCommand(SyncCommand.this);
            }
        });
        Frame frame = OptionPane.getRootFrame();
        EventQueue eventQueue = frame.getToolkit().getSystemEventQueue();
        eventQueue.postEvent(new MouseEvent(frame, 0, 0L, 0, 0, 0, 1, false, 0));
        logger.debug("Resume Event finished.");
    }

    public boolean isDispatchEvent(MouseEvent mouseEvent) {
        return false;
    }

    public boolean isDispatchEvent(KeyEvent keyEvent) {
        return false;
    }

    private void suspendEvent() {
        FrameworkUtilities.addActiveSyncCommand(this);
        logger.debug("SyncID:" + this.hashCode() + "--suspendEvent called.");
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.isSuspend && this.lockGUI) {
                this.setBusy(true);
            }
            Frame frame = OptionPane.getRootFrame();
            EventQueue eventQueue = frame.getToolkit().getSystemEventQueue();
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            while (this.isSuspend && !Thread.currentThread().isInterrupted()) {
                try {
                    Object object;
                    Object object2;
                    if (this.lockGUI && null != this.mainFrame && ((MDIFrame)this.mainFrame).getCursorState() != 3) {
                        this.setBusy(true);
                    }
                    if (!this.isSuspend) break;
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    if (!SequencedEventCheck.acceptEvent(aWTEvent)) {
                        arrayList.add(aWTEvent);
                        continue;
                    }
                    if (aWTEvent.getID() == 401 && aWTEvent instanceof KeyEvent && ((KeyEvent)(object2 = (KeyEvent)aWTEvent)).getKeyCode() == 3 && ((InputEvent)object2).isControlDown() && this.cancel()) break;
                    if (this.lockGUI && aWTEvent instanceof KeyEvent) {
                        object2 = (KeyEvent)aWTEvent;
                        if (!this.isDispatchEvent((KeyEvent)object2)) continue;
                        object = aWTEvent.getSource();
                        ((Component)object).dispatchEvent(aWTEvent);
                        continue;
                    }
                    if (this.lockGUI && aWTEvent instanceof MouseEvent) {
                        object2 = SwimapButtonListener.getCurrentButton();
                        object = (MouseEvent)aWTEvent;
                        if (aWTEvent.getID() == 503 && object2 != null && !((Component)object2).getBounds().contains(((MouseEvent)object).getPoint())) {
                            SwimapButtonListener.setLastMoveEvent(aWTEvent);
                        }
                        if (this.isDispatchEvent((MouseEvent)aWTEvent)) {
                            Object object3 = aWTEvent.getSource();
                            ((Component)object3).dispatchEvent(aWTEvent);
                            logger.trace("SyncID:" + this.hashCode() + "--SyncCommand dispatch a MouseEvent: " + aWTEvent.paramString());
                            continue;
                        }
                    }
                    if (this.lockGUI & (aWTEvent instanceof MouseEvent || aWTEvent instanceof KeyEvent) && !(aWTEvent instanceof SunDropTargetEvent) || this.lockGUI && aWTEvent instanceof InputMethodEvent) continue;
                    object2 = aWTEvent.getSource();
                    if (aWTEvent instanceof ActiveEvent) {
                        if (suspendInvocationEvent && aWTEvent instanceof InvocationEvent && ((String)(object = aWTEvent.toString())).indexOf("javax.swing.SystemEventQueueUtilities$ComponentWorkRequest") != -1) {
                            logger.debug("Adding the event to event list");
                            SyncCommand.addEvent(aWTEvent);
                            continue;
                        }
                        ((ActiveEvent)((Object)aWTEvent)).dispatch();
                        continue;
                    }
                    if (object2 instanceof Component) {
                        ((Component)object2).dispatchEvent(aWTEvent);
                        continue;
                    }
                    if (object2 instanceof MenuComponent) {
                        ((MenuComponent)object2).dispatchEvent(aWTEvent);
                        continue;
                    }
                    logger.error("SyncID:" + this.hashCode() + "--unable to dispatch event: " + aWTEvent);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    logger.trace(throwable.getMessage(), throwable);
                }
            }
            if (!arrayList.isEmpty()) {
                for (Object object2 : arrayList) {
                    eventQueue.postEvent((AWTEvent)object2);
                }
            }
            if (!this.isSuspend && this.lockGUI) {
                this.setBusy(false);
            }
            if (Thread.currentThread().isInterrupted()) {
                logger.error("SyncComand:" + this.hashCode() + " stopped dispatching since Event dispatch thread" + " is interrupted");
                this.excep = new IllegalThreadStateException("Thread is interrupted");
            }
        }
    }

    private void setBusy(boolean bl) {
        if (!bl && !this.isBusyResetted) {
            logger.debug("SyncID:" + this.hashCode() + "--setBusy called with busy=" + bl + " isBusyReset " + this.isBusyResetted);
            return;
        }
        this.isBusyResetted = bl;
        logger.debug("SyncID:" + this.hashCode() + "--setBusy called with busy=" + bl);
        if (null != this.mainFrame) {
            SyncCommand.setComponentCursorBusy(this.mainFrame, bl);
            if (bl) {
                ((MDIFrame)this.mainFrame).setCursorState(3);
            } else {
                ((MDIFrame)this.mainFrame).setCursorState(0);
            }
            if (this.windows != null) {
                for (int i = 0; i < this.windows.length; ++i) {
                    if (!(this.windows[i] instanceof RootPaneContainer)) continue;
                    try {
                        if (bl) {
                            if (!this.windows[i].isVisible()) continue;
                            SyncCommand.setComponentCursorBusy((RootPaneContainer)((Object)this.windows[i]), true);
                            continue;
                        }
                        SyncCommand.setComponentCursorBusy((RootPaneContainer)((Object)this.windows[i]), false);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                }
            }
        }
        if (null != this.component && this.component != this.mainFrame) {
            Window window = null;
            window = this.component instanceof Window ? (Window)this.component : SwingUtilities.getWindowAncestor(this.component);
            if (window instanceof RootPaneContainer) {
                SyncCommand.setComponentCursorBusy((RootPaneContainer)((Object)window), bl);
            }
        }
    }

    private static void setComponentCursorBusy(final RootPaneContainer rootPaneContainer, final boolean bl) {
        if (rootPaneContainer == null) {
            logger.warn("The RootPaneContainer is null, the call of setComponentCursorBusy is ignored.");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            SyncCommand.setComponentCursorBusyEx(rootPaneContainer, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyncCommand.setComponentCursorBusyEx(rootPaneContainer, bl);
                }
            });
        }
    }

    private static void setComponentCursorBusyEx(RootPaneContainer rootPaneContainer, boolean bl) {
        if (bl) {
            rootPaneContainer.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            rootPaneContainer.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public abstract Object call() throws Exception;

    private boolean cancel() {
        boolean bl = this.stop();
        if (bl) {
            this.isSuspend = false;
            FrameworkUtilities.removeActiveSyncCommand(this);
        }
        if (bl && this.showOptionDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(SyncCommand.this.component, res.getString("Synccommand.break"));
                }
            });
        }
        return bl;
    }

    protected boolean stop() {
        return false;
    }

    public void enableStopDialog(boolean bl) {
        this.showOptionDialog = bl;
    }

    public void stopActiveSyncCommand() {
        logger.debug("SyncID:" + this.hashCode() + "--stopActiveSyncCommand() called.");
        this.isSuspend = false;
        FrameworkUtilities.removeActiveSyncCommand(this);
        Frame frame = OptionPane.getRootFrame();
        EventQueue eventQueue = frame.getToolkit().getSystemEventQueue();
        eventQueue.postEvent(new MouseEvent(frame, 0, 0L, 0, 0, 0, 1, false, 0));
        logger.debug("SyncID:" + this.hashCode() + "--stopActiveSyncCommand() end");
    }

    private void dispatchCompEvent(Object object, AWTEvent aWTEvent) {
        if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else if (object instanceof TrayIcon) {
            try {
                Method method = TrayIcon.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                method.invoke(object, aWTEvent);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            logger.error("SyncID:" + this.hashCode() + "--unable to dispatch event: " + aWTEvent);
        }
    }

    private class ProcessRunable
    implements Runnable {
        private int index = 0;

        public ProcessRunable(int n) {
            this.index = n;
        }

        @Override
        public void run() {
            SyncCommand.this.excep = null;
            try {
                SyncCommand.this.result = SyncCommand.this.call();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                SyncCommand.this.excep = exception;
            }
            catch (Throwable throwable) {
                logger.error("Error while executing sync command. Sync command will terminate");
                logger.error("Error is :" + throwable);
                SyncCommand.this.excep = new Exception(throwable);
            }
            SyncCommand.this.resumeEvent();
        }
    }

    private static class PostInvocationEventRunable
    implements Runnable {
        private static final int HALF_SEC = 500;
        private ArrayList _eventList = null;

        public PostInvocationEventRunable(ArrayList arrayList) {
            this._eventList = arrayList;
        }

        @Override
        public void run() {
            suspendInvocationEvent = false;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
            for (InvocationEvent invocationEvent : this._eventList) {
                ((Toolkit)invocationEvent.getSource()).getSystemEventQueue().postEvent(invocationEvent);
            }
            this._eventList.clear();
        }
    }
}

