/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.framework.Main;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class SplashScreen
extends JWindow {
    private static IviewLogger logger = IviewLogger.getLogger(SplashScreen.class, "IVIEW");
    private static final String DRAWTEXT_ENABLE = "SplashScreen_DrawText_enable";
    private static final String DRAWTEXT_CONFIGFILE = "SplashScreen_DrawText_ConfigFile";
    private static final String DESC_NAME = "launchtext";

    public SplashScreen(ImageIcon imageIcon) {
        super(new JFrame());
        this.setName("SplashScreen");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.paintImmediately(jPanel.getVisibleRect());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(this.getDrawTxtImageIcon(imageIcon)), "Center");
        jPanel.setBorder(new BevelBorder(0));
        this.getContentPane().add(jPanel);
        this.pack();
        ScreenToolKit.centerLocateToScreen(this);
        this.getGlassPane().setCursor(new Cursor(3));
        this.getGlassPane().setVisible(true);
        this.setVisible(true);
    }

    public void close() {
        try {
            SwingUtilities.invokeAndWait(new CloseSplashScreen());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private ImageIcon getDrawTxtImageIcon(ImageIcon imageIcon) {
        String string = CommonUtil.getResString(Main.getProductResourceBundle(), DRAWTEXT_ENABLE);
        String string2 = CommonUtil.getResString(Main.getProductResourceBundle(), DRAWTEXT_CONFIGFILE);
        if (null != string && "true".equals(string.trim()) && null != string2 && string2.trim().length() > 0) {
            return ScreenToolKit.addText2Image(imageIcon.getImage(), string2, DESC_NAME);
        }
        return imageIcon;
    }

    private final class CloseSplashScreen
    implements Runnable {
        private CloseSplashScreen() {
        }

        @Override
        public void run() {
            SplashScreen.this.setVisible(false);
            ((Window)SplashScreen.this.getParent()).dispose();
        }
    }
}

