/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.math.BigInteger;
import javax.swing.JPanel;

public class SpinEditorExt
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(SpinEditorExt.class, "IVIEW");
    private Spinner spinner;
    private int m_lMin = 0;
    private int m_lMax = 0;

    public SpinEditorExt(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("max can not less then min");
        }
        this.m_lMin = (int)l;
        this.m_lMax = (int)l2;
        this.spinner = new Spinner(new NumericSpinnerModel(this.m_lMin, this.m_lMin, this.m_lMax, 1));
        if (this.spinner instanceof Spinner) {
            this.spinner.setPreferredSize(new Dimension(200, 20));
        }
        this.add(this.spinner);
    }

    public SpinEditorExt() {
        try {
            this.spinner = new Spinner();
            if (this.spinner instanceof Spinner) {
                this.spinner.setPreferredSize(new Dimension(200, 20));
            }
            this.add(this.spinner);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    @Override
    public void setName(String string) {
        this.spinner.setName(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.spinner.setEnabled(bl);
    }

    public Object getObjectValue() {
        return this.spinner.getValue();
    }

    public BigInteger getValue() {
        try {
            return (BigInteger)this.spinner.getValue();
        }
        catch (Exception exception) {
            return new BigInteger("-1");
        }
    }

    public char getCharValue() {
        String string = this.spinner.getValue().toString();
        return string.charAt(0);
    }

    @Override
    public void setToolTipText(String string) {
        this.spinner.setToolTipText(string);
    }

    public void setValue(Object object) {
        this.spinner.setValue(object);
    }
}

