/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.util.log.IviewLogger;

public final class SerializationHandler {
    private static IviewLogger logger = IviewLogger.getLogger(SerializationHandler.class, "IVIEW");
    private static SerializationHandler instance = null;
    private static String serializeFolder = System.getProperty("serFolder", "Default");
    private static boolean enableSerialization = Boolean.getBoolean("serialize");

    private SerializationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SerializationHandler getInstance() {
        if (null != instance) return instance;
        Class<SerializationHandler> clazz = SerializationHandler.class;
        synchronized (SerializationHandler.class) {
            if (null != instance) return instance;
            instance = new SerializationHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isEnableSerialization() {
        return enableSerialization;
    }

    public void readSerializedData() {
        if (enableSerialization) {
            CommStyleManager.readFolderList();
            String string = CommStyleManager.getLastFolderEntry();
            if (string == null) {
                String string2 = System.getProperty("serFolder", "Default");
                this.readSerializedData(string2);
                return;
            }
            this.readSerializedData(string);
        }
    }

    public void writeSerializedData() {
        if (enableSerialization) {
            CommStyleManager.writeFolderList();
            String string = System.getProperty("serFolder", "Default");
            this.writeSerializedData(string);
            PluginSerializationHandler.writeSerializedResource(serializeFolder);
        }
    }

    public void writeSerializedData(String string) {
        if (enableSerialization) {
            ResourceMng.getInstance().writeSerializedResource(string);
            CommStyleManager.writeSerializedResource(string);
            PluginSerializationHandler.writeSerializedResource(string);
        }
    }

    public void readSerializedData(String string) {
        logger.debug("@iviewPerf: readSErialziedData started:" + string + "time:" + System.currentTimeMillis());
        if (enableSerialization) {
            ResourceMng.getInstance().readSerializedResource(string);
            CommStyleManager.readSerializedResource(string);
            PluginSerializationHandler.readSerializedResource(string);
        }
        logger.debug("@iviewPerf: readSErialziedData started:" + string + "time:" + System.currentTimeMillis());
    }
}

