/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SerializableTool {
    private static IviewLogger logger = IviewLogger.getLogger(SerializableTool.class, "IVIEW");
    public static final String SER_DIR = System.getProperty("user.dir") + "/configuration/Serializable/";
    private static final String CONF_DIR = System.getProperty("user.dir") + "/configuration/";
    private static boolean isConfigCheck = false;
    private static final String PATCH_FOLDER = "./patch";
    public static final String CURRENT_DIR = "CURRENT_DIRECTORY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T readData(String string) {
        if (!isConfigCheck) {
            SerializableTool.deleteConfig(string);
        }
        Serializable serializable = null;
        if (string == null) {
            return null;
        }
        File file = new File(SER_DIR + string);
        ObjectInputStream objectInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                serializable = (Serializable)objectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            logger.trace("Serialization Reading Error " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.trace("Serialization Reading Error " + classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("Stream not able to close " + iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("Stream not able to close " + iOException);
                }
            }
        }
        return (T)serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void writeData(String string, T t) {
        File file = new File(SER_DIR + string);
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
        }
        if (t != null) {
            boolean bl = false;
            ObjectOutput objectOutput = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutput = new ObjectOutputStream(fileOutputStream);
                objectOutput.writeObject(t);
            }
            catch (IOException iOException) {
                logger.trace("Serialization Writing Error " + iOException);
                bl = true;
            }
            finally {
                if (objectOutput != null) {
                    try {
                        objectOutput.close();
                    }
                    catch (IOException iOException) {
                        logger.trace("Stream not able to close" + iOException);
                        bl = true;
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace("Stream not able to close" + iOException);
                    }
                }
                if (bl) {
                    file.delete();
                }
            }
        }
    }

    public static String getFileName(String string) {
        String string2 = SerializableTool.getSubsystemName();
        String string3 = string + '_' + string2 + ".dat";
        return string3;
    }

    private static void deleteConfig(String string) {
        File file = new File(CONF_DIR);
        if (!file.exists()) {
            isConfigCheck = true;
            return;
        }
        File file2 = new File(SER_DIR);
        if (!file2.exists()) {
            SerializableTool.checkDelete(file);
            return;
        }
        File file3 = new File(SER_DIR + string);
        SerializableTool.checkDelete(file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDelete(File file) {
        long l = file.lastModified();
        if (l > 0L) {
            File file2 = new File(PATCH_FOLDER);
            long l2 = file2.lastModified();
            if (l2 == 0L) {
                isConfigCheck = true;
                return;
            }
            File file3 = new File(CONF_DIR, "temp");
            File file4 = new File(CONF_DIR);
            if (l < l2) {
                CommonUtil.deleteDir(new File(CONF_DIR));
                file4.mkdir();
                long l3 = SerializableTool.checkFileTime(file2);
                SerializableTool.doWrite(file3, l3);
            } else {
                long l4 = SerializableTool.checkFileTime(file2);
                BufferedReader bufferedReader = null;
                try {
                    if (file3.exists()) {
                        FileReader fileReader = new FileReader(file3);
                        bufferedReader = new BufferedReader(fileReader);
                        String string = bufferedReader.readLine();
                        bufferedReader.close();
                        fileReader.close();
                        Long l5 = Long.valueOf(string);
                        if (l5 != l4) {
                            CommonUtil.deleteDir(new File(CONF_DIR));
                            file4.mkdir();
                            SerializableTool.doWrite(file3, l4);
                        }
                    } else {
                        SerializableTool.doWrite(file3, l4);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.trace("FileNotFoundException : " + fileNotFoundException.getMessage(), fileNotFoundException);
                }
                catch (IOException iOException) {
                    logger.trace("IOException : " + iOException.getMessage(), iOException);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            logger.trace("IOException in close: " + iOException.getMessage(), iOException);
                        }
                    }
                }
            }
            isConfigCheck = true;
        }
    }

    public static void recreateConfiguration() {
        File file = new File(CONF_DIR, "temp");
        File file2 = new File(CONF_DIR);
        File file3 = new File(PATCH_FOLDER);
        CommonUtil.deleteDir(new File(CONF_DIR));
        boolean bl = file2.mkdir();
        if (bl) {
            long l = SerializableTool.checkFileTime(file3);
            SerializableTool.doWrite(file, l);
        } else {
            logger.trace("configuration folder creation failed");
        }
    }

    private static void doWrite(final File file, final long l) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file);
                    fileWriter.write(Long.toString(l));
                }
                catch (IOException iOException) {
                    logger.trace("IOException : " + iOException.getMessage(), iOException);
                }
                finally {
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException iOException) {
                            logger.trace("IOException in close: " + iOException.getMessage(), iOException);
                        }
                    }
                }
            }
        }).start();
    }

    private static long checkFileTime(File file) {
        String[] stringArray;
        long l = 0L;
        if (null != file && null != (stringArray = file.list())) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                l += file2.lastModified();
            }
        }
        return l;
    }

    private static String getSubsystemName() {
        String string = System.getProperty("subsystem");
        if (null == string || 0 == string.length()) {
            String string2 = System.getProperty("exsubsystem");
            if (null == string2) {
                string = "All";
            } else {
                List<String> list = SerializableTool.getSubsystemList(string2);
                if (null != list && list.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string3 : list) {
                        stringBuffer.append(string3);
                    }
                    string = "All_exsub_" + stringBuffer.toString();
                }
            }
        }
        return string;
    }

    private static List<String> getSubsystemList(String string) {
        ArrayList<String> arrayList = null;
        if (null != string) {
            arrayList = new ArrayList<String>(10);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }
}

