/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

public class ScreenUIToolKit {
    static final String ActionMapKey = "ActionMapKey";
    static final KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
    private static final int MIN_WIDTH = 80;
    static final KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
    private static final String ENTER = "ENTER";
    private static final String ESCAPE = "ESCAPE";
    static final Action action = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getInputMap(2).get(enterKeyStroke) != null) {
                Container container = abstractButton.getRootPane().getParent();
                Component component = null;
                if (container != null) {
                    if (container instanceof Window) {
                        component = ((Window)container).getFocusOwner();
                    } else if (container instanceof JInternalFrame) {
                        component = ((JInternalFrame)container).getFocusOwner();
                    }
                }
                if (component == null || component instanceof TextArea || component instanceof JEditorPane || component instanceof JTextArea) {
                    return;
                }
            }
            abstractButton.doClick(20);
        }
    };

    public static void setDefaultButtons(AbstractButton abstractButton, AbstractButton abstractButton2) {
        if (abstractButton != null) {
            abstractButton.getInputMap(2).put(enterKeyStroke, ActionMapKey);
            abstractButton.getActionMap().put(ActionMapKey, action);
        }
        if (abstractButton2 != null) {
            abstractButton2.getInputMap(2).put(escapeKeyStroke, ActionMapKey);
            abstractButton2.getActionMap().put(ActionMapKey, action);
        }
    }

    public static void setPreferredSizeofButtons(JButton[] jButtonArray, int n) {
        int n2;
        if (jButtonArray == null || jButtonArray.length == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            n4 = jButtonArray[n2].getPreferredSize().width;
            n3 = n3 > n4 ? n3 : n4;
        }
        n3 = n3 > 80 ? n3 : 80;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            jButtonArray[n2].setPreferredSize(new Dimension(n3, n));
        }
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = null;
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        jPopupMenu.pack();
        jPopupMenu.validate();
        dimension = jPopupMenu.getSize();
        n3 = dimension.width;
        n4 = dimension.height;
        if (n3 == 0 || n4 == 0) {
            dimension = jPopupMenu.getPreferredSize();
            n3 = dimension.width;
            n4 = dimension.height;
        }
        Component component = mouseEvent.getComponent();
        Point point = component.getLocationOnScreen();
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        Point point2 = component2.getLocationOnScreen();
        Dimension dimension2 = component2.getSize();
        Insets insets = null;
        if (jPopupMenu.isBorderPainted()) {
            insets = jPopupMenu.getBorder().getBorderInsets(jPopupMenu);
        }
        Insets insets2 = ((Container)component2).getInsets();
        int n5 = 1;
        int n6 = (insets == null ? 0 : insets.bottom) + insets2.bottom + n5;
        int n7 = (insets == null ? 0 : insets.right) + insets2.right + n5;
        if (point.y + n2 + n4 + n6 > point2.y + dimension2.height) {
            n2 = point2.y + dimension2.height - n4 - n6 - point.y;
        }
        if (point.x + n + n3 + n7 > point2.x + dimension2.width) {
            n = point2.x + dimension2.width - n3 - n7 - point.x;
        }
        jPopupMenu.show(mouseEvent.getComponent(), n, n2);
    }

    public static void setDefaultButtons(JComponent jComponent, final AbstractButton abstractButton, final AbstractButton abstractButton2) {
        if (abstractButton != null) {
            abstractButton.getInputMap(2).put(enterKeyStroke, ActionMapKey);
            abstractButton.getActionMap().put(ActionMapKey, action);
            jComponent.getInputMap().put(KeyStroke.getKeyStroke(ENTER), ENTER);
            jComponent.getActionMap().put(ENTER, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    abstractButton.doClick();
                }
            });
        }
        if (abstractButton2 != null) {
            abstractButton2.getInputMap(2).put(escapeKeyStroke, ActionMapKey);
            abstractButton2.getActionMap().put(ActionMapKey, action);
            jComponent.getInputMap().put(KeyStroke.getKeyStroke(ESCAPE), ESCAPE);
            jComponent.getActionMap().put(ESCAPE, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    abstractButton2.doClick();
                }
            });
        }
    }

    public static void setDefaultButtons(JComponent[] jComponentArray, final AbstractButton abstractButton, final AbstractButton abstractButton2) {
        int n;
        AbstractAction abstractAction;
        if (abstractButton != null) {
            abstractButton.getInputMap(2).put(enterKeyStroke, ActionMapKey);
            abstractButton.getActionMap().put(ActionMapKey, action);
            if (jComponentArray != null && jComponentArray.length > 0) {
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        abstractButton.doClick();
                    }
                };
                for (n = 0; n < jComponentArray.length; ++n) {
                    jComponentArray[n].getInputMap().put(KeyStroke.getKeyStroke(ENTER), ENTER);
                    jComponentArray[n].getActionMap().put(ENTER, abstractAction);
                }
            }
        }
        if (abstractButton2 != null) {
            abstractButton2.getInputMap(2).put(escapeKeyStroke, ActionMapKey);
            abstractButton2.getActionMap().put(ActionMapKey, action);
            if (jComponentArray != null && jComponentArray.length > 0) {
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        abstractButton2.doClick();
                    }
                };
                for (n = 0; n < jComponentArray.length; ++n) {
                    jComponentArray[n].getInputMap().put(KeyStroke.getKeyStroke(ESCAPE), ESCAPE);
                    jComponentArray[n].getActionMap().put(ESCAPE, abstractAction);
                }
            }
        }
    }

    public static void centerLocateToScreen(Component component) {
        if (component == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point();
        point.x = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        point.y = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        component.setLocation(point);
    }

    public static void centerLocate(Component component, Container container) {
        if (component == null || null == container) {
            return;
        }
        Container container2 = null;
        for (Container container3 = container.getParent(); container3 != null; container3 = container3.getParent()) {
            if (!(container3 instanceof JViewport)) continue;
            container2 = (JViewport)container3;
        }
        if (null == container2) {
            container2 = container;
        }
        Point point = container2.getLocationOnScreen();
        Point point2 = new Point();
        point2.x = point.x + (container2.getWidth() / 2 - component.getWidth() / 2);
        point2.y = point.y + (container2.getHeight() / 2 - component.getWidth() / 2);
        component.setLocation(point2);
    }
}

