/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.MenuBar;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalDialog;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.DynDrawTxtImageIcon;
import com.swimap.iview.util.GlassPane;
import com.swimap.iview.util.ImageTextDescription;
import com.swimap.iview.util.ScreenUIToolKit;
import com.swimap.iview.util.adapter.LineWrapper;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public final class ScreenToolKit {
    private static IviewLogger logger = IviewLogger.getLogger(ScreenToolKit.class, "IVIEW");
    public static final int SAVE_FRONT = 0;
    public static final int SAVE_BACK = 1;
    private static final int ADJUST_HEIGHT = 30;
    private static final int MIN_WIDTH = 80;
    private static ArrayList<Window> showVisibleWindowsList = new ArrayList(5);
    private static ArrayList<Window> allChildWindowsList = new ArrayList(5);
    private static MDIFrame fullScreenFrame = null;
    private static final String HORIZONTAL_OFFSET = "horizontal_offset";
    private static final String VERTICAL_OFFSET = "vertical_offset";
    private static final String LOCATION_FILE_NAME = "conf/templates/dialoglocationsetting";
    private static final String DEFAULT_STYLE = "style/defaultstyle/";
    private static final String ISPERSISTDIALOG = "ispersistdialog";
    private static final String DIALOG_LOCATION = "dialoglocation";
    private static final int TWO = 2;
    private static final int DEFAULT_BUFFER_SIZE = 16;
    private static final String STYLEFILE_EXTENSION = ".xml";
    private static int lockCounts = 0;
    private static MouseListener glassMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }
    };
    private static char[] punctuations = new char[]{'\uff0c', '\u3002', '\uff1b', '\uff1f', '\uff01', '\uff1a', '\u201d', '\uff09', '\u300b', '\u2019', ',', '.', ';', '?', '!', ':', '\"', ')', '>'};
    private static JDialog closeFullScreenDialog = null;
    private static GlassPane glassPane = null;
    private static boolean isSavePositionEnable = false;
    private static boolean lockedWhenFullScreen = false;
    private static ArrayList<PropertyChangeListener> fsPropertyChangeListener = new ArrayList();
    private static ArrayList<WindowListener> fsWindowListener = new ArrayList();
    private static ArrayList<KeyListener> fsKeyListener = new ArrayList();
    private static ArrayList<FocusListener> fsFocusListener = new ArrayList();
    private static int srcFrameState = 6;
    private static String originalF10Action = null;
    static final Action action = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getInputMap(2).get(enterKeyStroke) != null) {
                Container container = abstractButton.getRootPane().getParent();
                Component component = null;
                if (container != null) {
                    if (container instanceof Window) {
                        component = ((Window)container).getFocusOwner();
                    } else if (container instanceof JInternalFrame) {
                        component = ((JInternalFrame)container).getFocusOwner();
                    }
                }
                if (component == null || component instanceof TextArea || component instanceof JEditorPane || component instanceof JTextArea) {
                    return;
                }
            }
            abstractButton.doClick(20);
        }
    };
    static final String ActionMapKey = "ActionMapKey";
    static final KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
    static final KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
    private static JFrame srcMainFrame = null;
    private static JInternalFrame srcInternalFrame = null;
    private static boolean fullScreenFlg = false;
    static JDesktopPane desktopPane = null;
    private static boolean isMaximum = false;
    private static boolean isClosing = false;
    private static KeyEventPostProcessor m_oKeyProcessor = new KeyEventPostProcessor(){

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && fullScreenFrame != null && fullScreenFrame.isActive()) {
                ScreenToolKit.closeFullScreenFrame();
                return true;
            }
            if (keyEvent.getKeyCode() == 67 && keyEvent.getModifiers() == 8 && fullScreenFrame != null && fullScreenFrame.isActive()) {
                ScreenToolKit.closeFullScreenFrame();
            }
            return false;
        }
    };

    private ScreenToolKit() {
    }

    public static ImageIcon addText2Image(Image image, ImageTextDescription[] imageTextDescriptionArray) {
        if (null == image) {
            throw new IllegalArgumentException("image argument shouldn't be null.");
        }
        if (null == imageTextDescriptionArray) {
            throw new IllegalArgumentException("info argument shouldn't be null.");
        }
        DynDrawTxtImageIcon dynDrawTxtImageIcon = new DynDrawTxtImageIcon(image, imageTextDescriptionArray);
        return dynDrawTxtImageIcon;
    }

    public static ImageIcon addText2Image(Image image, String string, String string2) {
        if (null == image) {
            throw new IllegalArgumentException("image argument shouldn't be null.");
        }
        if (null == string || string.trim().length() == 0) {
            throw new IllegalArgumentException("fileName argument shouldn't be null and filename's length shouldn't be zero.");
        }
        if (null == string2 || string2.trim().length() == 0) {
            throw new IllegalArgumentException("descName argument shouldn't be null and descName's length shouldn't be zero.");
        }
        DynDrawTxtImageIcon dynDrawTxtImageIcon = new DynDrawTxtImageIcon(image, string, string2);
        return dynDrawTxtImageIcon;
    }

    public static String getAbbreviatoryString(String string, int n, Font font) {
        return ScreenToolKit.getAbbreviatoryString(string, n, font, 0);
    }

    public static String getAbbreviatoryString(String string, int n, Font font, int n2) {
        return LineWrapper.getAbbreviatoryString(string, n, font, n2);
    }

    public static String getLineWrapString(String string, int n, Font font) {
        return ScreenToolKit.getLineWrapString(string, n, font, false);
    }

    public static String getLineWrapString(String string, int n, Font font, boolean bl) {
        return LineWrapper.getLineWrapString(string, n, font, bl);
    }

    public static String getLineWrapString(String string) {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
        Font font = graphics2D.getFont();
        return ScreenToolKit.getLineWrapString(string, n, font);
    }

    public static void setSystemBusy(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenToolKit.setSystemBusyEx(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenToolKit.setSystemBusyEx(bl);
                }
            });
        }
    }

    private static synchronized void setSystemBusyEx(boolean bl) {
        logger.debug("isBusy = " + bl);
        if (!bl && lockCounts > 0) {
            --lockCounts;
        }
        if (lockCounts == 0) {
            Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0);
            JFrame jFrame = FrameworkUtilities.getMainFrame();
            if (jFrame != null) {
                jFrame.getGlassPane().setVisible(bl);
                jFrame.getGlassPane().setCursor(cursor);
                if (bl) {
                    jFrame.getGlassPane().addMouseListener(glassMouseListener);
                } else {
                    jFrame.getGlassPane().removeMouseListener(glassMouseListener);
                }
            } else {
                logger.debug("mainFrame is null.");
                return;
            }
            if (jFrame instanceof MDIFrame) {
                JInternalFrame[] jInternalFrameArray = FrameworkUtilities.getWindowManager().getDesktopPane().getAllFrames();
                for (int i = 0; i < jInternalFrameArray.length; ++i) {
                    jInternalFrameArray[i].setCursor(cursor);
                }
            } else {
                jFrame.setCursor(cursor);
            }
        }
        if (bl) {
            ++lockCounts;
        }
    }

    public static void setSavePositionEnable(boolean bl) {
        isSavePositionEnable = bl;
        ScreenToolKit.saveDialogConfig(bl);
    }

    private static void saveDialogConfig(boolean bl) {
        Serializable serializable;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(LOCATION_FILE_NAME);
        DescContainer descContainer = null;
        if (null == commStyleInfo) {
            commStyleInfo = new CommStyleInfo();
            serializable = new AreaDescContainer();
            descContainer = new DescContainer(DIALOG_LOCATION);
            PARA pARA = new PARA();
            pARA.setName(ISPERSISTDIALOG);
            descContainer.addParasItem(pARA);
            ((AreaDescContainer)serializable).addDescContainer(descContainer);
            commStyleInfo.setAreaDescContainer((AreaDescContainer)serializable, true);
        }
        descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(DIALOG_LOCATION);
        descContainer.getParasItem(ISPERSISTDIALOG).setValue(Boolean.toString(bl));
        serializable = new StringBuffer(16);
        ((StringBuffer)serializable).append(DEFAULT_STYLE);
        ((StringBuffer)serializable).append(LOCATION_FILE_NAME);
        ((StringBuffer)serializable).append(STYLEFILE_EXTENSION);
        commStyleInfo.setFileName(((StringBuffer)serializable).toString());
        commStyleInfo.writeBackPersonal();
    }

    public static void restoreOldLocation(Component component) {
        Serializable serializable;
        if (null == component) {
            DebugTracer.trace(2, "ScreenToolKit", "centerLocateToScreen", "comtoLocate is null!");
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        int n = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        int n2 = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(LOCATION_FILE_NAME);
        if (null != commStyleInfo && null != (serializable = commStyleInfo.getAreaDescContainer(0).getDescContainer(DIALOG_LOCATION))) {
            isSavePositionEnable = Boolean.parseBoolean(((DescContainer)serializable).getParasItemValue(ISPERSISTDIALOG));
            String string = ((DescContainer)serializable).getParasItemValue(HORIZONTAL_OFFSET);
            if (isSavePositionEnable && null != string) {
                n = (int)(Double.parseDouble(string) * dimension.getWidth());
                n2 = (int)(Double.parseDouble(((DescContainer)serializable).getParasItemValue(VERTICAL_OFFSET)) * dimension.getHeight());
            }
        }
        serializable = new Point();
        ((Point)serializable).x = n;
        ((Point)serializable).y = n2;
        component.setLocation((Point)serializable);
    }

    public static void saveDialogLocation(Component component) {
        Serializable serializable;
        if (!isSavePositionEnable) {
            DebugTracer.trace(2, "ScreenToolKit", "centerLocateToScreen", "Save dialog location is not enabled");
            return;
        }
        if (null == component) {
            DebugTracer.trace(2, "ScreenToolKit", "centerLocateToScreen", "comtoLocate is null!");
            return;
        }
        String string = LOCATION_FILE_NAME;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(DIALOG_LOCATION);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = (double)component.getX() / dimension.getWidth();
        double d2 = (double)component.getY() / dimension.getHeight();
        if (null == descContainer.getParasItem(HORIZONTAL_OFFSET)) {
            serializable = new PARA();
            ((PARA)serializable).setName(HORIZONTAL_OFFSET);
            PARA pARA = new PARA();
            pARA.setName(VERTICAL_OFFSET);
            descContainer.addParasItem((PARA)serializable);
            descContainer.addParasItem(pARA);
        }
        descContainer.setParasItem(HORIZONTAL_OFFSET, String.valueOf(d));
        descContainer.setParasItem(VERTICAL_OFFSET, String.valueOf(d2));
        serializable = new StringBuffer(16);
        ((StringBuffer)serializable).append(DEFAULT_STYLE);
        ((StringBuffer)serializable).append(string);
        ((StringBuffer)serializable).append(STYLEFILE_EXTENSION);
        commStyleInfo.writeBackPersonal();
    }

    public static void centerLocateToScreen(Component component) {
        if (component == null) {
            logger.warn("comtoLocate is null!");
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point();
        point.x = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        point.y = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        component.setLocation(point);
    }

    public static void adjustToScreen(Container container) {
        if (container == null) {
            logger.warn("comtoSize is null!");
            return;
        }
        int n = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
        container.setSize(n, n2 - 30);
        container.setLocation(0, 0);
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = null;
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        jPopupMenu.pack();
        jPopupMenu.validate();
        dimension = jPopupMenu.getSize();
        n3 = dimension.width;
        n4 = dimension.height;
        if (n3 == 0 || n4 == 0) {
            dimension = jPopupMenu.getPreferredSize();
            n3 = dimension.width;
            n4 = dimension.height;
        }
        Component component = mouseEvent.getComponent();
        Point point = component.getLocationOnScreen();
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        Point point2 = component2.getLocationOnScreen();
        Dimension dimension2 = component2.getSize();
        Insets insets = null;
        if (jPopupMenu.isBorderPainted()) {
            insets = jPopupMenu.getBorder().getBorderInsets(jPopupMenu);
        }
        Insets insets2 = ((Container)component2).getInsets();
        int n5 = 1;
        int n6 = (insets == null ? 0 : insets.bottom) + insets2.bottom + n5;
        int n7 = (insets == null ? 0 : insets.right) + insets2.right + n5;
        if (point.y + n2 + n4 + n6 > point2.y + dimension2.height) {
            n2 = point2.y + dimension2.height - n4 - n6 - point.y;
        }
        if (point.x + n + n3 + n7 > point2.x + dimension2.width) {
            n = point2.x + dimension2.width - n3 - n7 - point.x;
        }
        jPopupMenu.show(mouseEvent.getComponent(), n, n2);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent, Point point) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = null;
        n = point.x;
        n2 = point.y;
        jPopupMenu.pack();
        jPopupMenu.validate();
        dimension = jPopupMenu.getSize();
        n3 = dimension.width;
        n4 = dimension.height;
        if (n3 == 0 || n4 == 0) {
            dimension = jPopupMenu.getPreferredSize();
            n3 = dimension.width;
            n4 = dimension.height;
        }
        Component component = mouseEvent.getComponent();
        while (component.getParent() != null) {
            component = component.getParent();
        }
        Point point2 = component.getLocationOnScreen();
        Dimension dimension2 = component.getSize();
        Insets insets = null;
        if (jPopupMenu.isBorderPainted()) {
            insets = jPopupMenu.getBorder().getBorderInsets(jPopupMenu);
        }
        Insets insets2 = ((Container)component).getInsets();
        int n5 = 1;
        int n6 = (insets == null ? 0 : insets.bottom) + insets2.bottom + n5;
        int n7 = (insets == null ? 0 : insets.right) + insets2.right + n5;
        if (n2 + n4 + n6 > point2.y + dimension2.height) {
            n2 = point2.y + dimension2.height - n4 - n6;
        }
        if (n + n3 + n7 > point2.x + dimension2.width) {
            n = point2.x + dimension2.width - n3 - n7;
        }
        jPopupMenu.show(mouseEvent.getComponent(), n, n2);
    }

    public static Point getPopupMenuShowupPosition(Component component, JPopupMenu jPopupMenu, int n, int n2) {
        int n3 = (int)component.getLocationOnScreen().getX() + n;
        int n4 = (int)component.getLocationOnScreen().getY() + n2;
        int n5 = (int)component.getLocationOnScreen().getY();
        int n6 = (int)jPopupMenu.getPreferredSize().getWidth();
        int n7 = (int)jPopupMenu.getPreferredSize().getHeight();
        if (n3 + n6 > ScreenToolKit.getScreenWidth()) {
            n -= n6;
        }
        if (n4 + n7 > ScreenToolKit.getScreenHeight() - 30 && 30 > (n2 -= n7) + n5) {
            n2 = 30 - n5;
        }
        return new Point(n, n2);
    }

    public static void setComponentCursorBusy(final RootPaneContainer rootPaneContainer, final boolean bl) {
        if (rootPaneContainer == null) {
            logger.warn("The RootPaneContainer is null, the call of setComponentCursorBusy is ignored.");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenToolKit.setComponentCursorBusyEx(rootPaneContainer, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenToolKit.setComponentCursorBusyEx(rootPaneContainer, bl);
                }
            });
        }
    }

    private static void setComponentCursorBusyEx(RootPaneContainer rootPaneContainer, boolean bl) {
        if (bl) {
            rootPaneContainer.getGlassPane().setVisible(true);
            rootPaneContainer.getGlassPane().addMouseListener(glassMouseListener);
            rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            rootPaneContainer.getGlassPane().setVisible(false);
            rootPaneContainer.getGlassPane().removeMouseListener(glassMouseListener);
            rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void setComponentCursorBusy(JComponent jComponent, boolean bl) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)jComponent.getRootPane().getParent());
        ScreenToolKit.setComponentCursorBusy(rootPaneContainer, bl);
    }

    public static void setPreferredSizeofButtons(JButton[] jButtonArray, int n) {
        int n2;
        if (jButtonArray == null || jButtonArray.length == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            n4 = jButtonArray[n2].getPreferredSize().width;
            n3 = n3 > n4 ? n3 : n4;
        }
        n3 = n3 > 80 ? n3 : 80;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            jButtonArray[n2].setPreferredSize(new Dimension(n3, n));
        }
    }

    public static void setMaxSizeofButtons(JButton[] jButtonArray, int n) {
        int n2;
        if (jButtonArray == null || jButtonArray.length == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            n4 = jButtonArray[n2].getPreferredSize().width;
            n3 = n3 > n4 ? n3 : n4;
        }
        n3 = n3 <= 80 ? n3 : 80;
        for (n2 = jButtonArray.length - 1; n2 >= 0; --n2) {
            jButtonArray[n2].setPreferredSize(new Dimension(n3, n));
        }
    }

    public static void setDefaultButtons(AbstractButton abstractButton, AbstractButton abstractButton2) {
        ScreenUIToolKit.setDefaultButtons(abstractButton, abstractButton2);
    }

    public static void setDefaultButtons(JComponent jComponent, AbstractButton abstractButton, AbstractButton abstractButton2) {
        ScreenUIToolKit.setDefaultButtons(jComponent, abstractButton, abstractButton2);
    }

    public static void setDefaultButtons(JComponent[] jComponentArray, AbstractButton abstractButton, AbstractButton abstractButton2) {
        ScreenUIToolKit.setDefaultButtons(jComponentArray, abstractButton, abstractButton2);
    }

    public static void setKyeMap(AbstractButton abstractButton, int n, char c) {
        InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
        if (inputMap == null || !(inputMap instanceof ComponentInputMapUIResource)) {
            inputMap = new ComponentInputMapUIResource(abstractButton);
            SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap);
        }
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(c, n, false), "pressed");
        inputMap.put(KeyStroke.getKeyStroke(c, n, true), "released");
        inputMap.put(KeyStroke.getKeyStroke(c, 0, true), "released");
    }

    public static void setIViewStyleMnemonic(AbstractButton abstractButton, char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        abstractButton.setMnemonic(n2);
    }

    public static synchronized void showFullScreen(JFrame jFrame, JInternalFrame jInternalFrame) {
        if (ScreenToolKit.getFullScreenFlg()) {
            logger.debug("It's already full screen. Just return here.");
            return;
        }
        if (jFrame == null || jInternalFrame == null) {
            logger.debug("Parameters is null");
            return;
        }
        srcFrameState = jFrame.getExtendedState();
        if (null == fullScreenFrame) {
            fullScreenFrame = new MDIFrame("");
            fullScreenFrame.jbInit();
            fullScreenFrame.setUndecorated(true);
            fullScreenFrame.setResizable(false);
        }
        fullScreenFrame.setIconImage(jFrame.getIconImage());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(m_oKeyProcessor);
        ScreenToolKit.addListenersOnFullScreen(jFrame);
        lockedWhenFullScreen = false;
        FrameworkUtilities.setMainFrame(fullScreenFrame);
        FrameworkUtilities.getMenuManager().broadcastEvent(new InternalLocalMsg(203));
        ScreenToolKit.initialize(jFrame, jInternalFrame);
        showVisibleWindowsList.clear();
        allChildWindowsList.clear();
        ScreenToolKit.hideOwnedVisibleWindows(srcMainFrame);
        isMaximum = jInternalFrame.isMaximum();
        ScreenToolKit.storeFocusOwner(fullScreenFrame, jInternalFrame);
        ScreenToolKit.updateTitleOnFullScreen((MDIFrame)jFrame, fullScreenFrame);
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            HelpManager.getInstance().enableHelpKey(fullScreenFrame, "topics_welcome_p_portal");
            HelpManager.getInstance().enableHelpKey(fullScreenFrame.getRootPane(), "topics_welcome_p_portal");
        } else {
            HelpManager.getInstance().enableHelpKey(fullScreenFrame, "topics_welcome_p_welcome");
            HelpManager.getInstance().enableHelpKey(fullScreenFrame.getRootPane(), "topics_welcome_p_welcome");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenToolKit.initFullScreenAndShow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenToolKit.initFullScreenAndShow();
                }
            });
        }
        if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenToolKit.glassPane = new GlassPane(fullScreenFrame);
                    if (!FrameworkUtilities.getTerminalManager().isFullScrnPasswdDialogShow()) {
                        glassPane.activate();
                    }
                }
            });
        }
    }

    public static boolean isLockedWhenFullScreen() {
        return lockedWhenFullScreen;
    }

    private static void addListenersOnFullScreen(JFrame jFrame) {
        for (PropertyChangeListener propertyChangeListener : jFrame.getPropertyChangeListeners()) {
            fullScreenFrame.addPropertyChangeListener(propertyChangeListener);
            fsPropertyChangeListener.add(propertyChangeListener);
        }
        EventListener[] eventListenerArray = (WindowListener[])jFrame.getListeners(WindowListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            fullScreenFrame.addWindowListener((WindowListener)eventListenerArray[i]);
            fsWindowListener.add((WindowListener)eventListenerArray[i]);
        }
        KeyListener[] keyListenerArray = (KeyListener[])jFrame.getListeners(KeyListener.class);
        for (int i = 0; i < keyListenerArray.length; ++i) {
            fullScreenFrame.addKeyListener(keyListenerArray[i]);
            fsKeyListener.add(keyListenerArray[i]);
        }
        FocusListener[] focusListenerArray = (FocusListener[])jFrame.getListeners(FocusListener.class);
        for (int i = 0; i < focusListenerArray.length; ++i) {
            fullScreenFrame.addFocusListener(focusListenerArray[i]);
            fsFocusListener.add(focusListenerArray[i]);
        }
    }

    private static void removeListenersOnFullScreen() {
        if (null != fullScreenFrame) {
            for (PropertyChangeListener eventListener : fsPropertyChangeListener) {
                fullScreenFrame.removePropertyChangeListener(eventListener);
            }
            fsPropertyChangeListener.clear();
            for (WindowListener windowListener : fsWindowListener) {
                fullScreenFrame.removeWindowListener(windowListener);
            }
            fsWindowListener.clear();
            for (KeyListener keyListener : fsKeyListener) {
                fullScreenFrame.removeKeyListener(keyListener);
            }
            fsKeyListener.clear();
            for (FocusListener focusListener : fsFocusListener) {
                fullScreenFrame.removeFocusListener(focusListener);
            }
            fsFocusListener.clear();
        }
    }

    public static void cleanupFullScreenOnExit() {
        if (null != fullScreenFrame) {
            ScreenToolKit.disposeCloseFullScreenDlg();
            fullScreenFrame.cleanupWhileOSGIExit();
            desktopPane = null;
            fullScreenFrame = null;
        }
    }

    private static void initFullScreenAndShow() {
        int n;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        fullScreenFrame.setBounds(0, 0, dimension.width, dimension.height);
        fullScreenFrame.setResizable(false);
        fullScreenFrame.setDefaultCloseOperation(0);
        fullScreenFrame.setVisible(true);
        ScreenToolKit.showCloseFullScreenDialog(fullScreenFrame);
        for (n = 0; n < allChildWindowsList.size(); ++n) {
            Window window = allChildWindowsList.get(n);
            ScreenToolKit.adjustParentHierarchy(window, fullScreenFrame);
            window.setIconImages(window.getIconImages());
        }
        FrameworkUtilities.getWindowManager().getDesktopPane().updateIconifiedFrameLocation();
        n = srcMainFrame.getGlassPane().isVisible() ? 1 : 0;
        fullScreenFrame.setGlassPane(srcMainFrame.getGlassPane());
        srcMainFrame.setVisible(false);
        ScreenToolKit.setFullScreenFlg(true);
        if (n != 0) {
            FrameworkUtilities.getMainFrame().getGlassPane().setVisible(true);
        }
        ScreenToolKit.hideMenuBar();
    }

    public static synchronized void updateFullScreen(JFrame jFrame, JInternalFrame jInternalFrame) {
        if (jFrame == null || jInternalFrame == null || isClosing) {
            logger.debug("Parameters is null");
            return;
        }
        FrameworkUtilities.getMenuManager().broadcastEvent(new InternalLocalMsg(203));
        MenuBar menuBar = (MenuBar)FrameworkUtilities.getMenuManager().getMenuBar();
        ((MDIFrame)srcMainFrame).setJMenuBar(menuBar);
        ScreenToolKit.initialize(srcMainFrame, jInternalFrame);
        ScreenToolKit.storeFocusOwner(fullScreenFrame, jInternalFrame);
        ScreenToolKit.hideMenuBar();
    }

    private static void initialize(JFrame jFrame, JInternalFrame jInternalFrame) {
        srcMainFrame = jFrame;
        srcInternalFrame = jInternalFrame;
    }

    private static void storeFocusOwner(JFrame jFrame, JInternalFrame jInternalFrame) {
        if (null == desktopPane) {
            desktopPane = FrameworkUtilities.getWindowManager().getDesktopPane();
        }
        InternalFrame internalFrame = (InternalFrame)jInternalFrame;
        while (internalFrame instanceof InternalDialog && ((InternalDialog)internalFrame).getModalParent() instanceof InternalFrame) {
            internalFrame = ((InternalDialog)internalFrame).getParentInternalFrame();
        }
        if (internalFrame != null && !internalFrame.isMaximum()) {
            internalFrame.setMaximum(true);
        }
        Component component = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        try {
            Method method = JFrame.class.getDeclaredMethod("setRootPane", JRootPane.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            logger.trace(exception);
        }
        jFrame.getContentPane().add(desktopPane);
        if (null != jInternalFrame) {
            jInternalFrame.revalidate();
        }
        if (component != null) {
            Component component2 = component;
            while (component2 instanceof Container && !(component2 instanceof InternalFrame) && null != (component2 = component2.getParent())) {
            }
            if (null != component2 && component2 instanceof InternalDialog) {
                ((InternalDialog)component2).toFront(true);
            }
            component.requestFocus();
        }
    }

    public static synchronized void closeFullScreenFrame() {
        ScreenToolKit.closeFullScreenFrame(false);
    }

    public static synchronized void closeFullScreenFrame(boolean bl) {
        InternalFrame internalFrame;
        lockedWhenFullScreen = bl;
        if (!ScreenToolKit.getFullScreenFlg()) {
            logger.debug("It's not yet full screen. Just return here.");
            return;
        }
        Component component = null;
        component = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            boolean bl2 = true;
            if (FrameworkUtilities.getWindowManager().isFullScreenPasswordProtected() && !bl) {
                if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(glassPane.getKeyEventDispatcher());
                }
                component = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                WindowManager windowManager = FrameworkUtilities.getWindowManager();
                if (!windowManager.isLogout()) {
                    bl2 = FrameworkUtilities.getTerminalManager().validatePassword();
                }
            }
            if (!bl2) {
                return;
            }
        }
        isClosing = true;
        FrameworkUtilities.setMainFrame(srcMainFrame);
        ScreenToolKit.updateTitleOnFullScreen(fullScreenFrame, (MDIFrame)srcMainFrame);
        FrameworkUtilities.getMenuManager().broadcastEvent(new InternalLocalMsg(204));
        showVisibleWindowsList.clear();
        allChildWindowsList.clear();
        ScreenToolKit.hideOwnedVisibleWindows(fullScreenFrame);
        if (srcMainFrame != null) {
            int n;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(m_oKeyProcessor);
            JInternalFrame jInternalFrame = desktopPane.getSelectedFrame();
            try {
                jInternalFrame.setMaximum(isMaximum);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.trace("Error when maximizing the Internal Frame:" + propertyVetoException);
            }
            srcMainFrame.setVisible(true);
            ((MDIFrame)srcMainFrame).addDesktopPane(desktopPane);
            for (n = 0; n < allChildWindowsList.size(); ++n) {
                Window window = allChildWindowsList.get(n);
                ScreenToolKit.adjustParentHierarchy(window, srcMainFrame);
                if (showVisibleWindowsList.contains(window)) {
                    window.setVisible(true);
                }
                window.setIconImages(window.getIconImages());
            }
            if (component != null) {
                component.requestFocus();
            }
            n = srcMainFrame.getGlassPane().isVisible() ? 1 : 0;
            srcMainFrame.setGlassPane(fullScreenFrame.getGlassPane());
            if (n != 0) {
                FrameworkUtilities.getMainFrame().getGlassPane().setVisible(true);
            }
        }
        ScreenToolKit.setToolBarButtonBorderPainted("mainframe:fullscreen", false);
        ScreenToolKit.setFullScreenFlg(false);
        if (null != srcMainFrame) {
            MenuBar menuBar = (MenuBar)FrameworkUtilities.getMenuManager().getMenuBar();
            ((MDIFrame)srcMainFrame).setJMenuBar(menuBar);
            ((MDIFrame)srcMainFrame).updateMenuBarHeight();
            if (null != originalF10Action) {
                menuBar.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), originalF10Action);
            } else {
                menuBar.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), "takeFocus");
            }
            srcMainFrame = null;
        }
        if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled() && null != glassPane) {
            glassPane.deactivate();
        }
        if (null != fullScreenFrame) {
            fullScreenFrame.setVisible(false);
            HelpManager.getInstance().removeHelpKey(fullScreenFrame.getRootPane());
            HelpManager.getInstance().removeHelpKey(fullScreenFrame);
            if (null != closeFullScreenDialog) {
                closeFullScreenDialog.setVisible(false);
            }
        }
        FrameworkUtilities.getWindowManager().getDesktopPane().updateIconifiedFrameLocation();
        isClosing = false;
        ScreenToolKit.removeListenersOnFullScreen();
        ScreenToolKit.showAndHideTempDlg();
        if (6 == srcFrameState) {
            FrameworkUtilities.getMainFrame().setExtendedState(srcFrameState);
        }
        if (FrameworkCommandProcessor.getInstance().isAppStyle() && null != (internalFrame = (InternalFrame)desktopPane.getSelectedFrame())) {
            ApplicationLauncher.getAppLauncher().updateMDIFrame(internalFrame.getAppID());
        }
    }

    private static void showAndHideTempDlg() {
        JDialog jDialog = new JDialog(FrameworkUtilities.getMainFrame());
        jDialog.setName("Temp_Dialog_DTS2011080502191");
        jDialog.setVisible(true);
        jDialog.setVisible(false);
        jDialog.dispose();
    }

    private static void hideMenuBar() {
        MenuBar menuBar = (MenuBar)FrameworkUtilities.getMenuManager().getMenuBar();
        if (menuBar == null) {
            return;
        }
        menuBar.setPreferredSize(new Dimension(0, 0));
        fullScreenFrame.add(menuBar);
        if (null == originalF10Action) {
            originalF10Action = (String)menuBar.getInputMap(2).get(KeyStroke.getKeyStroke("F10"));
        }
        menuBar.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), "none");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                fullScreenFrame.repaint();
            }
        });
    }

    public static void setToolBarButtonBorderPainted(String string, boolean bl) {
        ArrayList arrayList = CommandManager.getInstance().getAbstractButton(string);
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!(arrayList.get(i) instanceof ToolBarButton)) continue;
                ToolBarButton toolBarButton = (ToolBarButton)arrayList.get(i);
                toolBarButton.setBorderPainted(bl);
                break;
            }
        }
    }

    private static void setFullScreenFlg(boolean bl) {
        fullScreenFlg = bl;
    }

    public static boolean getFullScreenFlg() {
        return fullScreenFlg;
    }

    public static JInternalFrame getSrcChildFrame() {
        return srcInternalFrame;
    }

    private static void showCloseFullScreenDialog(JFrame jFrame) {
        try {
            if (closeFullScreenDialog == null) {
                closeFullScreenDialog = new CloseFullScreenDialog(jFrame);
            }
            closeFullScreenDialog.pack();
            closeFullScreenDialog.setLocation(CloseFullScreenDialog.INIT_POSITION_X, CloseFullScreenDialog.INIT_POSITION_Y);
            closeFullScreenDialog.setVisible(true);
            closeFullScreenDialog.toFront();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static void disposeCloseFullScreenDlg() {
        if (closeFullScreenDialog != null) {
            closeFullScreenDialog.dispose();
            closeFullScreenDialog = null;
        }
    }

    public static void setSplitDirection(JSplitPane jSplitPane, boolean bl) {
        jSplitPane.firePropertyChange("init state changed", !bl, bl);
    }

    public static GlassPane getGlassPane() {
        return glassPane;
    }

    private static void hideOwnedVisibleWindows(JFrame jFrame) {
        Window[] windowArray = jFrame.getOwnedWindows();
        if (windowArray == null || windowArray.length == 0) {
            return;
        }
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] == null || allChildWindowsList.contains(windowArray[i]) || !(windowArray[i] instanceof Dialog) && (!(windowArray[i] instanceof JWindow) || !windowArray[i].isVisible()) || windowArray[i] instanceof CloseFullScreenDialog) continue;
            if (windowArray[i].isVisible()) {
                showVisibleWindowsList.add(windowArray[i]);
            }
            if (!windowArray[i].isVisible() && !windowArray[i].isDisplayable()) continue;
            allChildWindowsList.add(windowArray[i]);
        }
    }

    private static void adjustParentHierarchy(Window window, Frame frame) {
        try {
            Window window2 = (Window)window.getParent();
            Field field = Window.class.getDeclaredField("weakThis");
            field.setAccessible(true);
            if (null != window2) {
                Object object;
                ComponentPeer componentPeer = window.getPeer();
                if (null != componentPeer && componentPeer.isReparentSupported()) {
                    if (window instanceof Dialog) {
                        object = (Dialog)window;
                        if (!((Dialog)object).isModal()) {
                            componentPeer.reparent((ContainerPeer)frame.getPeer());
                        }
                    } else if (window instanceof JWindow) {
                        componentPeer.reparent((ContainerPeer)frame.getPeer());
                    }
                }
                object = Window.class.getDeclaredMethod("removeOwnedWindow", WeakReference.class);
                ((Method)object).setAccessible(true);
                Object object2 = field.get(window);
                ((Method)object).invoke((Object)window2, object2);
                Method method = Window.class.getDeclaredMethod("ownedInit", Window.class);
                method.setAccessible(true);
                method.invoke((Object)window, frame);
                window.toFront();
            }
        }
        catch (Exception exception) {
            logger.trace("Exception while setting parent : " + exception);
        }
    }

    public static JFrame getFullFrame() {
        return fullScreenFrame;
    }

    public static JDialog getCloseFullScreenDialog() {
        return closeFullScreenDialog;
    }

    public static BufferedImage resizeImage(Image image, int n, int n2, float f) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src.derive(f));
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Window getContainingWindow(Component component) {
        if (null != component) {
            Container container;
            for (container = component.getParent(); null != container && !(container instanceof Window); container = container.getParent()) {
            }
            if (null != container) {
                return (Window)container;
            }
        }
        return null;
    }

    public static JFrame getMDIFrame() {
        return srcMainFrame;
    }

    private static void updateTitleOnFullScreen(MDIFrame mDIFrame, MDIFrame mDIFrame2) {
        mDIFrame2.setBaseTitle(mDIFrame.getBasetitle());
        mDIFrame2.setExtendtitle(mDIFrame.getExtendtitle());
        mDIFrame2.setIViewTitle(mDIFrame.getPrefixTitle(), true);
        mDIFrame2.setIViewTitle(mDIFrame.getSuffixTitle(), false);
        mDIFrame2.setMDITitle(mDIFrame.getMDITitle());
        mDIFrame2.setTitle(mDIFrame.getTitle());
    }

    private static class CloseFullScreenDialog
    extends JDialog {
        static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
        private static final Color COLOR_DIALOG_BACK = new Color(238, 239, 246);
        private static final Color COLOR_CAPTION_BACK = new Color(122, 121, 153);
        private static final Color COLOR_BUTTON_BACK = new Color(238, 239, 246);
        private static final Color COLOR_CAPTION_TEXT = Color.white;
        private static final Color COLOR_OUTER_BORDER = new Color(122, 121, 153);
        private static final Color COLOR_INNER_BORDER = new Color(219, 218, 228);
        private static final int DIALOG_HEIGHT = 45;
        private static final int DIALOG_WIDTH = 110;
        private static final int BORDER_SIZE_OUTER = 2;
        private static final int BORDER_SIZE_INNER = 1;
        private static final int CAPTION_WIDTH = 104;
        private static final int CAPTION_HEIGHT = 17;
        JPanel contentPanel = null;
        JPanel titlePanel = null;
        JLabel titleLabel = null;
        JButton closeButton = null;
        private static final String MOUSE_HOVER = "hover";
        private static final String MOUSE_PRESSED = "pressed";
        private static final String MOUSE_NORMAL = "normal";
        private Border darkBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, COLOR_OUTER_BORDER);
        private Border lightBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, COLOR_INNER_BORDER);
        private boolean pressed = false;
        static final int INIT_POSITION_X = ScreenToolKit.getScreenWidth() * 3 / 4;
        static final int INIT_POSITION_Y = ScreenToolKit.getScreenHeight() * 3 / 4;

        CloseFullScreenDialog(JFrame jFrame) {
            super((Frame)jFrame, false);
            this.initGUI();
            this.initListenners();
        }

        private void initGUI() {
            this.setUndecorated(true);
            this.setFocusableWindowState(false);
            this.getRootPane().setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, COLOR_OUTER_BORDER));
            this.getRootPane().setBackground(COLOR_DIALOG_BACK);
            this.setBounds(INIT_POSITION_X, INIT_POSITION_Y, 110, 45);
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.getRootPane().setLayout(new BorderLayout());
            this.getRootPane().add(this.contentPanel);
            this.contentPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, COLOR_INNER_BORDER));
            this.titlePanel = new JPanel();
            this.titleLabel = new JLabel(res.getString("Close_Full_Screen_Title"));
            this.titleLabel.setOpaque(false);
            this.titleLabel.setForeground(COLOR_CAPTION_TEXT);
            this.titlePanel.setLayout(new BorderLayout());
            this.titlePanel.add((Component)this.titleLabel, "West");
            this.titleLabel.setVerticalAlignment(0);
            this.titleLabel.setHorizontalAlignment(10);
            this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.titlePanel.setBackground(COLOR_CAPTION_BACK);
            this.titlePanel.setPreferredSize(new Dimension(104, 17));
            this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, COLOR_INNER_BORDER));
            this.contentPanel.add((Component)this.titlePanel, "North");
            this.closeButton = new JButton(res.getString("Close_Full_Screen_Button"));
            this.closeButton.setHorizontalAlignment(2);
            this.closeButton.setUI(new BasicButtonUI());
            this.closeButton.setMnemonic('C');
            this.closeButton.setFocusable(false);
            this.closeButton.setOpaque(true);
            this.setStatus(MOUSE_NORMAL);
            this.contentPanel.add((Component)this.closeButton, "Center");
        }

        private void setStatus(String string) {
            if (MOUSE_NORMAL.equals(string)) {
                this.closeButton.setBorder(this.lightBorder);
                this.closeButton.setBackground(COLOR_BUTTON_BACK);
            }
            if (MOUSE_HOVER.equals(string)) {
                this.closeButton.setBorder(this.darkBorder);
                this.closeButton.setBackground(COLOR_BUTTON_BACK.brighter());
            }
            if (MOUSE_PRESSED.equals(string)) {
                this.closeButton.setBorder(this.darkBorder);
                this.closeButton.setBackground(COLOR_BUTTON_BACK.darker());
            }
        }

        private void initListenners() {
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScreenToolKit.closeFullScreenFrame();
                }
            });
            this.closeButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    CloseFullScreenDialog.this.pressed = true;
                    CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_PRESSED);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    CloseFullScreenDialog.this.pressed = false;
                    CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_NORMAL);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (CloseFullScreenDialog.this.pressed) {
                        CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_PRESSED);
                    } else {
                        CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_HOVER);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (CloseFullScreenDialog.this.pressed) {
                        CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_HOVER);
                    } else {
                        CloseFullScreenDialog.this.setStatus(CloseFullScreenDialog.MOUSE_NORMAL);
                    }
                }
            });
            final Point point = new Point();
            this.titlePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        point.x = mouseEvent.getX();
                        point.y = mouseEvent.getY();
                        CloseFullScreenDialog.this.titlePanel.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        CloseFullScreenDialog.this.titlePanel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
            this.titlePanel.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        Point point2 = closeFullScreenDialog.getLocation();
                        closeFullScreenDialog.setLocation(point2.x + mouseEvent.getX() - point.x, point2.y + mouseEvent.getY() - point.y);
                    }
                }
            });
        }

        @Override
        public void dispose() {
            this.pressed = false;
            this.setStatus(MOUSE_NORMAL);
            super.dispose();
        }
    }
}

