/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.CheckDiskSpaceInterface;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SaveFolderChooser
extends FileChooser {
    private static IviewLogger logger = IviewLogger.getLogger(SaveFolderChooser.class, "IVIEW");
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 300;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private CheckDiskSpaceInterface checkDiskSpace = null;
    private String approveText = null;
    private boolean isDirectoryFieldEditable = false;
    private static final int FILE_TYPE_LABEL = 0;
    private static final int FILE_PATH_FIELD = 1;
    private static final int FILE_PATH_LABEL = 2;
    private static final int CANCEL_BUTOTN = 3;
    private static final int SELECT_BUTON = 4;
    boolean isInit = false;

    public SaveFolderChooser() {
        this.init();
    }

    public SaveFolderChooser(String string) {
        super(string);
        this.init();
    }

    public SaveFolderChooser(String string, CheckDiskSpaceInterface checkDiskSpaceInterface) {
        super(string);
        this.checkDiskSpace = checkDiskSpaceInterface;
        this.init();
    }

    private void init() {
        try {
            JButton jButton;
            this.isInit = true;
            JLabel jLabel = (JLabel)this.getComponent(this, 0);
            if (jLabel != null) {
                jLabel.getParent().setVisible(false);
            }
            JLabel jLabel2 = (JLabel)this.getComponent(this, 2);
            JTextField jTextField = (JTextField)this.getComponent(this, 1);
            if (jTextField != null) {
                jTextField.setName("saveFolderchooser_fileseletionFiled");
                jTextField.setEditable(this.isDirectoryFieldEditable);
            }
            if ((jButton = (JButton)this.getComponent(this, 3)) != null) {
                jButton.setName("saveFolderChooser_cancelbutton");
                jButton.setToolTipText(res.getString("CancelTip"));
                jButton.setText(res.getString("Cancel1"));
            }
            this.setDialogTitle(res.getString("TitleText"));
            JButton jButton2 = (JButton)this.getComponent(this, 4);
            if (null != jButton2) {
                jButton2.setName("saveFolderChooser_selectbtn");
                jButton2.setText(res.getString("ApproveText"));
                jButton2.setToolTipText(res.getString("ApproveTip"));
            }
            this.setFileSelectionMode(1);
            if (jLabel2 != null) {
                jLabel2.setText(res.getString("DirName"));
            }
            this.setPreferredSize(new Dimension(500, 300));
            this.setApproveButtonText(res.getString("ApproveText"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean isEqual(Component component, int n) {
        Locale locale = Locale.getDefault();
        switch (n) {
            case 3: {
                if (component instanceof JButton) {
                    String string = ((JButton)component).getText();
                    return string != null && (string.equals(UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale)) || string.equals(UIManager.getString((Object)"FileChooser.openDialogTitleText", locale)));
                }
                return false;
            }
            case 4: {
                if (component instanceof JButton) {
                    String string = ((JButton)component).getText();
                    return string != null && ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.cancelButtonText", locale));
                }
                return false;
            }
            case 1: {
                return component instanceof JTextField;
            }
            case 0: {
                if (component instanceof JLabel) {
                    String string = ((JLabel)component).getText();
                    return string != null && ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale));
                }
                return false;
            }
            case 2: {
                if (component instanceof JLabel) {
                    String string = ((JLabel)component).getText();
                    return string != null && ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.fileNameLabelText", locale));
                }
                return false;
            }
        }
        return false;
    }

    private Component getComponent(Component component, int n) {
        if (this.isEqual(component, n)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            Component component2 = null;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                component2 = this.getComponent(container.getComponent(i), n);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    public void setCheckDiskSpace(CheckDiskSpaceInterface checkDiskSpaceInterface) {
        this.checkDiskSpace = checkDiskSpaceInterface;
    }

    @Override
    public void approveSelection() {
        File file = null;
        try {
            file = File.createTempFile("myprefix", "mysuffix", new File(this.getSelectFilePath()));
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = OptionPane.separateStringWith(res.getString("SAVE_EXIT"), "\n");
            OptionPane.showErrorDialog(this, stringBuffer);
            return;
        }
        try {
            if (null != file && file.exists()) {
                file.delete();
            }
        }
        catch (SecurityException securityException) {
            logger.trace("file Deletion failed");
        }
        if (this.checkDiskSpace == null) {
            super.approveSelection();
            return;
        }
        boolean bl = this.checkDiskSpace.isDiskSpaceSufficient(this.getSelectFilePath());
        if (bl) {
            super.approveSelection();
        } else {
            String string = this.checkDiskSpace.getDiskSpaceINSufficientMsg();
            OptionPane.showWarningDialog(this, string == null ? res.getString("insufficientSpace") : string);
        }
    }

    public void setDirectoryFieldEditable(boolean bl) {
        this.isDirectoryFieldEditable = bl;
        JTextField jTextField = (JTextField)this.getComponent(this, 1);
        if (jTextField != null) {
            jTextField.setEditable(this.isDirectoryFieldEditable);
        }
    }
}

