/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.SwimapFileChooseUI;
import com.swimap.iview.templates.textfield.SaveValidCharDocument;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.AbstractFileStateChecker;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.FileLockTool;
import com.swimap.iview.util.IFileStateChecker;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.text.Document;

public class SaveFileChooser
extends FileChooser {
    private static IviewLogger logger = IviewLogger.getLogger(SaveFileChooser.class, "IVIEW");
    private static final int FILE_NAME_DEFAULT_LENGTH = 255;
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static String[] utfEncodingInfo = new String[]{res.getString("UTF-8"), res.getString("UTF8")};
    public static final HashMap<String, String> ENCODING_KEY_VALUE_MAP = new HashMap(2);
    private static String[] systemEncodingInfo = null;
    private int fileNameLength = 255;
    String invalidStr = "*\"?/|<>";
    private boolean isFileNameError = false;
    private String currentFileName = "";
    private boolean isInsert = false;
    private boolean isSelect = false;
    private JTextField inputTextFiled = null;
    private boolean isNotSetDir = false;
    private SaveValidCharDocument fileHeadDocument = null;
    private final int SAVEOROPENBTN = 0;
    private final int FILENAMETEXTFIELD = 1;
    private final int FILELIST = 2;
    private final int NEWFOLDERBTN = 3;
    private final int FILTERCOMBOBOX = 4;
    private final int CANCELBUTTON = 5;
    private boolean isCheck = false;
    private static boolean canWriteInReadOnly = true;
    private transient AbstractFileStateChecker checker = FileLockTool.getInstance();
    private int comboBoxIndex = 0;
    private String[] filePrefixOrPostfix = new String[]{""};
    private boolean postfixDefined = false;
    private boolean isEncodingEnabled = false;
    private static String localHistoryDir = null;
    private JButton save = null;

    public SaveFileChooser(String string, int n) {
        super(string);
        if (0 < n) {
            this.fileNameLength = n;
        }
        this.init();
        this.setFileHidingEnabled(true);
    }

    public SaveFileChooser(String string) {
        super(string);
        this.init();
        this.setFileHidingEnabled(true);
    }

    public SaveFileChooser() {
        super(FileChooser.currentDir);
        this.init();
        this.setFileHidingEnabled(true);
    }

    public SaveFileChooser(String string, boolean bl) {
        super(null != localHistoryDir ? localHistoryDir : string, true, true);
        this.init();
        this.setFileHidingEnabled(true);
    }

    public SaveFileChooser(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        this.init();
        this.setFileHidingEnabled(true);
    }

    public void setFileNameMaxLength(int n) {
        if (n <= 0 || this.fileNameLength == n) {
            return;
        }
        this.fileNameLength = n;
        Document document = this.getTextField(this).getDocument();
        if (document instanceof SaveValidCharDocument) {
            ((SaveValidCharDocument)document).setMaxLength(n);
            String string = MessageFormat.format(res.getString("Length_too_long"), String.valueOf(n));
            ((SaveValidCharDocument)document).setErrorInfo(string, res.getString("InvalidStr") + this.invalidStr, null, res.getString("MoreSlashes"));
        }
    }

    @Override
    public void setFileFilter(String[] stringArray, String[] stringArray2) {
        super.setFileFilter(stringArray, stringArray2);
    }

    private void initInputTextField() {
        Component component = this.getComponent(this, 1);
        if (component != null) {
            this.inputTextFiled = (JTextField)component;
            this.inputTextFiled.setName("SaveFileChooser_inputTextFiled");
            this.fileHeadDocument = new SaveValidCharDocument(this.fileNameLength, this.invalidStr, this);
            this.fileHeadDocument.setParentComponent(this);
            String string = MessageFormat.format(res.getString("Length_too_long"), String.valueOf(this.fileNameLength));
            this.fileHeadDocument.setErrorInfo(string, res.getString("InvalidStr") + this.invalidStr, null, res.getString("MoreSlashes"));
            this.fileHeadDocument.setCheckFileName(true);
            this.inputTextFiled.setDocument(this.fileHeadDocument);
            this.inputTextFiled.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SaveFileChooser.this.isInsert = true;
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SaveFileChooser.this.isInsert = false;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            this.inputTextFiled.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (SaveFileChooser.this.isSelect && !SaveFileChooser.this.fileHeadDocument.getOk()) {
                        SaveFileChooser.this.inputTextFiled.selectAll();
                    } else if (SaveFileChooser.this.fileHeadDocument.getOk()) {
                        SaveFileChooser.this.fileHeadDocument.setOk(false);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    SaveFileChooser.this.isSelect = false;
                }
            });
            this.inputTextFiled.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SaveFileChooser.this.determineWhetherSetDir();
                        SaveFileChooser.this.setCheck();
                    }
                }
            });
        }
    }

    private void init() {
        this.setName("SaveFileChooser");
        System.setProperty("isFileExtensionChange", "true");
        String string = System.getProperty("file.separator");
        if (null != string && string.equals("/")) {
            this.invalidStr = "*\"?|<>$";
        }
        try {
            JComboBox jComboBox;
            this.initInputTextField();
            this.initFileJList();
            this.initSaveOrOpenBtn();
            this.initNewFolderBtn(this.fileHeadDocument);
            JButton jButton = (JButton)this.getComponent(this, 5);
            if (null != jButton) {
                jButton.setName("SaveFileChooser_cancelBtn");
            }
            if (null != (jComboBox = (JComboBox)this.getComponent(this, 4))) {
                jComboBox.setName("SaveFileChooser_filterCombo");
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public JTextField getTextField(Component component) {
        if (component instanceof JTextField) {
            return (JTextField)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            JTextField jTextField = null;
            for (int i = 0; i < n; ++i) {
                jTextField = this.getTextField(container.getComponent(i));
                if (jTextField == null) continue;
                return jTextField;
            }
        }
        return null;
    }

    private Component getComponent(Component component, int n) {
        if (this.isEqual(component, n)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n2 = container.getComponentCount();
            Component component2 = null;
            for (int i = 0; i < n2; ++i) {
                component2 = this.getComponent(container.getComponent(i), n);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    private boolean isEqual(Component component, int n) {
        switch (n) {
            case 0: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && (string.equals(UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale)) || string.equals(UIManager.getString((Object)"FileChooser.openDialogTitleText", locale)));
            }
            case 1: {
                return component instanceof JTextField;
            }
            case 2: {
                return component instanceof JList;
            }
            case 3: {
                return component instanceof JButton && ((JButton)component).getIcon() != null && ((JButton)component).getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"));
            }
            case 4: {
                if (component instanceof JComboBox) {
                    ++this.comboBoxIndex;
                    if (this.comboBoxIndex == 2) {
                        this.comboBoxIndex = 0;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && string.equals(UIManager.getString((Object)"FileChooser.cancelButtonText", locale));
            }
        }
        return false;
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (file != null && (".".equals(file.getName()) || "..".equals(file.getName()) || !this.checkFileName(this.getInputTextField().getText().trim()))) {
            OptionPane.showErrorDialog(this, res.getString("FileName_Invalid"));
            this.isCheck = false;
            this.isFileNameError = true;
            this.isSelect = true;
            this.getInputTextField().requestFocus(true);
            this.isNotSetDir = false;
            return;
        }
        if (this.isNotSetDir) {
            this.isNotSetDir = false;
            return;
        }
        this.isCheck = false;
        super.setCurrentDirectory(file);
    }

    @Override
    public void setSelectedFile(File file) {
        this.currentFileName = this.getInputTextField().getText();
        this.isSelect = false;
        this.isFileNameError = false;
        File file2 = this.getCurrentDirectory();
        super.setSelectedFile(file);
        try {
            FileSystemView fileSystemView = this.getFileSystemView();
            File file3 = fileSystemView.createFileObject(this.currentFileName);
            if (!file3.isAbsolute()) {
                file3 = fileSystemView.getChild(file2, this.currentFileName);
            }
            if (file != null && file.getAbsolutePath().equals(file3.getAbsolutePath()) && file.getName().equals(file3.getName())) {
                this.getTextField(this).setText(this.currentFileName);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean checkFileName(String string) {
        if (string.indexOf("\\\\\\") >= 0) {
            return false;
        }
        if (string.length() >= 2 && string.substring(2).indexOf("\\\\") >= 0) {
            return false;
        }
        return !string.startsWith(".");
    }

    public void setValidatePath(String[] stringArray, boolean bl) {
        if (null == stringArray || 0 == stringArray.length) {
            return;
        }
        this.postfixDefined = bl;
        this.filePrefixOrPostfix = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void approveSelection() {
        Object object;
        if (this.isFileNameError) {
            this.isCheck = false;
            this.isFileNameError = false;
            return;
        }
        if (this.isCheck) {
            this.isCheck = false;
            StringBuffer stringBuffer = OptionPane.separateStringWith(res.getString("SAVE_EXIT"), "\n");
            OptionPane.showErrorDialog(this, stringBuffer);
            this.isSelect = true;
            this.getInputTextField().requestFocus(true);
            return;
        }
        String string = this.getName(this.getSelectedFile());
        FileFilter fileFilter = this.getFileFilter();
        String string2 = null;
        if (fileFilter instanceof FileChooserFilter) {
            FileChooserFilter fileChooserFilter = (FileChooserFilter)fileFilter;
            object = fileChooserFilter.getAllFilters();
            string2 = ((AbstractCollection)object).isEmpty() ? "" : (String)((LinkedList)object).get(0);
            string2 = '.' + string2;
        } else {
            string2 = "";
        }
        boolean bl = false;
        object = null;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        for (int i = 0; i < this.filePrefixOrPostfix.length && !bl; ++i) {
            int n;
            object = this.getSelectedFile().getPath();
            stringBuffer = new StringBuffer(string);
            stringBuffer2 = new StringBuffer((String)object);
            if (!stringBuffer2.toString().toLowerCase().endsWith(string2)) {
                if (this.postfixDefined) {
                    stringBuffer2.append(this.filePrefixOrPostfix[i]);
                    stringBuffer2.append(string2);
                    stringBuffer.append(this.filePrefixOrPostfix[i]);
                    stringBuffer.append(string2);
                } else {
                    int n2 = stringBuffer2.lastIndexOf(System.getProperty("file.separator")) + 1;
                    stringBuffer2.append(string2);
                    stringBuffer2.insert(n2, this.filePrefixOrPostfix[i]);
                    stringBuffer.insert(0, this.filePrefixOrPostfix[i]);
                    stringBuffer.append(string2);
                }
            } else if (this.postfixDefined) {
                if (0 == string2.length()) {
                    int n3 = -1 == string.lastIndexOf(46) ? string.length() - 1 : string.lastIndexOf(46);
                    n = -1 == stringBuffer2.lastIndexOf(".") ? stringBuffer2.length() : stringBuffer2.lastIndexOf(".");
                    stringBuffer2.insert(n, this.filePrefixOrPostfix[i]);
                    stringBuffer.insert(n3, this.filePrefixOrPostfix[i]);
                } else {
                    stringBuffer2.insert(stringBuffer2.indexOf(string2), this.filePrefixOrPostfix[i]);
                    stringBuffer.insert(stringBuffer.indexOf(string2), this.filePrefixOrPostfix[i]);
                }
            } else {
                stringBuffer2.insert(0, this.filePrefixOrPostfix[i]);
                stringBuffer.insert(0, this.filePrefixOrPostfix[i]);
            }
            File file = new File(CommonUtil.getAbsolutePath(stringBuffer2.toString()));
            if (ValidCharDocument.isValidFilename(stringBuffer.toString(), this.fileNameLength, this.invalidStr) == 2) {
                if (this.getInputTextField() != null && this.getInputTextField().getText().length() != 0 || !this.isInsert) {
                    String string3 = res.getString("LongFileName");
                    OptionPane.showErrorDialog(this, string3);
                    this.isSelect = true;
                    this.getInputTextField().requestFocus(true);
                }
                this.isInsert = false;
                return;
            }
            if (ValidCharDocument.isValidFilename(stringBuffer.toString(), this.fileNameLength, this.invalidStr) == 3 || ValidCharDocument.isValidFilename(stringBuffer.toString(), this.fileNameLength, this.invalidStr) == 4) {
                OptionPane.showErrorDialog(this, res.getString("FileName_Invalid"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            if (file.getAbsolutePath().length() > 255) {
                OptionPane.showErrorDialog(this, res.getString("LongFileName"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            if (file.getName().indexOf(":") >= 0) {
                logger.trace("The File Name is error,Because it contain \":\" ");
                StringBuffer stringBuffer3 = OptionPane.separateStringWith(res.getString("SAVE_EXIT"), "\n");
                OptionPane.showErrorDialog(this, stringBuffer3);
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            if (!canWriteInReadOnly && !this.getCurrentDirectory().canWrite()) {
                logger.trace("The currentDirectory is not writable.");
                OptionPane.showErrorDialog(this, res.getString("SAVE_EXIT"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            if (file.exists()) {
                if (file.canWrite()) {
                    n = 0;
                    if (this.checker != null) {
                        this.checker.setParentComponent(this);
                        n = this.checker.checkFileState(file.getAbsolutePath());
                    }
                    switch (n) {
                        case 0: {
                            if (this.isConfirmOverwrite(file)) {
                                bl = true;
                                break;
                            }
                            return;
                        }
                        case 1: {
                            this.isSelect = true;
                            this.getInputTextField().requestFocus(true);
                            return;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("checkFileState return value undefined: " + n);
                        }
                    }
                    continue;
                }
                OptionPane.showErrorDialog(this, res.getString("readOnly"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            FileOutputStream fileOutputStream = null;
            FileLock fileLock = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                fileLock = fileOutputStream.getChannel().lock();
                continue;
            }
            catch (Throwable throwable) {
                logger.trace(throwable.getMessage(), throwable);
                StringBuffer stringBuffer4 = OptionPane.separateStringWith(res.getString("SAVE_EXIT"), "\n");
                OptionPane.showErrorDialog(this, stringBuffer4);
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
            finally {
                if (null != fileLock) {
                    try {
                        fileLock.release();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (null != fileOutputStream) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (null != file && file.exists()) {
                    file.delete();
                }
            }
        }
        super.approveSelection(false);
        if (this.getSelectedFile().isDirectory()) {
            if (!FileChooser.isHistoryShared()) {
                localHistoryDir = this.getSelectedFile().getAbsolutePath();
            }
        } else if (!FileChooser.isHistoryShared()) {
            localHistoryDir = this.getSelectedFile().getParent();
        }
    }

    private boolean isConfirmOverwrite(File file) {
        int n = OptionPane.showExtConfirmDialog(this, res.getString("coverFile"), res.getString("confirmTitle"), 0);
        if (n == 0) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                bufferedWriter.close();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                OptionPane.showErrorDialog(this, res.getString("Save_Conflict"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return false;
            }
        } else {
            this.isSelect = true;
            this.getInputTextField().requestFocus(true);
            return false;
        }
        return true;
    }

    private JTextField getInputTextField() {
        if (this.inputTextFiled != null) {
            return this.inputTextFiled;
        }
        Component component = this.getComponent(this, 1);
        JTextField jTextField = null;
        if (component != null) {
            jTextField = (JTextField)component;
        }
        return jTextField;
    }

    private void initFileJList() {
        Component component = this.getComponent(this, 2);
        if (component != null) {
            JList jList = (JList)component;
            jList.setName("SaveFileChooser_list");
            jList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SaveFileChooser.this.determineWhetherSetDir();
                        SaveFileChooser.this.setCheck();
                    }
                }
            });
        }
    }

    public int showDialog(Component component, String string, boolean bl) {
        if (null != this.save) {
            this.save.setEnabled(bl);
            this.save.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("text".equals(propertyChangeEvent.getPropertyName())) {
                        boolean bl = ((SwimapFileChooseUI)SaveFileChooser.this.getUI()).isDirectorySelected();
                        SaveFileChooser.this.save.setEnabled(bl || SaveFileChooser.this.getTextField(SaveFileChooser.this).getText().trim().length() > 0);
                    }
                }
            });
        }
        this.inputTextFiled.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SaveFileChooser.this.save.setEnabled(SaveFileChooser.this.getTextField(SaveFileChooser.this).getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SaveFileChooser.this.save.setEnabled(SaveFileChooser.this.getTextField(SaveFileChooser.this).getText().trim().length() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        return this.showDialog(component, string);
    }

    private void initSaveOrOpenBtn() {
        this.save = (JButton)this.getComponent(this, 0);
        if (this.save != null) {
            this.save.setName("SaveFileChooser_saveOrOpenBtn");
            this.save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SaveFileChooser.this.determineWhetherSetDir();
                    SaveFileChooser.this.setCheck();
                }
            });
        }
    }

    private void initNewFolderBtn(final SaveValidCharDocument saveValidCharDocument) {
        Component component = this.getComponent(this, 3);
        if (component != null) {
            JButton jButton = (JButton)component;
            jButton.setName("SaveFileChooser_newFolderBtn");
            jButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (saveValidCharDocument != null) {
                        saveValidCharDocument.setIsClickNewFolder(true);
                    }
                }
            });
        }
    }

    private void determineWhetherSetDir() {
        try {
            Object object;
            this.isNotSetDir = false;
            String string = "";
            if (this.getUI() instanceof SwimapFileChooseUI) {
                object = (SwimapFileChooseUI)this.getUI();
                if (((SwimapFileChooseUI)object).isDirectorySelected()) {
                    return;
                }
            } else {
                return;
            }
            string = ((MetalFileChooserUI)object).getFileName();
            object = this.getCurrentDirectory();
            FileSystemView fileSystemView = this.getFileSystemView();
            File file = fileSystemView.createFileObject(string);
            if (!file.isAbsolute()) {
                file = fileSystemView.getChild((File)object, string);
            }
            if (!file.isDirectory() && !fileSystemView.isParent((File)object, file)) {
                this.isNotSetDir = true;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.isNotSetDir = false;
        }
    }

    private void setCheck() {
        try {
            this.isCheck = false;
            String string = this.getInputTextField().getText();
            if (string.endsWith("\\")) {
                this.isCheck = true;
            }
        }
        catch (Exception exception) {
            this.isCheck = false;
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static void setCanWriteInReadOnly(boolean bl) {
        canWriteInReadOnly = bl;
    }

    public static boolean getCanWriteInReadOnly() {
        return canWriteInReadOnly;
    }

    public void setFileStateChecker(IFileStateChecker iFileStateChecker) {
        if (iFileStateChecker instanceof AbstractFileStateChecker) {
            this.checker = (AbstractFileStateChecker)iFileStateChecker;
        }
    }

    @Override
    public int showSaveDialog(Component component) throws HeadlessException {
        this.selectFileFilterCombo();
        return super.showSaveDialog(component);
    }

    @Override
    public int showOpenDialog(Component component) throws HeadlessException {
        this.selectFileFilterCombo();
        return super.showOpenDialog(component);
    }

    @Override
    public int showDialog(Component component, String string) {
        this.selectFileFilterCombo();
        return super.showDialog(component, string);
    }

    private void selectFileFilterCombo() {
        JComboBox jComboBox;
        int n;
        JTextField jTextField = this.getInputTextField();
        String string = jTextField.getText();
        String string2 = "";
        if (string.length() > 0 && (n = string.lastIndexOf(46)) >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        if ((jComboBox = (JComboBox)this.getComponent(this, 4)) != null) {
            int n2;
            int n3 = -1;
            Object object = null;
            for (n2 = 0; n2 < jComboBox.getItemCount(); ++n2) {
                object = jComboBox.getItemAt(n2);
                if (object instanceof FileChooserFilter) {
                    LinkedList linkedList = ((FileChooserFilter)object).getAllFilters();
                    if (!linkedList.contains(string2)) continue;
                    n3 = n2;
                    break;
                }
                if (!this.isAcceptAllFileFilterUsed() || !object.equals(this.getAcceptAllFileFilter()) || string.length() == 0) continue;
                n3 = n2;
            }
            if (n3 == -1 && jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                n3 = jComboBox.getItemCount() - 1;
            }
            if (n3 != -1 && n3 != jComboBox.getSelectedIndex()) {
                n2 = n3;
                jComboBox.setSelectedIndex(n2);
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(string.length());
            }
        }
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        return jDialog;
    }

    public static String[] getSystemEncodingInfo() {
        return systemEncodingInfo;
    }

    public static String[] getUtfEncodingInfo() {
        return utfEncodingInfo;
    }

    public static String getSystemEncoding() {
        if (null != systemEncodingInfo && 2 == systemEncodingInfo.length) {
            return systemEncodingInfo[0];
        }
        return null;
    }

    public String getUserEncoding() {
        SwimapFileChooseUI swimapFileChooseUI;
        String string = null;
        if (this.getUI() instanceof SwimapFileChooseUI && this.isEncodingEnabled && (string = (swimapFileChooseUI = (SwimapFileChooseUI)this.getUI()).getEncodingType()) == null) {
            string = System.getProperty("file.encoding");
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof FileChooserFilter) {
                String string2 = (String)ReflectionUtilities.getFieldByObject(fileFilter, "fileType");
                if (null == string2) {
                    LinkedList linkedList = ((FileChooserFilter)fileFilter).getAllFilters();
                    String string3 = string2 = linkedList.size() > 0 ? linkedList.get(0).toString().trim() : "";
                }
                if (string2.equals("html") || string2.equals("xml")) {
                    string = "UTF-8";
                }
            }
        }
        return string;
    }

    public void setEncodingEnabled(boolean bl) {
        this.isEncodingEnabled = bl;
        this.updateUI();
        this.init();
    }

    public boolean isEncodingEnabled() {
        return this.isEncodingEnabled;
    }

    static {
        systemEncodingInfo = Os.getOs().getSystemEncoding();
        ENCODING_KEY_VALUE_MAP.put(utfEncodingInfo[0], utfEncodingInfo[1]);
        if (null != systemEncodingInfo) {
            SaveFileChooser.systemEncodingInfo[0] = systemEncodingInfo[0].contains("GBK") ? "GBK" : "ISO-8859-1";
            ENCODING_KEY_VALUE_MAP.put(systemEncodingInfo[0], systemEncodingInfo[1]);
        }
    }
}

