/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(ReflectionUtilities.class, "IVIEW");

    public static Object callTheMethod(String string, String string2, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ReflectionUtilities.callTheMethod(string, string2, classArray, objectArray);
    }

    public static Object callTheMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return object2;
    }

    public static Object callStaticMethodThrowException(String string, String string2, Class[] classArray, Object[] objectArray) throws Exception {
        Object object = null;
        Class<?> clazz = Class.forName(string);
        Method method = clazz.getMethod(string2, classArray);
        object = method.invoke(null, objectArray);
        return object;
    }

    public static Object callTheMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            object = method.invoke(constructor.newInstance(new Object[0]), objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return object;
    }

    public static Object callTheMethod(Object object, String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ReflectionUtilities.callTheMethod(object, string, classArray, objectArray);
    }

    public static Object callStaticMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            object = method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return object;
    }

    public static Object callStaticMethod(String string, String string2, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ReflectionUtilities.callStaticMethod(string, string2, classArray, objectArray);
    }

    public static Object instantiateTheClass(String string) throws Exception {
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        return ReflectionUtilities.instantiateTheClass(string, classArray, objectArray);
    }

    public static Object instantiateTheClass(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw exception;
        }
        return var3_3;
    }

    public static Object instantiateTheClass(Class clazz) throws Exception {
        Object var1_1 = null;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Constructor constructor = clazz.getConstructor(classArray);
            var1_1 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw exception;
        }
        return var1_1;
    }

    public static Object callMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object var4_4 = null;
        try {
            Method method = object.getClass().getDeclaredMethod(string, classArray);
            if (null != method) {
                method.setAccessible(true);
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugTracer.trace("Exception while invoking the method : " + illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DebugTracer.trace("Exception while invoking the method : " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DebugTracer.trace("Exception while invoking the method : " + invocationTargetException);
        }
        catch (SecurityException securityException) {
            DebugTracer.trace("Exception while invoking the method : " + securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DebugTracer.trace("Exception while invoking the method : " + noSuchMethodException);
        }
        return var4_4;
    }

    public static Object getFieldByObject(Object object, String string) {
        Field field;
        block7: {
            field = null;
            Class<?> clazz = object.getClass();
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (SecurityException securityException) {
                DebugTracer.trace("Exception while getDeclaredField the method : " + securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 == null || clazz2 == clazz) break block7;
                return ReflectionUtilities.getField(clazz2, object, string);
            }
        }
        if (null != field) {
            field.setAccessible(true);
            try {
                return field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                DebugTracer.trace("Exception while getDeclaredField the method : " + illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugTracer.trace("Exception while getDeclaredField the method : " + illegalArgumentException);
            }
        }
        return null;
    }

    private static Object getField(Class clazz, Object object, String string) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            DebugTracer.trace("Exception while getDeclaredField the method : " + securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != clazz) {
                return ReflectionUtilities.getField(clazz2, object, string);
            }
            return null;
        }
        if (null == field) {
            return null;
        }
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            DebugTracer.trace("Exception while getDeclaredField the method : " + illegalAccessException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugTracer.trace("Exception while getDeclaredField the method : " + illegalArgumentException);
            return null;
        }
    }

    public static boolean setFieldByObject(Object object, String string, Object object2) {
        Field field = null;
        Class<?> clazz = object.getClass();
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (SecurityException securityException) {
            DebugTracer.trace("Exception while getting the field : " + securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != clazz) {
                ReflectionUtilities.setField(clazz2, object, string, object2);
            }
            return false;
        }
        if (null == field) {
            return false;
        }
        field.setAccessible(true);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            DebugTracer.trace("Exception while setting the field : " + illegalAccessException);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugTracer.trace("Exception while setting the field : " + illegalArgumentException);
            return false;
        }
        return true;
    }

    public static boolean setField(Class clazz, Object object, String string, Object object2) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            DebugTracer.trace("Exception while getting the field : " + securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != clazz) {
                ReflectionUtilities.setField(clazz2, object, string, object2);
                return true;
            }
            return false;
        }
        if (null == field) {
            return false;
        }
        try {
            field.set(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            DebugTracer.trace("Exception while setting the field : " + illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugTracer.trace("Exception while setting the field : " + illegalArgumentException);
        }
        return false;
    }

    public static void callTheMethod(Object object, Class clazz, String string, Object[] objectArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, null);
            method.setAccessible(true);
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.trace(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.trace(invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            logger.trace(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.trace(noSuchMethodException);
        }
    }
}

