/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.IProcessor;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.multitaskdialog.ITaskFinish;
import com.swimap.iview.templates.multitaskdialog.ITaskInfo;
import com.swimap.iview.templates.multitaskdialog.MultiTaskProgressDialog;
import com.swimap.iview.templates.multitaskdialog.ProgressTaskMgr;
import com.swimap.iview.templates.progressdialog.IProgressFinish;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.MultipleProgressDialog;
import com.swimap.iview.templates.statusbar.BubbleStatusBarItem;
import com.swimap.iview.templates.statusbar.IModelChangeListener;
import com.swimap.iview.templates.statusbar.ProgressStatusBarItem;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public final class ProgressHandler {
    private static IviewLogger logger = IviewLogger.getLogger(ProgressHandler.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static ProgressHandler instance = null;
    private MultipleProgressDialog progressDialog = null;
    private MultiTaskProgressDialog multitaskDailog = null;
    private BubbleStatusBarItem bubble = null;
    private StatusBarManager manager = null;
    private ProgressStatusBarItem progressStatusbar = null;
    private ProgressStatusBarItem multiprogressStatusbar = null;
    private StatusBarItem notificationItem = null;
    private static final int WIDTH = 500;
    private static final int HEIGHT = 200;
    private boolean isFinished = true;
    private boolean isNeedLogout = false;
    private boolean isNeedExit = false;
    private boolean isModelChangeListenerAdded = false;
    private MouseAdapter bubblemouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ProgressTaskMgr.getInstance().showDialog();
        }
    };
    private ITaskFinish taskFinish = new ITaskFinish(){

        @Override
        public void taskFinished(final ITaskInfo iTaskInfo) {
            if (null != ProgressHandler.this.manager && null == ProgressHandler.this.bubble) {
                ProgressHandler.this.bubble = (BubbleStatusBarItem)ProgressHandler.this.manager.getStatusBarItem("Bubble");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.bubble.setEnableAutoHide(true);
                    ProgressHandler.this.bubble.setMessage(iTaskInfo.getTaskName() + " " + res.getString(iTaskInfo.getStatus().toString()));
                    ProgressHandler.this.bubble.addProgressListener(ProgressHandler.this.bubblemouseListener);
                }
            });
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (null != ProgressHandler.this.multitaskDailog && !ProgressHandler.this.multitaskDailog.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressHandler.this.hideProgressBar();
                    }
                });
                ProgressHandler.this.multitaskDailog.setVisible(true);
            }
        }
    };
    private ActionListener backgroundbtnAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgressHandler.this.isFinished = false;
            ProgressHandler.this.multitaskDailog.setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.showProgressBar();
                }
            });
        }
    };

    private ProgressHandler() {
        this.manager = FrameworkUtilities.getStatusBarManager();
        if (null != this.manager) {
            this.notificationItem = this.manager.getStatusBarItem("NotificationMessageItem");
        }
        IProcessor iProcessor = new IProcessor(){

            @Override
            public void postProcess() {
            }

            @Override
            public boolean preProcess() {
                return ProgressHandler.this.confirmCancel(false);
            }
        };
        FrameworkCommandProcessor.getInstance().setLogoutProcessor(iProcessor);
        IProcessor iProcessor2 = new IProcessor(){

            @Override
            public void postProcess() {
            }

            @Override
            public boolean preProcess() {
                return ProgressHandler.this.confirmCancel(true);
            }
        };
        FrameworkCommandProcessor.getInstance().addExitProcessor(iProcessor2);
    }

    private boolean confirmCancel(boolean bl) {
        DetailMessageDlg detailMessageDlg = null;
        if (!this.isFinished && null != this.progressDialog) {
            if (bl) {
                this.isNeedExit = true;
                detailMessageDlg = new DetailMessageDlg(this.progressDialog.getOwner(), res.getString("Progresshandler.option.title"), (Object)res.getString("Progresshandler.option.exit.msg"), 3, 1, (Object)res.getString("Progresshandler.option.exit.details"), false);
            } else {
                this.isNeedLogout = true;
                detailMessageDlg = new DetailMessageDlg(this.progressDialog.getOwner(), res.getString("Progresshandler.option.title"), (Object)res.getString("Progresshandler.option.msg"), 3, 1, (Object)res.getString("Progresshandler.option.details"), false);
            }
            detailMessageDlg.pack();
            int n = detailMessageDlg.confirmShow();
            logger.trace("User option is  = " + n);
            if (n == 0) {
                if (null != this.progressDialog) {
                    this.progressDialog.getCancelRef().doClick();
                    this.dispose();
                }
                return true;
            }
            if (null != this.progressDialog) {
                this.progressDialog.getBackgroundButton().setEnabled(false);
                this.progressDialog.getCancelRef().requestFocus();
                this.showDialog(true);
            }
            return false;
        }
        if (!this.isFinished && null != this.multiprogressStatusbar && this.multiprogressStatusbar.isVisible()) {
            if (bl) {
                this.isNeedExit = true;
                detailMessageDlg = new DetailMessageDlg(this.multitaskDailog.getOwner(), res.getString("Progresshandler.option.title"), (Object)res.getString("Progresshandler.option.exit.msg"), 3, 1, (Object)res.getString("Progresshandler.option.exit.details"), false);
            } else {
                this.isNeedLogout = true;
                detailMessageDlg = new DetailMessageDlg(this.multitaskDailog.getOwner(), res.getString("Progresshandler.option.title"), (Object)res.getString("Progresshandler.option.msg"), 3, 1, (Object)res.getString("Progresshandler.option.details"), false);
            }
            detailMessageDlg.pack();
            int n = detailMessageDlg.confirmShow();
            if (n == 0) {
                this.isNeedLogout = false;
                this.isNeedExit = false;
                this.removeTaskdialog();
                return true;
            }
            return false;
        }
        if (null != this.multitaskDailog) {
            this.removeTaskdialog();
        }
        return true;
    }

    public static ProgressHandler getInstance() {
        if (instance == null) {
            instance = new ProgressHandler();
        }
        return instance;
    }

    public void hideProgressBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.multiprogressStatusbar && this.multiprogressStatusbar.isVisible()) {
                this.multiprogressStatusbar.getProgressBar().setIndeterminate(false);
                this.multiprogressStatusbar.setVisible(false);
                this.multiprogressStatusbar.getShowButton().setVisible(false);
                this.manager.getStatusBarPanel().updateUI();
            }
            if (null != this.notificationItem) {
                this.notificationItem.setVisible(true);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.hideProgressBar();
                }
            });
        }
    }

    public void showProgressBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.manager) {
                this.notificationItem.setVisible(false);
                this.multiprogressStatusbar.getShowButton().setVisible(true);
                this.multiprogressStatusbar.getProgressBar().setIndeterminate(true);
                this.multiprogressStatusbar.setVisible(true);
                this.manager.getStatusBarPanel().updateUI();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.showProgressBar();
                }
            });
        }
    }

    public void setMultiTaskProcess(MultiTaskProgressDialog multiTaskProgressDialog) {
        if (null == multiTaskProgressDialog) {
            logger.trace("mutiltask progress Dialog is null");
            return;
        }
        this.multitaskDailog = multiTaskProgressDialog;
        this.multitaskDailog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProgressHandler.this.multitaskDailog.setVisible(false);
            }
        });
        this.multitaskDailog.addProgressFinishedListener(this.taskFinish);
        if (null != this.manager && null == this.multiprogressStatusbar) {
            this.multiprogressStatusbar = (ProgressStatusBarItem)this.manager.getStatusBarItem("MultiProgressStatusBar");
            this.multiprogressStatusbar.getProgressBar().setIndeterminate(true);
            this.multiprogressStatusbar.getShowButton().addMouseListener(this.mouseListener);
        }
        this.multitaskDailog.getBackgroudButton().addActionListener(this.backgroundbtnAction);
    }

    public void exitAfterProgressFinish() {
        this.isFinished = true;
        if (this.isNeedLogout) {
            this.isNeedLogout = false;
            this.isNeedExit = false;
            logger.trace("Logout initiated by the progress handler after background operation.");
            FrameworkCommandProcessor.getInstance().logoutDirectly();
        } else if (this.isNeedExit) {
            this.isNeedExit = false;
            this.isNeedLogout = false;
            logger.trace("Exit initiated by the progress handler after background operation.");
            Main.instance().exitTerminal();
        }
    }

    public void setProcess(Window window) {
        this.isFinished = false;
        if (null == this.progressDialog) {
            if (window instanceof JFrame || null == window) {
                this.progressDialog = new MultipleProgressDialog((JFrame)window, res.getString("Progresshandler.title.text"), res.getString("Progresshandler.message.text"));
            } else if (window instanceof JDialog) {
                this.progressDialog = new MultipleProgressDialog((JDialog)window, res.getString("Progresshandler.title.text"), res.getString("Progresshandler.message.text"));
            }
        }
        if (null != this.progressDialog) {
            this.progressDialog.setName("ProgressHandler.progressDialog");
            this.progressDialog.addProgressFinishedListener(new IProgressFinish(){

                @Override
                public void progressFinished() {
                    ProgressHandler.this.dispose();
                    if (ProgressHandler.this.isNeedLogout) {
                        ProgressHandler.this.isNeedLogout = false;
                        logger.trace("Logout initiated by the progress handler after background operation.");
                        FrameworkCommandProcessor.getInstance().logoutDirectly();
                    } else if (ProgressHandler.this.isNeedExit) {
                        ProgressHandler.this.isNeedExit = false;
                        logger.trace("Exit initiated by the progress handler after background operation.");
                        Main.instance().exitTerminal();
                    }
                }
            });
        }
        if (null == this.progressStatusbar && null != this.manager) {
            this.progressStatusbar = (ProgressStatusBarItem)this.manager.getStatusBarItem("ProgressStatusBar");
            this.progressStatusbar.getProgressBar().setIndeterminate(true);
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (null != ProgressHandler.this.progressDialog && !ProgressHandler.this.progressDialog.isVisible()) {
                        ProgressHandler.this.progressDialog.setVisible(true);
                    }
                }
            };
            this.progressStatusbar.getShowButton().addMouseListener(this.mouseListener);
        }
        this.setBackgroundAction();
    }

    public void showProgress() {
        if (null != this.progressDialog && this.progressDialog.isVisible()) {
            return;
        }
        Dimension dimension = new Dimension(500, 200);
        if (null != this.progressDialog) {
            this.progressDialog.setPreferredSize(dimension);
            this.progressDialog.setMaximumSize(dimension);
            this.progressDialog.setMinimumSize(dimension);
            this.progressDialog.setDefaultCloseOperation(2);
        }
        if (null != this.progressStatusbar && !this.isModelChangeListenerAdded) {
            this.progressStatusbar.addModelChangeListener(new IModelChangeListener(){

                @Override
                public void modelChanged() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (null != ProgressHandler.this.progressDialog) {
                                ProgressHandler.this.progressDialog.setVisible(true);
                            }
                        }
                    });
                }
            });
            this.isModelChangeListenerAdded = true;
        }
        ScreenToolKit.centerLocateToScreen(this.progressDialog);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != ProgressHandler.this.manager && !ProgressHandler.this.isFinished) {
                    ProgressHandler.this.notificationItem.setVisible(false);
                    ProgressHandler.this.progressStatusbar.getShowButton().setVisible(true);
                    ProgressHandler.this.progressStatusbar.getProgressBar().setIndeterminate(true);
                    ProgressHandler.this.progressStatusbar.setVisible(true);
                    ProgressHandler.this.manager.getStatusBarPanel().updateUI();
                }
                if (null != ProgressHandler.this.progressDialog) {
                    ProgressHandler.this.progressDialog.getBackgroundButton().requestFocus();
                    ProgressHandler.this.progressDialog.setVisible(true);
                }
            }
        });
    }

    public void addProgress(JProgressBar jProgressBar, IStop iStop) {
        if (null != this.progressDialog) {
            this.progressDialog.addProgress(jProgressBar, iStop);
        }
    }

    public void removeProgress(JProgressBar jProgressBar) {
        if (null != this.progressDialog) {
            this.progressDialog.removeProgress(jProgressBar);
        }
    }

    private void setBackgroundAction() {
        this.progressDialog.getBackgroundButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressHandler.this.progressDialog.setVisible(false);
            }
        });
    }

    private void removeTaskdialog() {
        if (null != this.multitaskDailog) {
            this.multitaskDailog.clearAllTasks();
            this.multitaskDailog.removeProgressFinishedListener(this.taskFinish);
        }
        if (null != this.multiprogressStatusbar) {
            this.multiprogressStatusbar.getProgressBar().setIndeterminate(false);
            this.multiprogressStatusbar.setVisible(false);
            this.multiprogressStatusbar.getShowButton().setVisible(false);
        }
        if (null != this.notificationItem) {
            this.notificationItem.setVisible(true);
        }
        if (null != this.bubble) {
            this.bubble.removeTipBubbleMouseListener(this.bubblemouseListener);
        }
        ProgressTaskMgr.freeInstance();
        this.multitaskDailog = null;
        this.isFinished = true;
    }

    private void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.progressDialog) {
                this.progressDialog.dispose();
            }
            this.progressDialog = null;
            if (null != this.progressStatusbar) {
                this.progressStatusbar.getProgressBar().setIndeterminate(false);
                this.progressStatusbar.setVisible(false);
                this.progressStatusbar.getShowButton().setVisible(false);
            }
            if (null != this.notificationItem) {
                this.notificationItem.setVisible(true);
            }
            this.isFinished = true;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.dispose();
                }
            });
        }
    }

    private void showDialog(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.progressDialog) {
                this.progressDialog.setVisible(bl);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressHandler.this.showDialog(bl);
                }
            });
        }
    }
}

