/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.PaneConstraints;
import com.swimap.iview.util.PaneNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class PaneLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 200L;
    int gap = 0;
    PaneNode rootNode;
    PaneNode lastSelected;
    private PaneNode lastDeleted;
    private String lastComponentAddition;
    private int plusCount = 0;

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setConstraints(Component component, PaneConstraints paneConstraints) {
        this.setComponentConstraints(component, paneConstraints);
        this.lastDeleted = null;
    }

    private boolean setComponentConstraints(Component component, PaneConstraints paneConstraints) {
        if (this.rootNode != null) {
            PaneNode paneNode = this.rootNode.getParentNode(component, null);
            if (paneNode != null) {
                paneNode.setConstraints(component, paneConstraints);
                return true;
            }
            return false;
        }
        this.rootNode = new PaneNode(paneConstraints.name, component, "Root");
        return true;
    }

    public PaneConstraints getConstraints(Component component) {
        PaneNode paneNode;
        PaneConstraints paneConstraints = null;
        if (this.rootNode != null && (paneNode = this.rootNode.getParentNode(component, null)) != null) {
            if (paneNode.childComponent == component) {
                paneConstraints = new PaneConstraints(paneNode.name, paneNode.name, "Root", 0.5f);
            } else {
                String string = paneNode.childNodeA.getNodeAComponent();
                float f = paneNode.heightDivide * paneNode.widthDivide;
                String string2 = paneNode.childNodeB.getNodeAComponent();
                if (paneNode.childNodeA.childComponent == component) {
                    string2 = paneNode.childNodeB.name;
                }
                paneConstraints = paneNode.horizontal ? (paneNode.reverse ? new PaneConstraints(string2, string, "Top", 1.0f - f) : new PaneConstraints(string2, string, "Bottom", 1.0f - f)) : (paneNode.reverse ? new PaneConstraints(string2, string, "Left", 1.0f - f) : new PaneConstraints(string2, string, "Right", 1.0f - f));
                if (string2.equals(string)) {
                    paneConstraints.position = "Root";
                }
            }
        }
        return paneConstraints;
    }

    public String toString() {
        return "PaneLayout";
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == null) {
            this.lastDeleted = null;
            return;
        }
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == component) {
                this.rootNode = null;
            } else {
                PaneNode paneNode = this.rootNode.getImmediateParent(component);
                if (paneNode != null) {
                    this.lastDeleted = paneNode.removeChild(component);
                }
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        if (this.rootNode != null) {
            Dimension dimension = this.rootNode.getPreferredSize(this.gap);
            dimension.width += insets.right + insets.left;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
        return new Dimension(10, 10);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.rootNode != null) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            this.rootNode.assertLocation(rectangle, this.gap);
        }
    }

    public String[] getAddOrder(Container container) {
        Component[] componentArray = container.getComponents();
        String[] stringArray = new String[componentArray.length];
        Point point = new Point(0, 0);
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == null) {
                this.rootNode.getComponents(point, stringArray, true);
            } else {
                stringArray[0] = this.rootNode.name;
            }
        }
        return stringArray;
    }

    void addChild(Component component, float f) {
        ++this.plusCount;
        String string = "component".concat(String.valueOf(this.plusCount));
        if (this.rootNode != null) {
            this.rootNode.addChild(string, component, "Bottom", f);
        } else {
            this.rootNode = new PaneNode(string, component, "Top");
        }
        this.lastComponentAddition = string;
    }

    public void dragDivider(int n, int n2) {
        if (this.lastSelected != null) {
            this.lastSelected.drag(n, n2);
        }
    }

    public Rectangle getDividerBounds() {
        if (this.lastSelected != null) {
            return this.lastSelected.location;
        }
        return null;
    }

    public Rectangle getDividerRect(int n, int n2) {
        if (this.rootNode != null) {
            this.lastSelected = this.rootNode.hitTest(n, n2, this.gap * 2);
        }
        if (this.lastSelected != null) {
            return this.lastSelected.getDividerRect(this.gap * 2);
        }
        return null;
    }

    void addChild(String string, String string2, String string3, Component component, float f) {
        if (this.rootNode == null) {
            this.rootNode = new PaneNode(string, component, "Top");
        } else {
            boolean bl = true;
            if (string2 == null || string2.length() == 0) {
                if (string3 != null) {
                    bl = this.rootNode.addChildSplit(string, this.lastComponentAddition, string3, component, f);
                } else {
                    this.rootNode.addChild(string, component, null, f);
                }
            } else if (!this.rootNode.addChildSplit(string, string2, string3, component, f)) {
                bl = this.rootNode.addChildSplit(string, this.lastComponentAddition, string3, component, f);
            }
            if (!bl) {
                this.rootNode.addChild(string, component, string3, f);
            }
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        PaneConstraints paneConstraints = new PaneConstraints(string, "", "", 0.5f);
        this.addLayoutComponent(component, paneConstraints);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null && component.getName() != null && component.getName().equals("SplitPanel.splitter")) {
            return;
        }
        if (object instanceof PaneConstraints) {
            if (!this.justDeleted(component, (PaneConstraints)object)) {
                Object object2;
                if (((PaneConstraints)object).name == null) {
                    ++this.plusCount;
                    object2 = "component".concat(String.valueOf(this.plusCount));
                }
                if (this.setComponentConstraints(component, (PaneConstraints)object)) {
                    this.lastDeleted = null;
                    return;
                }
                object2 = (PaneConstraints)object;
                this.addChild(((PaneConstraints)object2).name, ((PaneConstraints)object2).splitComponentName, ((PaneConstraints)object2).position, component, ((PaneConstraints)object2).proportion);
                this.lastComponentAddition = ((PaneConstraints)object2).name;
            }
        } else {
            this.addChild(component, 0.5f);
        }
        this.lastDeleted = null;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(500, 500);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    boolean justDeleted(Component component, PaneConstraints paneConstraints) {
        if (this.lastDeleted == null || paneConstraints == null) {
            return false;
        }
        if (this.lastDeleted.childComponent == component) {
            if (this.lastDeleted.childNodeA == null) {
                PaneNode paneNode = this.lastDeleted.childNodeB;
                if (paneNode == null) {
                    return false;
                }
                if (paneConstraints.splitComponentName != null && paneConstraints.splitComponentName.equals(paneNode.getNodeAComponent()) || !this.lastDeleted.name.equals(paneConstraints.name)) {
                    PaneNode paneNode2 = new PaneNode(paneNode.childNodeA, paneNode.childNodeB, "", 0.5f);
                    paneNode2.widthDivide = paneNode.widthDivide;
                    paneNode2.heightDivide = paneNode.heightDivide;
                    paneNode2.name = paneNode.name;
                    this.lastDeleted.name = paneConstraints.name;
                    paneNode2.childComponent = paneNode.childComponent;
                    if (paneNode2.childComponent != null) {
                        paneNode2.childNodeA = null;
                        paneNode2.childNodeB = null;
                    }
                    paneNode2.reverse = paneNode.reverse;
                    paneNode2.horizontal = paneNode.horizontal;
                    paneNode.childNodeB = this.lastDeleted;
                    paneNode.childNodeA = paneNode2;
                    paneNode.name = null;
                    paneNode.childComponent = null;
                    paneNode.heightDivide = this.lastDeleted.heightDivide;
                    paneNode.widthDivide = this.lastDeleted.widthDivide;
                    paneNode.horizontal = this.lastDeleted.horizontal;
                    paneNode.reverse = this.lastDeleted.reverse;
                    this.lastDeleted = null;
                    this.setConstraints(component, paneConstraints);
                    return true;
                }
            } else {
                PaneNode paneNode = this.lastDeleted.childNodeA;
                PaneNode paneNode3 = new PaneNode(paneNode.childNodeA, paneNode.childNodeB, "", 0.5f);
                paneNode3.heightDivide = paneNode.heightDivide;
                paneNode3.widthDivide = paneNode.widthDivide;
                paneNode3.name = paneNode.name;
                this.lastDeleted.name = paneConstraints.name;
                paneNode3.childComponent = paneNode.childComponent;
                if (paneNode3.childComponent != null) {
                    paneNode3.childNodeA = null;
                    paneNode3.childNodeB = null;
                }
                paneNode3.reverse = paneNode.reverse;
                paneNode3.horizontal = paneNode.horizontal;
                paneNode.childNodeA = this.lastDeleted;
                paneNode.childNodeB = paneNode3;
                paneNode.name = null;
                paneNode.childComponent = null;
                paneNode.heightDivide = this.lastDeleted.heightDivide;
                paneNode.widthDivide = this.lastDeleted.widthDivide;
                paneNode.horizontal = this.lastDeleted.horizontal;
                paneNode.reverse = this.lastDeleted.reverse;
                this.lastDeleted = null;
                this.setConstraints(component, paneConstraints);
                return true;
            }
            this.lastDeleted = null;
        }
        return false;
    }
}

