/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.DuplicationFilter;
import com.swimap.iview.util.LimitLengthDocument;
import com.swimap.iview.util.OptionPaneDialog;
import com.swimap.iview.util.ScreenUIToolKit;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.OptionPaneUI;

public class OptionPane
extends JOptionPane {
    private static IviewLogger logger = IviewLogger.getLogger(OptionPane.class, "IVIEW");
    static ResourceBundle res = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private final int MAX_TITLE_LENGTH = 48;
    public static final int MAX_CHAR_PER_LINE_COUNT = 60;
    private static Graphics2D standardGraphics = new BufferedImage(10, 10, 2).createGraphics();
    private static FontMetrics metrics = standardGraphics.getFontMetrics();
    private int maxCharPerLineCount = 60;
    private static final String IVIEW_SIGN = "SIGN_#$%iview^&*_SIGN";
    private JButton firstButton = null;
    private JButton secondButton = null;
    private JButton thirdButton = null;
    private int btnCount = 0;
    private char[] mnemonic;

    public static String showInputDialog(Object object) {
        return OptionPane.showInputDialog(null, object);
    }

    public static String showInputDialog(Component component, Object object, Object object2) {
        return (String)OptionPane.showInputDialog(component, object, res.getString("Input"), 1, null, null, object2);
    }

    public static String showInputDialog(Component component, Object object) {
        return OptionPane.showInputDialog(component, object, res.getString("Input"), 1);
    }

    public static String showInputDialog(Component component, Object object, String string, int n) {
        return (String)OptionPane.showInputDialog(component, object, string, n, null, null, null);
    }

    public static synchronized Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2, boolean bl) {
        Object object3 = null;
        String string2 = object.toString();
        if (bl || OptionPane.containsKey(string2)) {
            boolean bl2 = false;
            if (string2.endsWith(IVIEW_SIGN)) {
                bl2 = true;
                string2 = string2.substring(0, string2.length() - IVIEW_SIGN.length());
                object = string2;
            }
            OptionPane optionPane = new OptionPane(object, n, 2, icon, (Object[][])null, null);
            if (bl2) {
                optionPane.setMaxCharactersPerLineCount(Integer.MAX_VALUE);
            }
            optionPane.setWantsInput(true);
            optionPane.setSelectionValues(objectArray);
            optionPane.setInitialSelectionValue(object2);
            JDialog jDialog = optionPane.createDialog(component, string);
            optionPane.selectInitialValue();
            try {
                jDialog.show();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            Object object4 = optionPane.getInputValue();
            object3 = object4 == UNINITIALIZED_VALUE ? null : object4;
            if (!bl) {
                DuplicationFilter.remove(string2);
            }
        }
        return object3;
    }

    public static synchronized Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        return OptionPane.showInputDialog(component, object, string, n, icon, objectArray, object2, false);
    }

    public static void showMessageDialog(Component component, Object object) {
        OptionPane.showMessageDialog(component, object, res.getString("Prompt"), 1);
    }

    public static void showWarningDialog(Component component, Object object) {
        OptionPane.showMessageDialog(component, object, res.getString("Warning"), 2);
    }

    public static void showWarningDialog(Component component, Object object, boolean bl) {
        OptionPane.showMessageDialog(component, object, res.getString("Warning"), 2, null, bl);
    }

    public static void showErrorDialog(Component component, Object object) {
        OptionPane.showMessageDialog(component, object, res.getString("Error"), 0);
    }

    public static void showErrorDialog(Component component, Object object, boolean bl) {
        OptionPane.showOptionDialog(component, object, res.getString("Error"), -1, 0, null, (Object[][])null, null, bl);
    }

    public static int showQuestionDialog(Component component, Object object) {
        return OptionPane.showQuestionDialog(component, object, 0);
    }

    public static int showQuestionDialog(Component component, Object object, int n) {
        return OptionPane.showExtConfirmDialog(component, object, res.getString("Confirm"), n);
    }

    public static int showQuestionDialog(Component component, Object object, int n, boolean bl) {
        return OptionPane.showExtOptionDialog(component, object, res.getString("Confirm"), n, 3, null, (Object[][])null, null, bl);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        OptionPane.showMessageDialog(component, object, string, n, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        OptionPane.showOptionDialog(component, object, string, -1, n, icon, null, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n, Icon icon, boolean bl) {
        OptionPane.showOptionDialog(component, object, string, -1, n, icon, (Object[][])null, null, bl);
    }

    public static void showMessageDialogInInvoke(final Component component, final Object object, final String string, final int n, final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPane.showMessageDialog(component, object, string, n, icon);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(component, object, string, n, icon);
                }
            });
        }
    }

    public static void showMessageDialogInInvoke(final Component component, final Object object, final String string, final int n, final Icon icon, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPane.showMessageDialog(component, object, string, n, icon, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(component, object, string, n, icon, bl);
                }
            });
        }
    }

    public static int showConfirmDialog(Component component, Object object) {
        return OptionPane.showConfirmDialog(component, object, res.getString("Confirm"), 1);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n) {
        return OptionPane.showConfirmDialog(component, object, string, n, 3);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2) {
        return OptionPane.showConfirmDialog(component, object, string, n, n2, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        return OptionPane.showOptionDialog(component, object, string, n, n2, icon, null, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon, boolean bl) {
        return OptionPane.showOptionDialog(component, object, string, n, n2, icon, (Object[][])null, null, bl);
    }

    public static int showConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n, int n2, Icon icon) {
        int n3 = OptionPane.showConfirmDialog(component, object, string, n, n2, icon);
        if (n3 != 0) {
            return n3;
        }
        n3 = OptionPane.showConfirmDialog(component, object2, string2, n, n2, icon);
        return n3;
    }

    public static int showConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n, int n2) {
        return OptionPane.showConfirmDialog(component, object, object2, string, string2, n, n2, null);
    }

    public static int showConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n) {
        return OptionPane.showConfirmDialog(component, object, object2, string, string2, n, 3);
    }

    public static int showConfirmDialog(Component component, Object object, Object object2, String string, String string2) {
        return OptionPane.showConfirmDialog(component, object, object2, string, string2, 2);
    }

    public static int showConfirmDialog(Component component, Object object, Object object2) {
        return OptionPane.showConfirmDialog(component, object, object2, res.getString("Confirm"), res.getString("Confirm"));
    }

    public static int showExtConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n, int n2, Icon icon) {
        int n3 = OptionPane.showExtConfirmDialog(component, object, string, n, n2, icon);
        if (n3 != 0) {
            return n3;
        }
        n3 = OptionPane.showExtConfirmDialog(component, object2, string2, n, n2, icon);
        return n3;
    }

    public static int showExtConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n, int n2) {
        return OptionPane.showExtConfirmDialog(component, object, object2, string, string2, n, n2, null);
    }

    public static int showExtConfirmDialog(Component component, Object object, Object object2, String string, String string2, int n) {
        return OptionPane.showExtConfirmDialog(component, object, object2, string, string2, n, 3);
    }

    public static int showExtConfirmDialog(Component component, Object object, Object object2, String string, String string2) {
        return OptionPane.showExtConfirmDialog(component, object, object2, string, string2, 2);
    }

    public static int showExtConfirmDialog(Component component, Object object, Object object2) {
        return OptionPane.showExtConfirmDialog(component, object, object2, res.getString("Confirm"), res.getString("Confirm"));
    }

    public static int showExtConfirmDialog(Component component, Object object, String string, int n, int n2) {
        return OptionPane.showExtConfirmDialog(component, object, string, n, n2, null);
    }

    public static int showExtConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        return OptionPane.showExtOptionDialog(component, object, string, n, n2, icon, null, null);
    }

    public static int showExtConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon, boolean bl) {
        return OptionPane.showExtOptionDialog(component, object, string, n, n2, icon, (Object[][])null, null, bl);
    }

    public static int showExtConfirmDialog(Component component, Object object, String string, int n) {
        return OptionPane.showExtConfirmDialog(component, object, string, n, 3);
    }

    public static int showExtConfirmDialog(Component component, Object object) {
        return OptionPane.showExtOptionDialog(component, object, res.getString("Confirm"), 1, 3, null, null, null);
    }

    public static int showExtOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, boolean bl) {
        return OptionPane.showExtOptionDialog(component, object, string, n, n2, icon, OptionPane.makeTwoDim(objectArray), object2, bl);
    }

    public static int showExtOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[][] objectArray, Object object2, boolean bl) {
        int n3 = -1;
        String string2 = object.toString();
        if (bl || OptionPane.containsKey(string2) || OptionPane.isNoDlgShown(string2)) {
            boolean bl2 = false;
            if (string2.endsWith(IVIEW_SIGN)) {
                bl2 = true;
                string2 = string2.substring(0, string2.length() - IVIEW_SIGN.length());
                object = string2;
            }
            OptionPane optionPane = new OptionPane(object, n2, n, icon, objectArray, null);
            if (bl2) {
                optionPane.setMaxCharactersPerLineCount(Integer.MAX_VALUE);
            }
            optionPane.setInitialValue(object2);
            JDialog jDialog = optionPane.createExtDialog(component, string);
            optionPane.selectInitialValue();
            try {
                jDialog.show();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            Object object3 = optionPane.getValue();
            if (object3 == null) {
                n3 = -1;
            } else if (objectArray == null) {
                n3 = object3 instanceof Integer ? (Integer)object3 : -1;
            } else {
                int n4 = objectArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!objectArray[i][0].equals(object3)) continue;
                    n3 = i;
                }
            }
            if (!bl) {
                DuplicationFilter.remove(string2);
            }
        } else {
            logger.trace("May be the message key " + string2 + " already present.");
        }
        return n3;
    }

    public static int showExtOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        return OptionPane.showExtOptionDialog(component, object, string, n, n2, icon, objectArray, object2, false);
    }

    private void removeListeners(OptionPaneDialog optionPaneDialog) {
        WindowListener[] windowListenerArray = optionPaneDialog.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            optionPaneDialog.removeWindowListener(windowListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            this.removeMouseListener(mouseListenerArray[i]);
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
    }

    public JDialog createExtDialog(Component component, String string) {
        Window window = OptionPane.getWindowForComponent(component);
        final OptionPaneDialog optionPaneDialog = window instanceof Frame ? new OptionPaneDialog((Frame)window, string, true){

            @Override
            public void dispose() {
                OptionPane.this.removeListeners(this);
                super.dispose();
                DuplicationFilter.remove(OptionPane.this.message.toString());
            }
        } : new OptionPaneDialog((Dialog)window, string, true){

            @Override
            public void dispose() {
                OptionPane.this.removeListeners(this);
                super.dispose();
                DuplicationFilter.remove(OptionPane.this.message.toString());
            }
        };
        optionPaneDialog.setName("iview_OptionPaneDialog");
        optionPaneDialog.setResizable(false);
        Container container = optionPaneDialog.getContentPane();
        container.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.firstButton = this.getFirstButton();
        if (this.firstButton != null) {
            this.firstButton.setName("OptionPane_firstButton");
            if (null != this.mnemonic && this.mnemonic.length > 0 && ' ' != this.mnemonic[0]) {
                this.firstButton.setMnemonic(this.mnemonic[0]);
            }
        }
        this.secondButton = this.getSecondButton();
        if (this.secondButton != null) {
            this.secondButton.setName("OptionPane_secondButton");
            if (null != this.mnemonic && this.mnemonic.length > 1 && ' ' != this.mnemonic[1]) {
                this.secondButton.setMnemonic(this.mnemonic[1]);
            }
        }
        this.thirdButton = this.getLastButton();
        if (this.thirdButton != null) {
            this.thirdButton.setName("OptionPane_thirdButton");
            int n = 2;
            if (null == this.secondButton) {
                n = 1;
            }
            if (null != this.mnemonic && this.mnemonic.length > n && ' ' != this.mnemonic[n]) {
                this.thirdButton.setMnemonic(this.mnemonic[n]);
            }
        }
        this.btnAddMouseListener();
        container.add((Component)this, "Center");
        try {
            optionPaneDialog.pack();
        }
        catch (Exception exception) {
            optionPaneDialog.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            logger.trace(exception.getMessage(), exception);
        }
        ScreenUIToolKit.centerLocateToScreen(optionPaneDialog);
        optionPaneDialog.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OptionPane.this.setValue(null);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    OptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPane.this.thirdButton.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (OptionPane.this.thirdButton != null && null == OptionPane.this.initialValue) {
                    ScreenUIToolKit.setDefaultButtons(OptionPane.this.firstButton, null);
                    optionPaneDialog.getRootPane().setDefaultButton(null);
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (optionPaneDialog.isVisible() && propertyChangeEvent.getSource() == OptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                    optionPaneDialog.setVisible(false);
                    optionPaneDialog.dispose();
                }
            }
        });
        return optionPaneDialog;
    }

    public JButton getLastButton() {
        Component component = this.getComponent(1);
        JButton jButton = null;
        if (component instanceof JPanel) {
            int n = ((JPanel)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = ((JPanel)component).getComponent(i);
                if (!(component2 instanceof JButton)) continue;
                jButton = (JButton)component2;
                jButton.setPreferredSize(new Dimension(80, 21));
            }
        }
        return jButton;
    }

    public JButton getFirstButton() {
        Component component = this.getComponent(1);
        JButton jButton = null;
        if (component instanceof JPanel) {
            int n = ((JPanel)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = ((JPanel)component).getComponent(i);
                if (!(component2 instanceof JButton)) continue;
                jButton = (JButton)component2;
                break;
            }
        }
        return jButton;
    }

    private int getButtonCount() {
        int n = 0;
        Component component = this.getComponent(1);
        int n2 = ((JPanel)component).getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component2 = ((JPanel)component).getComponent(i);
            if (!(component2 instanceof JButton)) continue;
            ++n;
        }
        return n2;
    }

    private JButton getSecondButton() {
        if (this.btnCount == 0) {
            this.btnCount = this.getButtonCount();
        }
        int n = 0;
        if (this.btnCount < 3) {
            return null;
        }
        Component component = this.getComponent(1);
        int n2 = ((JPanel)component).getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component2 = ((JPanel)component).getComponent(i);
            if (!(component2 instanceof JButton) || ++n != 2) continue;
            return (JButton)component2;
        }
        return null;
    }

    private void btnAddMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getSource() instanceof JButton) {
                    ((JButton)mouseEvent.getSource()).doClick();
                }
            }
        };
        if (this.firstButton != null) {
            this.firstButton.removeMouseListener(mouseAdapter);
            this.firstButton.addMouseListener(mouseAdapter);
        }
        if (this.secondButton != null) {
            this.secondButton.removeMouseListener(mouseAdapter);
            this.secondButton.addMouseListener(mouseAdapter);
        }
        if (this.thirdButton != null) {
            this.thirdButton.removeMouseListener(mouseAdapter);
            this.thirdButton.addMouseListener(mouseAdapter);
        }
    }

    public static int showLineWrapOptionDialog(Component component, Object object, int n) {
        return OptionPane.showLineWrapOptionDialog(component, object, n, true);
    }

    public static int showLineWrapOptionDialog(Component component, Object object, int n, boolean bl) {
        if (object instanceof String || object instanceof StringBuffer) {
            int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
            object = OptionPane.separateStringWith(object.toString(), n2, "\n");
        }
        switch (n) {
            case 2: {
                OptionPane.showWarningDialog(component, object, true);
                return -1;
            }
            case 3: {
                return OptionPane.showQuestionDialog(component, object, 0, true);
            }
            case 1: {
                OptionPane.showMessageDialog(component, object, res.getString("Prompt"), 1, null, bl);
                return -1;
            }
            case 0: {
                OptionPane.showErrorDialog(component, object, true);
                return -1;
            }
        }
        OptionPane.showMessageDialog(component, object, res.getString("Prompt"), 1, null, bl);
        return -1;
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, boolean bl) {
        return OptionPane.showOptionDialog(component, object, string, n, n2, icon, OptionPane.makeTwoDim(objectArray), object2, bl);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[][] objectArray, Object object2, boolean bl) {
        int n3 = -1;
        String string2 = object.toString();
        if (bl || OptionPane.containsKey(string2) || OptionPane.isNoDlgShown(string2)) {
            boolean bl2 = false;
            if (string2.endsWith(IVIEW_SIGN)) {
                bl2 = true;
                string2 = string2.substring(0, string2.length() - IVIEW_SIGN.length());
                object = string2;
            }
            OptionPane optionPane = new OptionPane(object, n2, n, icon, objectArray, null);
            if (bl2) {
                optionPane.setMaxCharactersPerLineCount(Integer.MAX_VALUE);
            }
            optionPane.setInitialValue(object2);
            JDialog jDialog = optionPane.createDialog(component, string);
            optionPane.selectInitialValue();
            try {
                jDialog.show();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            Object object3 = optionPane.getValue();
            if (object3 == null) {
                n3 = -1;
            } else if (objectArray == null) {
                n3 = object3 instanceof Integer ? (Integer)object3 : -1;
            } else {
                int n4 = objectArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!objectArray[i][0].equals(object3)) continue;
                    n3 = i;
                }
            }
            if (!bl) {
                DuplicationFilter.remove(string2);
            }
        } else {
            logger.trace("May be the message key " + string2 + " already present.");
        }
        return n3;
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, boolean bl, boolean bl2) {
        return OptionPane.showOptionDialog(component, object, string, n, n2, icon, OptionPane.makeTwoDim(objectArray), object2, bl, bl2);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[][] objectArray, Object object2, boolean bl, boolean bl2) {
        int n3 = -1;
        String string2 = object.toString();
        if (bl || OptionPane.containsKey(string2)) {
            boolean bl3 = false;
            if (string2.endsWith(IVIEW_SIGN)) {
                bl3 = true;
                string2 = string2.substring(0, string2.length() - IVIEW_SIGN.length());
                object = string2;
            }
            OptionPane optionPane = new OptionPane(object, n2, n, icon, objectArray, null);
            if (bl3) {
                optionPane.setMaxCharactersPerLineCount(Integer.MAX_VALUE);
            }
            optionPane.setInitialValue(object2);
            JDialog jDialog = optionPane.createDialog(component, string, bl2);
            optionPane.selectInitialValue();
            try {
                jDialog.show();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            Object object3 = optionPane.getValue();
            if (object3 == null) {
                n3 = -1;
            } else if (objectArray == null) {
                n3 = object3 instanceof Integer ? (Integer)object3 : -1;
            } else {
                int n4 = objectArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!objectArray[i][0].equals(object3)) continue;
                    n3 = i;
                }
            }
        }
        return n3;
    }

    private static boolean containsKey(String string) {
        if (string.endsWith(IVIEW_SIGN)) {
            string = string.substring(0, string.length() - IVIEW_SIGN.length());
        }
        return DuplicationFilter.addObjectByKey(string);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        return OptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2, false);
    }

    @Override
    public JDialog createDialog(Component component, String string) {
        return this.createDialog(component, string, true);
    }

    public JDialog createDialog(Component component, String string, boolean bl) {
        Component component2;
        int n;
        int n2;
        Window window = OptionPane.getWindowForComponent(component);
        final OptionPaneDialog optionPaneDialog = window instanceof Frame ? new OptionPaneDialog((Frame)window, string, bl){

            @Override
            public void dispose() {
                OptionPane.this.removeListeners(this);
                super.dispose();
                DuplicationFilter.remove(OptionPane.this.message.toString());
            }
        } : new OptionPaneDialog((Dialog)window, string, bl){

            @Override
            public void dispose() {
                OptionPane.this.removeListeners(this);
                super.dispose();
                DuplicationFilter.remove(OptionPane.this.message.toString());
            }
        };
        optionPaneDialog.setName("iview_OptionPaneDialog");
        optionPaneDialog.setResizable(false);
        Container container = optionPaneDialog.getContentPane();
        container.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        int n3 = 0;
        Component component3 = this.getComponent(0);
        if (component3 instanceof JPanel) {
            n2 = ((JPanel)component3).getComponentCount();
            for (int i = 0; i < n2; i += 1) {
                Component component4 = ((JPanel)component3).getComponent(i);
                if (!(component4 instanceof JPanel)) continue;
                n = ((JPanel)component4).getComponentCount();
                for (int j = 0; j < n; ++j) {
                    component2 = ((JPanel)component4).getComponent(j);
                    if (!(component2 instanceof JPanel)) continue;
                    int n4 = ((JPanel)component2).getComponentCount();
                    for (int k = 0; k < n4; ++k) {
                        Component component5 = ((JPanel)component2).getComponent(k);
                        if (!(component5 instanceof JTextField)) continue;
                        n3 = 1;
                        JTextField jTextField = (JTextField)component5;
                        String string2 = jTextField.getText();
                        jTextField.setDocument(new LimitLengthDocument(48));
                        jTextField.setText(string2);
                        jTextField.selectAll();
                    }
                }
            }
        }
        n2 = n3;
        Component component6 = this.getComponent(1);
        if (component6 instanceof JPanel) {
            int n5 = ((JPanel)component6).getComponentCount();
            for (n = 0; n < n5; ++n) {
                Component component7 = ((JPanel)component6).getComponent(n);
                if (!(component7 instanceof JButton)) continue;
                component2 = (JButton)component7;
                component2.setPreferredSize(new Dimension(80, 21));
                if (n == 0) {
                    this.firstButton = component2;
                    this.firstButton.setName("OptionPane_firstButton");
                    if (null != this.mnemonic && this.mnemonic.length > 0 && ' ' != this.mnemonic[0]) {
                        this.firstButton.setMnemonic(this.mnemonic[0]);
                    }
                }
                if (n == 1) {
                    this.secondButton = component2;
                    this.secondButton.setName("OptionPane_secondButton");
                    if (null != this.mnemonic && this.mnemonic.length > 1 && ' ' != this.mnemonic[1]) {
                        this.secondButton.setMnemonic(this.mnemonic[1]);
                    }
                }
                if (n != n5 - 1) continue;
                this.thirdButton = component2;
                this.thirdButton.setName("OptionPane_thirdButton");
                if (null == this.mnemonic || this.mnemonic.length <= 2 || ' ' == this.mnemonic[2]) continue;
                this.thirdButton.setMnemonic(this.mnemonic[2]);
            }
        }
        this.btnAddMouseListener();
        container.add((Component)this, "Center");
        try {
            optionPaneDialog.pack();
        }
        catch (Exception exception) {
            optionPaneDialog.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            logger.trace(exception.getMessage(), exception);
        }
        ScreenUIToolKit.centerLocateToScreen(optionPaneDialog);
        optionPaneDialog.addWindowListener(new WindowAdapter(n2 != 0){
            boolean gotFocus = false;
            final /* synthetic */ boolean val$hasFiled;
            {
                this.val$hasFiled = bl;
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OptionPane.this.setValue(null);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    OptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                optionPaneDialog.getRootPane().setDefaultButton(null);
                ScreenUIToolKit.setDefaultButtons(OptionPane.this.firstButton, null);
                if (!this.val$hasFiled && OptionPane.this.firstButton != null && null == OptionPane.this.initialValue) {
                    OptionPane.this.firstButton.requestFocus();
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (optionPaneDialog.isVisible() && propertyChangeEvent.getSource() == OptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                    optionPaneDialog.setVisible(false);
                    optionPaneDialog.dispose();
                }
            }
        });
        return optionPaneDialog;
    }

    public static Frame getFrameForComponent(Component component) {
        if (component == null) {
            return OptionPane.getRootFrame();
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return OptionPane.getFrameForComponent(component.getParent());
    }

    public OptionPane(Object object) {
        this(object, -1);
    }

    public OptionPane(Object object, int n) {
        this(object, n, -1);
    }

    public OptionPane(Object object, int n, int n2) {
        this(object, n, n2, null);
    }

    public OptionPane(Object object, int n, int n2, Icon icon) {
        this(object, n, n2, icon, null);
    }

    public OptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray) {
        this(object, n, n2, icon, objectArray, null);
    }

    public OptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        this(object, n, n2, icon, OptionPane.makeTwoDim(objectArray), object2);
    }

    public OptionPane(Object object, int n, int n2, Icon icon, Object[][] objectArray, Object object2) {
        this.message = object;
        this.setOptions(objectArray);
        this.initialValue = object2;
        this.icon = icon;
        this.setMessageType(n);
        this.setOptionType(n2);
        this.value = UNINITIALIZED_VALUE;
        this.inputValue = UNINITIALIZED_VALUE;
        this.setName("iview_OptionPane");
        this.updateUI();
    }

    private void setOptions(Object[][] objectArray) {
        if (objectArray == null) {
            this.options = null;
            return;
        }
        int n = 0;
        int n2 = 0;
        Object[] objectArray2 = new Object[objectArray.length];
        String[] stringArray = new String[objectArray.length];
        this.mnemonic = new char[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            for (n2 = 0; n2 < objectArray[n].length; ++n2) {
                if (n2 == 0) {
                    objectArray2[n] = objectArray[n][n2];
                }
                if (n2 != 1) continue;
                stringArray[n] = (String)objectArray[n][n2];
                this.mnemonic[n] = null == stringArray[n] || 0 == stringArray[n].length() ? 32 : stringArray[n].charAt(0);
            }
        }
        this.options = objectArray2;
    }

    private static Object[][] makeTwoDim(Object[] objectArray) {
        if (null == objectArray) {
            Object[][] objectArray2 = null;
            return objectArray2;
        }
        int n = 0;
        int n2 = 0;
        Object[][] objectArray3 = new Object[objectArray.length][2];
        for (n = 0; n < objectArray.length; ++n) {
            for (n2 = 0; n2 < 2; ++n2) {
                if (n2 == 0) {
                    objectArray3[n][n2] = objectArray[n];
                }
                if (n2 != 1) continue;
                objectArray3[n][n2] = null;
            }
        }
        return objectArray3;
    }

    @Override
    public void setUI(OptionPaneUI optionPaneUI) {
        if ((OptionPaneUI)this.ui != optionPaneUI) {
            super.setUI(optionPaneUI);
            this.invalidate();
        }
    }

    @Override
    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
    }

    @Override
    public int getMaxCharactersPerLineCount() {
        return this.maxCharPerLineCount;
    }

    public void setMaxCharactersPerLineCount(int n) {
        this.maxCharPerLineCount = n;
    }

    static Window getWindowForComponent(Component component) {
        if (component == null) {
            return OptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return OptionPane.getWindowForComponent(component.getParent());
    }

    private static List devideString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        List<String> list = Collections.synchronizedList(new ArrayList(16));
        while (stringTokenizer.hasMoreElements()) {
            list.add(stringTokenizer.nextToken());
        }
        return list;
    }

    private static String[] splitString(String string, int n) {
        String[] stringArray = new String[]{string, ""};
        char[] cArray = string.toCharArray();
        int n2 = 0;
        try {
            for (int i = 0; i < cArray.length; ++i) {
                if (metrics.charsWidth(cArray, 0, i) <= n) continue;
                n2 = i;
                while (OptionPane.isChar(cArray[i - 1]) && OptionPane.isChar(cArray[i])) {
                    if (--i != 0) continue;
                    i = n2;
                    break;
                }
                stringArray[0] = string.substring(0, i);
                stringArray[1] = string.substring(i);
                break;
            }
            return stringArray;
        }
        catch (Exception exception) {
            stringArray[0] = string.substring(0, n2);
            stringArray[1] = string.substring(n2);
            return stringArray;
        }
    }

    private static boolean isChar(char c) {
        return c <= '\u007f' && !Character.isWhitespace(c);
    }

    public static List separateString(String string, int n) {
        List<String> list = Collections.synchronizedList(new ArrayList(16));
        int n2 = metrics.stringWidth(string);
        if (n2 <= n) {
            list.add(string);
        } else {
            String string2 = null;
            Iterator iterator = OptionPane.separateStringInitial(string, "\n").iterator();
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                Iterator iterator2 = OptionPane.separateStringParticular(string2, n).iterator();
                while (iterator2.hasNext()) {
                    list.add((String)iterator2.next());
                }
            }
        }
        if (string != null && string.length() != 0) {
            list.add(IVIEW_SIGN);
        }
        return list;
    }

    private static List separateStringInitial(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(16);
        String string3 = string;
        int n = 0;
        if (string3.indexOf(string2) == -1) {
            arrayList.add(string);
        }
        if (string3.indexOf(string2) != -1) {
            while (string3.indexOf(string2) != -1) {
                n = string3.indexOf(string2);
                string = string3.substring(0, n);
                string3 = string3.substring(n + 1);
                arrayList.add(string);
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static List separateStringParticular(String string, int n) {
        List<String> list = Collections.synchronizedList(new ArrayList(16));
        int n2 = metrics.stringWidth(string);
        if (n2 <= n) {
            list.add(string);
            return list;
        }
        Iterator iterator = OptionPane.devideString(string, " ").iterator();
        String[] stringArray = null;
        String string2 = "";
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = iterator.next().toString();
            string2 = string2 + string3;
            while (metrics.stringWidth(string2) > n) {
                stringArray = OptionPane.splitString(string2, n);
                list.add(stringArray[0]);
                string2 = stringArray[1];
            }
        }
        if (string2.length() > 0) {
            list.add(string2);
        }
        return list;
    }

    public static List separateString(String string) {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        return OptionPane.separateString(string, n);
    }

    public static StringBuffer separateStringWith(String string, String string2) {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        return OptionPane.separateStringWith(string, n, string2);
    }

    public static StringBuffer separateStringWith(String string, int n, String string2) {
        Iterator iterator = OptionPane.separateString(string, n).iterator();
        StringBuffer stringBuffer = new StringBuffer(16);
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer;
    }

    public static void showMessageModelessDialog(Component component, Object object) {
        OptionPane.showMessageModelessDialog(component, object, res.getString("Prompt"), 1);
    }

    public static void showMessageModelessDialog(Component component, Object object, String string, int n) {
        OptionPane.showMessageModelessDialog(component, object, string, n, null);
    }

    public static void showMessageModelessDialog(Component component, Object object, String string, int n, Icon icon) {
        OptionPane.showOptionDialog(component, object, string, -1, n, icon, (Object[][])null, null, false, false);
    }

    public static void showMessageModelessDialog(Component component, Object object, String string, int n, Icon icon, boolean bl) {
        OptionPane.showOptionDialog(component, object, string, -1, n, icon, (Object[][])null, null, bl, false);
    }

    private static boolean isNoDlgShown(String string) {
        logger.trace("Checking whether the dialogs are shown :" + string);
        Window[] windowArray = FrameworkHelper.getMainFrame().getOwnedWindows();
        if (null != windowArray) {
            for (Window window : windowArray) {
                if (!window.isVisible() || !(window instanceof JDialog) || !((JDialog)window).isModal()) continue;
                return false;
            }
        }
        logger.trace("Removing the message key from list : " + string);
        if (string.endsWith(IVIEW_SIGN)) {
            string = string.substring(0, string.length() - IVIEW_SIGN.length());
        }
        DuplicationFilter.remove(string);
        return true;
    }
}

