/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.lookandfeel.SwimapFileChooseUI;
import com.swimap.iview.templates.textfield.SaveValidCharDocument;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.FileEncodingDetector;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.text.Document;

public class OpenFileChooser
extends JFileChooser {
    protected static final String currentDir = CommonUtil.getDefaultSavePath();
    private static IviewLogger logger = IviewLogger.getLogger(OpenFileChooser.class, "IVIEW");
    private ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static final int FILE_NAME_LENGTH = 255;
    private int fileNameLength = 255;
    private String invalidStr = "*?";
    private boolean isCheckFileExist = true;
    private final int SAVEOROPENBTN = 0;
    private final int FILENAMETEXTFIELD = 1;
    private final int FILELIST = 2;
    private final int NEWFOLDERBTN = 3;
    private final int FILTERCOMBOBOX = 4;
    private final int CANCELBUTTON = 5;
    private String oldText = "";
    private JTextField inputTextFiled = null;
    private int comboBoxIndex = 0;
    private boolean isSelect = false;
    private boolean isNotSetDir = false;
    private String title = null;
    private boolean existTitle = false;
    private String helpID = null;
    private static String localHistoryDir = null;
    private JButton open = null;
    private boolean isEncodingSupported = false;
    public static final HashMap<String, String> ENCODING_KEY_VALUE_MAP = new HashMap(2);

    public OpenFileChooser() {
        this(false);
    }

    public OpenFileChooser(boolean bl) {
        super(null != OpenFileChooser.getHistoryDir() ? OpenFileChooser.getHisDir() : (currentDir.length() > 0 ? new File(currentDir) : new File(System.getProperty("user.dir"))));
        if (bl) {
            this.isEncodingSupported = true;
            this.updateUI();
        }
        this.setFileHidingEnabled(true);
        this.initInputTextField();
        this.init();
    }

    public OpenFileChooser(String string) {
        this(string.length() > 0 ? string : (currentDir.length() > 0 ? currentDir : System.getProperty("user.dir")), false);
    }

    public OpenFileChooser(String string, boolean bl) {
        super(null != OpenFileChooser.getHistoryDir() ? OpenFileChooser.getHisDir() : (string.length() > 0 ? new File(string) : (currentDir.length() > 0 ? new File(currentDir) : new File(System.getProperty("user.dir")))));
        this.setFileHidingEnabled(true);
        if (bl) {
            this.isEncodingSupported = true;
            this.updateUI();
        }
        this.initInputTextField();
        this.init();
    }

    static File getHisDir() {
        FileSystemView fileSystemView;
        File file;
        String string;
        String string2 = OpenFileChooser.getHistoryDir();
        if (string2.equals(string = (file = (fileSystemView = FileSystemView.getFileSystemView()).getHomeDirectory()).getAbsolutePath())) {
            return file;
        }
        return new File(string2);
    }

    public OpenFileChooser(String string, int n) {
        this(string, n, false);
    }

    public OpenFileChooser(String string, int n, boolean bl) {
        super(null != OpenFileChooser.getHistoryDir() ? OpenFileChooser.getHisDir() : new File(string));
        this.setFileHidingEnabled(true);
        if (bl) {
            this.isEncodingSupported = true;
            this.updateUI();
        }
        if (0 < n) {
            this.fileNameLength = n;
        }
        this.initInputTextField();
        this.init();
    }

    public OpenFileChooser(String string, int n, String string2) {
        this(string, n, string2, false);
    }

    public OpenFileChooser(String string, int n, String string2, boolean bl) {
        super(null != OpenFileChooser.getHistoryDir() ? OpenFileChooser.getHistoryDir() : string);
        this.setFileHidingEnabled(true);
        if (bl) {
            this.isEncodingSupported = true;
            this.updateUI();
        }
        if (0 < n) {
            this.fileNameLength = n;
        }
        this.invalidStr = string2;
        this.initInputTextField();
        this.init();
    }

    public OpenFileChooser(File file) {
        this(file, false);
    }

    public OpenFileChooser(File file, boolean bl) {
        super(file);
        if (bl) {
            this.isEncodingSupported = true;
            this.updateUI();
        }
        if (null != OpenFileChooser.getHistoryDir()) {
            File file2 = OpenFileChooser.getHisDir();
            this.setCurrentDirectory(file2);
        }
        this.setFileHidingEnabled(true);
        this.initInputTextField();
        this.init();
    }

    public void setCheckFileExist(boolean bl) {
        this.isCheckFileExist = bl;
    }

    public boolean isCheckFileExist() {
        return this.isCheckFileExist;
    }

    public void setFileNameMaxLength(int n) {
        if (n <= 0 || this.fileNameLength == n) {
            return;
        }
        this.fileNameLength = n;
        Document document = this.getTextField(this).getDocument();
        if (document instanceof SaveValidCharDocument) {
            ((SaveValidCharDocument)document).setMaxLength(n);
            String string = MessageFormat.format(this.res.getString("Length_too_long"), String.valueOf(n));
            ((SaveValidCharDocument)document).setErrorInfo(string, this.res.getString("InvalidStr") + this.invalidStr, null, null);
        }
    }

    public int getFileNameMaxLength() {
        return this.fileNameLength;
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (file != null && (".".equals(file.getName()) || "..".equals(file.getName()))) {
            this.getInputTextField().setCaretPosition(this.getInputTextField().getText().length());
            OptionPane.showErrorDialog(this, this.res.getString("FileName_Not_Exist"));
            this.isSelect = true;
            this.isNotSetDir = false;
            this.getInputTextField().requestFocus(true);
            return;
        }
        if (this.isNotSetDir) {
            this.isNotSetDir = false;
            return;
        }
        super.setCurrentDirectory(file);
    }

    private void init() {
        JComboBox jComboBox;
        JComponent jComponent;
        Component component;
        this.setName("OpenFileChooser");
        System.setProperty("isFileExtensionChange", "false");
        this.open = (JButton)this.getComponent(this, 0);
        if (this.open != null) {
            this.open.setName("OpenFileChooser_save");
            this.open.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenFileChooser.this.determineWhetherSetDir();
                    OpenFileChooser.this.oldText = OpenFileChooser.this.getTextField(OpenFileChooser.this).getText();
                }
            });
        }
        if ((component = this.getComponent(this, 2)) != null) {
            jComponent = (JList)component;
            jComponent.setName("OpenFileChooser_list");
            jComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        OpenFileChooser.this.determineWhetherSetDir();
                        OpenFileChooser.this.oldText = OpenFileChooser.this.getTextField(OpenFileChooser.this).getText();
                    }
                }
            });
        }
        if (null != (jComponent = (JButton)this.getComponent(this, 5))) {
            jComponent.setName("OpenFileChooser_cancelBtn");
        }
        if (null != (jComboBox = (JComboBox)this.getComponent(this, 4))) {
            jComboBox.setName("OpenFileChooser_filterCombo");
        }
    }

    private void initInputTextField() {
        JTextField jTextField;
        this.inputTextFiled = jTextField = this.getTextField(this);
        if (jTextField != null) {
            this.inputTextFiled.setName("OpenFileChooser_inputTextFiled");
            final SaveValidCharDocument saveValidCharDocument = new SaveValidCharDocument(this.fileNameLength, this.invalidStr, this);
            saveValidCharDocument.setParentComponent(this);
            String string = MessageFormat.format(this.res.getString("Length_too_long"), String.valueOf(this.fileNameLength));
            saveValidCharDocument.setErrorInfo(string, this.res.getString("InvalidStr") + this.invalidStr, null, null);
            jTextField.setDocument(saveValidCharDocument);
            try {
                JButton jButton = this.getNewFolderBtn(this);
                if (jButton != null) {
                    jButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            saveValidCharDocument.setIsClickNewFolder(true);
                        }
                    });
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            this.inputTextFiled.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (OpenFileChooser.this.isSelect && !saveValidCharDocument.getOk()) {
                        OpenFileChooser.this.inputTextFiled.selectAll();
                    } else if (saveValidCharDocument.getOk()) {
                        saveValidCharDocument.setOk(false);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    OpenFileChooser.this.isSelect = false;
                }
            });
            jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        OpenFileChooser.this.determineWhetherSetDir();
                        OpenFileChooser.this.oldText = OpenFileChooser.this.getTextField(OpenFileChooser.this).getText();
                    }
                }
            });
        }
    }

    private Component getComponent(Component component, int n) {
        if (this.isEqual(component, n)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component2 = this.getComponent(container.getComponent(i), n);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    private boolean isEqual(Component component, int n) {
        switch (n) {
            case 0: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && (ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale)) || ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.openDialogTitleText", locale)));
            }
            case 1: {
                return component instanceof JTextField;
            }
            case 2: {
                return component instanceof JList;
            }
            case 3: {
                return component instanceof JButton && ((JButton)component).getIcon() != null && ((JButton)component).getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"));
            }
            case 4: {
                if (component instanceof JComboBox) {
                    ++this.comboBoxIndex;
                    if ("Encoding_ComboBox".equals(component.getName())) {
                        return false;
                    }
                    if (this.comboBoxIndex == 2) {
                        this.comboBoxIndex = 0;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.cancelButtonText", locale));
            }
        }
        return false;
    }

    public JTextField getTextField(Component component) {
        if (component instanceof JTextField) {
            return (JTextField)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JTextField jTextField = this.getTextField(container.getComponent(i));
                if (jTextField == null) continue;
                return jTextField;
            }
        }
        return null;
    }

    public void displayPathName() {
        JLabel jLabel = this.getFileNameLabel(this);
        if (jLabel != null) {
            String string = jLabel.getText();
            String string2 = SaveFileChooser.res.getString("PathName") + string.substring(string.length() - 1);
            if (string.indexOf("n") >= 0) {
                string2 = string2.replaceAll("N", "n");
            }
            jLabel.setText(string2);
        }
    }

    public JButton getNewFolderBtn(Component component) {
        if (component instanceof JButton) {
            if (((JButton)component).getIcon() != null && ((JButton)component).getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"))) {
                return (JButton)component;
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JButton jButton = this.getNewFolderBtn(container.getComponent(i));
                if (jButton == null) continue;
                return jButton;
            }
        }
        return null;
    }

    private JLabel getFileNameLabel(Component component) {
        if (component instanceof JLabel && ((JLabel)component).getLabelFor() == this.getComponent(this, 1)) {
            return (JLabel)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JLabel jLabel = this.getFileNameLabel(container.getComponent(i));
                if (jLabel == null) continue;
                return jLabel;
            }
        }
        return null;
    }

    public void setDirectory(File file) {
        File file2;
        if (file == null) {
            return;
        }
        File file3 = this.getFileSystemView().getHomeDirectory();
        if (!file.isDirectory() && (file2 = file.getParentFile()) != null && file2.equals(file3)) {
            this.setCurrentDirectory(new File(System.getProperty("user.dir")));
            this.setCurrentDirectory(file3);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.existTitle = true;
    }

    @Override
    public void approveSelection() {
        Object object;
        if (this.isMultiSelectionEnabled() && this.isCheckFileExist) {
            if (this.getSelectedFiles() != null) {
                int n = this.getSelectedFiles().length;
                object = null;
                for (int i = 0; i < n; ++i) {
                    object = this.getSelectedFiles()[i];
                    if (object != null && ((File)object).exists()) continue;
                    this.getInputTextField().setText(this.oldText);
                    this.oldText = "";
                    OptionPane.showErrorDialog(this, this.res.getString("FileName_Not_Exist"));
                    this.isSelect = true;
                    this.getInputTextField().requestFocus(true);
                    return;
                }
                if (this.oldText.length() > 0) {
                    StringTokenizer stringTokenizer;
                    String string = this.oldText.trim();
                    if (string.startsWith("\"")) {
                        string = string.substring(1);
                    }
                    if (string.endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if ((stringTokenizer = new StringTokenizer(string = string.replaceAll("\" \"", ">"), ">")).countTokens() != n) {
                        this.getInputTextField().setText(this.oldText);
                        this.oldText = "";
                        OptionPane.showErrorDialog(this, this.res.getString("FileName_Not_Exist"));
                        this.isSelect = true;
                        this.getInputTextField().requestFocus(true);
                        return;
                    }
                    this.oldText = "";
                }
            } else {
                this.getInputTextField().setText(this.oldText);
                this.oldText = "";
                OptionPane.showErrorDialog(this, this.res.getString("FileName_Not_Exist"));
                this.isSelect = true;
                this.getInputTextField().requestFocus(true);
                return;
            }
        }
        String string = this.getSelectedFile().getAbsolutePath();
        if (this.getSelectedFile().getName().length() > this.fileNameLength) {
            this.oldText = "";
            object = MessageFormat.format(this.res.getString("Length_too_long"), String.valueOf(this.fileNameLength));
            OptionPane.showErrorDialog(this, object);
            return;
        }
        if (this.isCheckFileExist && !((File)(object = new File(string))).exists()) {
            this.getInputTextField().setText(this.oldText);
            this.oldText = "";
            this.getInputTextField().setCaretPosition(this.getInputTextField().getText().length());
            OptionPane.showErrorDialog(this, this.res.getString("FileName_Not_Exist"));
            this.isSelect = true;
            this.getInputTextField().requestFocus(true);
            return;
        }
        this.oldText = "";
        super.approveSelection();
        object = this.getSelectedFile();
        String string2 = null;
        string2 = ((File)object).isDirectory() ? ((File)object).getAbsolutePath() : ((File)object).getParent();
        if (FileChooser.isHistoryShared()) {
            FileChooser.setSharedHistoryDir(string2);
        } else {
            localHistoryDir = string2;
        }
    }

    @Override
    public int showDialog(Component component, String string) {
        this.correctWrongFileName();
        this.selectFileFilterCombo();
        this.setDirectory(this.getCurrentDirectory());
        return super.showDialog(component, string);
    }

    public int showDialog(Component component, String string, boolean bl) {
        if (null != this.open) {
            this.open.setEnabled(bl);
            this.open.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("text".equals(propertyChangeEvent.getPropertyName())) {
                        OpenFileChooser.this.open.setEnabled(((SwimapFileChooseUI)OpenFileChooser.this.getUI()).isDirectorySelected());
                    }
                }
            });
        }
        this.inputTextFiled.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                OpenFileChooser.this.open.setEnabled(OpenFileChooser.this.getTextField(OpenFileChooser.this).getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                OpenFileChooser.this.open.setEnabled(OpenFileChooser.this.getTextField(OpenFileChooser.this).getText().trim().length() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        return this.showDialog(component, string);
    }

    @Override
    public int showSaveDialog(Component component) throws HeadlessException {
        this.correctWrongFileName();
        this.selectFileFilterCombo();
        return super.showSaveDialog(component);
    }

    @Override
    public int showOpenDialog(Component component) throws HeadlessException {
        this.correctWrongFileName();
        this.selectFileFilterCombo();
        return super.showOpenDialog(component);
    }

    private void correctWrongFileName() {
        JTextField jTextField = this.getInputTextField();
        if (1 != this.getFileSelectionMode() || null == jTextField) {
            return;
        }
        String string = jTextField.getText();
        File file = this.getSelectedFile();
        if (null == file) {
            return;
        }
        String string2 = file.getAbsolutePath();
        if (!ResourceUtil.areEquals(string, string2)) {
            jTextField.setText(string2);
        }
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        if (this.existTitle) {
            jDialog.setTitle(this.title);
        }
        jDialog.pack();
        ScreenToolKit.centerLocateToScreen(jDialog);
        jDialog.setResizable(true);
        if (null != this.helpID && !"".equals(this.helpID.trim())) {
            HelpManager.getInstance().enableHelpKey(jDialog.getRootPane(), this.helpID);
        }
        return jDialog;
    }

    private void selectFileFilterCombo() {
        JComboBox jComboBox;
        int n;
        JTextField jTextField = this.getInputTextField();
        String string = jTextField.getText();
        String string2 = "";
        if (string.length() > 0 && (n = string.lastIndexOf(46)) >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        if ((jComboBox = (JComboBox)this.getComponent(this, 4)) != null) {
            int n2;
            int n3 = -1;
            Object object = null;
            for (n2 = 0; n2 < jComboBox.getItemCount(); ++n2) {
                object = jComboBox.getItemAt(n2);
                if (object instanceof FileChooserFilter) {
                    LinkedList linkedList = ((FileChooserFilter)object).getAllFilters();
                    if (!linkedList.contains(string2)) continue;
                    n3 = n2;
                    break;
                }
                if (!this.isAcceptAllFileFilterUsed() || !object.equals(this.getAcceptAllFileFilter()) || string.length() == 0) continue;
                n3 = n2;
            }
            if (n3 == -1 && jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                n3 = jComboBox.getItemCount() - 1;
            }
            if (n3 != -1 && n3 != jComboBox.getSelectedIndex()) {
                n2 = n3;
                jComboBox.setSelectedIndex(n2);
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(string.length());
            }
        }
    }

    private JTextField getInputTextField() {
        if (this.inputTextFiled != null) {
            return this.inputTextFiled;
        }
        Component component = this.getComponent(this, 1);
        JTextField jTextField = null;
        if (component != null) {
            jTextField = (JTextField)component;
        }
        return jTextField;
    }

    private void determineWhetherSetDir() {
        try {
            Object object;
            this.isNotSetDir = false;
            String string = "";
            if (this.getUI() instanceof SwimapFileChooseUI) {
                object = (SwimapFileChooseUI)this.getUI();
                if (((SwimapFileChooseUI)object).isDirectorySelected()) {
                    File file = ((SwimapFileChooseUI)object).getDirectory();
                    if (null != file && !file.exists()) {
                        OptionPane.showErrorDialog(this, this.res.getString("Directory_Not_Exist"));
                    }
                    return;
                }
            } else {
                return;
            }
            string = ((MetalFileChooserUI)object).getFileName();
            object = this.getCurrentDirectory();
            FileSystemView fileSystemView = this.getFileSystemView();
            File file = fileSystemView.createFileObject(string);
            if (!file.isAbsolute()) {
                file = fileSystemView.getChild((File)object, string);
            }
            if (!file.isDirectory() && !fileSystemView.isParent((File)object, file)) {
                this.isNotSetDir = true;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.isNotSetDir = false;
        }
    }

    public void setHelpID(String string) {
        this.helpID = string;
    }

    private static String getHistoryDir() {
        if (FileChooser.isHistoryShared()) {
            return FileChooser.getSharedHistoryDir();
        }
        return localHistoryDir;
    }

    private String getFileEncoding() {
        File file = this.getSelectedFile();
        if (null == file) {
            return null;
        }
        try {
            return FileEncodingDetector.detectEncodingFromFile(file);
        }
        catch (IOException iOException) {
            logger.trace("IO Exception while trying to read the encoding of :" + file.getName());
            return null;
        }
    }

    public String getFileEncoding(File file) {
        if (null == file) {
            return null;
        }
        try {
            return FileEncodingDetector.detectEncodingFromFile(file);
        }
        catch (IOException iOException) {
            logger.trace("IO Exception while trying to read the encoding of :" + file.getName());
            return null;
        }
    }

    public String getEncodingType() {
        SwimapFileChooseUI swimapFileChooseUI;
        String string = null;
        if (this.getUI() instanceof SwimapFileChooseUI && this.isEncodingSupported && (string = (swimapFileChooseUI = (SwimapFileChooseUI)this.getUI()).getEncodingType()) == null) {
            string = this.res.getString("auto");
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof FileChooserFilter) {
                String string2 = (String)ReflectionUtilities.getFieldByObject(fileFilter, "fileType");
                if (null == string2) {
                    LinkedList linkedList = ((FileChooserFilter)fileFilter).getAllFilters();
                    String string3 = string2 = linkedList.size() > 0 ? linkedList.get(0).toString().trim() : "";
                }
                if (string2.equals("html") || string2.equals("xml")) {
                    string = "UTF-8";
                }
            }
        }
        return string;
    }

    public String getSelectedFileEncoding() {
        String string = this.getEncodingType();
        String string2 = this.getFileEncoding();
        String string3 = string;
        if (this.res.getString("auto").equals(string) || null == string) {
            string3 = string2;
            logger.trace("Selected Encoding :: " + string + " File Encoding :: " + string2 + " returning Encoding :: " + string3);
        }
        return string3;
    }

    public boolean isEncodingEnabled() {
        return this.isEncodingSupported;
    }

    @Override
    protected void fireActionPerformed(String string) {
        if (string.equals("ApproveSelection")) {
            // empty if block
        }
    }
}

