/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.Layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private static final int GAP = 5;
    private int hzgap = 0;
    private int vtgap = 0;
    private boolean hzfill = false;
    private boolean vtfill = false;

    public VerticalFlowLayout() {
        this(0);
    }

    public VerticalFlowLayout(int n) {
        this(n, true, false);
    }

    public VerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, bl, bl2);
    }

    public VerticalFlowLayout(int n, boolean bl, boolean bl2) {
        this(n, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setAlignment(n);
        this.hzgap = n2;
        this.vtgap = n3;
        this.hzfill = bl;
        this.vtfill = bl2;
    }

    @Override
    public void setHgap(int n) {
        super.setHgap(n);
        this.hzgap = n;
    }

    @Override
    public int getHgap() {
        return this.hzgap;
    }

    @Override
    public void setVgap(int n) {
        super.setVgap(n);
        this.vtgap = n;
    }

    @Override
    public int getVgap() {
        return this.vtgap;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getFixedLayoutSize(container, false);
    }

    private Dimension getFixedLayoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = null;
            dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vtgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width = dimension.width + insets.left + insets.right + this.hzgap * 2;
        dimension.height = dimension.height + insets.top + insets.bottom + this.vtgap * 2;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getFixedLayoutSize(container, true);
    }

    public void setHorizontalFill(boolean bl) {
        this.hzfill = bl;
    }

    public boolean getHorizontalFill() {
        return this.hzfill;
    }

    public void setVerticalFill(boolean bl) {
        this.vtfill = bl;
    }

    public boolean getVerticalFill() {
        return this.vtfill;
    }

    private void alignChildren(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getAlignment();
        if (n7 == 1) {
            n2 += n4 / 2;
        } else if (n7 == 2) {
            n2 += n4;
        }
        Component component = null;
        for (int i = n5; i < n6; ++i) {
            component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n8 = n + (n3 - component.getSize().width) / 2;
            component.setLocation(n8, n2);
            n2 = n2 + this.vtgap + component.getSize().height;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - insets.top + insets.bottom + this.vtgap * 2;
        int n2 = container.getSize().width - insets.left + insets.right + this.hzgap * 2;
        int n3 = container.getComponentCount();
        int n4 = insets.left + this.hzgap;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Component component = null;
        Dimension dimension = null;
        for (int i = 0; i < n3; ++i) {
            component = container.getComponent(i);
            if (!component.isVisible()) continue;
            dimension = component.getPreferredSize();
            if (this.vtfill && i == n3 - 1) {
                dimension.height = Math.max(n - n5, component.getPreferredSize().height);
            }
            if (this.hzfill) {
                component.setSize(n2, dimension.height);
                dimension.width = n2;
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (n5 + dimension.height > n) {
                this.alignChildren(container, n4, insets.top + this.vtgap, n6, n - n5, n7, i);
                n5 = dimension.height;
                n4 = n4 + this.hzgap + n6;
                n6 = dimension.width;
                n7 = i;
                continue;
            }
            if (n5 > 0) {
                n5 += this.vtgap;
            }
            n5 += dimension.height;
            n6 = Math.max(n6, dimension.width);
        }
        this.alignChildren(container, n4, insets.top + this.vtgap, n6, n - n5, n7, n3);
    }
}

