/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.IviewTimer;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class IviewTimerImp
implements IviewTimer {
    private PrintWriter printWriter = null;
    private long start = 0L;

    public IviewTimerImp(PrintWriter printWriter) {
        this.printWriter = printWriter;
        this.start = System.currentTimeMillis();
    }

    @Override
    public synchronized void logTime(String string) {
        if (this.printWriter == null) {
            return;
        }
        StringBuffer stringBuffer = this.getTimeString();
        stringBuffer.append(" | ");
        stringBuffer.append(string);
        this.printWriter.println(stringBuffer.toString());
        this.printWriter.flush();
    }

    @Override
    public synchronized void resetTime(String string) {
        if (this.printWriter == null) {
            return;
        }
        this.start = System.currentTimeMillis();
        StringBuffer stringBuffer = this.getTimeString();
        stringBuffer.append(" | ");
        stringBuffer.append(string);
        stringBuffer.append(" reset time.");
        this.printWriter.println(stringBuffer.toString());
        this.printWriter.flush();
    }

    @Override
    public synchronized void endTime(String string) {
        if (this.printWriter == null) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.start;
        StringBuffer stringBuffer = this.getTimeString();
        stringBuffer.append(" | ");
        stringBuffer.append(string);
        stringBuffer.append(" | ");
        stringBuffer.append(l2);
        stringBuffer.append(" ms.");
        this.printWriter.println(stringBuffer.toString());
        this.printWriter.flush();
    }

    private synchronized StringBuffer getTimeString() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append('[');
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(']');
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss.sss");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = simpleDateFormat.format(gregorianCalendar.getTime());
        stringBuffer.append(string);
        return stringBuffer;
    }
}

