/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IviewTimer;
import com.swimap.iview.util.IviewTimerImp;
import com.swimap.iview.util.IviewTimerNullImp;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class IviewTimerFactory {
    private static IviewLogger logger = IviewLogger.getLogger(IviewTimerFactory.class, "IVIEW");
    private static final String TIME_LOG_FILE_NAME = "-timerfile";
    private static IviewTimerFactory iviewTimerFactory;
    private static String outputFileName;
    protected static PrintWriter printWriter;

    private IviewTimerFactory() {
        if (printWriter == null && outputFileName != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(outputFileName), true);
                printWriter = new PrintWriter(fileOutputStream, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error("Can't creat the FileOutputStream for the " + outputFileName);
                logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
                outputFileName = null;
            }
        }
    }

    public static synchronized IviewTimerFactory getInstance() {
        if (iviewTimerFactory == null) {
            iviewTimerFactory = new IviewTimerFactory();
        }
        return iviewTimerFactory;
    }

    public synchronized IviewTimer createIviewTimer() {
        if (outputFileName == null) {
            return IviewTimerNullImp.getInsance();
        }
        return new IviewTimerImp(printWriter);
    }

    public static synchronized void identifyTimerParam(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        String string = null;
        int n = stringArray.length;
        for (int i = 0; i < n && null != (string = stringArray[i]); ++i) {
            if (!TIME_LOG_FILE_NAME.equalsIgnoreCase(string) || i + 1 >= n || stringArray[i + 1].startsWith("-")) continue;
            IviewTimerFactory.setOutputFileName(stringArray[i + 1]);
        }
    }

    public static synchronized void cleanup() {
        IviewTimerFactory.closeFileStream();
        outputFileName = null;
        printWriter = null;
        iviewTimerFactory = null;
    }

    private static synchronized void setOutputFileName(String string) {
        File file;
        if (string == null || string.length() == 0) {
            return;
        }
        IviewTimerFactory.closeFileStream();
        if (string.indexOf(File.separator) != -1 && !(file = CommonUtil.getAbsoluteFile(string).getParentFile()).exists()) {
            file.mkdirs();
        }
        outputFileName = string;
    }

    private static synchronized void closeFileStream() {
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
            printWriter = null;
        }
    }

    static {
        outputFileName = null;
        printWriter = null;
    }
}

