/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.util.adapter.TypeConverter;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;

public class ImageTextDescription {
    public static final int LEFT_RIGHT = 0;
    public static final int TOP_BOTTOM = 1;
    public static final int BOTTOM_TOP = 2;
    private static final String PARA_DESCRIPTION = "description";
    private static final String PARA_FONT = "font";
    private static final String PARA_COLOR = "color";
    private static final String PARA_X = "x";
    private static final String PARA_Y = "y";
    private static final String PARA_SHOWDIRECTION = "showdirection";
    private String description = "";
    private Font font = new JLabel().getFont();
    private Color color = Color.black;
    private int x = 0;
    private int y = 0;
    private int showDirection = 0;

    public ImageTextDescription(String string, int n, int n2) {
        if (null != string) {
            this.description = string;
        }
        this.x = n;
        this.y = n2;
    }

    public ImageTextDescription(String string, Font font, Color color, int n, int n2, int n3) {
        this(string, n, n2);
        if (null != font) {
            this.font = font;
        }
        if (null != color) {
            this.color = color;
        }
        this.setShowdirection(n3);
    }

    public ImageTextDescription(DescContainer descContainer) {
        if (null == descContainer) {
            throw new IllegalArgumentException("desc argument shouldn't be null.");
        }
        String string = "";
        string = descContainer.getParasItemValue(PARA_DESCRIPTION);
        if (null != string) {
            this.description = string;
        }
        if (null != (string = descContainer.getParasItemValue(PARA_FONT)) && string.trim().length() > 0) {
            this.font = TypeConverter.toFont(string.trim(), this.font);
        }
        if (null != (string = descContainer.getParasItemValue(PARA_COLOR)) && string.trim().length() > 0) {
            this.color = TypeConverter.toColor(string, this.color);
        }
        if (null != (string = descContainer.getParasItemValue(PARA_X)) && string.trim().length() > 0) {
            this.x = Integer.parseInt(string.trim());
        }
        if (null != (string = descContainer.getParasItemValue(PARA_Y)) && string.trim().length() > 0) {
            this.y = Integer.parseInt(string.trim());
        }
        if (null != (string = descContainer.getParasItemValue(PARA_SHOWDIRECTION)) && string.trim().length() > 0) {
            this.setShowdirection(Integer.parseInt(string.trim()));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getShowdirection() {
        return this.showDirection;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setShowdirection(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("showDirection should be value of LEFT_RIGHT, TOP_BOTTOM or BOTTOM_TOP.");
        }
        this.showDirection = n;
    }
}

