/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class GlassPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private JFrame mainFrm = null;
    private Component originalGlassPane = null;
    private LockMouseListener lockMouseListener = new LockMouseListener();
    private transient KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && GlassPane.this.mainFrm != null && GlassPane.this.mainFrm.isActive()) {
                return false;
            }
            return keyEvent.getKeyCode() != 67 || keyEvent.getModifiers() != 8 || GlassPane.this.mainFrm == null || !GlassPane.this.mainFrm.isActive();
        }
    };

    public GlassPane(JFrame jFrame) {
        this.mainFrm = jFrame;
        this.setOpaque(false);
    }

    public void activate() {
        if (null != this.mainFrm) {
            this.originalGlassPane = this.mainFrm.getRootPane().getGlassPane();
            this.mainFrm.getRootPane().setGlassPane(this);
        }
        this.setVisible(true);
        this.requestFocusInWindow();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        this.addMouseListener(this.lockMouseListener);
    }

    public void deactivate() {
        this.setVisible(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        this.removeMouseListener(this.lockMouseListener);
        if (null != this.mainFrm && null != this.originalGlassPane) {
            this.mainFrm.getRootPane().setGlassPane(this.originalGlassPane);
        }
    }

    public KeyEventDispatcher getKeyEventDispatcher() {
        return this.keyEventDispatcher;
    }

    private class LockMouseListener
    extends MouseAdapter {
        private LockMouseListener() {
        }
    }
}

