/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.framework.pluginmanagement.PluginDefinitionHandler;
import com.swimap.iview.framework.pluginmanagement.spi.PluginCommStyleHandler;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.StartupFactory;
import com.swimap.iview.util.ClassURLHandler;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.MetaDataTool;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileMetaDataManager {
    private static IviewLogger logger = IviewLogger.getLogger(FileMetaDataManager.class, "IVIEW");
    private static FileMetaDataManager instance = null;
    private static final String METADATAFILENAME = "startupPlugins";

    private FileMetaDataManager() {
    }

    public static FileMetaDataManager getInstance() {
        if (null == instance) {
            instance = new FileMetaDataManager();
        }
        return instance;
    }

    public void initialize() {
        if (SerializationHandler.isEnableSerialization() && this.checkReadData()) {
            PluginDefinitionHandler.getPluginDefinitionHandler().initialize();
            PluginCommStyleHandler.getInstance().initialize();
        }
    }

    private boolean checkReadData() {
        String string = MetaDataTool.getSerializeDirectory();
        List<IStartupElement> list = StartupFactory.getStartupElements(1);
        String string2 = MetaDataTool.getFileName(METADATAFILENAME);
        List<String> list2 = this.readData(string + string2 + ".xml", null);
        if (null == list2) {
            return false;
        }
        if (list != null) {
            return FileMetaDataManager.compareServerPluginLists(list2, list);
        }
        return false != list2.isEmpty();
    }

    public void dispose() {
        if (SerializationHandler.isEnableSerialization()) {
            PluginDefinitionHandler.getPluginDefinitionHandler().savePluginDef();
            PluginCommStyleHandler.getInstance().saveStyleURL();
            ClassURLHandler.getInstance().saveStyleURL();
        }
    }

    public void clear() {
        if (SerializationHandler.isEnableSerialization()) {
            PluginDefinitionHandler.getPluginDefinitionHandler().clear();
            PluginCommStyleHandler.getInstance().clear();
            ClassURLHandler.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLinksData() {
        List<IStartupElement> list = StartupFactory.getStartupElements(1);
        StringBuffer stringBuffer = new StringBuffer(16);
        if (list != null) {
            for (IStartupElement object2 : list) {
                stringBuffer.append(object2.getName() + ";");
            }
        }
        String string = MetaDataTool.getFileName(METADATAFILENAME);
        String string2 = MetaDataTool.getSerializeDirectory();
        String string3 = string2 + (String)string + ".xml";
        CommonUtil.checkDirectory(string3);
        File file = new File(string3);
        BufferedWriter bufferedWriter = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException document) {
            logger.trace("IOException, file not found" + document);
        }
        Document document = this.makeDoc(stringBuffer.toString());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException dOMSource) {
            logger.trace("TransformerConfigurationException" + dOMSource);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(bufferedWriter);
        try {
            if (null != transformer) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("standalone", "no");
                transformer.transform(dOMSource, streamResult);
            }
        }
        catch (TransformerException iOException) {
            logger.trace("TransformerException" + iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    logger.info(iOException.getMessage(), iOException);
                }
            }
        }
    }

    public Document makeDoc(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("pluginStartupElements");
            document.appendChild(element);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Element element2 = document.createElement("TextElement");
                element2.appendChild(document.createTextNode(string2.trim()));
                element.appendChild(element2);
            }
            return document;
        }
        catch (Exception exception) {
            logger.error(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readData(String string, String string2) {
        String string3 = CommonUtil.getAbsolutePath(string);
        File file = new File(string3);
        if (file.exists()) {
            Object object;
            block18: {
                boolean bl;
                Document document;
                block17: {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = null;
                    document = null;
                    bl = false;
                    try {
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        document = documentBuilder.parse(string3);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        bl = true;
                        logger.trace("while reading data from" + string + "parserConfigurationException happened");
                    }
                    catch (SAXException sAXException) {
                        bl = true;
                        logger.trace(sAXException);
                    }
                    catch (IOException iOException) {
                        bl = true;
                        logger.trace("file not found:" + iOException);
                    }
                    finally {
                        if (!bl) break block17;
                        return null;
                    }
                }
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = null;
                object = null;
                try {
                    xPathExpression = xPath.compile("//pluginStartupElements/TextElement/text()");
                    object = xPathExpression.evaluate(document, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    bl = true;
                    logger.trace("XPathExpressionException" + xPathExpressionException);
                }
                finally {
                    if (!bl) break block18;
                    return null;
                }
            }
            NodeList nodeList = (NodeList)object;
            ArrayList<String> arrayList = new ArrayList<String>(10);
            int n = nodeList.getLength();
            if (null != nodeList) {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(nodeList.item(i).getNodeValue());
                }
            }
            return arrayList;
        }
        return null;
    }

    private static boolean compareServerPluginLists(List<String> list, List<IStartupElement> list2) {
        int n;
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = list2.get(i).getName();
            if (list.get(i).equals(string)) continue;
            return false;
        }
        return true;
    }
}

