/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.AbstractFileStateChecker;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public final class FileLockTool
extends AbstractFileStateChecker {
    private static IviewLogger logger = IviewLogger.getLogger(FileLockTool.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static FileLockTool instance = null;

    private FileLockTool() {
    }

    public static synchronized FileLockTool getInstance() {
        if (instance == null) {
            instance = new FileLockTool();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkFileState(String string) {
        if (null == string || string.trim().length() == 0) {
            return 0;
        }
        File file = new File(CommonUtil.getAbsolutePath(string));
        if (file.exists()) {
            FileOutputStream fileOutputStream = null;
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileChannel = fileOutputStream.getChannel();
                fileLock = fileChannel.tryLock();
                if (null == fileLock) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Component component = FileLockTool.this.getParentComponent();
                            if (component == null) {
                                component = FrameworkUtilities.getMainFrame();
                            }
                            OptionPane.showMessageDialog(component, res.getString("Selected_File_Is_Locked"));
                        }
                    });
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), res.getString("Selected_File_Is_Locked"));
                    }
                });
                int n = 1;
                return n;
            }
            finally {
                if (fileLock != null) {
                    try {
                        fileLock.release();
                        fileLock = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                        fileChannel = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
            }
        }
        return 0;
    }
}

