/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileEncodingDetector {
    private static IviewLogger logger = IviewLogger.getLogger(FileEncodingDetector.class, "IVIEW");
    protected static final String CHARSET_ASCII = "ASCII";
    private static final String CHARSET_NO_UTF_8 = "GBK";
    protected static final String CHARSET_UNICODE_BIG = "UnicodeBig";
    protected static final String CHARSET_UNICODE_LITTLE = "UnicodeLittle";
    private static final String CHARSET_UTF_8 = "UTF-8";
    protected static boolean havingBom = false;
    private static final char CHAR_EQUIVALENT_2_BITS = '\u0080';
    private static final char CHAR_EQUIVALENT_3_BITS = '\u00c0';
    private static final char CHAR_EQUIVALENT_4_BITS = '\u00ff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncodingFromFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        String string = null;
        try {
            fileInputStream = new FileInputStream(file);
            string = FileEncodingDetector.detectEncodingFromStream(fileInputStream);
            logger.trace("Encoding of file:" + file.getAbsolutePath() + " is :" + string);
            String string2 = string;
            return string2;
        }
        finally {
            if (null != fileInputStream) {
                fileInputStream.close();
            }
        }
    }

    public static String detect(File file) throws IOException {
        return FileEncodingDetector.detectEncodingFromFile(file);
    }

    public static String detect(InputStream inputStream) throws IOException {
        String string = FileEncodingDetector.detectEncodingFromStream(inputStream);
        logger.trace("Encoding of input stream is " + string);
        return FileEncodingDetector.detectEncodingFromStream(inputStream);
    }

    public static boolean isAscii(String string) {
        if (null == string) {
            return false;
        }
        char[] cArray = string.toCharArray();
        boolean bl = true;
        char c = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            c = cArray[i];
            if ((c & 0x80) == 0) continue;
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String detectEncodingFromStream(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(0);
            havingBom = false;
            int n = bufferedInputStream.read();
            int n2 = bufferedInputStream.read();
            int n3 = bufferedInputStream.read();
            String string = Integer.toHexString(0xFF & n);
            String string2 = Integer.toHexString(0xFF & n2);
            String string3 = Integer.toHexString(0xFF & n3);
            if ("FF".equalsIgnoreCase(string) && "FE".equalsIgnoreCase(string2)) {
                String string4 = CHARSET_UNICODE_LITTLE;
                return string4;
            }
            if ("FE".equalsIgnoreCase(string) && "FF".equalsIgnoreCase(string2)) {
                String string5 = CHARSET_UNICODE_BIG;
                return string5;
            }
            if ("EF".equalsIgnoreCase(string) && "BB".equalsIgnoreCase(string2) && "BF".equalsIgnoreCase(string3)) {
                havingBom = true;
                String string6 = CHARSET_UTF_8;
                return string6;
            }
            bufferedInputStream.reset();
            int n4 = 0;
            int n5 = -1;
            boolean bl = true;
            n4 = 0;
            while ((n5 = bufferedInputStream.read()) != -1) {
                if ((n5 & 0x80) != 0) {
                    bl = false;
                }
                if (n4 == 0) {
                    if (n5 < 128) continue;
                    do {
                        ++n4;
                    } while (((n5 <<= 1) & 0x80) != 0);
                    if (--n4 != 0) continue;
                    String string7 = CHARSET_NO_UTF_8;
                    return string7;
                }
                if ((n5 & 0xC0) != 128) {
                    String string8 = CHARSET_NO_UTF_8;
                    return string8;
                }
                --n4;
            }
            if (n4 > 0) {
                String string9 = CHARSET_NO_UTF_8;
                return string9;
            }
            if (bl) {
                String string10 = CHARSET_ASCII;
                return string10;
            }
            String string11 = CHARSET_UTF_8;
            return string11;
        }
        finally {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
    }
}

