/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private Hashtable filters = new Hashtable(11);
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private String fileType = null;
    public static final String ENC_TXT = "txt";
    public static final String ENC_CSV = "csv";
    public static final String ENC_HTML = "html";
    public static final String ENC_XML = "xml";
    public static final String ENC_PDF = "pdf";
    public static final String ENC_XLS = "xls";
    public static final String ENC_XLSX = "xlsx";

    public FileChooserFilter() {
    }

    public FileChooserFilter(String string) {
        this(string, null);
    }

    public FileChooserFilter(String string, String string2, String string3) {
        this(string, string3);
        this.fileType = string2;
    }

    public FileChooserFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public FileChooserFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public FileChooserFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(string) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        if (file != null) {
            return this.getExtension(file.getName());
        }
        return null;
    }

    public String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public LinkedList getAllFilters() {
        LinkedList linkedList = new LinkedList();
        if (this.filters == null || this.filters.size() == 0) {
            return linkedList;
        }
        Enumeration enumeration = this.filters.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                linkedList.add(enumeration.nextElement());
            }
        }
        return linkedList;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription != null) {
            return this.fullDescription;
        }
        if (this.description == null || this.isExtensionListInDescription()) {
            this.fullDescription = this.description == null ? "(" : this.description + " (";
            Enumeration enumeration = this.filters.keys();
            if (enumeration != null && enumeration.hasMoreElements()) {
                this.fullDescription = this.fullDescription + "*." + (String)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    this.fullDescription = this.fullDescription + ", " + (String)enumeration.nextElement();
                }
            }
            this.fullDescription = this.fullDescription + ")";
        } else {
            this.fullDescription = this.description;
        }
        return this.fullDescription;
    }
}

