/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends JFileChooser {
    private String helpID = null;
    private static IviewLogger logger = IviewLogger.getLogger(FileChooser.class, "IVIEW");
    protected static final String currentDir = CommonUtil.getDefaultSavePath();
    private static String historyDir = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private String title = null;
    private JButton open = null;
    private int comboBoxIndex = 0;
    private final int SAVEOROPENBTN = 0;
    private final int FILENAMETEXTFIELD = 1;
    private final int FILELIST = 2;
    private final int NEWFOLDERBTN = 3;
    private final int FILTERCOMBOBOX = 4;
    private final int CANCELBUTTON = 5;
    private boolean existTitle = false;
    public static final FileChooserFilter TXT_FILECHOOSERFILTER = new FileChooserFilter("txt", res.getString("TXTFiles"));
    public static final FileChooserFilter HTML_FILECHOOSERFILTER = new FileChooserFilter("html", res.getString("HTMLFiles"));
    public static final FileChooserFilter CSV_FILECHOOSERFILTER = new FileChooserFilter("csv", res.getString("CSVFiles"));
    public static final FileChooserFilter XLS_FILECHOOSERFILTER = new FileChooserFilter("xls", res.getString("XLSFiles"));
    public static final FileChooserFilter XLSX_FILECHOOSERFILTER = new FileChooserFilter("xlsx", res.getString("XLSXFiles"));
    public static final FileChooserFilter XML_FILECHOOSERFILTER = new FileChooserFilter("xml", res.getString("XMLFiles"));
    public static final FileChooserFilter JPG_FILECHOOSERFILTER = new FileChooserFilter("jpg", res.getString("JPGFiles"));
    public static final FileChooserFilter WAV_FILECHOOSERFILTER = new FileChooserFilter("wav", res.getString("WAVFiles"));
    public static final FileChooserFilter PDF_FILECHOOSERFILTER = new FileChooserFilter("pdf", res.getString("PDFFiles"));
    public static final FileChooserFilter GIF_FILECHOOSERFILTER = new FileChooserFilter("gif", res.getString("GIFFiles"));
    public static final FileChooserFilter PNG_FILECHOOSERFILTER = new FileChooserFilter("png", res.getString("PNGFiles"));
    public static final FileChooserFilter BAT_FILECHOOSERFILTER = new FileChooserFilter("bat", res.getString("BATFiles"));
    public static final FileChooserFilter EXE_FILECHOOSERFILTER = new FileChooserFilter("exe", res.getString("EXEFiles"));
    private static final String COMMON_HISTORY_PATH = "SingleFileChooserPath";
    private static String sharedHistoryDir = null;
    private static boolean historyShared = false;

    public FileChooser() {
        super(FileChooser.getSharedOrLocalHisOrUSerDirPath(currentDir));
        this.init();
    }

    public FileChooser(String string) {
        super(FileChooser.getUserDirDefaultPath(string));
        this.init();
    }

    static void setHistoryDir(String string) {
        historyDir = string;
    }

    static String getHistoryDir() {
        return historyDir;
    }

    public FileChooser(String string, boolean bl) {
        super(FileChooser.getSharedOrLocalHistoryDefaultPath(string));
        this.init();
    }

    public FileChooser(String string, boolean bl, boolean bl2) {
        super(FileChooser.getDefaultPath(string));
        this.init();
    }

    private void init() {
        JComponent jComponent;
        this.setName("FileChooser");
        Component component = this.getComponent(this, 1);
        if (component != null) {
            jComponent = (JTextField)component;
            jComponent.setName("FileChooser_inputTextFiled");
        }
        if (null != (component = this.getComponent(this, 4))) {
            jComponent = (JComboBox)component;
            jComponent.setName("FileChooser_filterCombo");
        }
        if ((component = this.getComponent(this, 0)) != null) {
            jComponent = (JButton)component;
            jComponent.setName("FileChooser_save");
        }
        if (null != (component = this.getComponent(this, 5))) {
            jComponent = (JButton)component;
            jComponent.setName("FileChooser_cancelBtn");
        }
        if ((component = this.getComponent(this, 2)) != null) {
            jComponent = (JList)component;
            jComponent.setName("FileChooser_list");
        }
        if ((component = this.getComponent(this, 3)) != null) {
            jComponent = (JButton)component;
            jComponent.setName("FileChooser_newFolderBtn");
        }
    }

    private Component getComponent(Component component, int n) {
        if (this.isEqual(component, n)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component2 = this.getComponent(container.getComponent(i), n);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    private boolean isEqual(Component component, int n) {
        switch (n) {
            case 0: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && (ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale)) || ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.openDialogTitleText", locale)));
            }
            case 1: {
                return component instanceof JTextField;
            }
            case 2: {
                return component instanceof JList;
            }
            case 3: {
                return component instanceof JButton && ((JButton)component).getIcon() != null && ((JButton)component).getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"));
            }
            case 4: {
                if (component instanceof JComboBox) {
                    ++this.comboBoxIndex;
                    if (this.comboBoxIndex == 2) {
                        this.comboBoxIndex = 0;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                if (!(component instanceof JButton)) {
                    return false;
                }
                Locale locale = Locale.getDefault();
                String string = ((JButton)component).getText();
                return string != null && ResourceUtil.areEquals(string, UIManager.getString((Object)"FileChooser.cancelButtonText", locale));
            }
        }
        return false;
    }

    public void setFileFilter(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            this.setAcceptAllFileFilterUsed(true);
        } else {
            FileChooserFilter fileChooserFilter = null;
            for (int i = 0; i < stringArray.length; ++i) {
                fileChooserFilter = new FileChooserFilter(stringArray[i], stringArray2[i]);
                this.addChoosableFileFilter(fileChooserFilter);
            }
        }
    }

    private JLabel getFileNameLabel(Component component) {
        if (component instanceof JLabel && ((JLabel)component).getLabelFor() == this.getComponent(this, 1)) {
            return (JLabel)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JLabel jLabel = this.getFileNameLabel(container.getComponent(i));
                if (jLabel == null) continue;
                return jLabel;
            }
        }
        return null;
    }

    public File getSelectFile() {
        return this.getSelectedFile();
    }

    public void displayPathName() {
        JLabel jLabel = this.getFileNameLabel(this);
        if (jLabel != null) {
            String string = jLabel.getText();
            String string2 = res.getString("PathName") + string.substring(string.length() - 1);
            if (string.indexOf("n") >= 0) {
                string2 = string2.replaceAll("N", "n");
            }
            jLabel.setText(string2);
        }
    }

    private static File getOSDefFileForPath(File file) {
        File[] fileArray = FileSystemView.getFileSystemView().getRoots();
        File file2 = null;
        if (null != fileArray && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        if (null != file2 && null != file && file.getPath().equals(file2.getPath())) {
            file = file2;
        }
        return file;
    }

    @Override
    public void setCurrentDirectory(File file) {
        super.setCurrentDirectory(FileChooser.getOSDefFileForPath(file));
    }

    public void setDirectory(File file) {
        File file2;
        if (file == null) {
            return;
        }
        File file3 = this.getFileSystemView().getHomeDirectory();
        if (!file.isDirectory() && (file2 = file.getParentFile()) != null && file2.equals(file3)) {
            this.setCurrentDirectory(new File(System.getProperty("user.dir")));
            this.setCurrentDirectory(file3);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.existTitle = true;
    }

    @Override
    public int showDialog(Component component, String string) {
        this.setDirectory(this.getCurrentDirectory());
        return super.showDialog(component, string);
    }

    public String getSelectFilePath() {
        return this.getSelectedFile().getAbsolutePath();
    }

    @Override
    public void approveSelection() {
        this.approveSelection(true);
    }

    protected void approveSelection(boolean bl) {
        super.approveSelection();
        if (this.getSelectedFile().isDirectory()) {
            if (FileChooser.isHistoryShared()) {
                sharedHistoryDir = this.getSelectedFile().getAbsolutePath();
            } else if (bl) {
                historyDir = this.getSelectedFile().getAbsolutePath();
            }
        } else if (FileChooser.isHistoryShared()) {
            sharedHistoryDir = this.getSelectedFile().getParent();
        } else if (bl) {
            historyDir = this.getSelectedFile().getParent();
        }
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        if (this.existTitle) {
            jDialog.setTitle(this.title);
        }
        jDialog.pack();
        ScreenToolKit.centerLocateToScreen(jDialog);
        jDialog.setResizable(true);
        if (null != this.helpID) {
            HelpManager.getInstance().enableHelpKey(jDialog.getRootPane(), this.helpID);
        }
        return jDialog;
    }

    public void setHelpID(String string) {
        this.helpID = string;
    }

    private static String getUserDirDefaultPath(String string) {
        String string2 = null;
        if (FileChooser.isHistoryShared()) {
            string2 = sharedHistoryDir;
        }
        if (null == string2) {
            if (null != string && string.length() > 0) {
                string2 = string;
            } else {
                string2 = System.getProperty("user.dir");
                logger.trace("FileChooser-currentDir is null, so using user.dir: " + System.getProperty("user.dir"));
            }
        }
        return string2;
    }

    private static String getDefaultPath(String string) {
        String string2 = null;
        if (FileChooser.isHistoryShared()) {
            string2 = sharedHistoryDir;
        }
        if (null == string2) {
            string2 = string;
        }
        return string2;
    }

    private static String getSharedOrLocalHistoryDefaultPath(String string) {
        String string2 = null;
        string2 = FileChooser.isHistoryShared() ? sharedHistoryDir : historyDir;
        if (null == string2) {
            string2 = string;
        }
        return string2;
    }

    private static String getSharedOrLocalHisOrUSerDirPath(String string) {
        String string2 = null;
        string2 = FileChooser.isHistoryShared() ? sharedHistoryDir : historyDir;
        if (null == string2) {
            if (null != string && string.length() > 0) {
                string2 = string;
            } else {
                string2 = System.getProperty("user.dir");
                logger.trace("FileChooser-currentDir is null, so using user.dir: " + System.getProperty("user.dir"));
            }
        }
        return string2;
    }

    static boolean isHistoryShared() {
        return historyShared;
    }

    static String getSharedHistoryDir() {
        return sharedHistoryDir;
    }

    static void setSharedHistoryDir(String string) {
        sharedHistoryDir = string;
    }

    static {
        String string = System.getProperty(COMMON_HISTORY_PATH);
        if (null != string) {
            string = string.trim();
        }
        Boolean bl = Boolean.parseBoolean(string);
        historyShared = bl;
    }
}

